/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties.initializer;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.ForeignKey;
import org.apache.torque.engine.database.model.Table;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.exception.DfIllegalPropertySettingException;
import org.seasar.dbflute.exception.DfPropertySettingColumnNotFoundException;
import org.seasar.dbflute.exception.DfPropertySettingTableNotFoundException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.helper.StringSet;
import org.seasar.dbflute.properties.DfAdditionalForeignKeyProperties;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfAdditionalForeignKeyInitializer {
    private static final Log _log = LogFactory.getLog(DfAdditionalForeignKeyInitializer.class);
    protected Database _database;

    public DfAdditionalForeignKeyInitializer(Database database) {
        this._database = database;
    }

    public void initializeAdditionalForeignKey() {
        _log.info((Object)"/=======================================");
        _log.info((Object)"...Initializing additional foreign keys.");
        Map<String, Map<String, String>> additionalForeignKeyMap = this.getAdditionalForeignKeyMap();
        Set<String> foreignKeyNameKeySet = additionalForeignKeyMap.keySet();
        for (String foreignKeyName : foreignKeyNameKeySet) {
            String foreignTableName = this.getForeignTableName(foreignKeyName);
            this.assertForeignTable(foreignKeyName, foreignTableName);
            List<String> foreignColumnNameList = this.getForeignColumnNameList(foreignKeyName, foreignTableName);
            this.assertForeignTableColumn(foreignKeyName, foreignTableName, foreignColumnNameList);
            String localTableName = this.getLocalTableName(foreignKeyName);
            _log.info((Object)foreignKeyName);
            if (localTableName.equals("$$ALL$$") || localTableName.equals("*")) {
                this.processAllTableFK(foreignKeyName, foreignTableName, foreignColumnNameList);
                continue;
            }
            this.processOneTableFK(foreignKeyName, localTableName, foreignTableName, foreignColumnNameList);
        }
        _log.info((Object)"==========/");
    }

    protected void processAllTableFK(String foreignKeyName, String foreignTableName, List<String> foreignColumnNameList) {
        String fixedCondition = this.getFixedCondition(foreignKeyName);
        String fixedSuffix = this.getFixedSuffix(foreignKeyName);
        String comment = this.getComment(foreignKeyName);
        Table foreignTable = this.getTable(foreignTableName);
        StringSet foreignColumnSet = StringSet.createAsFlexible();
        foreignColumnSet.addAll(foreignColumnNameList);
        for (Table localTable : this.getTables()) {
            String localTableName = localTable.getName();
            List<String> localColumnNameList = this.getLocalColumnNameList(foreignKeyName, foreignTableName, foreignColumnNameList, localTableName, false);
            if (!localTable.containsColumn(localColumnNameList)) continue;
            StringSet localColumnSet = StringSet.createAsFlexible();
            localColumnSet.addAll(localColumnNameList);
            boolean selfReference = localTable.getName().equals(foreignTable.getName());
            if (selfReference && localColumnSet.equalsUnderCharOption(foreignColumnSet)) continue;
            if (localTable.existsForeignKey(foreignTableName, localColumnNameList, foreignColumnNameList, fixedSuffix)) {
                String msg = "The foreign key has already set up: ";
                _log.info((Object)(msg + foreignKeyName + "(" + fixedSuffix + ")"));
                continue;
            }
            String currentForeignKeyName = foreignKeyName + "_" + localTableName;
            this.setupForeignKeyToTable(currentForeignKeyName, foreignTableName, foreignColumnNameList, fixedCondition, localTable, localColumnNameList, fixedSuffix, comment);
            this.showResult(foreignTableName, foreignColumnNameList, fixedCondition, localTable, localColumnNameList);
        }
    }

    protected void processOneTableFK(String foreignKeyName, String localTableName, String foreignTableName, List<String> foreignColumnNameList) {
        this.assertLocalTable(foreignKeyName, localTableName);
        String fixedCondition = this.getFixedCondition(foreignKeyName);
        String fixedSuffix = this.getFixedSuffix(foreignKeyName);
        String comment = this.getComment(foreignKeyName);
        Table table = this.getTable(localTableName);
        List<String> localColumnNameList = this.getLocalColumnNameList(foreignKeyName, foreignTableName, foreignColumnNameList, localTableName, true);
        this.assertLocalTableColumn(foreignKeyName, localTableName, localColumnNameList);
        if (table.existsForeignKey(foreignTableName, localColumnNameList, foreignColumnNameList, fixedSuffix)) {
            String msg = "The foreign key has already set up: ";
            _log.info((Object)(msg + foreignKeyName + "(" + fixedSuffix + ")"));
            return;
        }
        this.setupForeignKeyToTable(foreignKeyName, foreignTableName, foreignColumnNameList, fixedCondition, table, localColumnNameList, fixedSuffix, comment);
        this.showResult(foreignTableName, foreignColumnNameList, fixedCondition, table, localColumnNameList);
    }

    protected void setupForeignKeyToTable(String foreignKeyName, String foreignTableName, List<String> foreignColumnNameList, String fixedCondition, Table table, List<String> localColumnNameList, String fixedSuffix, String comment) {
        ForeignKey fk = this.createAdditionalForeignKey(foreignKeyName, foreignTableName, localColumnNameList, foreignColumnNameList, fixedCondition, fixedSuffix, comment);
        table.addForeignKey(fk);
        Table foreignTable = this.getTable(foreignTableName);
        boolean canBeReferrer = foreignTable.addReferrer(fk);
        if (canBeReferrer) {
            for (String foreignColumnName : foreignColumnNameList) {
                Column foreignColumn = foreignTable.getColumn(foreignColumnName);
                foreignColumn.addReferrer(fk);
            }
        } else {
            _log.info((Object)"  *Referrer setting was not allowed in this case");
        }
        if (fk.hasFixedCondition()) {
            this.processImplicitReverseForeignKey(table, foreignTable, localColumnNameList, foreignColumnNameList);
        }
    }

    protected void processImplicitReverseForeignKey(Table table, Table foreignTable, List<String> localColumnNameList, List<String> foreignColumnNameList) {
        String reverseName = "FK_" + foreignTable.getName() + table.getName();
        ForeignKey fk = this.createAdditionalForeignKey(reverseName, table.getName(), foreignColumnNameList, localColumnNameList, null, null, null);
        for (String localColumnName : localColumnNameList) {
            Column localColumn = table.getColumn(localColumnName);
            if (localColumn.isPrimaryKey()) continue;
            return;
        }
        if (foreignTable.existsForeignKey(table.getName(), foreignColumnNameList, localColumnNameList, null)) {
            return;
        }
        foreignTable.addForeignKey(fk);
        boolean canBeReferrer = table.addReferrer(fk);
        if (canBeReferrer) {
            for (String localColumnName : localColumnNameList) {
                Column localColumn = table.getColumn(localColumnName);
                localColumn.addReferrer(fk);
            }
        }
        _log.info((Object)"  *Reversed FK was also made implicitly");
    }

    protected ForeignKey createAdditionalForeignKey(String foreignKeyName, String foreignTableName, List<String> localColumnNameList, List<String> foreignColumnNameList, String fixedCondition, String fixedSuffix, String comment) {
        ForeignKey fk = new ForeignKey();
        fk.setName(foreignKeyName);
        fk.setForeignTableName(foreignTableName);
        fk.addReference(localColumnNameList, foreignColumnNameList);
        fk.setAdditionalForeignKey(true);
        if (Srl.is_NotNull_and_NotTrimmedEmpty((String)fixedCondition)) {
            fk.setFixedCondition(fixedCondition);
        }
        if (Srl.is_NotNull_and_NotTrimmedEmpty((String)fixedSuffix)) {
            fk.setFixedSuffix(fixedSuffix);
        }
        if (Srl.is_NotNull_and_NotTrimmedEmpty((String)comment)) {
            fk.setComment(comment);
        }
        return fk;
    }

    protected void showResult(String foreignTableName, List<String> foreignColumnNameList, String fixedCondition, Table table, List<String> localColumnNameList) {
        String msg = "  Add foreign key " + table.getName() + "." + localColumnNameList;
        if (fixedCondition != null && fixedCondition.trim().length() > 0) {
            msg = msg + " to " + foreignTableName + "." + foreignColumnNameList;
            _log.info((Object)msg);
            String withFixedCondition = "  with " + fixedCondition;
            _log.info((Object)withFixedCondition);
        } else {
            msg = msg + " to " + foreignTableName + "." + foreignColumnNameList;
            _log.info((Object)msg);
        }
    }

    protected List<String> getForeignColumnNameList(String foreignKeyName, String foreignTableName) {
        List foreignColumnNameList = this.getForeignColumnNameList(foreignKeyName);
        if (foreignColumnNameList != null && !foreignColumnNameList.isEmpty()) {
            return foreignColumnNameList;
        }
        foreignColumnNameList = DfCollectionUtil.newArrayList();
        List<Column> foreignPrimaryKeyList = this.getTable(foreignTableName).getPrimaryKey();
        if (foreignPrimaryKeyList.isEmpty()) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("Not found primary key on the foreign table of additionalForeignKey.");
            br.addItem("Advice");
            br.addElement((Object)"Foreign table should have primary keys.");
            br.addItem("Additional FK");
            br.addElement((Object)foreignKeyName);
            br.addItem("Foreign Table");
            br.addElement((Object)foreignTableName);
            String msg = br.buildExceptionMessage();
            throw new DfIllegalPropertySettingException(msg);
        }
        for (Column column : foreignPrimaryKeyList) {
            foreignColumnNameList.add(column.getName());
        }
        return foreignColumnNameList;
    }

    protected DfAdditionalForeignKeyProperties getProperties() {
        return DfBuildProperties.getInstance().getAdditionalForeignKeyProperties();
    }

    protected List<String> getLocalColumnNameList(String foreignKeyName, String foreignTableName, List<String> foreignColumnNameList, String localTableName, boolean errorIfNotFound) {
        List localColumnNameList = this.getLocalColumnNameList(foreignKeyName);
        if (localColumnNameList != null && !localColumnNameList.isEmpty()) {
            return localColumnNameList;
        }
        localColumnNameList = DfCollectionUtil.newArrayList();
        Table localTable = this.getTable(localTableName);
        for (String foreignColumnName : foreignColumnNameList) {
            Column column = localTable.getColumn(foreignColumnName);
            if (column != null) {
                localColumnNameList.add(column.getName());
                continue;
            }
            if (errorIfNotFound) {
                ExceptionMessageBuilder br = new ExceptionMessageBuilder();
                br.addNotice("Not found local column by the foreign column of additionalForeignKey.");
                br.addItem("Advice");
                br.addElement((Object)"When localColumnName is omitted, the local table should have");
                br.addElement((Object)"the columns that are same as primary keys of foreign table.");
                br.addItem("Additional FK");
                br.addElement((Object)foreignKeyName);
                br.addItem("Local Table");
                br.addElement((Object)localTableName);
                br.addItem("Foreign Table");
                br.addElement((Object)foreignTableName);
                br.addItem("Foreign Column");
                br.addElement(foreignColumnNameList);
                String msg = br.buildExceptionMessage();
                throw new DfPropertySettingColumnNotFoundException(msg);
            }
            return DfCollectionUtil.newArrayList();
        }
        return localColumnNameList;
    }

    protected void assertForeignTable(String foreignKeyName, String foreignTableName) {
        if (this.getTable(foreignTableName) != null) {
            return;
        }
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found table by the foreignTableName of additionalForeignKey.");
        br.addItem("Additional FK");
        br.addElement((Object)foreignKeyName);
        br.addItem("NotFound Table");
        br.addElement((Object)foreignTableName);
        String msg = br.buildExceptionMessage();
        throw new DfPropertySettingTableNotFoundException(msg);
    }

    protected void assertForeignTableColumn(String foreignKeyName, String foreignTableName, List<String> foreignColumnNameList) {
        if (this.getTable(foreignTableName).containsColumn(foreignColumnNameList)) {
            return;
        }
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found column by the foreignColumnName of additionalForeignKey.");
        br.addItem("Additional FK");
        br.addElement((Object)foreignKeyName);
        br.addItem("Foreign Table");
        br.addElement((Object)foreignTableName);
        br.addItem("NotFound Column");
        br.addElement(foreignColumnNameList);
        String msg = br.buildExceptionMessage();
        throw new DfPropertySettingColumnNotFoundException(msg);
    }

    protected void assertLocalTable(String foreignKeyName, String localTableName) {
        if (this.getTable(localTableName) != null) {
            return;
        }
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found table by the localTableName of additionalForeignKey.");
        br.addItem("Additional FK");
        br.addElement((Object)foreignKeyName);
        br.addItem("NotFound Table");
        br.addElement((Object)localTableName);
        String msg = br.buildExceptionMessage();
        throw new DfPropertySettingTableNotFoundException(msg);
    }

    protected void assertLocalTableColumn(String foreignKeyName, String localTableName, List<String> localColumnNameList) {
        if (this.getTable(localTableName).containsColumn(localColumnNameList)) {
            return;
        }
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found column by the localColumnName of additionalForeignKey.");
        br.addItem("Additional FK");
        br.addElement((Object)foreignKeyName);
        br.addItem("Local Table");
        br.addElement((Object)localTableName);
        br.addItem("NotFound Column");
        br.addElement(localColumnNameList);
        String msg = br.buildExceptionMessage();
        throw new DfPropertySettingColumnNotFoundException(msg);
    }

    protected String getLocalTableName(String foreignKeyName) {
        return this.getProperties().findLocalTableName(foreignKeyName);
    }

    protected String getForeignTableName(String foreignKeyName) {
        return this.getProperties().findForeignTableName(foreignKeyName);
    }

    protected List<String> getLocalColumnNameList(String foreignKeyName) {
        return this.getProperties().findLocalColumnNameList(foreignKeyName);
    }

    protected List<String> getForeignColumnNameList(String foreignKeyName) {
        return this.getProperties().findForeignColumnNameList(foreignKeyName);
    }

    protected String getFixedCondition(String foreignKeyName) {
        return this.getProperties().findFixedCondition(foreignKeyName);
    }

    protected String getFixedSuffix(String foreignKeyName) {
        return this.getProperties().findFixedSuffix(foreignKeyName);
    }

    protected String getComment(String foreignKeyName) {
        return this.getProperties().findComment(foreignKeyName);
    }

    protected Map<String, Map<String, String>> getAdditionalForeignKeyMap() {
        return this.getProperties().getAdditionalForeignKeyMap();
    }

    protected Table getTable(String tableName) {
        return this.getDatabase().getTable(tableName);
    }

    protected Table[] getTables() {
        return this.getDatabase().getTables();
    }

    protected Database getDatabase() {
        return this._database;
    }
}

