/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties.assistant.classification;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.exception.SQLFailureException;
import org.seasar.dbflute.properties.assistant.classification.DfClassificationSqlResourceCloser;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfClassificationAllInOneSqlExecutor {
    private static final Log _log = LogFactory.getLog(DfClassificationAllInOneSqlExecutor.class);

    public List<Map<String, String>> executeAllInOneSql(Connection conn, String sql) {
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<Map<String, String>> elementList = new ArrayList<Map<String, String>>();
        try {
            try {
                stmt = conn.createStatement();
                _log.debug((Object)"/ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -");
                _log.debug((Object)("The classification sql: " + sql));
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    String tmpAliasValue;
                    String tmpClassificationNameValue = rs.getString("classificationName");
                    String tmpCodeValue = rs.getString("code");
                    if (tmpCodeValue == null) {
                        String msg = "The sql should have 'code' column. But null: sql=" + sql;
                        throw new IllegalStateException(msg);
                    }
                    String tmpNameValue = rs.getString("name");
                    if (tmpNameValue == null) {
                        tmpNameValue = tmpCodeValue;
                    }
                    if ((tmpAliasValue = rs.getString("alias")) == null) {
                        tmpAliasValue = tmpNameValue;
                    }
                    String tmpCommentValue = rs.getString("comment");
                    String tmpTopCommentValue = rs.getString("topComment");
                    LinkedHashMap<String, String> selectedTmpMap = new LinkedHashMap<String, String>();
                    selectedTmpMap.put("classificationName", tmpClassificationNameValue);
                    selectedTmpMap.put("code", tmpCodeValue);
                    selectedTmpMap.put("name", tmpNameValue);
                    selectedTmpMap.put("alias", tmpAliasValue);
                    if (tmpCommentValue != null) {
                        selectedTmpMap.put("comment", tmpCommentValue);
                    }
                    if (tmpTopCommentValue != null) {
                        selectedTmpMap.put("topComment", tmpTopCommentValue);
                    }
                    elementList.add(selectedTmpMap);
                }
                _log.debug((Object)"- - - - - - - - /");
            }
            catch (SQLException e) {
                throw new SQLFailureException("Failed to execute the SQL:" + this.ln() + sql, e);
            }
            Object var14_14 = null;
            new DfClassificationSqlResourceCloser().closeSqlResource(conn, stmt, rs);
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            new DfClassificationSqlResourceCloser().closeSqlResource(conn, stmt, rs);
            throw throwable;
        }
        return elementList;
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }
}

