/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.properties.DfAbstractHelperProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DfIncludeQueryProperties
extends DfAbstractHelperProperties {
    protected Map<String, Map<String, Map<String, List<String>>>> _includeQueryMap;
    protected Map<String, Map<String, Map<String, List<String>>>> _excludeQueryMap;

    public DfIncludeQueryProperties(Properties prop) {
        super(prop);
    }

    public Map<String, Map<String, Map<String, List<String>>>> getIncludeQueryMap() {
        if (this._includeQueryMap != null) {
            return this._includeQueryMap;
        }
        LinkedHashMap<String, Map<String, Map<String, List<String>>>> resultMap = new LinkedHashMap<String, Map<String, Map<String, List<String>>>>();
        Map<String, Object> targetMap = this.mapProp("torque.includeQueryMap", DEFAULT_EMPTY_MAP);
        Set<String> targetKeySet = targetMap.keySet();
        for (String key : targetKeySet) {
            Object value = targetMap.get(key);
            if (!(value instanceof Map)) {
                String msg = "The key[" + key + "] should have map value. But the value is " + value + ": targetMap=" + targetMap;
                throw new IllegalStateException(msg);
            }
            Map elementMap = (Map)value;
            resultMap.put(key, elementMap);
        }
        this._includeQueryMap = resultMap;
        return this._includeQueryMap;
    }

    public Map<String, Map<String, Map<String, List<String>>>> getExcludeQueryMap() {
        if (this._excludeQueryMap != null) {
            return this._excludeQueryMap;
        }
        LinkedHashMap<String, Map<String, Map<String, List<String>>>> resultMap = new LinkedHashMap<String, Map<String, Map<String, List<String>>>>();
        Map<String, Object> targetMap = this.mapProp("torque.excludeQueryMap", DEFAULT_EMPTY_MAP);
        Set<String> targetKeySet = targetMap.keySet();
        for (String key : targetKeySet) {
            Object value = targetMap.get(key);
            if (!(value instanceof Map)) {
                String msg = "The key[" + key + "] should have map value. But the value is " + value + ": targetMap=" + targetMap;
                throw new IllegalStateException(msg);
            }
            Map elementMap = (Map)value;
            resultMap.put(key, elementMap);
        }
        this._excludeQueryMap = resultMap;
        return this._excludeQueryMap;
    }

    public boolean isAvailableStringNotEqual(String tableName, String columnName) {
        return this.isAvailable("String", "NotEqual", tableName, columnName);
    }

    public boolean isAvailableStringGreaterThan(String tableName, String columnName) {
        return this.isAvailable("String", "GreaterThan", tableName, columnName);
    }

    public boolean isAvailableStringGreaterEqual(String tableName, String columnName) {
        return this.isAvailable("String", "GreaterEqual", tableName, columnName);
    }

    public boolean isAvailableStringLessThan(String tableName, String columnName) {
        return this.isAvailable("String", "LessThan", tableName, columnName);
    }

    public boolean isAvailableStringLessEqual(String tableName, String columnName) {
        return this.isAvailable("String", "LessEqual", tableName, columnName);
    }

    public boolean isAvailableStringPrefixSearch(String tableName, String columnName) {
        return this.isAvailable("String", "PrefixSearch", tableName, columnName);
    }

    public boolean isAvailableStringLikeSearch(String tableName, String columnName) {
        return this.isAvailable("String", "LikeSearch", tableName, columnName);
    }

    public boolean isAvailableStringNotLikeSearch(String tableName, String columnName) {
        return this.isAvailable("String", "NotLikeSearch", tableName, columnName);
    }

    public boolean isAvailableStringInScope(String tableName, String columnName) {
        return this.isAvailable("String", "InScope", tableName, columnName);
    }

    public boolean isAvailableStringNotInScope(String tableName, String columnName) {
        return this.isAvailable("String", "NotInScope", tableName, columnName);
    }

    public boolean isAvailableStringEmptyString(String tableName, String columnName) {
        return this.isAvailable("String", "EmptyString", tableName, columnName);
    }

    public boolean isAvailableNumberNotEqual(String tableName, String columnName) {
        return this.isAvailable("Number", "NotEqual", tableName, columnName);
    }

    public boolean isAvailableNumberGreaterThan(String tableName, String columnName) {
        return this.isAvailable("Number", "GreaterThan", tableName, columnName);
    }

    public boolean isAvailableNumberGreaterEqual(String tableName, String columnName) {
        return this.isAvailable("Number", "GreaterEqual", tableName, columnName);
    }

    public boolean isAvailableNumberLessThan(String tableName, String columnName) {
        return this.isAvailable("Number", "LessThan", tableName, columnName);
    }

    public boolean isAvailableNumberLessEqual(String tableName, String columnName) {
        return this.isAvailable("Number", "LessEqual", tableName, columnName);
    }

    public boolean isAvailableNumberInScope(String tableName, String columnName) {
        return this.isAvailable("Number", "InScope", tableName, columnName);
    }

    public boolean isAvailableNumberNotInScope(String tableName, String columnName) {
        return this.isAvailable("Number", "NotInScope", tableName, columnName);
    }

    public boolean isAvailableDateNotEqual(String tableName, String columnName) {
        return this.isAvailable("Date", "NotEqual", tableName, columnName);
    }

    public boolean isAvailableDateGreaterThan(String tableName, String columnName) {
        return this.isAvailable("Date", "GreaterThan", tableName, columnName);
    }

    public boolean isAvailableDateGreaterEqual(String tableName, String columnName) {
        return this.isAvailable("Date", "GreaterEqual", tableName, columnName);
    }

    public boolean isAvailableDateLessThan(String tableName, String columnName) {
        return this.isAvailable("Date", "LessThan", tableName, columnName);
    }

    public boolean isAvailableDateLessEqual(String tableName, String columnName) {
        return this.isAvailable("Date", "LessEqual", tableName, columnName);
    }

    public boolean isAvailableDateFromTo(String tableName, String columnName) {
        return this.isAvailable("Date", "FromTo", tableName, columnName);
    }

    public boolean isAvailableDateDateFromTo(String tableName, String columnName) {
        return this.isAvailable("Date", "DateFromTo", tableName, columnName);
    }

    public boolean isAvailableDateInScope(String tableName, String columnName) {
        return this.isAvailable("Date", "InScope", tableName, columnName);
    }

    public boolean isAvailableDateNotInScope(String tableName, String columnName) {
        return this.isAvailable("Date", "NotInScope", tableName, columnName);
    }

    public boolean isAvailableStringEqualOldAsInline(String tableName, String columnName) {
        return this.isAvailable("String", "EqualOldAsInline", tableName, columnName);
    }

    public boolean isAvailableStringNotEqualOldAsInline(String tableName, String columnName) {
        return this.isAvailable("String", "NotEqualOldAsInline", tableName, columnName);
    }

    public boolean isAvailableStringGreaterThanOldAsInline(String tableName, String columnName) {
        return this.isAvailable("String", "GreaterThanOldAsInline", tableName, columnName);
    }

    public boolean isAvailableStringGreaterEqualOldAsInline(String tableName, String columnName) {
        return this.isAvailable("String", "GreaterEqualOldAsInline", tableName, columnName);
    }

    public boolean isAvailableStringLessThanOldAsInline(String tableName, String columnName) {
        return this.isAvailable("String", "LessThanOldAsInline", tableName, columnName);
    }

    public boolean isAvailableStringLessEqualOldAsInline(String tableName, String columnName) {
        return this.isAvailable("String", "LessEqualOldAsInline", tableName, columnName);
    }

    public boolean isAvailableStringPrefixSearchOldAsInline(String tableName, String columnName) {
        return this.isAvailable("String", "PrefixSearchOldAsInline", tableName, columnName);
    }

    public boolean isAvailableStringInScopeOldAsInline(String tableName, String columnName) {
        return this.isAvailable("String", "InScopeOldAsInline", tableName, columnName);
    }

    public boolean isAvailableStringNotInScopeOldAsInline(String tableName, String columnName) {
        return this.isAvailable("String", "NotInScopeOldAsInline", tableName, columnName);
    }

    public boolean isAvailableStringInScopeSubQueryOldAsInline(String tableName, String columnName) {
        return this.isAvailable("String", "InScopeSubQueryOldAsInline", tableName, columnName);
    }

    public boolean isAvailableNumberEqualOldAsInline(String tableName, String columnName) {
        return this.isAvailable("Number", "EqualOldAsInline", tableName, columnName);
    }

    public boolean isAvailableNumberNotEqualOldAsInline(String tableName, String columnName) {
        return this.isAvailable("Number", "NotEqualOldAsInline", tableName, columnName);
    }

    public boolean isAvailableNumberGreaterThanOldAsInline(String tableName, String columnName) {
        return this.isAvailable("Number", "GreaterThanOldAsInline", tableName, columnName);
    }

    public boolean isAvailableNumberGreaterEqualOldAsInline(String tableName, String columnName) {
        return this.isAvailable("Number", "GreaterEqualOldAsInline", tableName, columnName);
    }

    public boolean isAvailableNumberLessThanOldAsInline(String tableName, String columnName) {
        return this.isAvailable("Number", "LessThanOldAsInline", tableName, columnName);
    }

    public boolean isAvailableNumberLessEqualOldAsInline(String tableName, String columnName) {
        return this.isAvailable("Number", "LessEqualOldAsInline", tableName, columnName);
    }

    public boolean isAvailableNumberInScopeOldAsInline(String tableName, String columnName) {
        return this.isAvailable("Number", "InScopeOldAsInline", tableName, columnName);
    }

    public boolean isAvailableNumberNotInScopeOldAsInline(String tableName, String columnName) {
        return this.isAvailable("Number", "NotInScopeOldAsInline", tableName, columnName);
    }

    public boolean isAvailableNumberInScopeSubQueryOldAsInline(String tableName, String columnName) {
        return this.isAvailable("Number", "InScopeSubQueryOldAsInline", tableName, columnName);
    }

    public boolean isAvailableDateEqualOldAsInline(String tableName, String columnName) {
        return this.isAvailable("Date", "EqualOldAsInline", tableName, columnName);
    }

    public boolean isAvailableDateNotEqualOldAsInline(String tableName, String columnName) {
        return this.isAvailable("Date", "NotEqualOldAsInline", tableName, columnName);
    }

    public boolean isAvailableDateGreaterThanOldAsInline(String tableName, String columnName) {
        return this.isAvailable("Date", "GreaterThanOldAsInline", tableName, columnName);
    }

    public boolean isAvailableDateGreaterEqualOldAsInline(String tableName, String columnName) {
        return this.isAvailable("Date", "GreaterEqualOldAsInline", tableName, columnName);
    }

    public boolean isAvailableDateLessThanOldAsInline(String tableName, String columnName) {
        return this.isAvailable("Date", "LessThanOldAsInline", tableName, columnName);
    }

    public boolean isAvailableDateLessEqualOldAsInline(String tableName, String columnName) {
        return this.isAvailable("Date", "LessEqualOldAsInline", tableName, columnName);
    }

    protected boolean isAvailable(String javaTypeName, String queryTypeName, String tableName, String columnName) {
        if (this.containsQueryTypeIncludeQueryMap(javaTypeName, queryTypeName)) {
            return this.containsTableColumnIncludeQueryMap(javaTypeName, queryTypeName, tableName, columnName);
        }
        if (this.containsQueryTypeExcludeQueryMap(javaTypeName, queryTypeName)) {
            return !this.containsTableColumnExcludeQueryMap(javaTypeName, queryTypeName, tableName, columnName);
        }
        return true;
    }

    protected boolean containsQueryTypeIncludeQueryMap(String javaTypeName, String queryTypeName) {
        Map<String, Map<String, List<String>>> map = this.getIncludeQueryMap().get(javaTypeName);
        return map != null && map.get(queryTypeName) != null;
    }

    protected boolean containsQueryTypeExcludeQueryMap(String javaTypeName, String queryTypeName) {
        Map<String, Map<String, List<String>>> map = this.getExcludeQueryMap().get(javaTypeName);
        return map != null && map.get(queryTypeName) != null;
    }

    protected boolean containsTableColumnIncludeQueryMap(String javaTypeName, String queryTypeName, String tableName, String columnName) {
        InternalTableColumnJudgement judgement = new InternalTableColumnJudgement();
        judgement.setQueryMap(this.getIncludeQueryMap());
        return judgement.containsTableColumn(javaTypeName, queryTypeName, tableName, columnName);
    }

    protected boolean containsTableColumnExcludeQueryMap(String javaTypeName, String queryTypeName, String tableName, String columnName) {
        InternalTableColumnJudgement judgement = new InternalTableColumnJudgement();
        judgement.setQueryMap(this.getExcludeQueryMap());
        return judgement.containsTableColumn(javaTypeName, queryTypeName, tableName, columnName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class InternalTableColumnJudgement {
        protected Map<String, Map<String, Map<String, List<String>>>> _queryMap;

        protected InternalTableColumnJudgement() {
        }

        protected boolean containsTableColumn(String javaTypeName, String queryTypeName, String tableName, String columnName) {
            if (this._queryMap.get(javaTypeName) == null) {
                String msg = "The javaTypeName[" + javaTypeName + "] should have the value of excludeQueryMap: " + this._queryMap;
                throw new IllegalStateException(msg);
            }
            if (this._queryMap.get(javaTypeName).get(queryTypeName) == null) {
                String msg = "The queryTypeName[" + queryTypeName + "] should have the value of excludeQueryMap: " + this._queryMap;
                throw new IllegalStateException(msg);
            }
            Map<String, List<String>> map = this._queryMap.get(javaTypeName).get(queryTypeName);
            StringKeyMap tableNameMap = StringKeyMap.createAsFlexible();
            tableNameMap.putAll(map);
            if (!tableNameMap.containsKey(tableName) && !tableNameMap.containsKey("$$ALL$$")) {
                return false;
            }
            List columnNameList = (List)tableNameMap.get(tableName);
            if (columnNameList == null) {
                columnNameList = (List)tableNameMap.get("$$ALL$$");
            }
            HashMap<String, Object> columnTmpMap = new HashMap<String, Object>();
            for (String protoColumnName : columnNameList) {
                columnTmpMap.put(protoColumnName, new Object());
            }
            StringKeyMap columnNameMap = StringKeyMap.createAsFlexible();
            columnNameMap.putAll(columnTmpMap);
            return columnNameMap.containsKey(columnName);
        }

        public Map<String, Map<String, Map<String, List<String>>>> getQueryMap() {
            return this._queryMap;
        }

        public void setQueryMap(Map<String, Map<String, Map<String, List<String>>>> queryMap) {
            this._queryMap = queryMap;
        }
    }
}

