/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties;

import java.util.Map;
import java.util.Properties;
import org.seasar.dbflute.properties.DfAbstractHelperProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DfHibernateProperties
extends DfAbstractHelperProperties {
    protected Map<String, Object> hibernateDefinitionMap;

    public DfHibernateProperties(Properties prop) {
        super(prop);
    }

    protected Map<String, Object> getHibernateDefinitionMap() {
        if (this.hibernateDefinitionMap == null) {
            this.hibernateDefinitionMap = this.mapProp("torque.hibernateDefinitionMap", DEFAULT_EMPTY_MAP);
        }
        return this.hibernateDefinitionMap;
    }

    public boolean hasHibernateDefinition() {
        return !this.getHibernateDefinitionMap().isEmpty();
    }

    public String getManyToOneFetch() {
        return this.getEntityPropertyIfNullEmpty("manyToOneFetch");
    }

    public String getOneToOneFetch() {
        return this.getEntityPropertyIfNullEmpty("oneToOneFetch");
    }

    public String getOneToManyFetch() {
        return this.getEntityPropertyIfNullEmpty("oneToManyFetch");
    }

    protected String getEntityPropertyRequired(String key) {
        String value = this.getEntityProperty(key);
        if (value == null || value.trim().length() == 0) {
            String msg = "The property '" + key + "' should not be null or empty:";
            msg = msg + " hibernateDefinitionMap=" + this.getHibernateDefinitionMap();
            throw new IllegalStateException(msg);
        }
        return value;
    }

    protected String getEntityPropertyIfNullEmpty(String key) {
        String value = this.getEntityProperty(key);
        if (value == null) {
            return "";
        }
        return value;
    }

    protected String getEntityProperty(String key) {
        String value = (String)this.getHibernateDefinitionMap().get(key);
        return value;
    }
}

