/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.sql2entity.pmbean;

import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.properties.DfAbstractHelperProperties;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfOutsideSqlProperties;
import org.seasar.dbflute.util.DfStringUtil;
import org.seasar.dbflute.util.Srl;

public class DfPropertyTypePackageResolver {
    public static final String VAR_CDEF = "$$CDef$$";
    public static final String VAR_DOMAIN = "$$Domain$$";
    public static final String VAR_CUSTOMIZE = "$$Customize$$";
    public static final String VAR_PMB = "$$Pmb$$";

    public String resolvePackageName(String typeName) {
        return this.doResolvePackageName(typeName, false);
    }

    public String resolvePackageNameExceptUtil(String typeName) {
        return this.doResolvePackageName(typeName, true);
    }

    protected String doResolvePackageName(String typeName, boolean exceptUtil) {
        String pkg;
        DfAbstractHelperProperties prop;
        String processed;
        if (typeName == null) {
            return typeName;
        }
        if (this.isTargetLanguageJava() ? (processed = this.processJavaType(typeName, exceptUtil)) != null : this.isTargetLanguageCSharp() && (processed = this.processCSharpType(typeName, exceptUtil)) != null) {
            return processed;
        }
        if (typeName.startsWith(VAR_CDEF)) {
            prop = this.getBasicProperties();
            String pkg2 = ((DfBasicProperties)prop).getBaseCommonPackage();
            String prefix = ((DfBasicProperties)prop).getProjectPrefix();
            typeName = DfStringUtil.replace((String)typeName, (String)VAR_CDEF, (String)(pkg2 + "." + prefix + "CDef"));
            return typeName;
        }
        if (typeName.startsWith("$$Domain$$.")) {
            prop = this.getBasicProperties();
            pkg = ((DfBasicProperties)prop).getExtendedEntityPackage();
            typeName = Srl.replace((String)typeName, (String)"$$Domain$$.", (String)(pkg + "."));
        }
        if (typeName.startsWith("$$Customize$$.")) {
            prop = this.getOutsideSqlProperties();
            pkg = ((DfOutsideSqlProperties)prop).getExtendedEntityPackage();
            typeName = Srl.replace((String)typeName, (String)"$$Customize$$.", (String)(pkg + "."));
        }
        if (typeName.startsWith("$$Pmb$$.")) {
            prop = this.getOutsideSqlProperties();
            pkg = ((DfOutsideSqlProperties)prop).getExtendedParameterBeanPackage();
            typeName = Srl.replace((String)typeName, (String)"$$Pmb$$.", (String)(pkg + "."));
        }
        return typeName;
    }

    protected String processJavaType(String typeName, boolean exceptUtil) {
        if (!exceptUtil) {
            String listType = this.processListType(typeName, exceptUtil, "java.util", "List");
            if (listType != null) {
                return listType;
            }
            String mapType = this.processMapType(typeName, exceptUtil, "java.util", "Map");
            if (mapType != null) {
                return mapType;
            }
        }
        if (typeName.equals("BigDecimal")) {
            return "java.math." + typeName;
        }
        if (typeName.equals("Time")) {
            return "java.sql." + typeName;
        }
        if (typeName.equals("Timestamp")) {
            return "java.sql." + typeName;
        }
        if (!exceptUtil && typeName.equals("Date")) {
            return "java.util." + typeName;
        }
        return null;
    }

    protected String processCSharpType(String typeName, boolean exceptUtil) {
        String listType = this.processListType(typeName, exceptUtil, "System.Collections.Generic", "IList");
        if (listType != null) {
            return listType;
        }
        String mapType = this.processMapType(typeName, exceptUtil, "System.Collections.Generic", "IDictionary");
        if (mapType != null) {
            return mapType;
        }
        return null;
    }

    protected String processListType(String typeName, boolean exceptUtil, String listPkg, String listName) {
        String listBegin = listName + "<";
        String listEnd = ">";
        if (typeName.startsWith(listBegin) && typeName.endsWith(">")) {
            Srl.ScopeInfo scope = Srl.extractScopeWide((String)typeName, (String)listBegin, (String)">");
            String content = scope.getContent();
            String resolvedContent = this.doResolvePackageName(content, exceptUtil);
            return listPkg + "." + listBegin + resolvedContent + ">";
        }
        return null;
    }

    protected String processMapType(String typeName, boolean exceptUtil, String mapPkg, String mapName) {
        String mapBegin = mapName + "<";
        String mapEnd = ">";
        if (typeName.startsWith(mapBegin) && typeName.endsWith(">")) {
            Srl.ScopeInfo scope = Srl.extractScopeWide((String)typeName, (String)mapBegin, (String)">");
            String content = scope.getContent();
            String keyType = Srl.substringFirstFront((String)content, (String[])new String[]{","}).trim();
            String valueType = Srl.substringFirstRear((String)content, (String[])new String[]{","}).trim();
            String resolvedValueType = this.doResolvePackageName(valueType, exceptUtil);
            return mapPkg + "." + mapBegin + keyType + ", " + resolvedValueType + ">";
        }
        return null;
    }

    protected boolean isTargetLanguageJava() {
        return this.getBasicProperties().isTargetLanguageJava();
    }

    protected boolean isTargetLanguageCSharp() {
        return this.getBasicProperties().isTargetLanguageCSharp();
    }

    protected DfBasicProperties getBasicProperties() {
        return DfBuildProperties.getInstance().getBasicProperties();
    }

    protected DfOutsideSqlProperties getOutsideSqlProperties() {
        return DfBuildProperties.getInstance().getOutsideSqlProperties();
    }
}

