/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.sql2entity.cmentity;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.logic.jdbc.handler.DfColumnHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfColumnMetaInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfCustomizeEntityMetaExtractor {
    private static final Log _log = LogFactory.getLog(DfCustomizeEntityMetaExtractor.class);

    public Map<String, DfColumnMetaInfo> extractColumnMetaInfoMap(ResultSet rs, String sql, DfForcedJavaNativeProvider forcedJavaNativeProvider) throws SQLException {
        StringKeyMap columnMetaInfoMap = StringKeyMap.createAsFlexibleOrdered();
        ResultSetMetaData md = rs.getMetaData();
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            DfColumnMetaInfo metaInfo = new DfColumnMetaInfo();
            String sql2EntityRelatedTableName = null;
            try {
                sql2EntityRelatedTableName = md.getTableName(i);
            }
            catch (SQLException ignored) {
                String msg = "ResultSetMetaData.getTableName(" + i + ") threw the exception:";
                msg = msg + " " + ignored.getMessage();
                _log.info((Object)msg);
            }
            metaInfo.setSql2EntityRelatedTableName(sql2EntityRelatedTableName);
            String columnName = md.getColumnLabel(i);
            String relatedColumnName = md.getColumnName(i);
            metaInfo.setSql2EntityRelatedColumnName(relatedColumnName);
            if (columnName == null || columnName.trim().length() == 0) {
                columnName = relatedColumnName;
            }
            if (columnName == null || columnName.trim().length() == 0) {
                String ln = this.ln();
                String msg = "The columnName is invalid: columnName=" + columnName + ln;
                msg = msg + "ResultSetMetaData returned invalid value." + ln;
                msg = msg + "sql=" + sql;
                throw new IllegalStateException(msg);
            }
            metaInfo.setColumnName(columnName);
            int columnType = md.getColumnType(i);
            metaInfo.setJdbcDefValue(columnType);
            String columnTypeName = md.getColumnTypeName(i);
            metaInfo.setDbTypeName(columnTypeName);
            int columnSize = md.getPrecision(i);
            if (!DfColumnHandler.isColumnSizeValid(columnSize)) {
                columnSize = md.getColumnDisplaySize(i);
            }
            metaInfo.setColumnSize(columnSize);
            int scale = md.getScale(i);
            metaInfo.setDecimalDigits(scale);
            if (forcedJavaNativeProvider != null) {
                String sql2entityForcedJavaNative = forcedJavaNativeProvider.provide(columnName);
                metaInfo.setSql2EntityForcedJavaNative(sql2entityForcedJavaNative);
            }
            columnMetaInfoMap.put(columnName, metaInfo);
        }
        return columnMetaInfoMap;
    }

    protected String ln() {
        return "\n";
    }

    public static interface DfForcedJavaNativeProvider {
        public String provide(String var1);
    }
}

