/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.replaceschema.loaddata.impl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.exception.DfTableDataRegistrationFailureException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.StringSet;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfColumnMetaInfo;
import org.seasar.dbflute.logic.replaceschema.loaddata.DfDelimiterDataWriter;
import org.seasar.dbflute.logic.replaceschema.loaddata.impl.DfAbsractDataWriter;
import org.seasar.dbflute.logic.replaceschema.loaddata.impl.DfDelimiterDataWriteSqlBuilder;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfDelimiterDataWriterImpl
extends DfAbsractDataWriter
implements DfDelimiterDataWriter {
    private static final Log _log = LogFactory.getLog(DfDelimiterDataWriterImpl.class);
    protected String _filename;
    protected String _encoding;
    protected String _delimiter;
    protected Map<String, Map<String, String>> _convertValueMap;
    protected Map<String, String> _defaultValueMap;
    protected final Map<String, Map<String, DfColumnMetaInfo>> _metaInfoCacheMap = StringKeyMap.createAsFlexible();

    public DfDelimiterDataWriterImpl(DataSource dataSource) {
        super(dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void writeData(Map<String, Set<String>> notFoundColumnMap) throws IOException {
        block48: {
            Statement ps;
            Connection conn;
            String lineString;
            String tableName;
            BufferedReader br;
            InputStreamReader ir;
            FileInputStream fis;
            block45: {
                Map<String, DfColumnMetaInfo> columnMetaInfoMap;
                _log.info((Object)"/= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = ");
                _log.info((Object)("writeData(" + this._filename + ", " + this._encoding + ")"));
                _log.info((Object)"= = = = = = =/");
                fis = null;
                ir = null;
                br = null;
                tableName = this._filename.substring(this._filename.lastIndexOf("/") + 1, this._filename.lastIndexOf("."));
                if (tableName.indexOf("-") >= 0) {
                    tableName = tableName.substring(tableName.indexOf("-") + "-".length());
                }
                if ((columnMetaInfoMap = this.getColumnMetaInfo(tableName)).isEmpty()) {
                    String msg = "The tableName[" + tableName + "] was not found: filename=" + this._filename;
                    throw new IllegalStateException(msg);
                }
                lineString = null;
                String preContinueString = "";
                ArrayList<String> columnNameList = new ArrayList<String>();
                ArrayList<String> additionalColumnList = new ArrayList<String>();
                ArrayList<String> valueList = new ArrayList<String>();
                conn = null;
                ps = null;
                fis = new FileInputStream(this._filename);
                ir = new InputStreamReader((InputStream)fis, this._encoding);
                br = new BufferedReader(ir);
                FirstLineInfo firstLineInfo = null;
                int loopIndex = -1;
                int addedBatchSize = 0;
                while (true) {
                    Object var27_37;
                    ++loopIndex;
                    lineString = br.readLine();
                    if (lineString == null) break;
                    if (loopIndex == 0) {
                        firstLineInfo = this.getFirstLineInfo(this._delimiter, lineString);
                        columnNameList.addAll(firstLineInfo.getColumnNameList());
                        StringSet columnSet = StringSet.createAsFlexible();
                        columnSet.addAll(columnNameList);
                        for (String defaultColumn : this._defaultValueMap.keySet()) {
                            if (columnSet.contains((Object)defaultColumn)) continue;
                            additionalColumnList.add(defaultColumn);
                        }
                        columnNameList.addAll(additionalColumnList);
                        continue;
                    }
                    String realLineString = preContinueString.equals("") ? lineString : preContinueString + "\n" + lineString;
                    ValueLineInfo valueLineInfo = this.arrangeValueList(realLineString, this._delimiter);
                    List<String> ls = valueLineInfo.getValueList();
                    if (valueLineInfo.isContinueNextLine()) {
                        preContinueString = ls.remove(ls.size() - 1);
                        valueList.addAll(ls);
                        continue;
                    }
                    valueList.addAll(ls);
                    try {
                        if (this.isDifferentColumnValueCount(firstLineInfo, valueList, lineString)) {
                            String msg = "The count of values wasn't correct:";
                            msg = msg + " columnNameSize=" + firstLineInfo.getColumnNameList().size();
                            msg = msg + " valueSize=" + valueList.size();
                            msg = msg + " lineString=" + lineString + " valueList=" + valueList;
                            _log.warn((Object)msg);
                            var27_37 = null;
                            valueList.clear();
                            preContinueString = "";
                            continue;
                        }
                        DfDelimiterDataWriteSqlBuilder sqlBuilder = new DfDelimiterDataWriteSqlBuilder();
                        sqlBuilder.setTableName(tableName);
                        sqlBuilder.setColumnMap(columnMetaInfoMap);
                        sqlBuilder.setColumnNameList(columnNameList);
                        sqlBuilder.setValueList(valueList);
                        sqlBuilder.setNotFoundColumnMap(notFoundColumnMap);
                        sqlBuilder.setConvertValueMap(this._convertValueMap);
                        sqlBuilder.setDefaultValueMap(this._defaultValueMap);
                        if (conn == null) {
                            conn = this._dataSource.getConnection();
                        }
                        if (ps == null) {
                            ps = conn.prepareStatement(sqlBuilder.buildSql());
                        }
                        Map<String, Object> columnValueMap = sqlBuilder.setupParameter();
                        if (this._loggingInsertSql) {
                            _log.info((Object)this.buildSql4Log(tableName, columnNameList, columnValueMap.values()));
                        }
                        int bindCount = 1;
                        Set<Map.Entry<String, Object>> entrySet = columnValueMap.entrySet();
                        for (Map.Entry<String, Object> entry : entrySet) {
                            Object obj;
                            String columnName = entry.getKey();
                            if (this.processNull(tableName, columnName, obj = entry.getValue(), (PreparedStatement)ps, bindCount, columnMetaInfoMap)) {
                                ++bindCount;
                                continue;
                            }
                            if (this.processNotNullNotString(tableName, columnName, obj, conn, (PreparedStatement)ps, bindCount, columnMetaInfoMap)) {
                                ++bindCount;
                                continue;
                            }
                            String value = (String)obj;
                            this.processNotNullString(tableName, columnName, value, conn, (PreparedStatement)ps, bindCount, columnMetaInfoMap);
                            ++bindCount;
                        }
                        if (this._suppressBatchUpdate) {
                            ps.execute();
                        } else {
                            ps.addBatch();
                            if (++addedBatchSize == 100000) {
                                ps.executeBatch();
                                ps.clearBatch();
                                addedBatchSize = 0;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        var27_37 = null;
                        valueList.clear();
                        preContinueString = "";
                        throw throwable;
                    }
                    var27_37 = null;
                    valueList.clear();
                    preContinueString = "";
                }
                if (ps == null || addedBatchSize <= 0) break block45;
                ps.executeBatch();
            }
            Object var29_39 = null;
            try {
                if (fis != null) {
                    fis.close();
                }
                if (ir != null) {
                    ir.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ignored) {
                _log.warn((Object)"File-close threw the exception: ", (Throwable)ignored);
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ignored) {
                    _log.info((Object)"Statement.close() threw the exception!", (Throwable)ignored);
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ignored) {
                    _log.info((Object)"Connection.close() threw the exception!", (Throwable)ignored);
                }
            }
            break block48;
            {
                catch (FileNotFoundException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (SQLException e) {
                    SQLException nextEx = e.getNextException();
                    if (nextEx != null && !e.equals(nextEx)) {
                        _log.warn((Object)("*Failed to register: " + e.getMessage()));
                        String msg = this.buildExceptionMessage(this._filename, tableName, lineString, nextEx);
                        throw new DfTableDataRegistrationFailureException(msg, nextEx);
                    }
                    String msg = this.buildExceptionMessage(this._filename, tableName, lineString, e);
                    throw new DfTableDataRegistrationFailureException(msg, e);
                }
                catch (RuntimeException e) {
                    String msg = this.buildExceptionMessage(this._filename, tableName, lineString, e);
                    throw new DfTableDataRegistrationFailureException(msg, e);
                }
            }
            catch (Throwable throwable) {
                Object var29_40 = null;
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    if (ir != null) {
                        ir.close();
                    }
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ignored) {
                    _log.warn((Object)"File-close threw the exception: ", (Throwable)ignored);
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException ignored) {
                        _log.info((Object)"Statement.close() threw the exception!", (Throwable)ignored);
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ignored) {
                        _log.info((Object)"Connection.close() threw the exception!", (Throwable)ignored);
                    }
                }
                throw throwable;
            }
        }
    }

    protected String buildExceptionMessage(String filename, String tableName, String lineString, Exception e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to register the table data.");
        br.addItem("File");
        br.addElement((Object)filename);
        br.addItem("Table");
        br.addElement((Object)tableName);
        br.addItem("Line String");
        br.addElement((Object)lineString);
        br.addItem("Message");
        br.addElement((Object)e.getMessage());
        Map bindTypeCacheMap = (Map)this._bindTypeCacheMap.get(tableName);
        if (bindTypeCacheMap != null) {
            br.addItem("Bind Type");
            Set entrySet = bindTypeCacheMap.entrySet();
            for (Map.Entry entry : entrySet) {
                br.addElement((Object)((String)entry.getKey() + " = " + entry.getValue()));
            }
        }
        Map stringProcessorCacheMap = (Map)this._stringProcessorCacheMap.get(tableName);
        if (bindTypeCacheMap != null) {
            br.addItem("String Processor");
            Set entrySet = stringProcessorCacheMap.entrySet();
            for (Map.Entry entry : entrySet) {
                br.addElement((Object)((String)entry.getKey() + " = " + entry.getValue()));
            }
        }
        return br.buildExceptionMessage();
    }

    @Override
    protected boolean isNullValue(Object value) {
        if (value == null) {
            return true;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String str = (String)value;
        return str.length() == 0 || str.equals("\"\"");
    }

    protected FirstLineInfo getFirstLineInfo(String delimiter, String lineString) {
        ArrayList<String> columnNameList = new ArrayList<String>();
        String[] values = lineString.split(delimiter);
        int count = 0;
        boolean quotated = false;
        for (String value : values) {
            if (count == 0 && value != null && value.startsWith("\"") && value.endsWith("\"")) {
                quotated = true;
            }
            this.addValueToList(columnNameList, value);
            ++count;
        }
        FirstLineInfo firstLineInformation = new FirstLineInfo();
        firstLineInformation.setColumnNameList(columnNameList);
        firstLineInformation.setQuotated(quotated);
        return firstLineInformation;
    }

    protected void addValueToList(List<String> ls, String value) {
        if (value != null && value.startsWith("\"") && value.endsWith("\"")) {
            ls.add(value.substring(1, value.length() - 1));
        } else {
            ls.add(value != null ? value : "");
        }
    }

    protected String buildSql4Log(String tableName, List<String> columnNameList, Collection<Object> bindParameters) {
        String bindParameterString = bindParameters.toString();
        bindParameterString = bindParameterString.substring(1, bindParameterString.length() - 1);
        return tableName + ":{" + bindParameterString + "}";
    }

    protected ValueLineInfo arrangeValueList(String lineString, String delimiter) {
        List valueList = Srl.splitList((String)lineString, (String)delimiter);
        return this.arrangeValueList(valueList, delimiter);
    }

    protected ValueLineInfo arrangeValueList(List<String> valueList, String delimiter) {
        ValueLineInfo valueLineInfo = new ValueLineInfo();
        ArrayList<String> resultList = new ArrayList<String>();
        String preString = "";
        for (int i = 0; i < valueList.size(); ++i) {
            String value = valueList.get(i);
            if (value == null) continue;
            if (i == valueList.size() - 1) {
                if (preString.equals("")) {
                    if (this.isFrontQOnly(value)) {
                        valueLineInfo.setContinueNextLine(true);
                        resultList.add(value);
                        break;
                    }
                    if (this.isRearQOnly(value)) {
                        resultList.add(value);
                        break;
                    }
                    if (this.isNotBothQ(value)) {
                        resultList.add(value);
                        break;
                    }
                    resultList.add(this.removeDoubleQuotation(value));
                    break;
                }
                if (this.endsQuote(value, false)) {
                    resultList.add(this.removeDoubleQuotation(this.connectPreString(preString, delimiter, value)));
                    break;
                }
                valueLineInfo.setContinueNextLine(true);
                resultList.add(this.connectPreString(preString, delimiter, value));
                break;
            }
            if (preString.equals("")) {
                if (this.isFrontQOnly(value)) {
                    preString = value;
                    continue;
                }
                if (this.isRearQOnly(value)) {
                    preString = value;
                    continue;
                }
                if (this.isNotBothQ(value)) {
                    resultList.add(value);
                } else {
                    resultList.add(this.removeDoubleQuotation(value));
                }
            } else if (this.endsQuote(value, false)) {
                resultList.add(this.removeDoubleQuotation(this.connectPreString(preString, delimiter, value)));
            } else {
                preString = this.connectPreString(preString, delimiter, value);
                continue;
            }
            preString = "";
        }
        valueLineInfo.setValueList(resultList);
        return valueLineInfo;
    }

    protected String connectPreString(String preString, String delimiter, String value) {
        if (preString.equals("")) {
            return value;
        }
        return preString + delimiter + value;
    }

    protected boolean isNotBothQ(String value) {
        return !this.isQQ(value) && !value.startsWith("\"") && !this.endsQuote(value, false);
    }

    protected boolean isRearQOnly(String value) {
        return !this.isQQ(value) && !value.startsWith("\"") && this.endsQuote(value, false);
    }

    protected boolean isFrontQOnly(String value) {
        return !this.isQQ(value) && value.startsWith("\"") && !this.endsQuote(value, true);
    }

    protected boolean isQQ(String value) {
        return value.equals("\"\"");
    }

    protected boolean endsQuote(String value, boolean startsQuote) {
        char ch;
        value = startsQuote ? value.substring(1) : value;
        int length = value.length();
        int count = 0;
        for (int i = 0; i < length && (ch = value.charAt(length - (i + 1))) == '\"'; ++i) {
            ++count;
        }
        return count > 0 && this.isOddNumber(count);
    }

    protected boolean isOddNumber(int number) {
        return number % 2 != 0;
    }

    protected String removeDoubleQuotation(String value) {
        if (!value.startsWith("\"") && !value.endsWith("\"")) {
            return value;
        }
        if (value.startsWith("\"")) {
            value = value.substring(1);
        }
        if (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        value = Srl.replace((String)value, (String)"\"\"", (String)"\"");
        return value;
    }

    protected String removeRightDoubleQuotation(String value) {
        if (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    protected boolean isDifferentColumnValueCount(FirstLineInfo firstLineInfo, List<String> valueList, String lineString) {
        return valueList.size() < firstLineInfo.getColumnNameList().size();
    }

    public String getDelimiter() {
        return this._delimiter;
    }

    public void setDelimiter(String delimiter) {
        this._delimiter = delimiter;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public String getFilename() {
        return this._filename;
    }

    public void setFilename(String filename) {
        this._filename = filename;
    }

    public Map<String, Map<String, String>> getConvertValueMap() {
        return this._convertValueMap;
    }

    public void setConvertValueMap(Map<String, Map<String, String>> convertValueMap) {
        this._convertValueMap = convertValueMap;
    }

    public Map<String, String> getDefaultValueMap() {
        return this._defaultValueMap;
    }

    public void setDefaultValueMap(Map<String, String> defaultValueMap) {
        this._defaultValueMap = defaultValueMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValueLineInfo {
        protected List<String> valueList;
        protected boolean continueNextLine;

        public List<String> getValueList() {
            return this.valueList;
        }

        public void setValueList(List<String> valueList) {
            this.valueList = valueList;
        }

        public boolean isContinueNextLine() {
            return this.continueNextLine;
        }

        public void setContinueNextLine(boolean continueNextLine) {
            this.continueNextLine = continueNextLine;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FirstLineInfo {
        protected List<String> columnNameList;
        protected boolean quotated;

        public List<String> getColumnNameToLowerList() {
            ArrayList<String> ls = new ArrayList<String>();
            for (String columnName : this.columnNameList) {
                ls.add(columnName.toLowerCase());
            }
            return ls;
        }

        public List<String> getColumnNameList() {
            return this.columnNameList;
        }

        public void setColumnNameList(List<String> columnNameList) {
            this.columnNameList = columnNameList;
        }

        public boolean isQuotated() {
            return this.quotated;
        }

        public void setQuotated(boolean quotated) {
            this.quotated = quotated;
        }
    }
}

