/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.various.array;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.StringSet;
import org.seasar.dbflute.helper.jdbc.facade.DfJdbcFacade;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTypeArrayInfo;
import org.seasar.dbflute.logic.jdbc.metadata.procedure.DfProcedureParameterExtractorOracle;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfArrayExtractorOracle {
    private static final Log _log = LogFactory.getLog(DfArrayExtractorOracle.class);
    protected final DataSource _dataSource;
    protected final boolean _suppressLogging;

    public DfArrayExtractorOracle(DataSource dataSource, boolean suppressLogging) {
        this._dataSource = dataSource;
        this._suppressLogging = suppressLogging;
    }

    public StringKeyMap<DfTypeArrayInfo> extractFlatArrayInfoMap(UnifiedSchema unifiedSchema) {
        StringKeyMap<DfTypeArrayInfo> firstMap = this.doExtractFlatArrayInfoFirstMap(unifiedSchema);
        if (!firstMap.isEmpty()) {
            return firstMap;
        }
        return this.doExtractFlatArrayInfoSecondMap(unifiedSchema);
    }

    protected StringKeyMap<DfTypeArrayInfo> doExtractFlatArrayInfoFirstMap(UnifiedSchema unifiedSchema) {
        List<Map<String, String>> resultList = this.selectFirstArray(unifiedSchema);
        StringKeyMap arrayTypeMap = StringKeyMap.createAsFlexibleOrdered();
        for (Map<String, String> map : resultList) {
            String typeName = this.buildArrayTypeName(map.get("TYPE_NAME"), unifiedSchema);
            DfTypeArrayInfo arrayInfo = new DfTypeArrayInfo(unifiedSchema, typeName);
            String elementTypeOwner = map.get("ELEM_TYPE_OWNER");
            String elementTypeName = map.get("ELEM_TYPE_NAME");
            String elementType = Srl.connectPrefix((String)elementTypeName, (String)elementTypeOwner, (String)".");
            arrayInfo.setElementType(elementType);
            arrayTypeMap.put(typeName, (Object)arrayInfo);
        }
        return arrayTypeMap;
    }

    protected List<Map<String, String>> selectFirstArray(UnifiedSchema unifiedSchema) {
        List<Map<String, String>> resultList;
        DfJdbcFacade facade = new DfJdbcFacade(this._dataSource);
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.add("TYPE_NAME");
        columnList.add("COLL_TYPE");
        columnList.add("ELEM_TYPE_OWNER");
        columnList.add("ELEM_TYPE_NAME");
        columnList.add("LENGTH");
        columnList.add("PRECISION");
        columnList.add("SCALE");
        String sql = this.buildFirstArraySql(unifiedSchema);
        try {
            this.log(sql);
            resultList = facade.selectStringList(sql, columnList);
        }
        catch (Exception continued) {
            this.log("Failed to select first array info: " + continued.getMessage());
            return DfCollectionUtil.emptyList();
        }
        return resultList;
    }

    protected String buildFirstArraySql(UnifiedSchema unifiedSchema) {
        StringBuilder sb = new StringBuilder();
        sb.append("select *");
        sb.append(" from ALL_COLL_TYPES");
        sb.append(" where OWNER = '" + unifiedSchema.getPureSchema() + "'");
        sb.append(" order by TYPE_NAME");
        return sb.toString();
    }

    protected StringKeyMap<DfTypeArrayInfo> doExtractFlatArrayInfoSecondMap(UnifiedSchema unifiedSchema) {
        StringKeyMap flatArrayInfoMap = StringKeyMap.createAsFlexibleOrdered();
        List<DfProcedureParameterExtractorOracle.ProcedureArgumentInfo> argInfoList = this.extractProcedureArgumentInfoList(unifiedSchema);
        for (int i = 0; i < argInfoList.size(); ++i) {
            String typeName;
            String dataType;
            DfProcedureParameterExtractorOracle.ProcedureArgumentInfo argInfo = argInfoList.get(i);
            String argumentName = argInfo.getArgumentName();
            if (Srl.is_Null_or_TrimmedEmpty((String)argumentName) || !this.isDataTypeArray(dataType = argInfo.getDataType()) || Srl.is_Null_or_TrimmedEmpty((String)(typeName = argInfo.getTypeName()))) continue;
            this.setupFlatArrayInfo((StringKeyMap<DfTypeArrayInfo>)flatArrayInfoMap, argInfoList, argInfo, i);
        }
        StringSet allArrayTypeSet = this.extractSimpleArrayNameSet(unifiedSchema);
        for (String allArrayTypeName : allArrayTypeSet) {
            if (flatArrayInfoMap.containsKey((Object)allArrayTypeName)) continue;
            DfTypeArrayInfo arrayInfo = new DfTypeArrayInfo(unifiedSchema, allArrayTypeName);
            arrayInfo.setElementType("Unknown");
            flatArrayInfoMap.put(allArrayTypeName, (Object)arrayInfo);
        }
        return flatArrayInfoMap;
    }

    protected void setupFlatArrayInfo(StringKeyMap<DfTypeArrayInfo> flatArrayInfoMap, List<DfProcedureParameterExtractorOracle.ProcedureArgumentInfo> argInfoList, DfProcedureParameterExtractorOracle.ProcedureArgumentInfo argInfo, int index) {
        UnifiedSchema owner = UnifiedSchema.createAsDynamicSchema(null, argInfo.getTypeOwner());
        String realTypeName = this.buildArrayTypeName(argInfo);
        DfTypeArrayInfo arrayInfo = new DfTypeArrayInfo(owner, realTypeName);
        boolean nestedArray = this.reflectArrayElementType(argInfoList, index, arrayInfo);
        flatArrayInfoMap.put(realTypeName, (Object)arrayInfo);
        if (nestedArray) {
            int nextIndex = index + 1;
            DfProcedureParameterExtractorOracle.ProcedureArgumentInfo nextArgInfo = argInfoList.get(nextIndex);
            this.setupFlatArrayInfo(flatArrayInfoMap, argInfoList, nextArgInfo, nextIndex);
        }
    }

    protected boolean reflectArrayElementType(List<DfProcedureParameterExtractorOracle.ProcedureArgumentInfo> argInfoList, int i, DfTypeArrayInfo arrayInfo) {
        boolean nestedArray = false;
        int nextIndex = i + 1;
        if (argInfoList.size() > nextIndex) {
            DfProcedureParameterExtractorOracle.ProcedureArgumentInfo nextInfo = argInfoList.get(nextIndex);
            if (Srl.is_Null_or_TrimmedEmpty((String)nextInfo.getArgumentName())) {
                String elementType;
                String typeName = nextInfo.getTypeName();
                String dataType = nextInfo.getDataType();
                if (Srl.is_NotNull_and_NotTrimmedEmpty((String)typeName)) {
                    if (this.isDataTypeArray(dataType)) {
                        nestedArray = true;
                    }
                    elementType = this.buildArrayTypeName(nextInfo);
                } else {
                    elementType = dataType;
                }
                arrayInfo.setElementType(elementType);
            }
        } else {
            this.log("*Unexpected, no next record for array meta: " + arrayInfo);
            arrayInfo.setElementType("Unknown");
        }
        return nestedArray;
    }

    protected boolean isDataTypeArray(String dataType) {
        return Srl.containsAnyIgnoreCase((String)dataType, (String[])new String[]{"TABLE", "VARRAY"});
    }

    protected boolean isDataTypeStruct(String dataType) {
        return Srl.equalsIgnoreCase((String)dataType, (String[])new String[]{"OBJECT"});
    }

    protected String buildArrayTypeName(DfProcedureParameterExtractorOracle.ProcedureArgumentInfo argInfo) {
        return argInfo.buildArrayTypeName();
    }

    protected List<DfProcedureParameterExtractorOracle.ProcedureArgumentInfo> extractProcedureArgumentInfoList(UnifiedSchema unifiedSchema) {
        DfProcedureParameterExtractorOracle extractor = this.createProcedureParameterExtractorOracle();
        return extractor.extractProcedureArgumentInfoList(unifiedSchema);
    }

    protected DfProcedureParameterExtractorOracle createProcedureParameterExtractorOracle() {
        return new DfProcedureParameterExtractorOracle(this._dataSource, this._suppressLogging);
    }

    protected StringSet extractSimpleArrayNameSet(UnifiedSchema unifiedSchema) {
        List<Map<String, String>> resultList = this.selectSimpleArray(unifiedSchema);
        StringSet arrayTypeSet = StringSet.createAsFlexibleOrdered();
        for (Map<String, String> map : resultList) {
            arrayTypeSet.add(this.buildArrayTypeName(map.get("TYPE_NAME"), unifiedSchema));
        }
        return arrayTypeSet;
    }

    protected List<Map<String, String>> selectSimpleArray(UnifiedSchema unifiedSchema) {
        List<Map<String, String>> resultList;
        DfJdbcFacade facade = new DfJdbcFacade(this._dataSource);
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.add("TYPE_NAME");
        String sql = this.buildSimpleArraySql(unifiedSchema);
        try {
            this.log(sql);
            resultList = facade.selectStringList(sql, columnList);
        }
        catch (Exception continued) {
            this.log("Failed to select simple array info: " + continued.getMessage());
            return DfCollectionUtil.emptyList();
        }
        return resultList;
    }

    protected String buildSimpleArraySql(UnifiedSchema unifiedSchema) {
        StringBuilder sb = new StringBuilder();
        sb.append("select *");
        sb.append(" from ALL_TYPES");
        sb.append(" where OWNER = '" + unifiedSchema.getPureSchema() + "'");
        sb.append(" and TYPECODE = 'COLLECTION'");
        sb.append(" order by TYPE_NAME");
        return sb.toString();
    }

    public String buildArrayTypeName(String typeName, UnifiedSchema unifiedSchema) {
        return Srl.connectPrefix((String)typeName, (String)unifiedSchema.getPureSchema(), (String)".");
    }

    protected void log(String msg) {
        if (this._suppressLogging) {
            return;
        }
        _log.info((Object)msg);
    }
}

