/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.info;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.logic.jdbc.metadata.comment.DfDbCommentExtractor;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfColumnMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfForeignKeyMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfPrimaryKeyMetaInfo;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSynonymMetaInfo {
    protected UnifiedSchema _synonymOwner;
    protected String _synonymName;
    protected UnifiedSchema _tableOwner;
    protected String _tableName;
    protected DfPrimaryKeyMetaInfo _primaryKey;
    protected boolean _autoIncrement;
    protected Map<String, Map<Integer, String>> _uniqueKeyMap;
    protected Map<String, DfForeignKeyMetaInfo> _foreignKeyMap;
    protected Map<String, Map<Integer, String>> _indexMap;
    protected String _dbLinkName;
    protected List<DfColumnMetaInfo> _columnMetaInfoList4DBLink;
    protected boolean _selectable;
    protected boolean _procedureSynonym;
    protected boolean _sequenceSynonym;
    protected String _tableComment;
    protected Map<String, DfDbCommentExtractor.UserColComments> _columnCommentMap;

    public boolean isDBLink() {
        return this._dbLinkName != null;
    }

    public boolean hasTableComment() {
        return this._tableComment != null && this._tableComment.trim().length() > 0;
    }

    public boolean hasColumnCommentMap() {
        return this._columnCommentMap != null && !this._columnCommentMap.isEmpty();
    }

    public String buildSynonymFullQualifiedName() {
        return this._synonymOwner.buildFullQualifiedName(this._synonymName);
    }

    public String buildSynonymSchemaQualifiedName() {
        return this._synonymOwner.buildSchemaQualifiedName(this._synonymName);
    }

    public String buildSynonymSqlName() {
        return this._synonymOwner.buildSqlName(this._synonymName);
    }

    public String toString() {
        String comment = "";
        if (this._tableComment != null) {
            String ln = DfSystemUtil.getLineSeparator();
            int indexOf = this._tableComment.indexOf(ln);
            comment = indexOf > 0 ? this._tableComment.substring(0, indexOf) + "..." : this._tableComment;
        }
        String columns = "";
        if (this._columnMetaInfoList4DBLink != null) {
            columns = "(" + this._columnMetaInfoList4DBLink.size() + " columns for DB link)";
        }
        String synonymSchema = this._synonymOwner != null ? this._synonymOwner.getPureSchema() : "";
        String tableSchema = this._tableOwner != null ? this._tableOwner.getPureSchema() : "";
        return synonymSchema + "." + this._synonymName + ":{" + (this._dbLinkName != null ? this._dbLinkName : tableSchema) + "." + this._tableName + columns + ", PK=" + this._primaryKey + (this._autoIncrement ? ", ID" : "") + ", " + (this._uniqueKeyMap != null ? "UQ=" + this._uniqueKeyMap.size() : null) + ", " + (this._foreignKeyMap != null ? "FK=" + this._foreignKeyMap.size() : null) + ", " + (this._selectable ? "selectable" : "unselectable") + "}" + (comment != null && comment.trim().length() > 0 ? " // " + comment : "");
    }

    public UnifiedSchema getSynonymOwner() {
        return this._synonymOwner;
    }

    public void setSynonymOwner(UnifiedSchema synonymOwner) {
        this._synonymOwner = synonymOwner;
    }

    public String getSynonymName() {
        return this._synonymName;
    }

    public void setSynonymName(String synonymName) {
        this._synonymName = synonymName;
    }

    public UnifiedSchema getTableOwner() {
        return this._tableOwner;
    }

    public void setTableOwner(UnifiedSchema tableOwner) {
        this._tableOwner = tableOwner;
    }

    public String getTableName() {
        return this._tableName;
    }

    public void setTableName(String tableName) {
        this._tableName = tableName;
    }

    public DfPrimaryKeyMetaInfo getPrimaryKey() {
        return this._primaryKey;
    }

    public void setPrimaryKey(DfPrimaryKeyMetaInfo primaryKey) {
        this._primaryKey = primaryKey;
    }

    public boolean isAutoIncrement() {
        return this._autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this._autoIncrement = autoIncrement;
    }

    public Map<String, Map<Integer, String>> getUniqueKeyMap() {
        return this._uniqueKeyMap != null ? this._uniqueKeyMap : new HashMap<String, Map<Integer, String>>();
    }

    public void setUniqueKeyMap(Map<String, Map<Integer, String>> uniqueKeyMap) {
        this._uniqueKeyMap = uniqueKeyMap;
    }

    public Map<String, DfForeignKeyMetaInfo> getForeignKeyMap() {
        return this._foreignKeyMap != null ? this._foreignKeyMap : new HashMap<String, DfForeignKeyMetaInfo>();
    }

    public void setForeignKeyMap(Map<String, DfForeignKeyMetaInfo> foreignKeyMap) {
        this._foreignKeyMap = foreignKeyMap;
    }

    public Map<String, Map<Integer, String>> getIndexMap() {
        return this._indexMap != null ? this._indexMap : new HashMap<String, Map<Integer, String>>();
    }

    public void setIndexMap(Map<String, Map<Integer, String>> indexMap) {
        this._indexMap = indexMap;
    }

    public String getDBLinkName() {
        return this._dbLinkName;
    }

    public void setDBLinkName(String dbLinkName) {
        this._dbLinkName = dbLinkName;
    }

    public List<DfColumnMetaInfo> getColumnMetaInfoList4DBLink() {
        return this._columnMetaInfoList4DBLink != null ? this._columnMetaInfoList4DBLink : new ArrayList<DfColumnMetaInfo>();
    }

    public void setColumnMetaInfoList4DBLink(List<DfColumnMetaInfo> columnMetaInfoList4DBLink) {
        this._columnMetaInfoList4DBLink = columnMetaInfoList4DBLink;
    }

    public boolean isSelectable() {
        return this._selectable;
    }

    public void setSelectable(boolean selectable) {
        this._selectable = selectable;
    }

    public String getTableComment() {
        return this._tableComment;
    }

    public void setTableComment(String tableComment) {
        this._tableComment = tableComment;
    }

    public Map<String, DfDbCommentExtractor.UserColComments> getColumnCommentMap() {
        return this._columnCommentMap;
    }

    public void setColumnCommentMap(Map<String, DfDbCommentExtractor.UserColComments> columnCommentMap) {
        this._columnCommentMap = columnCommentMap;
    }
}

