/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.handler;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.helper.StringSet;
import org.seasar.dbflute.logic.jdbc.handler.DfAbstractMetaDataHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTableMetaInfo;
import org.seasar.dbflute.properties.assistant.DfAdditionalSchemaInfo;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfTableHandler
extends DfAbstractMetaDataHandler {
    private static final Log _log = LogFactory.getLog(DfTableHandler.class);

    public List<DfTableMetaInfo> getTableList(DatabaseMetaData metaData, UnifiedSchema unifiedSchema) throws SQLException {
        return this.doGetTableList(metaData, unifiedSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<DfTableMetaInfo> doGetTableList(DatabaseMetaData metaData, UnifiedSchema unifiedSchema) throws SQLException {
        Object[] objectTypes = this.getRealObjectTypeTargetArray(unifiedSchema);
        ArrayList<DfTableMetaInfo> tableList = new ArrayList<DfTableMetaInfo>();
        ResultSet rs = null;
        try {
            _log.info((Object)"...Getting tables:");
            _log.info((Object)("  schema = " + unifiedSchema));
            _log.info((Object)("  types  = " + DfCollectionUtil.newArrayList((Object[])objectTypes)));
            String catalogName = unifiedSchema.getPureCatalog();
            String schemaName = unifiedSchema.getPureSchema();
            rs = metaData.getTables(catalogName, schemaName, "%", (String[])objectTypes);
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                String tableType = rs.getString("TABLE_TYPE");
                String plainCatalog = rs.getString("TABLE_CAT");
                String tableCatalog = Srl.is_NotNull_and_NotTrimmedEmpty((String)plainCatalog) ? plainCatalog : catalogName;
                String tableSchema = rs.getString("TABLE_SCHEM");
                String tableComment = rs.getString("REMARKS");
                UnifiedSchema tableUnifiedSchema = this.createAsDynamicSchema(tableCatalog, tableSchema);
                if (this.isTableExcept(tableUnifiedSchema, tableName)) {
                    _log.info((Object)(tableName + " is excepted!"));
                    continue;
                }
                if (this.isSystemTableForDBMS(tableName)) {
                    _log.info((Object)(tableName + " is excepted! {system table}"));
                    continue;
                }
                DfTableMetaInfo tableMetaInfo = new DfTableMetaInfo();
                tableMetaInfo.setTableName(tableName);
                tableMetaInfo.setTableType(tableType);
                tableMetaInfo.setUnifiedSchema(tableUnifiedSchema);
                tableMetaInfo.setTableComment(tableComment);
                tableList.add(tableMetaInfo);
            }
            Object var16_15 = null;
            if (rs == null) return tableList;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            if (rs == null) throw throwable;
            rs.close();
            throw throwable;
        }
        rs.close();
        return tableList;
    }

    public boolean isSystemTableForDBMS(String tableName) {
        if (this.isDatabaseOracle() && tableName.startsWith("BIN$")) {
            return true;
        }
        if (this.isDatabaseSQLServer()) {
            StringSet systemSet = StringSet.createAsFlexible();
            systemSet.add("sysobjects");
            systemSet.add("sysconstraints");
            systemSet.add("syssegments");
            if (systemSet.contains(tableName)) {
                return true;
            }
        }
        return this.isDatabaseSQLite() && tableName.startsWith("sqlite_");
    }

    protected String[] getRealObjectTypeTargetArray(UnifiedSchema unifiedSchema) {
        DfAdditionalSchemaInfo schemaInfo;
        if (unifiedSchema != null && (schemaInfo = this.getAdditionalSchemaInfo(unifiedSchema)) != null) {
            List<String> objectTypeTargetList = schemaInfo.getObjectTypeTargetList();
            this.assertObjectTypeTargetListNotEmpty(unifiedSchema, objectTypeTargetList);
            return objectTypeTargetList.toArray(new String[objectTypeTargetList.size()]);
        }
        List<String> objectTypeTargetList = this.getProperties().getDatabaseProperties().getObjectTypeTargetList();
        this.assertObjectTypeTargetListNotEmpty(unifiedSchema, objectTypeTargetList);
        return objectTypeTargetList.toArray(new String[objectTypeTargetList.size()]);
    }

    protected void assertObjectTypeTargetListNotEmpty(UnifiedSchema unifiedSchema, List<String> objectTypeTargetList) {
        if (objectTypeTargetList == null || objectTypeTargetList.isEmpty()) {
            String msg = "The property 'objectTypeTargetList' should be required:";
            msg = msg + " unifiedSchema=" + unifiedSchema;
            throw new IllegalStateException(msg);
        }
    }

    public Map<String, DfTableMetaInfo> getTableMap(DatabaseMetaData metaData, UnifiedSchema unifiedSchema) throws SQLException {
        List<DfTableMetaInfo> tableList = this.getTableList(metaData, unifiedSchema);
        Map map = DfCollectionUtil.newLinkedHashMap();
        for (DfTableMetaInfo tableInfo : tableList) {
            map.put(tableInfo.getTableName(), tableInfo);
        }
        return map;
    }
}

