/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.handler;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.logic.jdbc.handler.DfAbstractMetaDataHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTableMetaInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfIndexHandler
extends DfAbstractMetaDataHandler {
    private static final Log _log = LogFactory.getLog(DfIndexHandler.class);

    public Map<String, Map<Integer, String>> getIndexMap(DatabaseMetaData metaData, DfTableMetaInfo tableInfo, Map<String, Map<Integer, String>> uniqueKeyMap) throws SQLException {
        UnifiedSchema unifiedSchema = tableInfo.getUnifiedSchema();
        String tableName = tableInfo.getTableName();
        if (tableInfo.isTableTypeView()) {
            return this.newLinkedHashMap();
        }
        return this.getIndexMap(metaData, unifiedSchema, tableName, uniqueKeyMap);
    }

    public Map<String, Map<Integer, String>> getIndexMap(DatabaseMetaData metaData, UnifiedSchema unifiedSchema, String tableName, Map<String, Map<Integer, String>> uniqueKeyMap) throws SQLException {
        Map<String, Map<Integer, String>> resultMap = this.doGetIndexMap(metaData, unifiedSchema, tableName, uniqueKeyMap);
        if (resultMap.isEmpty()) {
            resultMap = this.doGetIndexMap(metaData, unifiedSchema, tableName.toLowerCase(), uniqueKeyMap);
        }
        if (resultMap.isEmpty()) {
            resultMap = this.doGetIndexMap(metaData, unifiedSchema, tableName.toUpperCase(), uniqueKeyMap);
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Map<String, Map<Integer, String>> doGetIndexMap(DatabaseMetaData dbMeta, UnifiedSchema unifiedSchema, String tableName, Map<String, Map<Integer, String>> uniqueKeyMap) throws SQLException {
        LinkedHashMap<String, Map<Integer, String>> indexMap = new LinkedHashMap<String, Map<Integer, String>>();
        ResultSet rs = null;
        try {
            boolean uniqueKeyOnly = false;
            String catalogName = unifiedSchema.getPureCatalog();
            String schemaName = unifiedSchema.getPureSchema();
            rs = dbMeta.getIndexInfo(catalogName, schemaName, tableName, false, true);
            while (rs.next()) {
                Map<Object, Object> indexElementMap;
                Integer ordinalPosition;
                String metaTableName = rs.getString(3);
                if (this.checkMetaTableDiffIfNeeds(tableName, metaTableName)) continue;
                String indexName = rs.getString(6);
                Boolean nonUnique = rs.getBoolean(4);
                boolean isNonUnique = nonUnique != null && nonUnique != false;
                if (!isNonUnique || uniqueKeyMap != null && uniqueKeyMap.containsKey(indexName)) continue;
                String indexType = rs.getString(7);
                String columnName = rs.getString(9);
                if (columnName == null || columnName.trim().length() == 0 || this.isColumnExcept(unifiedSchema, tableName, columnName)) continue;
                String ordinalPositionString = rs.getString(8);
                if (ordinalPositionString == null) {
                    String msg = "The unique columnName should have ordinal-position but null: ";
                    msg = msg + " columnName=" + columnName + " indexType=" + indexType;
                    _log.warn((Object)msg);
                    continue;
                }
                try {
                    ordinalPosition = Integer.parseInt(ordinalPositionString);
                }
                catch (NumberFormatException e) {
                    String msg = "The unique column should have ordinal-position as number but: ";
                    msg = msg + ordinalPositionString + " columnName=" + columnName + " indexType=" + indexType;
                    _log.warn((Object)msg);
                    continue;
                }
                if (indexMap.containsKey(indexName)) {
                    indexElementMap = (Map)indexMap.get(indexName);
                    indexElementMap.put(ordinalPosition, columnName);
                    continue;
                }
                indexElementMap = this.newLinkedHashMap();
                indexElementMap.put(ordinalPosition, columnName);
                indexMap.put(indexName, indexElementMap);
            }
            Object var20_20 = null;
            if (rs == null) return indexMap;
        }
        catch (Throwable throwable) {
            Object var20_21 = null;
            if (rs == null) throw throwable;
            rs.close();
            throw throwable;
        }
        rs.close();
        return indexMap;
    }
}

