/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.handler;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.helper.StringSet;
import org.seasar.dbflute.logic.jdbc.handler.DfAbstractMetaDataHandler;
import org.seasar.dbflute.logic.jdbc.mapping.DfJdbcTypeMapper;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfColumnMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTableMetaInfo;
import org.seasar.dbflute.properties.DfTypeMappingProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfColumnHandler
extends DfAbstractMetaDataHandler {
    private static final Log _log = LogFactory.getLog(DfColumnHandler.class);
    protected DfJdbcTypeMapper _jdbcTypeMapper;

    public List<DfColumnMetaInfo> getColumnList(DatabaseMetaData metaData, DfTableMetaInfo tableInfo) throws SQLException {
        UnifiedSchema unifiedSchema = tableInfo.getUnifiedSchema();
        String tableName = tableInfo.getTableName();
        return this.getColumnList(metaData, unifiedSchema, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DfColumnMetaInfo> getColumnList(DatabaseMetaData metaData, UnifiedSchema unifiedSchema, String tableName) throws SQLException {
        ArrayList<DfColumnMetaInfo> columns = new ArrayList<DfColumnMetaInfo>();
        ResultSet columnResultSet = null;
        ResultSet lowerSpare = null;
        ResultSet upperSpare = null;
        try {
            String catalogName = unifiedSchema.getPureCatalog();
            String schemaName = unifiedSchema.getPureSchema();
            columnResultSet = metaData.getColumns(catalogName, schemaName, tableName, null);
            this.setupColumnMetaInfo(columns, columnResultSet, unifiedSchema, tableName);
            if (columns.isEmpty()) {
                lowerSpare = metaData.getColumns(catalogName, schemaName, tableName.toLowerCase(), null);
                this.setupColumnMetaInfo(columns, lowerSpare, unifiedSchema, tableName);
            }
            if (columns.isEmpty()) {
                upperSpare = metaData.getColumns(catalogName, schemaName, tableName.toUpperCase(), null);
                this.setupColumnMetaInfo(columns, upperSpare, unifiedSchema, tableName);
            }
        }
        finally {
            if (columnResultSet != null) {
                try {
                    columnResultSet.close();
                }
                catch (SQLException ignored) {}
            }
            if (lowerSpare != null) {
                try {
                    lowerSpare.close();
                }
                catch (SQLException ignored) {}
            }
            if (upperSpare != null) {
                try {
                    upperSpare.close();
                }
                catch (SQLException ignored) {}
            }
        }
        return columns;
    }

    protected void setupColumnMetaInfo(List<DfColumnMetaInfo> columns, ResultSet columnResultSet, UnifiedSchema unifiedSchema, String tableName) throws SQLException {
        StringSet columnNameSet = StringSet.createAsFlexible();
        StringSet duplicateTableNameSet = StringSet.createAsFlexible();
        StringSet duplicateColumnNameSet = StringSet.createAsFlexible();
        while (columnResultSet.next()) {
            String metaTableName;
            String columnName = columnResultSet.getString(4);
            if (this.isColumnExcept(unifiedSchema, tableName, columnName) || this.checkMetaTableDiffIfNeeds(tableName, metaTableName = columnResultSet.getString(3))) continue;
            if (columnNameSet.contains((Object)columnName)) {
                duplicateTableNameSet.add(metaTableName);
                duplicateColumnNameSet.add(columnName);
                continue;
            }
            columnNameSet.add(columnName);
            Integer jdbcTypeCode = Integer.valueOf(columnResultSet.getString(5));
            String dbTypeName = columnResultSet.getString(6);
            Integer columnSize = columnResultSet.getInt(7);
            Integer decimalDigits = columnResultSet.getInt(9);
            Integer nullType = columnResultSet.getInt(11);
            String columnComment = columnResultSet.getString(12);
            String defaultValue = columnResultSet.getString(13);
            DfColumnMetaInfo columnMetaInfo = new DfColumnMetaInfo();
            columnMetaInfo.setColumnName(columnName);
            columnMetaInfo.setJdbcDefValue(jdbcTypeCode);
            columnMetaInfo.setDbTypeName(dbTypeName);
            columnMetaInfo.setColumnSize(columnSize);
            columnMetaInfo.setDecimalDigits(decimalDigits);
            columnMetaInfo.setRequired(nullType == 0);
            columnMetaInfo.setColumnComment(columnComment);
            columnMetaInfo.setDefaultValue(defaultValue);
            columns.add(columnMetaInfo);
        }
        if (!duplicateColumnNameSet.isEmpty()) {
            String msg = "*Duplicate meta data was found:";
            msg = msg + "\n[" + tableName + "]";
            msg = msg + "\n  duplicate tables = " + duplicateTableNameSet;
            msg = msg + "\n  duplicate columns = " + duplicateColumnNameSet;
            _log.info((Object)msg);
        }
    }

    public Map<String, DfColumnMetaInfo> getColumnMap(DatabaseMetaData metaData, DfTableMetaInfo tableInfo) throws SQLException {
        List<DfColumnMetaInfo> columnList = this.getColumnList(metaData, tableInfo);
        LinkedHashMap<String, DfColumnMetaInfo> map = new LinkedHashMap<String, DfColumnMetaInfo>();
        for (DfColumnMetaInfo columnInfo : columnList) {
            map.put(columnInfo.getColumnName(), columnInfo);
        }
        return map;
    }

    public String getColumnJdbcType(DfColumnMetaInfo columnMetaInfo) {
        return this.getColumnJdbcType(columnMetaInfo.getJdbcDefValue(), columnMetaInfo.getDbTypeName());
    }

    public String getColumnJdbcType(int jdbcDefType, String dbTypeName) {
        return this.getJdbcTypeMapper().getColumnJdbcType(jdbcDefType, dbTypeName);
    }

    public boolean hasMappingJdbcType(DfColumnMetaInfo columnMetaInfo) {
        return this.hasMappingJdbcType(columnMetaInfo.getJdbcDefValue(), columnMetaInfo.getDbTypeName());
    }

    public boolean hasMappingJdbcType(int jdbcDefType, String dbTypeName) {
        return this.getJdbcTypeMapper().hasMappingJdbcType(jdbcDefType, dbTypeName);
    }

    protected DfJdbcTypeMapper getJdbcTypeMapper() {
        if (this._jdbcTypeMapper == null) {
            this._jdbcTypeMapper = this.newJdbcTypeMapper();
        }
        return this._jdbcTypeMapper;
    }

    protected DfJdbcTypeMapper newJdbcTypeMapper() {
        DfTypeMappingProperties typeMappingProperties = this.getProperties().getTypeMappingProperties();
        Map<String, String> nameToJdbcTypeMap = typeMappingProperties.getNameToJdbcTypeMap();
        DfJdbcTypeMapper mapper = new DfJdbcTypeMapper(nameToJdbcTypeMap, new DfJdbcTypeMapper.Resource(){

            public boolean isLangJava() {
                return DfColumnHandler.this.getBasicProperties().isTargetLanguageJava();
            }

            public boolean isDbmsPostgreSQL() {
                return DfColumnHandler.this.isDatabasePostgreSQL();
            }

            public boolean isDbmsOracle() {
                return DfColumnHandler.this.isDatabaseOracle();
            }

            public boolean isDbmsSQLServer() {
                return DfColumnHandler.this.isDatabaseSQLServer();
            }

            public String toString() {
                return "{" + this.isLangJava() + ", " + this.isDbmsOracle() + ", " + this.isDbmsPostgreSQL() + "}";
            }
        });
        return mapper;
    }

    public boolean isConceptTypeUUID(String dbTypeName) {
        return this.getJdbcTypeMapper().isConceptTypeUUID(dbTypeName);
    }

    public boolean isConceptTypeStringClob(String dbTypeName) {
        return this.getJdbcTypeMapper().isConceptTypeStringClob(dbTypeName);
    }

    public boolean isConceptTypeBytesOid(String dbTypeName) {
        return this.getJdbcTypeMapper().isConceptTypeBytesOid(dbTypeName);
    }

    public boolean isConceptTypeFixedLengthString(String dbTypeName) {
        return this.getJdbcTypeMapper().isConceptTypeFixedLengthString(dbTypeName);
    }

    public boolean isConceptTypeObjectBindingBigDecimal(String dbTypeName) {
        return this.getJdbcTypeMapper().isConceptTypeObjectBindingBigDecimal(dbTypeName);
    }

    public boolean isPostgreSQLBpChar(String dbTypeName) {
        return this.getJdbcTypeMapper().isPostgreSQLBpChar(dbTypeName);
    }

    public boolean isPostgreSQLNumeric(String dbTypeName) {
        return this.getJdbcTypeMapper().isPostgreSQLNumeric(dbTypeName);
    }

    public boolean isPostgreSQLUuid(String dbTypeName) {
        return this.getJdbcTypeMapper().isPostgreSQLUuid(dbTypeName);
    }

    public boolean isPostgreSQLOid(String dbTypeName) {
        return this.getJdbcTypeMapper().isPostgreSQLOid(dbTypeName);
    }

    public boolean isPostgreSQLCursor(String dbTypeName) {
        return this.getJdbcTypeMapper().isPostgreSQLCursor(dbTypeName);
    }

    public boolean isOracleNCharOrNVarchar(String dbTypeName) {
        return this.getJdbcTypeMapper().isOracleNCharOrNVarchar(dbTypeName);
    }

    public boolean isOracleNumber(String dbTypeName) {
        return this.getJdbcTypeMapper().isOracleNumber(dbTypeName);
    }

    public boolean isOracleDate(String dbTypeName) {
        return this.getJdbcTypeMapper().isOracleDate(dbTypeName);
    }

    public boolean isOracleCursor(String dbTypeName) {
        return this.getJdbcTypeMapper().isOracleCursor(dbTypeName);
    }

    public boolean isOracleTreatedAsArray(String dbTypeName) {
        return this.isOracleTable(dbTypeName) || this.isOracleVArray(dbTypeName);
    }

    public boolean isOracleTable(String dbTypeName) {
        return this.getJdbcTypeMapper().isOracleTable(dbTypeName);
    }

    public boolean isOracleVArray(String dbTypeName) {
        return this.getJdbcTypeMapper().isOracleVArray(dbTypeName);
    }

    public boolean isSQLServerUniqueIdentifier(String dbTypeName) {
        return this.getJdbcTypeMapper().isSQLServerUniqueIdentifier(dbTypeName);
    }

    public static boolean isColumnSizeValid(Integer columnSize) {
        return columnSize != null && columnSize > 0;
    }

    public static boolean isDecimalDigitsValid(Integer decimalDigits) {
        return decimalDigits != null && decimalDigits > 0;
    }
}

