/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.handler;

import java.sql.Connection;
import java.sql.SQLException;
import org.seasar.dbflute.exception.DfJDBCException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.logic.jdbc.handler.DfAbstractMetaDataHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfColumnMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTableMetaInfo;

public class DfAutoIncrementHandler
extends DfAbstractMetaDataHandler {
    public boolean isAutoIncrementColumn(Connection conn, DfTableMetaInfo tableInfo, DfColumnMetaInfo primaryKeyColumnInfo) throws SQLException {
        if (this.analyzeByDatabaseDependencyMeta(tableInfo, primaryKeyColumnInfo)) {
            return true;
        }
        String primaryKeyColumnName = primaryKeyColumnInfo.getColumnName();
        return this.isAutoIncrementColumn(conn, tableInfo, primaryKeyColumnName);
    }

    protected boolean analyzeByDatabaseDependencyMeta(DfTableMetaInfo tableInfo, DfColumnMetaInfo primaryKeyColumnInfo) {
        if (this.isDatabaseSybase()) {
            String defaultValue = primaryKeyColumnInfo.getDefaultValue();
            return "autoincrement".equalsIgnoreCase(defaultValue);
        }
        return false;
    }

    public boolean isAutoIncrementColumn(Connection conn, DfTableMetaInfo tableInfo, String primaryKeyColumnName) throws SQLException {
        return this.analyzeByResultSetMeta(conn, tableInfo, primaryKeyColumnName);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean analyzeByResultSetMeta(Connection conn, DfTableMetaInfo tableInfo, String primaryKeyColumnName) throws SQLException {
        block14: {
            tableSqlName = tableInfo.buildTableSqlName();
            sql = this.buildMetaDataSql(primaryKeyColumnName, tableSqlName);
            st = null;
            rs = null;
            try {
                try {
                    st = conn.createStatement();
                    rs = st.executeQuery(sql);
                    md = rs.getMetaData();
                    i = 1;
                    while (true) {
                        if (i > md.getColumnCount()) {
                            msg = "The primaryKeyColumnName is not found in the table: ";
                            msg = msg + tableSqlName + "." + primaryKeyColumnName;
                            throw new IllegalStateException(msg);
                        }
                        currentColumnName = md.getColumnName(i);
                        if (primaryKeyColumnName.equals(currentColumnName)) {
                            var11_15 = md.isAutoIncrement(i);
                            var13_16 = null;
                            if (st == null) break block14;
                            break;
                        }
                        ++i;
                    }
                }
                catch (SQLException e) {
                    br = new ExceptionMessageBuilder();
                    br.addNotice("Failed to execute the SQL for getting auto-increment");
                    br.addItem("SQL for getting");
                    br.addElement((Object)sql);
                    msg = br.buildExceptionMessage();
                    throw new DfJDBCException(msg, e);
                }
            }
            catch (Throwable var12_20) {
                var13_17 = null;
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException ignored) {
                        // empty catch block
                    }
                }
                if (rs == null) throw var12_20;
                try {
                    rs.close();
                    throw var12_20;
                }
                catch (SQLException ignored) {
                    throw var12_20;
                }
            }
            ** try [egrp 2[TRYBLOCK] [4 : 220->230)] { 
lbl52:
            // 1 sources

            st.close();
            break block14;
lbl54:
            // 1 sources

            catch (SQLException ignored) {
                // empty catch block
            }
        }
        if (rs == null) return var11_15;
        ** try [egrp 3[TRYBLOCK] [5 : 237->247)] { 
lbl59:
        // 1 sources

        rs.close();
        return var11_15;
lbl61:
        // 1 sources

        catch (SQLException ignored) {
            // empty catch block
        }
        return var11_15;
    }

    protected String buildMetaDataSql(String pkName, String tableName) {
        pkName = this.getProperties().getLittleAdjustmentProperties().quoteColumnNameIfNeeds(pkName, true);
        return "select " + pkName + " from " + tableName + " where 0 = 1";
    }
}

