/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.handler;

import java.util.List;
import java.util.Map;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.logic.jdbc.metadata.DfAbstractMetaDataExtractor;
import org.seasar.dbflute.properties.assistant.DfAdditionalSchemaInfo;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.DfNameHintUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfAbstractMetaDataHandler
extends DfAbstractMetaDataExtractor {
    private static final List<String> EMPTY_STRING_LIST = DfCollectionUtil.emptyList();
    private List<String> _tableExceptList;
    private List<String> _tableTargetList;
    private Map<String, List<String>> _columnExceptMap;

    protected final List<String> getTableExceptList() {
        if (this._tableExceptList == null) {
            this._tableExceptList = this.getProperties().getDatabaseProperties().getTableExceptList();
        }
        return this._tableExceptList;
    }

    protected final List<String> getTableTargetList() {
        if (this._tableTargetList == null) {
            this._tableTargetList = this.getProperties().getDatabaseProperties().getTableTargetList();
        }
        return this._tableTargetList;
    }

    protected final Map<String, List<String>> getColumnExceptMap() {
        if (this._columnExceptMap == null) {
            this._columnExceptMap = this.getProperties().getDatabaseProperties().getColumnExceptMap();
        }
        return this._columnExceptMap;
    }

    public boolean isTableExcept(UnifiedSchema unifiedSchema, String tableName) {
        List<String> tableExceptList;
        if (tableName == null) {
            throw new IllegalArgumentException("The argument 'tableName' should not be null.");
        }
        List<String> tableTargetList = this.getRealTableTargetList(unifiedSchema);
        return !this.isTargetByHint(tableName, tableTargetList, tableExceptList = this.getRealTableExceptList(unifiedSchema));
    }

    protected List<String> getRealTableExceptList(UnifiedSchema unifiedSchema) {
        DfAdditionalSchemaInfo schemaInfo;
        if (unifiedSchema != null && (schemaInfo = this.getAdditionalSchemaInfo(unifiedSchema)) != null) {
            return schemaInfo.getTableExceptList();
        }
        return this.getTableExceptList();
    }

    protected List<String> getRealTableTargetList(UnifiedSchema unifiedSchema) {
        DfAdditionalSchemaInfo schemaInfo;
        if (unifiedSchema != null && (schemaInfo = this.getAdditionalSchemaInfo(unifiedSchema)) != null) {
            return schemaInfo.getTableTargetList();
        }
        return this.getTableTargetList();
    }

    public boolean isColumnExcept(UnifiedSchema unifiedSchema, String tableName, String columnName) {
        if (tableName == null) {
            throw new IllegalArgumentException("The argument 'tableName' should not be null.");
        }
        if (columnName == null) {
            throw new IllegalArgumentException("The argument 'columnName' should not be null.");
        }
        Map<String, List<String>> columnExceptMap = this.getRealColumnExceptMap(unifiedSchema);
        List<String> columnExceptList = columnExceptMap.get(tableName);
        if (columnExceptList == null) {
            return false;
        }
        return !this.isTargetByHint(columnName, EMPTY_STRING_LIST, columnExceptList);
    }

    protected Map<String, List<String>> getRealColumnExceptMap(UnifiedSchema unifiedSchema) {
        DfAdditionalSchemaInfo schemaInfo = this.getAdditionalSchemaInfo(unifiedSchema);
        if (schemaInfo != null) {
            return schemaInfo.getColumnExceptMap();
        }
        return this.getColumnExceptMap();
    }

    protected boolean isTargetByHint(String name, List<String> targetList, List<String> exceptList) {
        return DfNameHintUtil.isTargetByHint(name, targetList, exceptList);
    }

    protected final DfAdditionalSchemaInfo getAdditionalSchemaInfo(UnifiedSchema unifiedSchema) {
        return this.getProperties().getDatabaseProperties().getAdditionalSchemaInfo(unifiedSchema);
    }
}

