/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.doc.dataxls;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.Column;
import org.seasar.dbflute.helper.jdbc.facade.DfJdbcFacade;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.properties.DfAbstractHelperProperties;
import org.seasar.dbflute.s2dao.valuetype.basic.StringType;
import org.seasar.dbflute.s2dao.valuetype.basic.TimeType;
import org.seasar.dbflute.s2dao.valuetype.basic.TimestampType;
import org.seasar.dbflute.s2dao.valuetype.basic.UtilDateAsSqlDateType;
import org.seasar.dbflute.util.DfTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfTemplateDataExtractor {
    private static final Log _log = LogFactory.getLog(DfAbstractHelperProperties.class);
    protected DataSource _dataSource;

    public DfTemplateDataExtractor(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public Map<String, List<Map<String, String>>> extractData(Map<String, List<Column>> tableColumnMap, int limit) {
        LinkedHashMap<String, List<Map<String, String>>> templateDataMap = new LinkedHashMap<String, List<Map<String, String>>>();
        Set<Map.Entry<String, List<Column>>> entrySet = tableColumnMap.entrySet();
        for (Map.Entry<String, List<Column>> entry : entrySet) {
            String tableName = entry.getKey();
            List<Column> columnList = entry.getValue();
            List<Map<String, Object>> objectList = this.selectObjectList(tableName, columnList, limit);
            List<Map<String, String>> resultList = this.createResultList(objectList);
            _log.info((Object)("    " + tableName + "(" + resultList.size() + ")"));
            templateDataMap.put(tableName, resultList);
        }
        return templateDataMap;
    }

    protected List<Map<String, Object>> selectObjectList(String tableName, List<Column> columnList, int limit) {
        String selectClause = this.buildSelectClause(columnList);
        String fromClause = this.buildFromClause(tableName);
        String sql = selectClause + " " + fromClause;
        LinkedHashMap<String, ValueType> columnValueTypeMap = new LinkedHashMap<String, ValueType>();
        for (Column column : columnList) {
            String columnName = column.getName();
            Object valueType = column == null ? new StringType() : (column.isJdbcTypeTime() ? new TimeType() : (column.isJdbcTypeTimestamp() ? new TimestampType() : (column.isJdbcTypeDate() ? new UtilDateAsSqlDateType() : new StringType())));
            columnValueTypeMap.put(columnName, (ValueType)valueType);
        }
        DfJdbcFacade facade = new DfJdbcFacade(this._dataSource);
        return facade.selectList(sql, columnValueTypeMap, limit);
    }

    protected String buildSelectClause(List<Column> columnList) {
        StringBuilder sb = new StringBuilder();
        for (Column column : columnList) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(column.getColumnSqlNameDirectUse());
        }
        return sb.insert(0, "select ").toString();
    }

    protected String buildFromClause(String tableName) {
        return "from " + tableName;
    }

    protected List<Map<String, String>> createResultList(List<Map<String, Object>> objectList) {
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        for (Map<String, Object> recordMap : objectList) {
            LinkedHashMap<String, String> stringMap = new LinkedHashMap<String, String>();
            for (Map.Entry<String, Object> entry : recordMap.entrySet()) {
                String strValue;
                String columnName = entry.getKey();
                Object objValue = entry.getValue();
                if (objValue instanceof String) {
                    strValue = (String)objValue;
                } else if (objValue instanceof Timestamp) {
                    Timestamp timestamp = (Timestamp)objValue;
                    strValue = this.formatDate(timestamp, "yyyy-MM-dd HH:mm:ss.SSS");
                } else if (objValue instanceof Time) {
                    strValue = DfTypeUtil.toString((Object)((Time)objValue), (String)"HH:mm:ss");
                } else if (objValue instanceof Date) {
                    Date date = (Date)objValue;
                    strValue = this.formatDate(date, "yyyy-MM-dd HH:mm:ss");
                } else {
                    strValue = objValue != null ? objValue.toString() : null;
                }
                stringMap.put(columnName, strValue);
            }
            resultList.add(stringMap);
        }
        return resultList;
    }

    protected String formatDate(Date date, String pattern) {
        String prefix = DfTypeUtil.isDateBC((Date)date) ? "BC" : "";
        return prefix + DfTypeUtil.toString((Object)date, (String)pattern);
    }
}

