/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.dataset;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.dataset.DfDataTable;

public class DfDataSet {
    private Map<String, DfDataTable> _tableMap = StringKeyMap.createAsFlexibleOrdered();
    private List<DfDataTable> _tableList = new ArrayList<DfDataTable>();

    public int getTableSize() {
        return this._tableMap.size();
    }

    public String getTableName(int index) {
        return this.getTable(index).getTableName();
    }

    public DfDataTable getTable(int index) {
        return this._tableList.get(index);
    }

    public boolean hasTable(String tableName) {
        return this._tableMap.containsKey(tableName);
    }

    public DfDataTable getTable(String tableName) {
        DfDataTable table = this._tableMap.get(tableName);
        if (table == null) {
            String msg = "The table was Not Found: " + tableName;
            throw new IllegalStateException(msg);
        }
        return table;
    }

    public DfDataTable addTable(String tableName) {
        return this.addTable(new DfDataTable(tableName));
    }

    public DfDataTable addTable(DfDataTable table) {
        this._tableMap.put(table.getTableName(), table);
        this._tableList.add(table);
        return table;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(100);
        for (int i = 0; i < this.getTableSize(); ++i) {
            buf.append(this.getTable(i));
            buf.append("\n");
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DfDataSet)) {
            return false;
        }
        DfDataSet other = (DfDataSet)o;
        if (this.getTableSize() != other.getTableSize()) {
            return false;
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (this.getTable(i).equals(other.getTable(i))) continue;
            return false;
        }
        return true;
    }
}

