/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.model;

import java.util.List;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfDatabaseProperties;
import org.seasar.dbflute.properties.DfLittleAdjustmentProperties;
import org.seasar.dbflute.properties.assistant.DfAdditionalSchemaInfo;
import org.seasar.dbflute.util.DfSystemUtil;
import org.seasar.dbflute.util.Srl;

public class UnifiedSchema {
    public static final String NO_NAME_SCHEMA = "$$NoNameSchema$$";
    protected final String _catalog;
    protected final String _schema;
    protected boolean _mainSchema;
    protected boolean _additionalSchema;
    protected boolean _unknownSchema;
    protected boolean _catalogAdditionalSchema;

    protected UnifiedSchema(String catalog, String schema) {
        if (this.isCompletelyUnsupportedDBMS()) {
            this._catalog = null;
            this._schema = null;
            return;
        }
        this._catalog = this.filterAttribute(catalog);
        this._schema = this.filterAttribute(schema);
    }

    protected UnifiedSchema(String schemaExpression) {
        if (this.isCompletelyUnsupportedDBMS()) {
            this._catalog = null;
            this._schema = null;
            return;
        }
        if (schemaExpression != null) {
            if (schemaExpression.contains(".")) {
                this._catalog = this.filterAttribute(Srl.substringFirstFront((String)schemaExpression, (String[])new String[]{"."}));
                this._schema = this.filterAttribute(Srl.substringFirstRear((String)schemaExpression, (String[])new String[]{"."}));
            } else {
                this._catalog = null;
                this._schema = this.filterAttribute(schemaExpression);
            }
        } else {
            this._catalog = null;
            this._schema = null;
        }
    }

    protected String filterAttribute(String element) {
        return Srl.is_NotNull_and_NotTrimmedEmpty((String)element) ? element.trim() : null;
    }

    protected boolean isCompletelyUnsupportedDBMS() {
        return this.getBasicProperties().isDatabaseAsUnifiedSchemaUnsupported();
    }

    public static UnifiedSchema createAsMainSchema(String catalog, String schema) {
        return new UnifiedSchema(catalog, schema).asMainSchema();
    }

    public static UnifiedSchema createAsAdditionalSchema(String catalog, String schema, boolean explicitCatalog) {
        UnifiedSchema unifiedSchema = new UnifiedSchema(catalog, schema).asAdditionalSchema();
        if (explicitCatalog) {
            unifiedSchema.asCatalogAdditionalSchema();
        }
        return unifiedSchema;
    }

    public static UnifiedSchema createAsDynamicSchema(String catalog, String schema) {
        return new UnifiedSchema(catalog, schema).judgeSchema();
    }

    public static UnifiedSchema createAsDynamicSchema(String schemaExpression) {
        return new UnifiedSchema(schemaExpression).judgeSchema();
    }

    protected UnifiedSchema asMainSchema() {
        this._mainSchema = true;
        return this;
    }

    protected UnifiedSchema asAdditionalSchema() {
        this._additionalSchema = true;
        return this;
    }

    protected UnifiedSchema asCatalogAdditionalSchema() {
        this._catalogAdditionalSchema = true;
        return this;
    }

    protected UnifiedSchema asUnknownSchema() {
        this._unknownSchema = true;
        return this;
    }

    protected UnifiedSchema judgeSchema() {
        DfDatabaseProperties databaseProp = this.getDatabaseProperties();
        UnifiedSchema mainSchema = databaseProp.getDatabaseSchema();
        if (this.equals(mainSchema)) {
            this.asMainSchema();
        } else {
            DfAdditionalSchemaInfo info = databaseProp.getAdditionalSchemaInfo(this);
            if (info != null) {
                this.asAdditionalSchema();
                if (info.getUnifiedSchema().isCatalogAdditionalSchema()) {
                    this.asCatalogAdditionalSchema();
                }
            } else {
                this.asUnknownSchema();
            }
        }
        return this;
    }

    public String getCatalogSchema() {
        StringBuilder sb = new StringBuilder();
        if (Srl.is_NotNull_and_NotTrimmedEmpty((String)this._catalog)) {
            sb.append(this._catalog);
        }
        if (Srl.is_NotNull_and_NotTrimmedEmpty((String)this._schema) && !this.isNoNameSchema()) {
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(this._schema);
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    public String getIdentifiedSchema() {
        StringBuilder sb = new StringBuilder();
        if (Srl.is_NotNull_and_NotTrimmedEmpty((String)this._catalog)) {
            sb.append(this._catalog);
        }
        if (sb.length() > 0) {
            sb.append(".");
        }
        if (Srl.is_NotNull_and_NotTrimmedEmpty((String)this._schema)) {
            sb.append(this._schema);
        } else {
            sb.append(NO_NAME_SCHEMA);
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    public String getLoggingSchema() {
        return this.getCatalogSchema();
    }

    public String getPureCatalog() {
        return this._catalog;
    }

    public String getPureSchema() {
        if (this.isNoNameSchema()) {
            return null;
        }
        return this._schema;
    }

    protected String getSqlPrefixSchema() {
        DfLittleAdjustmentProperties prop = DfBuildProperties.getInstance().getLittleAdjustmentProperties();
        if (prop.isAvailableAddingSchemaToTableSqlName()) {
            if (prop.isAvailableAddingCatalogToTableSqlName()) {
                return this.getCatalogSchema();
            }
            return this.getPureSchema();
        }
        if (this._mainSchema) {
            return "";
        }
        if (this._additionalSchema) {
            if (this._catalogAdditionalSchema) {
                return this.getCatalogSchema();
            }
            return this.getPureSchema();
        }
        this.throwUnknownSchemaCannotUseSQLPrefixException();
        return null;
    }

    protected void throwUnknownSchemaCannotUseSQLPrefixException() {
        DfDatabaseProperties databaseProp = this.getDatabaseProperties();
        UnifiedSchema databaseSchema = databaseProp.getDatabaseSchema();
        List<UnifiedSchema> additionalSchemaList = databaseProp.getAdditionalSchemaList();
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Unknown schema is NOT supported to use SQL prefix.");
        br.addItem("Advice");
        br.addElement((Object)"The schema is NOT recognized as main and additional schema.");
        br.addElement((Object)"Please confirm your database settings.");
        br.addElement((Object)"(the schema must match any schema in target schemas)");
        br.addItem("Unknown Schema");
        br.addElement((Object)this.toString());
        br.addItem("Target Schema");
        br.addElement((Object)databaseSchema);
        for (UnifiedSchema additionalSchema : additionalSchemaList) {
            br.addElement((Object)additionalSchema);
        }
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg);
    }

    public String buildFullQualifiedName(String elementName) {
        return Srl.connectPrefix((String)elementName, (String)this.getCatalogSchema(), (String)".");
    }

    public String buildSchemaQualifiedName(String elementName) {
        return Srl.connectPrefix((String)elementName, (String)this.getPureSchema(), (String)".");
    }

    public String buildIdentifiedName(String elementName) {
        return Srl.connectPrefix((String)elementName, (String)this.getIdentifiedSchema(), (String)".");
    }

    public String buildSqlName(String elementName) {
        String sqlPrefixSchema = this.getSqlPrefixSchema();
        return Srl.connectPrefix((String)elementName, (String)sqlPrefixSchema, (String)".");
    }

    public boolean isMainSchema() {
        return this._mainSchema;
    }

    public boolean isAdditionalSchema() {
        return this._additionalSchema;
    }

    public boolean isUnknownSchema() {
        return this._unknownSchema;
    }

    public boolean isCatalogAdditionalSchema() {
        return this.isAdditionalSchema() && this._catalogAdditionalSchema;
    }

    public boolean hasSchema() {
        return Srl.is_NotNull_and_NotTrimmedEmpty((String)this.getCatalogSchema());
    }

    public boolean existsPureCatalog() {
        return Srl.is_NotNull_and_NotTrimmedEmpty((String)this.getPureCatalog());
    }

    public boolean existsPureSchema() {
        return Srl.is_NotNull_and_NotTrimmedEmpty((String)this.getPureSchema());
    }

    protected boolean isNoNameSchema() {
        return Srl.is_NotNull_and_NotTrimmedEmpty((String)this._schema) && NO_NAME_SCHEMA.equalsIgnoreCase(this._schema);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UnifiedSchema)) {
            return false;
        }
        String mySchema = this.getIdentifiedSchema();
        String yourSchema = ((UnifiedSchema)obj).getIdentifiedSchema();
        if (mySchema == null && yourSchema == null) {
            return true;
        }
        return mySchema != null && mySchema.equalsIgnoreCase(yourSchema);
    }

    public int hashCode() {
        String identifiedSchema = this.getIdentifiedSchema();
        return identifiedSchema != null ? identifiedSchema.hashCode() : 17;
    }

    public String toString() {
        return "{" + this.getIdentifiedSchema() + " as " + (this.isMainSchema() ? "main" : "") + (this.isAdditionalSchema() ? "additional" : "") + (this.isCatalogAdditionalSchema() ? "(catalog)" : "") + (this.isUnknownSchema() ? "unknown" : "") + "}";
    }

    protected DfBasicProperties getBasicProperties() {
        return DfBuildProperties.getInstance().getBasicProperties();
    }

    protected DfDatabaseProperties getDatabaseProperties() {
        return DfBuildProperties.getInstance().getDatabaseProperties();
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }
}

