/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.seasar.dbflute.util.DfBase64Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DfTypeUtil {
    protected static final String NULL = "null";
    protected static final long AD_ORIGIN_MILLISECOND;
    protected static Map<Locale, DecimalFormatSymbols> symbolsCache;
    protected static final String[] EMPTY_STRINGS;

    public static String toString(Object obj) {
        return DfTypeUtil.toString(obj, null);
    }

    public static String toString(Object obj, String pattern) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof java.util.Date) {
            return DfTypeUtil.toStringFromDate((java.util.Date)obj, pattern);
        }
        if (obj instanceof Number) {
            return DfTypeUtil.toStringFromNumber((Number)obj, pattern);
        }
        if (obj instanceof Calendar) {
            return DfTypeUtil.toStringFromDate(((Calendar)obj).getTime(), pattern);
        }
        if (obj instanceof byte[]) {
            return DfBase64Util.encode((byte[])obj);
        }
        return obj.toString();
    }

    protected static String toStringFromNumber(Number value, String pattern) {
        if (value != null) {
            if (pattern != null) {
                return DfTypeUtil.createDecimalFormat(pattern).format(value);
            }
            return value.toString();
        }
        return null;
    }

    protected static String toStringFromDate(java.util.Date value, String pattern) {
        if (value != null) {
            if (pattern != null) {
                return DfTypeUtil.createDateFormat(pattern).format(value);
            }
            return value.toString();
        }
        return null;
    }

    public static byte[] toStringBytes(String str, String encoding) {
        if (str == null) {
            return null;
        }
        try {
            return str.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            String msg = "The encoding is invalid: encoding=" + encoding + " str=" + str;
            throw new IllegalStateException(msg);
        }
    }

    public static Object toNumber(Class<?> type, Object obj) {
        if (type == Integer.class) {
            return DfTypeUtil.toInteger(obj);
        }
        if (type == Double.class) {
            return DfTypeUtil.toDouble(obj);
        }
        if (type == Long.class) {
            return DfTypeUtil.toLong(obj);
        }
        if (type == Float.class) {
            return DfTypeUtil.toFloat(obj);
        }
        if (type == Short.class) {
            return DfTypeUtil.toShort(obj);
        }
        if (type == Byte.class) {
            return DfTypeUtil.toByte(obj);
        }
        if (type == BigDecimal.class) {
            return DfTypeUtil.toBigDecimal(obj);
        }
        if (type == BigInteger.class) {
            return DfTypeUtil.toBigInteger(obj);
        }
        return obj;
    }

    protected static String normalize(String value) {
        return DfTypeUtil.normalize(value, Locale.getDefault());
    }

    protected static String normalize(String value, Locale locale) {
        if (value == null) {
            return null;
        }
        DecimalFormatSymbols symbols = DfTypeUtil.getDecimalFormatSymbols(locale);
        char groupingSep = symbols.getGroupingSeparator();
        char decimalSep = symbols.getDecimalSeparator();
        StringBuilder sb = new StringBuilder(20);
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == groupingSep) continue;
            if (c == decimalSep) {
                c = '.';
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static DecimalFormat createDecimalFormat(String pattern) {
        return new DecimalFormat(pattern);
    }

    public static Integer toInteger(Object obj) {
        return DfTypeUtil.toInteger(obj, null);
    }

    public static Integer toInteger(Object obj, String pattern) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof String) {
            return DfTypeUtil.toInteger((String)obj);
        }
        if (obj instanceof java.util.Date) {
            if (pattern != null) {
                return new Integer(DfTypeUtil.createDateFormat(pattern).format(obj));
            }
            return (int)((java.util.Date)obj).getTime();
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? Integer.valueOf(1) : Integer.valueOf(0);
        }
        if (obj instanceof byte[]) {
            return DfTypeUtil.toInteger(DfTypeUtil.toSerializable((byte[])obj));
        }
        return DfTypeUtil.toInteger(obj.toString());
    }

    protected static Integer toInteger(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return new Integer(DfTypeUtil.normalize(str));
    }

    public static int toPrimitiveInt(Object obj) {
        return DfTypeUtil.toPrimitiveInt(obj, null);
    }

    public static int toPrimitiveInt(Object obj, String pattern) {
        Integer wrapper = DfTypeUtil.toInteger(obj, pattern);
        return wrapper != null ? wrapper : 0;
    }

    public static Long toLong(Object obj) {
        return DfTypeUtil.toLong(obj, null);
    }

    public static Long toLong(Object obj, String pattern) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof String) {
            return DfTypeUtil.toLong((String)obj);
        }
        if (obj instanceof java.util.Date) {
            if (pattern != null) {
                return new Long(DfTypeUtil.createDateFormat(pattern).format(obj));
            }
            return ((java.util.Date)obj).getTime();
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? Long.valueOf(1L) : Long.valueOf(0L);
        }
        if (obj instanceof byte[]) {
            return DfTypeUtil.toLong(DfTypeUtil.toSerializable((byte[])obj));
        }
        return DfTypeUtil.toLong(obj.toString());
    }

    protected static Long toLong(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return new Long(DfTypeUtil.normalize(str));
    }

    public static long toPrimitiveLong(Object obj) {
        return DfTypeUtil.toPrimitiveLong(obj, null);
    }

    public static long toPrimitiveLong(Object obj, String pattern) {
        Long wrapper = DfTypeUtil.toLong(obj, pattern);
        return wrapper != null ? wrapper : 0L;
    }

    public static Double toDouble(Object obj) {
        return DfTypeUtil.toDouble(obj, null);
    }

    public static Double toDouble(Object obj, String pattern) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof Number) {
            return new Double(((Number)obj).doubleValue());
        }
        if (obj instanceof String) {
            return DfTypeUtil.toDouble((String)obj);
        }
        if (obj instanceof java.util.Date) {
            if (pattern != null) {
                return new Double(DfTypeUtil.createDateFormat(pattern).format(obj));
            }
            return new Double(((java.util.Date)obj).getTime());
        }
        if (obj instanceof byte[]) {
            return DfTypeUtil.toDouble(DfTypeUtil.toSerializable((byte[])obj));
        }
        return DfTypeUtil.toDouble(obj.toString());
    }

    protected static Double toDouble(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return new Double(DfTypeUtil.normalize(str));
    }

    public static double toPrimitiveDouble(Object obj) {
        return DfTypeUtil.toPrimitiveDouble(obj, null);
    }

    public static double toPrimitiveDouble(Object obj, String pattern) {
        Double wrapper = DfTypeUtil.toDouble(obj, pattern);
        return wrapper != null ? wrapper : 0.0;
    }

    public static Float toFloat(Object obj) {
        return DfTypeUtil.toFloat(obj, null);
    }

    public static Float toFloat(Object obj, String pattern) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Float) {
            return (Float)obj;
        }
        if (obj instanceof Number) {
            return new Float(((Number)obj).floatValue());
        }
        if (obj instanceof String) {
            return DfTypeUtil.toFloat((String)obj);
        }
        if (obj instanceof java.util.Date) {
            if (pattern != null) {
                return new Float(DfTypeUtil.createDateFormat(pattern).format(obj));
            }
            return new Float(((java.util.Date)obj).getTime());
        }
        if (obj instanceof byte[]) {
            return DfTypeUtil.toFloat(DfTypeUtil.toSerializable((byte[])obj));
        }
        return DfTypeUtil.toFloat(obj.toString());
    }

    protected static Float toFloat(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return new Float(DfTypeUtil.normalize(str));
    }

    public static float toPrimitiveFloat(Object obj) {
        return DfTypeUtil.toPrimitiveFloat(obj, null);
    }

    public static float toPrimitiveFloat(Object obj, String pattern) {
        Float wrapper = DfTypeUtil.toFloat(obj, pattern);
        return wrapper != null ? wrapper.floatValue() : 0.0f;
    }

    public static Short toShort(Object obj) {
        return DfTypeUtil.toShort(obj, null);
    }

    public static Short toShort(Object obj, String pattern) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Short) {
            return (Short)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).shortValue();
        }
        if (obj instanceof String) {
            return DfTypeUtil.toShort((String)obj);
        }
        if (obj instanceof java.util.Date) {
            if (pattern != null) {
                return Short.valueOf(DfTypeUtil.createDateFormat(pattern).format(obj));
            }
            return (short)((java.util.Date)obj).getTime();
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? Short.valueOf((short)1) : Short.valueOf((short)0);
        }
        if (obj instanceof byte[]) {
            return DfTypeUtil.toShort(DfTypeUtil.toSerializable((byte[])obj));
        }
        return DfTypeUtil.toShort(obj.toString());
    }

    protected static Short toShort(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return new Short(DfTypeUtil.normalize(str));
    }

    public static short toPrimitiveShort(Object obj) {
        return DfTypeUtil.toPrimitiveShort(obj, null);
    }

    public static short toPrimitiveShort(Object obj, String pattern) {
        Short wrapper = DfTypeUtil.toShort(obj, pattern);
        return wrapper != null ? wrapper : (short)0;
    }

    public static Byte toByte(Object obj) {
        return DfTypeUtil.toByte(obj, null);
    }

    public static Byte toByte(Object obj, String pattern) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Byte) {
            return (Byte)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).byteValue();
        }
        if (obj instanceof String) {
            return DfTypeUtil.toByte((String)obj);
        }
        if (obj instanceof java.util.Date) {
            if (pattern != null) {
                return new Byte(DfTypeUtil.createDateFormat(pattern).format(obj));
            }
            return (byte)((java.util.Date)obj).getTime();
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        }
        if (obj instanceof byte[]) {
            return DfTypeUtil.toByte(DfTypeUtil.toSerializable((byte[])obj));
        }
        return DfTypeUtil.toByte(obj.toString());
    }

    protected static Byte toByte(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return new Byte(DfTypeUtil.normalize(str));
    }

    public static byte toPrimitiveByte(Object obj) {
        return DfTypeUtil.toPrimitiveByte(obj, null);
    }

    public static byte toPrimitiveByte(Object obj, String pattern) {
        Byte wrapper = DfTypeUtil.toByte(obj, pattern);
        return wrapper != null ? wrapper : (byte)0;
    }

    public static BigDecimal toBigDecimal(Object obj) {
        return DfTypeUtil.toBigDecimal(obj, null);
    }

    public static BigDecimal toBigDecimal(Object obj, String pattern) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            BigDecimal paramBigDecimal = (BigDecimal)obj;
            if (BigDecimal.class.equals(paramBigDecimal.getClass())) {
                return paramBigDecimal;
            }
            return new BigDecimal(paramBigDecimal.toPlainString());
        }
        if (obj instanceof java.util.Date) {
            if (pattern != null) {
                return new BigDecimal(DfTypeUtil.createDateFormat(pattern).format(obj));
            }
            return new BigDecimal(Long.toString(((java.util.Date)obj).getTime()));
        }
        if (obj instanceof String) {
            String s = (String)obj;
            if (s == null || s.trim().length() == 0) {
                return null;
            }
            return new BigDecimal(new BigDecimal(s).toPlainString());
        }
        if (obj instanceof byte[]) {
            return DfTypeUtil.toBigDecimal(DfTypeUtil.toSerializable((byte[])obj));
        }
        return new BigDecimal(new BigDecimal(obj.toString()).toPlainString());
    }

    public static BigInteger toBigInteger(Object obj) {
        return DfTypeUtil.toBigInteger(obj, null);
    }

    public static BigInteger toBigInteger(Object obj, String pattern) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigInteger) {
            BigInteger paramBigInteger = (BigInteger)obj;
            if (BigInteger.class.equals(paramBigInteger.getClass())) {
                return paramBigInteger;
            }
            return BigInteger.valueOf(paramBigInteger.longValue());
        }
        Long l = DfTypeUtil.toLong(obj, pattern);
        if (l == null) {
            return null;
        }
        return BigInteger.valueOf(l);
    }

    public static java.util.Date toDate(Object obj) {
        return DfTypeUtil.toDate(obj, null);
    }

    public static java.util.Date toDate(Object obj, String pattern) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return DfTypeUtil.toDateFromString((String)obj, pattern);
        }
        if (obj instanceof java.util.Date) {
            java.util.Date paramDate = (java.util.Date)obj;
            if (java.util.Date.class.equals(paramDate.getClass())) {
                return paramDate;
            }
            java.util.Date date = new java.util.Date();
            date.setTime(paramDate.getTime());
            return date;
        }
        if (obj instanceof Calendar) {
            return ((Calendar)obj).getTime();
        }
        if (obj instanceof byte[]) {
            return DfTypeUtil.toDate(DfTypeUtil.toSerializable((byte[])obj));
        }
        return DfTypeUtil.toDateFromString(obj.toString(), pattern);
    }

    protected static java.util.Date toDateFromString(String str, String pattern) {
        boolean strict;
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        if (pattern == null || pattern.trim().length() == 0) {
            boolean includeMilli = true;
            strict = !(str = DfTypeUtil.filterDateStringValueFlexibly(str, true)).startsWith("-");
            pattern = "yyyy-MM-dd HH:mm:ss.SSS";
        } else {
            strict = true;
        }
        DateFormat df = DfTypeUtil.createDateFormat(pattern, strict);
        try {
            return df.parse(str);
        }
        catch (ParseException e) {
            try {
                df.setLenient(true);
                df.parse(str);
                String msg = "The date expression is out of calendar:";
                msg = msg + " string=" + str + " pattern=" + pattern;
                throw new ParseDateOutOfCalendarException(msg, e);
            }
            catch (ParseException ignored) {
                String msg = "Failed to parse the string to date:";
                msg = msg + " string=" + str + " pattern=" + pattern;
                throw new ParseDateException(msg, e);
            }
        }
    }

    protected static String filterDateStringValueFlexibly(String pureStr, boolean includeMilli) {
        boolean bc;
        String dateLiteralPrefix = "date ";
        String bcSymbolPrefix = "-";
        String adLatinPrefix = "AD";
        String adLatinDotPrefix = "A.D.";
        String bcLatinPrefix = "BC";
        String bcLatinDotPrefix = "B.C.";
        String dateDlm = "-";
        String dateTimeDlm = " ";
        String timeDlm = ":";
        String timeMilliDlm = ".";
        String value = pureStr;
        boolean dateLiteral = (value = value.trim()).startsWith("date ");
        if (dateLiteral) {
            value = value.substring("date ".length());
            value = value.trim();
        }
        if (value.startsWith("AD")) {
            value = value.substring("AD".length());
            bc = false;
        } else if (value.startsWith("A.D.")) {
            value = value.substring("A.D.".length());
            bc = false;
        } else if (value.startsWith("BC")) {
            value = value.substring("BC".length());
            bc = true;
        } else if (value.startsWith("B.C.")) {
            value = value.substring("B.C.".length());
            bc = true;
        } else if (value.startsWith("-")) {
            value = value.substring("-".length());
            bc = true;
        } else {
            bc = false;
        }
        value = value.trim();
        value = value.replaceAll("/", "-");
        if (dateLiteral && value.length() <= 8 && !value.contains("-")) {
            if (value.length() >= 5) {
                value = DfTypeUtil.resolveDateElementZeroPrefix(value, 8 - value.length());
                String yyyy = value.substring(0, 4);
                String mm = value.substring(4, 6);
                String dd = value.substring(6, 8);
                value = yyyy + "-" + mm + "-" + dd;
            } else {
                return pureStr;
            }
        }
        if (!value.contains("-") || value.indexOf("-") == value.lastIndexOf("-")) {
            return pureStr;
        }
        int yearEndIndex = value.indexOf("-");
        String yyyy = value.substring(0, yearEndIndex);
        yyyy = DfTypeUtil.resolveDateElementZeroPrefix(yyyy, 4 - yyyy.length());
        if (bc) {
            Integer yyyyInt = DfTypeUtil.formatDateElementAsNumber(yyyy, "yyyy", pureStr);
            yyyy = String.valueOf(yyyyInt - 1);
            yyyy = DfTypeUtil.resolveDateElementZeroPrefix(yyyy, 4 - yyyy.length());
        } else {
            DfTypeUtil.formatDateElementAsNumber(yyyy, "yyyy", pureStr);
        }
        String startsMon = value.substring(yearEndIndex + "-".length());
        int monthEndIndex = startsMon.indexOf("-");
        String mm = startsMon.substring(0, monthEndIndex);
        mm = DfTypeUtil.resolveDateElementZeroPrefix(mm, 2 - mm.length());
        DfTypeUtil.formatDateElementAsNumber(mm, "MM", pureStr);
        String startsDay = startsMon.substring(monthEndIndex + "-".length());
        int dayEndIndex = startsDay.indexOf(" ");
        String dd = dayEndIndex >= 0 ? startsDay.substring(0, dayEndIndex) : startsDay;
        dd = DfTypeUtil.resolveDateElementZeroPrefix(dd, 2 - dd.length());
        DfTypeUtil.formatDateElementAsNumber(dd, "dd", pureStr);
        String yyyy_MM_dd = yyyy + "-" + mm + "-" + dd;
        if (dayEndIndex >= 0) {
            String time = startsDay.substring(dayEndIndex + " ".length());
            if (!time.contains(":") || time.indexOf(":") == time.lastIndexOf(":")) {
                return pureStr;
            }
            value = yyyy_MM_dd + " " + DfTypeUtil.handleTimeZeroPrefix(time, pureStr, includeMilli);
        } else {
            value = yyyy_MM_dd + " " + "00:00:00";
            if (includeMilli) {
                value = value + "." + "000";
            }
        }
        return (bc ? "-" : "") + value;
    }

    protected static String handleTimeZeroPrefix(String time, String pureStr, boolean includeMilli) {
        String timeDlm = ":";
        String timeMilliDlm = ".";
        int hourEndIndex = time.indexOf(":");
        String hour = time.substring(0, hourEndIndex);
        hour = DfTypeUtil.resolveDateElementZeroPrefix(hour, 2 - hour.length());
        DfTypeUtil.formatDateElementAsNumber(hour, "HH", pureStr);
        String startsMin = time.substring(hourEndIndex + ":".length());
        int minEndIndex = startsMin.indexOf(":");
        String min = startsMin.substring(0, minEndIndex);
        min = DfTypeUtil.resolveDateElementZeroPrefix(min, 2 - min.length());
        DfTypeUtil.formatDateElementAsNumber(min, "mm", pureStr);
        String startsSec = startsMin.substring(minEndIndex + ":".length());
        int secEndIndex = startsSec.indexOf(".");
        String sec = secEndIndex >= 0 ? startsSec.substring(0, secEndIndex) : startsSec;
        sec = DfTypeUtil.resolveDateElementZeroPrefix(sec, 2 - sec.length());
        DfTypeUtil.formatDateElementAsNumber(sec, "ss", pureStr);
        String value = hour + ":" + min + ":" + sec;
        if (includeMilli) {
            if (secEndIndex >= 0) {
                String milli = startsSec.substring(secEndIndex + ".".length());
                DfTypeUtil.resolveDateElementZeroPrefix(milli, 3 - milli.length());
                DfTypeUtil.formatDateElementAsNumber(milli, "SSS", pureStr);
                value = value + "." + milli;
            } else {
                value = value + "." + "000";
            }
        }
        return value;
    }

    protected static Integer formatDateElementAsNumber(String str, String title, String pureValue) {
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            String msg = "Failed to format " + title + " as number:";
            msg = msg + " " + title + "=" + str + " value=" + pureValue;
            throw new ParseDateNumberFormatException(msg, e);
        }
    }

    protected static String resolveDateElementZeroPrefix(String str, int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append("0");
        }
        return sb.toString() + str;
    }

    public static boolean isDateAD(java.util.Date date) {
        return date.getTime() >= AD_ORIGIN_MILLISECOND;
    }

    public static boolean isDateBC(java.util.Date date) {
        return date.getTime() < AD_ORIGIN_MILLISECOND;
    }

    public static void addDateYear(java.util.Date date, int year) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.addCalendarYear(cal, year);
        date.setTime(cal.getTimeInMillis());
    }

    public static void addDateMonth(java.util.Date date, int month) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.addCalendarMonth(cal, month);
        date.setTime(cal.getTimeInMillis());
    }

    public static void addDateDate(java.util.Date date, int dayOfMonth) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.addCalendarDate(cal, dayOfMonth);
        date.setTime(cal.getTimeInMillis());
    }

    public static void addDateHourOfDay(java.util.Date date, int hourOfDay) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.addCalendarHourOfDay(cal, hourOfDay);
        date.setTime(cal.getTimeInMillis());
    }

    public static void addDateMinute(java.util.Date date, int minute) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.addCalendarMinute(cal, minute);
        date.setTime(cal.getTimeInMillis());
    }

    public static void addDateSecond(java.util.Date date, int second) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.addCalendarSecond(cal, second);
        date.setTime(cal.getTimeInMillis());
    }

    public static void addDateMillisecond(java.util.Date date, int millisecond) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.addCalendarMillisecond(cal, millisecond);
        date.setTime(cal.getTimeInMillis());
    }

    public static void setDateFirstDateOfMonth(java.util.Date date) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.setCalendarFirstDateOfMonth(cal);
        date.setTime(cal.getTimeInMillis());
    }

    public static void setDateLastDateOfMonth(java.util.Date date) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.setCalendarLastDateOfMonth(cal);
        date.setTime(cal.getTimeInMillis());
    }

    public static void clearDateTimeParts(java.util.Date date) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.clearCalendarTimeParts(cal);
        date.setTime(cal.getTimeInMillis());
    }

    public static void clearDateMillisecond(java.util.Date date) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.clearCalendarMillisecond(cal);
        date.setTime(cal.getTimeInMillis());
    }

    public static DateFormat createDateFormat(String pattern) {
        return DfTypeUtil.createDateFormat(pattern, false);
    }

    public static DateFormat createDateFormat(String pattern, boolean strict) {
        if (pattern == null) {
            String msg = "The argument 'pattern' should not be null!";
            throw new IllegalArgumentException(msg);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setLenient(!strict);
        return sdf;
    }

    public static Timestamp toTimestamp(Object obj) {
        return DfTypeUtil.toTimestamp(obj, null);
    }

    public static Timestamp toTimestamp(Object obj, String pattern) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Timestamp) {
            Timestamp paramTimestamp = (Timestamp)obj;
            if (Timestamp.class.equals(paramTimestamp.getClass())) {
                return paramTimestamp;
            }
            return new Timestamp(paramTimestamp.getTime());
        }
        if (obj instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)obj).getTime());
        }
        if (obj instanceof String) {
            return DfTypeUtil.toTimestampFromString((String)obj, pattern);
        }
        if (obj instanceof Calendar) {
            return new Timestamp(((Calendar)obj).getTime().getTime());
        }
        if (obj instanceof byte[]) {
            return DfTypeUtil.toTimestamp(DfTypeUtil.toSerializable((byte[])obj));
        }
        return DfTypeUtil.toTimestampFromString(obj.toString(), pattern);
    }

    protected static Timestamp toTimestampFromString(String str, String pattern) {
        boolean strict;
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        if (pattern == null || pattern.trim().length() == 0) {
            strict = !(str = DfTypeUtil.filterTimestampStringValueFlexibly(str)).startsWith("-");
            pattern = "yyyy-MM-dd HH:mm:ss.SSS";
        } else {
            strict = true;
        }
        DateFormat df = DfTypeUtil.createDateFormat(pattern, strict);
        try {
            return new Timestamp(df.parse(str).getTime());
        }
        catch (ParseException e) {
            try {
                df.setLenient(true);
                df.parse(str);
                String msg = "The timestamp expression is out of calendar:";
                msg = msg + " string=" + str + " pattern=" + pattern;
                throw new ParseTimestampOutOfCalendarException(msg, e);
            }
            catch (ParseException ignored) {
                String msg = "Failed to parse the string to timestamp:";
                msg = msg + " string=" + str + " pattern=" + pattern;
                throw new ParseTimestampException(msg, e);
            }
        }
    }

    protected static String filterTimestampStringValueFlexibly(String pureStr) {
        String str = pureStr;
        try {
            boolean includeMilli = true;
            str = DfTypeUtil.filterDateStringValueFlexibly(str, true);
        }
        catch (ParseDateNumberFormatException e) {
            String msg = "Failed to format the timestamp as number:";
            msg = msg + " value=" + pureStr;
            throw new ParseTimestampNumberFormatException(msg, e);
        }
        return str;
    }

    public static Time toTime(Object obj) {
        return DfTypeUtil.toTime(obj, null);
    }

    public static Time toTime(Object obj, String pattern) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return DfTypeUtil.toTimeFromString((String)obj, pattern);
        }
        if (obj instanceof Time) {
            Time paramTime = (Time)obj;
            if (Time.class.equals(paramTime.getClass())) {
                return paramTime;
            }
            return new Time(paramTime.getTime());
        }
        if (obj instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)obj;
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.set(1, 1970);
            cal.set(2, 0);
            cal.set(5, 1);
            return new Time(cal.getTimeInMillis());
        }
        if (obj instanceof Calendar) {
            Calendar cal = (Calendar)obj;
            cal.set(1, 1970);
            cal.set(2, 0);
            cal.set(5, 1);
            return new Time(cal.getTimeInMillis());
        }
        if (obj instanceof byte[]) {
            return DfTypeUtil.toTime(DfTypeUtil.toSerializable((byte[])obj));
        }
        return DfTypeUtil.toTimeFromString(obj.toString(), pattern);
    }

    protected static Time toTimeFromString(String str, String pattern) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        if (pattern == null || pattern.trim().length() == 0) {
            str = DfTypeUtil.filterTimeStringValueFlexibly(str);
            pattern = "HH:mm:ss";
        }
        DateFormat df = DfTypeUtil.createDateFormat(pattern, true);
        try {
            return new Time(df.parse(str).getTime());
        }
        catch (ParseException e) {
            try {
                df.setLenient(true);
                df.parse(str);
                String msg = "The time expression is out of calendar:";
                msg = msg + " string=" + str + " pattern=" + pattern;
                throw new ParseTimeOutOfCalendarException(msg, e);
            }
            catch (ParseException ignored) {
                String msg = "Failed to parse the string to time:";
                msg = msg + " string=" + str + " pattern=" + pattern;
                throw new ParseTimeException(msg, e);
            }
        }
    }

    protected static String filterTimeStringValueFlexibly(String pureStr) {
        String str = pureStr;
        int dateEndIndex = (str = str.trim()).indexOf(" ");
        if (dateEndIndex >= 0) {
            String time = str.substring(dateEndIndex + " ".length());
            boolean includeMilli = false;
            try {
                str = DfTypeUtil.handleTimeZeroPrefix(time, pureStr, false);
            }
            catch (ParseDateNumberFormatException e) {
                String msg = "Failed to format the time as number:";
                msg = msg + " value=" + pureStr;
                throw new ParseTimeNumberFormatException(msg, e);
            }
        }
        return str;
    }

    public static Date toSqlDate(Object obj) {
        return DfTypeUtil.toSqlDate(obj, null);
    }

    public static Date toSqlDate(Object obj, String pattern) {
        java.util.Date date;
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            Date paramSqlDate = (Date)obj;
            Date resultDate = Date.class.equals(paramSqlDate.getClass()) ? paramSqlDate : new Date(paramSqlDate.getTime());
            DfTypeUtil.clearDateTimeParts(resultDate);
            return resultDate;
        }
        try {
            date = DfTypeUtil.toDate(obj, pattern);
        }
        catch (ParseDateNumberFormatException e) {
            String msg = "Failed to format the time as number:";
            msg = msg + " obj=" + obj + " pattern=" + pattern;
            throw new ParseSqlDateNumberFormatException(msg, e);
        }
        catch (ParseDateOutOfCalendarException e) {
            String msg = "The SQL-date expression is out of calendar:";
            msg = msg + " obj=" + obj + " pattern=" + pattern;
            throw new ParseSqlDateOutOfCalendarException(msg, e);
        }
        catch (ParseDateException e) {
            String msg = "Failed to parse the object to SQL-date:";
            msg = msg + " obj=" + obj + " pattern=" + pattern;
            throw new ParseSqlDateException(msg, e);
        }
        if (date != null) {
            DfTypeUtil.clearDateTimeParts(date);
            return new Date(date.getTime());
        }
        return null;
    }

    public static Calendar toCalendar(Object obj) {
        return DfTypeUtil.toCalendar(obj, null);
    }

    public static Calendar toCalendar(Object obj, String pattern) {
        java.util.Date date;
        if (obj instanceof Calendar) {
            Calendar original = (Calendar)obj;
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(original.getTimeInMillis());
            cal.setTimeZone(original.getTimeZone());
            return cal;
        }
        try {
            date = DfTypeUtil.toDate(obj, pattern);
        }
        catch (ParseDateNumberFormatException e) {
            String msg = "Failed to format the calendar as number:";
            msg = msg + " obj=" + obj + " pattern=" + pattern;
            throw new ParseCalendarNumberFormatException(msg, e);
        }
        catch (ParseDateOutOfCalendarException e) {
            String msg = "The calendar expression is out of calendar:";
            msg = msg + " obj=" + obj + " pattern=" + pattern;
            throw new ParseCalendarOutOfCalendarException(msg, e);
        }
        catch (ParseDateException e) {
            String msg = "Failed to parse the object to calendar:";
            msg = msg + " obj=" + obj + " pattern=" + pattern;
            throw new ParseCalendarParseException(msg, e);
        }
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return cal;
        }
        return null;
    }

    public static void addCalendarYear(Calendar cal, int year) {
        cal.add(1, year);
    }

    public static void addCalendarMonth(Calendar cal, int month) {
        cal.add(2, month);
    }

    public static void addCalendarDate(Calendar cal, int date) {
        cal.add(5, date);
    }

    public static void addCalendarHourOfDay(Calendar cal, int hourOfDay) {
        cal.add(11, hourOfDay);
    }

    public static void addCalendarMinute(Calendar cal, int minute) {
        cal.add(12, minute);
    }

    public static void addCalendarSecond(Calendar cal, int second) {
        cal.add(13, second);
    }

    public static void addCalendarMillisecond(Calendar cal, int millisecond) {
        cal.add(14, millisecond);
    }

    public static void setCalendarFirstDateOfMonth(Calendar cal) {
        cal.set(5, cal.getActualMinimum(5));
    }

    public static void setCalendarLastDateOfMonth(Calendar cal) {
        cal.set(5, cal.getActualMaximum(5));
    }

    public static void clearCalendarTimeParts(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        DfTypeUtil.clearCalendarMillisecond(cal);
    }

    public static void clearCalendarMillisecond(Calendar cal) {
        cal.set(14, 0);
    }

    public static Calendar localize(Calendar calendar) {
        if (calendar == null) {
            return calendar;
        }
        Calendar localCalendar = Calendar.getInstance();
        localCalendar.setTimeInMillis(calendar.getTimeInMillis());
        return localCalendar;
    }

    public static Boolean toBoolean(Object obj) {
        if (obj == null) {
            return (Boolean)obj;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            int num = ((Number)obj).intValue();
            return num != 0;
        }
        if (obj instanceof String) {
            String str = (String)obj;
            if ("true".equalsIgnoreCase(str)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(str)) {
                return Boolean.FALSE;
            }
            if (str.equalsIgnoreCase("1")) {
                return Boolean.TRUE;
            }
            if (str.equalsIgnoreCase("0")) {
                return Boolean.FALSE;
            }
            if (str.equalsIgnoreCase("t")) {
                return Boolean.TRUE;
            }
            if (str.equalsIgnoreCase("f")) {
                return Boolean.FALSE;
            }
            String msg = "Failed to parse the boolean string:";
            msg = msg + " value=" + str;
            throw new ToBooleanParseException(msg);
        }
        if (obj instanceof byte[]) {
            return DfTypeUtil.toBoolean(DfTypeUtil.toSerializable((byte[])obj));
        }
        return Boolean.FALSE;
    }

    public static boolean toPrimitiveBoolean(Object obj) {
        Boolean wrapper = DfTypeUtil.toBoolean(obj);
        return wrapper != null ? wrapper : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBinary(Serializable obj) {
        byte[] byArray;
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        try {
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                oos.close();
                throw throwable;
            }
            catch (Exception e) {
                String msg = "Failed to convert the object to binary: obj=" + obj;
                throw new IllegalStateException(msg, e);
            }
        }
        oos.close();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Serializable toSerializable(byte[] bytes) {
        Serializable serializable;
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        try {
            serializable = (Serializable)ois.readObject();
        }
        catch (Throwable throwable) {
            try {
                ois.close();
                throw throwable;
            }
            catch (Exception e) {
                String msg = "Failed to convert the object to binary: bytes.length=" + bytes.length;
                throw new IllegalStateException(msg, e);
            }
        }
        ois.close();
        return serializable;
    }

    public static Object toWrapper(Class<?> type, Object obj) {
        if (type == Integer.TYPE) {
            Integer i = DfTypeUtil.toInteger(obj);
            if (i != null) {
                return i;
            }
            return 0;
        }
        if (type == Double.TYPE) {
            Double d = DfTypeUtil.toDouble(obj);
            if (d != null) {
                return d;
            }
            return new Double(0.0);
        }
        if (type == Long.TYPE) {
            Long l = DfTypeUtil.toLong(obj);
            if (l != null) {
                return l;
            }
            return 0L;
        }
        if (type == Float.TYPE) {
            Float f = DfTypeUtil.toFloat(obj);
            if (f != null) {
                return f;
            }
            return new Float(0.0f);
        }
        if (type == Short.TYPE) {
            Short s = DfTypeUtil.toShort(obj);
            if (s != null) {
                return s;
            }
            return (short)0;
        }
        if (type == Boolean.TYPE) {
            Boolean b = DfTypeUtil.toBoolean(obj);
            if (b != null) {
                return b;
            }
            return Boolean.FALSE;
        }
        if (type == Byte.TYPE) {
            Byte b = DfTypeUtil.toByte(obj);
            if (b != null) {
                return b;
            }
            return (byte)0;
        }
        return obj;
    }

    public static String nullText() {
        return NULL;
    }

    public static String toText(Number value) {
        if (value == null) {
            return NULL;
        }
        return value.toString();
    }

    public static String toText(Boolean value) {
        if (value == null) {
            return NULL;
        }
        return DfTypeUtil.quote(value.toString());
    }

    public static String toText(String value) {
        if (value == null) {
            return NULL;
        }
        return DfTypeUtil.quote(value);
    }

    public static String toText(java.util.Date value) {
        if (value == null) {
            return NULL;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        StringBuilder sb = new StringBuilder();
        DfTypeUtil.appendCalendarDate(sb, calendar);
        return DfTypeUtil.quote(sb.toString());
    }

    public static String toText(Time value) {
        if (value == null) {
            return NULL;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        StringBuilder sb = new StringBuilder();
        DfTypeUtil.appendCalendarTime(sb, calendar);
        DfTypeUtil.appendTimeDecimalPart(sb, calendar.get(14));
        return DfTypeUtil.quote(sb.toString());
    }

    public static String toText(Timestamp value) {
        if (value == null) {
            return NULL;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        StringBuilder sb = new StringBuilder(30);
        DfTypeUtil.appendCalendarDate(sb, calendar);
        DfTypeUtil.appendCalendarTime(sb, calendar);
        DfTypeUtil.appendTimeDecimalPart(sb, value.getNanos());
        return DfTypeUtil.quote(sb.toString());
    }

    public static String toText(byte[] value) {
        if (value == null) {
            return NULL;
        }
        return DfTypeUtil.quote(value.getClass() + "(byteLength=" + Integer.toString(value.length) + ")");
    }

    public static String toText(Object value) {
        if (value == null) {
            return NULL;
        }
        return DfTypeUtil.quote(value.toString());
    }

    protected static void appendCalendarDate(StringBuilder sb, Calendar calendar) {
        int year = calendar.get(1);
        sb.append(year);
        sb.append('-');
        int month = calendar.get(2) + 1;
        if (month < 10) {
            sb.append('0');
        }
        sb.append(month);
        sb.append('-');
        int date = calendar.get(5);
        if (date < 10) {
            sb.append('0');
        }
        sb.append(date);
    }

    protected static void appendCalendarTime(StringBuilder sb, Calendar calendar) {
        int hour;
        if (sb.length() > 0) {
            sb.append(' ');
        }
        if ((hour = calendar.get(11)) < 10) {
            sb.append('0');
        }
        sb.append(hour);
        sb.append(':');
        int minute = calendar.get(12);
        if (minute < 10) {
            sb.append('0');
        }
        sb.append(minute);
        sb.append(':');
        int second = calendar.get(13);
        if (second < 10) {
            sb.append('0');
        }
        sb.append(second);
    }

    protected static void appendTimeDecimalPart(StringBuilder sb, int decimalPart) {
        if (decimalPart == 0) {
            return;
        }
        if (sb.length() > 0) {
            sb.append('.');
        }
        sb.append(decimalPart);
    }

    protected static String quote(String text) {
        return "'" + text + "'";
    }

    protected static DecimalFormatSymbols getDecimalFormatSymbols(Locale locale) {
        DecimalFormatSymbols symbols = symbolsCache.get(locale);
        if (symbols == null) {
            symbols = new DecimalFormatSymbols(locale);
            symbolsCache.put(locale, symbols);
        }
        return symbols;
    }

    protected static String replace(String text, String from, String to) {
        if (text == null || from == null || to == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int pos2 = 0;
        while (true) {
            if ((pos = text.indexOf(from, pos2)) == 0) {
                sb.append(to);
                pos2 = from.length();
                continue;
            }
            if (pos <= 0) break;
            sb.append(text.substring(pos2, pos));
            sb.append(to);
            pos2 = pos + from.length();
        }
        sb.append(text.substring(pos2));
        return sb.toString();
    }

    protected static String[] split(String str, String delimiter) {
        if (str == null || str.trim().length() == 0) {
            return EMPTY_STRINGS;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str, delimiter);
        while (st.hasMoreElements()) {
            list.add(st.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    static {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, 0, 1, 0, 0, 0);
        cal.set(14, 0);
        AD_ORIGIN_MILLISECOND = cal.getTimeInMillis();
        symbolsCache = new ConcurrentHashMap<Locale, DecimalFormatSymbols>();
        EMPTY_STRINGS = new String[0];
    }

    public static class ToBooleanParseException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ToBooleanParseException(String msg) {
            super(msg);
        }
    }

    public static class ParseCalendarOutOfCalendarException
    extends ParseCalendarParseException {
        private static final long serialVersionUID = 1L;

        public ParseCalendarOutOfCalendarException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseCalendarNumberFormatException
    extends ParseCalendarParseException {
        private static final long serialVersionUID = 1L;

        public ParseCalendarNumberFormatException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseCalendarParseException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ParseCalendarParseException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseSqlDateOutOfCalendarException
    extends ParseSqlDateException {
        private static final long serialVersionUID = 1L;

        public ParseSqlDateOutOfCalendarException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseSqlDateNumberFormatException
    extends ParseSqlDateException {
        private static final long serialVersionUID = 1L;

        public ParseSqlDateNumberFormatException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseSqlDateException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ParseSqlDateException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseTimeOutOfCalendarException
    extends ParseTimeException {
        private static final long serialVersionUID = 1L;

        public ParseTimeOutOfCalendarException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseTimeNumberFormatException
    extends ParseTimeException {
        private static final long serialVersionUID = 1L;

        public ParseTimeNumberFormatException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseTimeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ParseTimeException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseTimestampNumberFormatException
    extends ParseTimestampException {
        private static final long serialVersionUID = 1L;

        public ParseTimestampNumberFormatException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseTimestampOutOfCalendarException
    extends ParseTimestampException {
        private static final long serialVersionUID = 1L;

        public ParseTimestampOutOfCalendarException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseTimestampException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ParseTimestampException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseDateOutOfCalendarException
    extends ParseDateException {
        private static final long serialVersionUID = 1L;

        public ParseDateOutOfCalendarException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseDateNumberFormatException
    extends ParseDateException {
        private static final long serialVersionUID = 1L;

        public ParseDateNumberFormatException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseDateException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ParseDateException(String msg, Exception e) {
            super(msg, e);
        }
    }
}

