/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.metadata.impl;

import java.util.ArrayList;
import java.util.List;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.helper.beans.DfBeanDesc;
import org.seasar.dbflute.helper.beans.DfPropertyDesc;
import org.seasar.dbflute.s2dao.metadata.TnBeanAnnotationReader;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.metadata.impl.TnAbstractPropertyTypeFactory;
import org.seasar.dbflute.s2dao.valuetype.TnValueTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnPropertyTypeFactoryImpl
extends TnAbstractPropertyTypeFactory {
    protected DBMeta _dbmeta;

    public TnPropertyTypeFactoryImpl(Class<?> beanClass, TnBeanAnnotationReader beanAnnotationReader, TnValueTypeFactory valueTypeFactory) {
        super(beanClass, beanAnnotationReader, valueTypeFactory);
        this.initializeResources();
    }

    protected void initializeResources() {
        if (this.isEntity()) {
            this._dbmeta = this.findDBMeta();
        }
    }

    protected boolean isEntity() {
        return Entity.class.isAssignableFrom(this.beanClass);
    }

    protected boolean hasDBMeta() {
        return this._dbmeta != null;
    }

    protected DBMeta findDBMeta() {
        try {
            Entity entity = (Entity)this.beanClass.newInstance();
            return entity.getDBMeta();
        }
        catch (Exception e) {
            String msg = "beanClass.newInstance() threw the exception: beanClass=" + this.beanClass;
            throw new RuntimeException(msg, e);
        }
    }

    @Override
    public TnPropertyType[] createBeanPropertyTypes() {
        ArrayList<TnPropertyType> list = new ArrayList<TnPropertyType>();
        DfBeanDesc beanDesc = this.getBeanDesc();
        List<String> proppertyNameList = beanDesc.getProppertyNameList();
        for (String proppertyName : proppertyNameList) {
            DfPropertyDesc pd = beanDesc.getPropertyDesc(proppertyName);
            if (!pd.hasWriteMethod() || this.isRelation(pd)) continue;
            TnPropertyType pt = this.createPropertyType(pd);
            pt.setPrimaryKey(this.isPrimaryKey(pd));
            pt.setPersistent(this.isPersistent(pt));
            list.add(pt);
        }
        return list.toArray(new TnPropertyType[list.size()]);
    }

    @Override
    protected boolean isRelation(DfPropertyDesc propertyDesc) {
        String propertyName = propertyDesc.getPropertyName();
        if (this.hasDBMeta() && (this._dbmeta.hasForeign(propertyName) || this._dbmeta.hasReferrer(propertyName))) {
            return true;
        }
        return this.hasRelationNoAnnotation(propertyDesc);
    }

    protected boolean hasRelationNoAnnotation(DfPropertyDesc propertyDesc) {
        return this.beanAnnotationReader.hasRelationNo(propertyDesc);
    }

    @Override
    protected boolean isPrimaryKey(DfPropertyDesc propertyDesc) {
        String propertyName = propertyDesc.getPropertyName();
        if (this.hasDBMeta() && this._dbmeta.hasPrimaryKey() && this._dbmeta.hasColumn(propertyName) && this._dbmeta.findColumnInfo(propertyName).isPrimary()) {
            return true;
        }
        return this.hasIdAnnotation(propertyDesc);
    }

    protected boolean hasIdAnnotation(DfPropertyDesc propertyDesc) {
        return this.beanAnnotationReader.getId(propertyDesc) != null;
    }

    @Override
    protected boolean isPersistent(TnPropertyType propertyType) {
        String propertyName = propertyType.getPropertyName();
        DfPropertyDesc propertyDesc = propertyType.getPropertyDesc();
        return this.hasDBMeta() && this._dbmeta.hasColumn(propertyName) || this.hasColumnAnnotation(propertyDesc);
    }

    protected boolean hasColumnAnnotation(DfPropertyDesc propertyDesc) {
        return this.beanAnnotationReader.getColumnAnnotation(propertyDesc) != null;
    }
}

