/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.util;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.seasar.dbflute.helper.mapstring.impl.MapListStringImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfPropertyUtil {
    public static String stringProp(Properties prop, String key) {
        if (prop == null) {
            String msg = "The argument 'prop' should not be null:";
            msg = msg + " " + DfPropertyUtil.getLogStrKey(key);
            throw new NullPointerException(msg);
        }
        if (key == null) {
            throw new NullPointerException("Argument[key] must not be null.");
        }
        String value = (String)prop.get(key);
        if (value == null) {
            String msg = "Not found property for the key:";
            msg = msg + " " + DfPropertyUtil.getLogStrKey(key) + " properties=" + prop;
            throw new PropertyNotFoundException(msg);
        }
        if ("null".equalsIgnoreCase(value.trim())) {
            return "";
        }
        return value.trim();
    }

    public static boolean booleanProp(Properties prop, String key) {
        String value = DfPropertyUtil.stringProp(prop, key);
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        String msg = "The property is not boolean: " + DfPropertyUtil.getLogStrKeyValue(key, value);
        throw new PropertyBooleanFormatException(msg);
    }

    public static int intProp(Properties prop, String key) {
        String value = DfPropertyUtil.stringProp(prop, key);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            String msg = "NumberFormatException: " + DfPropertyUtil.getLogStrKeyValue(key, value);
            throw new PropertyIntegerFormatException(msg);
        }
    }

    public static BigDecimal bigDecimalProp(Properties prop, String key) {
        String value = DfPropertyUtil.stringProp(prop, key);
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            String msg = "NumberFormatException: " + DfPropertyUtil.getLogStrKeyValue(key, value);
            throw new IllegalStateException(msg);
        }
    }

    public static List<Object> listProp(Properties prop, String key) {
        MapListStringImpl mapListString = new MapListStringImpl();
        return mapListString.generateList(DfPropertyUtil.stringProp(prop, key));
    }

    public static List<Object> listProp(Properties prop, String key, String delimiter) {
        MapListStringImpl mapListString = new MapListStringImpl();
        mapListString.setDelimiter(delimiter);
        return mapListString.generateList(DfPropertyUtil.stringProp(prop, key));
    }

    public static Map<String, Object> mapProp(Properties prop, String key) {
        MapListStringImpl mapListString = new MapListStringImpl();
        return mapListString.generateMap(DfPropertyUtil.stringProp(prop, key));
    }

    public static Map<String, Object> mapProp(Properties prop, String key, String delimiter) {
        MapListStringImpl mapListString = new MapListStringImpl();
        mapListString.setDelimiter(delimiter);
        return mapListString.generateMap(DfPropertyUtil.stringProp(prop, key));
    }

    public static String getLogStrKey(String key) {
        return "key=[" + key + "]";
    }

    public static String getLogStrKeyValue(String key, String value) {
        return "key=[" + key + "] value=[" + value + "]";
    }

    public static String convertTag(String targetStr, Map convertMap) {
        Set keySet = convertMap.keySet();
        Collection valCol = convertMap.values();
        Iterator keyIte = keySet.iterator();
        Iterator valIte = valCol.iterator();
        LinkedHashMap<String, String> wk = new LinkedHashMap<String, String>(convertMap.size());
        while (keyIte.hasNext()) {
            String key = (String)keyIte.next();
            String val = (String)valIte.next();
            wk.put("[" + key + "]", val);
        }
        return DfPropertyUtil.convertAll(targetStr, wk);
    }

    public static String removeTag(String targetStr) {
        return DfPropertyUtil.removeAll(targetStr, "[", "]");
    }

    public static boolean containsTag(String targetStr) {
        int start = targetStr.indexOf("[");
        int end = targetStr.indexOf("]");
        return start != -1 && end != -1 && start < end;
    }

    public static String convertAll(String targetStr, String oldStr, String newStr) {
        if (targetStr == null) {
            throw new IllegalArgumentException("'targetStr' is null");
        }
        if (oldStr == null) {
            throw new IllegalArgumentException("'oldStr' is null");
        }
        if (newStr == null) {
            throw new IllegalArgumentException("'newStr' is null");
        }
        String result = "";
        int index = 0;
        StringBuffer sb = new StringBuffer(targetStr);
        while (true) {
            if ((index = sb.toString().indexOf(oldStr)) == -1) break;
            sb.delete(index, index + oldStr.length());
            sb.insert(index, newStr);
            int endIndex = index + newStr.length();
            result = result + sb.substring(0, endIndex);
            sb.delete(0, endIndex);
        }
        result = result + sb.toString();
        return result;
    }

    public static String convertAll(String targetStr, Map convertMap) {
        if (targetStr == null) {
            throw new IllegalArgumentException("'targetStr' is null");
        }
        if (convertMap == null) {
            throw new IllegalArgumentException("'replaceMap' is null");
        }
        Set keySet = convertMap.keySet();
        Collection valCol = convertMap.values();
        Iterator keyIte = keySet.iterator();
        Iterator valIte = valCol.iterator();
        while (keyIte.hasNext()) {
            String oldStr = (String)keyIte.next();
            String newStr = (String)valIte.next();
            if (oldStr == null) {
                throw new IllegalArgumentException("'replaceMap' has null key!");
            }
            if (newStr == null) {
                newStr = "";
            }
            targetStr = DfPropertyUtil.convertAll(targetStr, oldStr, newStr);
        }
        return targetStr;
    }

    public static String removeAll(String targetStr, String removeStr) {
        if (targetStr == null) {
            throw new IllegalArgumentException("'targetStr' is null");
        }
        if (removeStr == null) {
            throw new IllegalArgumentException("'start' is null");
        }
        return DfPropertyUtil.removeAll(targetStr, new String[]{removeStr});
    }

    public static String removeAll(String targetStr, String[] removeStrs) {
        if (targetStr == null) {
            throw new IllegalArgumentException("'targetStr' is null");
        }
        if (removeStrs == null) {
            throw new IllegalArgumentException("'removeStrs' is null");
        }
        for (int i = 0; i < removeStrs.length; ++i) {
            String removeStr = removeStrs[i];
            if (removeStr == null) {
                throw new IllegalArgumentException("'removeStrs' has null: index==[" + i + "]");
            }
            targetStr = DfPropertyUtil.convertAll(targetStr, removeStr, "");
        }
        return targetStr;
    }

    public static String removeAll(String targetStr, String start, String end) {
        if (targetStr == null) {
            throw new IllegalArgumentException("'targetStr' is null");
        }
        if (start == null) {
            throw new IllegalArgumentException("'start' is null");
        }
        if (end == null) {
            throw new IllegalArgumentException("'end' is null");
        }
        int startIndex = 0;
        int endIndex = 0;
        StringBuffer sb = new StringBuffer(targetStr);
        while ((startIndex = sb.toString().indexOf(start)) != -1 && (endIndex = sb.toString().indexOf(end, startIndex + 1)) != -1) {
            sb.delete(startIndex, endIndex + 1);
        }
        return sb.toString();
    }

    public static int countDelim(String str, String delim) {
        int result = 0;
        int i = 0;
        while (str.indexOf(delim, i) != -1) {
            ++result;
            i = str.indexOf(delim, i) + 1;
        }
        if (result == 0) {
            result = -1;
        }
        return result;
    }

    public static class PropertyIntegerFormatException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public PropertyIntegerFormatException(String msg) {
            super(msg);
        }
    }

    public static class PropertyBooleanFormatException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public PropertyBooleanFormatException(String msg) {
            super(msg);
        }
    }

    public static class PropertyNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public PropertyNotFoundException(String msg) {
            super(msg);
        }
    }
}

