/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.exception.DfIllegalPropertySettingException;
import org.seasar.dbflute.exception.DfIllegalPropertyTypeException;
import org.seasar.dbflute.exception.DfRequiredPropertyNotFoundException;
import org.seasar.dbflute.properties.DfAbstractHelperProperties;
import org.seasar.dbflute.util.DfStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DfReplaceSchemaProperties
extends DfAbstractHelperProperties {
    private static final Log _log = LogFactory.getLog(DfReplaceSchemaProperties.class);
    public static final String KEY_replaceSchemaDefinitionMap = "replaceSchemaDefinitionMap";
    protected Map<String, Object> _replaceSchemaDefinitionMap;
    protected Map<String, String> _filterVariablesMap;
    protected Map<String, Map<String, String>> _additionalUesrMap;

    public DfReplaceSchemaProperties(Properties prop) {
        super(prop);
    }

    public Map<String, Object> getReplaceSchemaDefinitionMap() {
        if (this._replaceSchemaDefinitionMap == null) {
            this._replaceSchemaDefinitionMap = this.mapProp("torque.replaceSchemaDefinitionMap", DEFAULT_EMPTY_MAP);
            _log.info((Object)("...Initializing replaceSchemaDefinitionMap: " + this._replaceSchemaDefinitionMap));
        }
        return this._replaceSchemaDefinitionMap;
    }

    public String getReplaceSchemaSqlFile() {
        return "./playsql/replace-schema.sql";
    }

    public String getTakeFinallySqlFile() {
        return "./playsql/take-finally.sql";
    }

    public String getDataLoadingType() {
        String propString = (String)this.getReplaceSchemaDefinitionMap().get("dataLoadingType");
        if (propString == null) {
            return this.getOldStyleEnvironmentType();
        }
        return propString;
    }

    protected String getOldStyleEnvironmentType() {
        String propString = (String)this.getReplaceSchemaDefinitionMap().get("environmentType");
        if (propString == null) {
            return "ut";
        }
        return propString;
    }

    protected Map<String, String> getFilterVariablesMap() {
        if (this._filterVariablesMap != null) {
            return this._filterVariablesMap;
        }
        this._filterVariablesMap = (Map)this.getReplaceSchemaDefinitionMap().get("filterVariablesMap");
        if (this._filterVariablesMap == null) {
            this._filterVariablesMap = new HashMap<String, String>();
        }
        return this._filterVariablesMap;
    }

    protected String getFilterVariablesBeginMark() {
        return "/*$";
    }

    protected String getFilterVariablesEndMark() {
        return "*/";
    }

    public String resolveFilterVariablesIfNeeds(String sql) {
        String beginMark = this.getFilterVariablesBeginMark();
        String endMark = this.getFilterVariablesEndMark();
        Map<String, String> filterVariablesMap = this.getFilterVariablesMap();
        if (!filterVariablesMap.isEmpty() && sql.contains(beginMark) && sql.contains(endMark)) {
            Set<String> keySet = filterVariablesMap.keySet();
            for (String key : keySet) {
                String variableMark = beginMark + key + endMark;
                if (!sql.contains(variableMark)) continue;
                String value = filterVariablesMap.get(key);
                sql = this.replaceString(sql, variableMark, value);
            }
        }
        return sql;
    }

    public boolean isLoggingInsertSql() {
        return this.isProperty("isLoggingInsertSql", true, this.getReplaceSchemaDefinitionMap());
    }

    public String getSqlFileEncoding() {
        String sqlFileEncoding = (String)this.getReplaceSchemaDefinitionMap().get("sqlFileEncoding");
        if (sqlFileEncoding != null && sqlFileEncoding.trim().length() != 0) {
            return sqlFileEncoding;
        }
        return "UTF-8";
    }

    public String getSkipSheet() {
        String skipSheet = (String)this.getReplaceSchemaDefinitionMap().get("skipSheet");
        if (skipSheet != null && skipSheet.trim().length() != 0) {
            return skipSheet;
        }
        return null;
    }

    public boolean isIncrementSequenceToDataMax() {
        return this.isProperty("isIncrementSequenceToDataMax", false, this.getReplaceSchemaDefinitionMap());
    }

    public boolean isSuppressBatchUpdate() {
        return this.isProperty("isSuppressBatchUpdate", false, this.getReplaceSchemaDefinitionMap());
    }

    public boolean isDropGenerateTableOnly() {
        return this.isProperty("isDropGenerateTableOnly", false, this.getReplaceSchemaDefinitionMap());
    }

    public boolean isDropGenerateProcedureOnly() {
        return this.isProperty("isDropGenerateProcedureOnly", false, this.getReplaceSchemaDefinitionMap());
    }

    public Map<String, Map<String, String>> getAdditionalUserMap() {
        if (this._additionalUesrMap != null) {
            return this._additionalUesrMap;
        }
        Object obj = this.getReplaceSchemaDefinitionMap().get("additionalUserMap");
        if (obj == null) {
            return new HashMap<String, Map<String, String>>();
        }
        if (!(obj instanceof Map)) {
            String msg = "The type of the property 'additionalUserMap' should be Map: " + obj;
            throw new DfIllegalPropertyTypeException(msg);
        }
        this._additionalUesrMap = (Map)obj;
        return this._additionalUesrMap;
    }

    protected Map<String, String> getAdditionalUserPropertyMap(String additonalUser) {
        return this.getAdditionalUserMap().get(additonalUser);
    }

    public Connection createAdditionalUserConnection(String additonalUser) {
        Map<String, String> propertyMap = this.getAdditionalUserPropertyMap(additonalUser);
        if (propertyMap == null) {
            return null;
        }
        String driver = this.getDatabaseProperties().getDatabaseDriver();
        String property = propertyMap.get("url");
        String url = property != null && property.trim().length() > 0 ? property : this.getDatabaseProperties().getDatabaseUrl();
        String schema = propertyMap.get("schema");
        String user = propertyMap.get("user");
        String password = propertyMap.get("password");
        _log.info((Object)"...Creating a connection for additional user");
        return this.createConnection(driver, url, schema, user, password);
    }

    public List<Map<String, Object>> getAdditionalDropMapList() {
        Object obj = this.getReplaceSchemaDefinitionMap().get("additionalDropMapList");
        if (obj == null) {
            return new ArrayList<Map<String, Object>>();
        }
        return this.castToList(obj, "additionalDropMapList");
    }

    public String getAdditionalDropUrl(Map<String, Object> additionalDropMap) {
        Object obj = additionalDropMap.get("url");
        if (obj == null) {
            return null;
        }
        return this.castToString(obj, "additionalDropMapList.url");
    }

    public String getAdditionalDropUser(Map<String, Object> additionalDropMap) {
        Object obj = additionalDropMap.get("user");
        if (obj == null) {
            return null;
        }
        return this.castToString(obj, "additionalDropMapList.user");
    }

    public String getAdditionalDropPassword(Map<String, Object> additionalDropMap) {
        Object obj = additionalDropMap.get("password");
        if (obj == null) {
            return null;
        }
        return this.castToString(obj, "additionalDropMapList.password");
    }

    public Properties getAdditionalDropPropertiesMap(Map<String, Object> additionalDropMap) {
        Object obj = additionalDropMap.get("propertiesMap");
        if (obj == null) {
            return new Properties();
        }
        if (!(obj instanceof Map)) {
            String msg = "The schema should be Map<String, String>:";
            msg = msg + " propertiesMap=" + obj + " type=" + obj.getClass();
            throw new DfIllegalPropertyTypeException(msg);
        }
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)((Map)obj));
        return prop;
    }

    public String getAdditionalDropSchema(Map<String, Object> additionalDropMap) {
        Object obj = additionalDropMap.get("schema");
        if (obj == null) {
            this.getBasicProperties().isDatabasePostgreSQL();
            if (!this.isSchemaCanBeOmittedDBMS()) {
                String msg = "The schema is required:";
                msg = msg + " additionalDropMap=" + additionalDropMap;
                throw new DfRequiredPropertyNotFoundException(msg);
            }
            return null;
        }
        return this.castToString(obj, "additionalDropMapList.schema");
    }

    protected boolean isSchemaCanBeOmittedDBMS() {
        return this.getBasicProperties().isDatabaseSchemaCanBeOmitted();
    }

    public List<String> getAdditionalDropObjectTypeList(Map<String, Object> additionalDropMap) {
        Object obj = additionalDropMap.get("objectTypeTargetList");
        if (obj == null && (obj = additionalDropMap.get("objectTypeList")) == null) {
            ArrayList<String> defaultList = new ArrayList<String>();
            defaultList.add("TABLE");
            defaultList.add("VIEW");
            return defaultList;
        }
        return this.castToList(obj, "additionalDropMapList.objectTypeTargetList");
    }

    public List<String> getAdditionalDropTableTargetList(Map<String, Object> additionalDropMap) {
        Object obj = additionalDropMap.get("tableTargetList");
        if (obj == null) {
            return new ArrayList<String>();
        }
        return this.castToList(obj, "additionalDropMapList.tableTargetList");
    }

    public List<String> getAdditionalDropTableExceptList(Map<String, Object> additionalDropMap) {
        Object obj = additionalDropMap.get("tableExceptList");
        if (obj == null) {
            return new ArrayList<String>();
        }
        return this.castToList(obj, "additionalDropMapList.tableExceptList");
    }

    public boolean isAdditionalDropAllTable(Map<String, Object> additionalDropMap) {
        return this.isProperty("isDropAllTable", false, additionalDropMap);
    }

    public Connection createAdditionalDropConnection(Map<String, Object> additionalDropMap) {
        String password;
        String driver = this.getDatabaseProperties().getDatabaseDriver();
        String url = this.getAdditionalDropUrl(additionalDropMap);
        url = url != null && url.trim().length() > 0 ? url : this.getDatabaseProperties().getDatabaseUrl();
        String user = this.getAdditionalDropUser(additionalDropMap);
        if (user != null && user.trim().length() > 0) {
            password = this.getAdditionalDropPassword(additionalDropMap);
            if (password == null || password.trim().length() == 0) {
                String msg = "The password is required when the user is specified:";
                msg = msg + " user=" + user + " additionalDropMap=" + additionalDropMap;
                throw new DfIllegalPropertySettingException(msg);
            }
        } else {
            user = this.getDatabaseProperties().getDatabaseUser();
            password = this.getDatabaseProperties().getDatabasePassword();
        }
        Properties prop = this.getAdditionalDropPropertiesMap(additionalDropMap);
        Properties info = new Properties();
        info.putAll((Map<?, ?>)prop);
        info.put("user", user);
        info.put("password", password);
        String schema = this.getAdditionalDropSchema(additionalDropMap);
        _log.info((Object)"...Creating a connection for additional drop");
        return this.createConnection(driver, url, schema, info);
    }

    public boolean isSuppressTruncateTable() {
        return this.isProperty("isSuppressTruncateTable", false, this.getReplaceSchemaDefinitionMap());
    }

    public boolean isSuppressDropForeignKey() {
        return this.isProperty("isSuppressDropForeignKey", false, this.getReplaceSchemaDefinitionMap());
    }

    public boolean isSuppressDropTable() {
        return this.isProperty("isSuppressDropTable", false, this.getReplaceSchemaDefinitionMap());
    }

    public boolean isSuppressDropSequence() {
        return this.isProperty("isSuppressDropSequence", false, this.getReplaceSchemaDefinitionMap());
    }

    public boolean isSuppressDropProcedure() {
        return this.isProperty("isSuppressDropProcedure", false, this.getReplaceSchemaDefinitionMap());
    }

    public boolean isSuppressDropDBLink() {
        return this.isProperty("isSuppressDropDBLink", false, this.getReplaceSchemaDefinitionMap());
    }

    public boolean isErrorContinue() {
        return this.isProperty("isErrorContinue", true, this.getReplaceSchemaDefinitionMap());
    }

    public String getBeforeTakeFinally() {
        return (String)this.getReplaceSchemaDefinitionMap().get("beforeTakeFinally");
    }

    protected String replaceString(String text, String fromText, String toText) {
        return DfStringUtil.replace((String)text, (String)fromText, (String)toText);
    }
}

