/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.exception.DfIllegalPropertyTypeException;
import org.seasar.dbflute.exception.DfRequiredPropertyNotFoundException;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.properties.DfAbstractHelperProperties;
import org.seasar.dbflute.properties.assistant.DfAdditionalSchemaInfo;
import org.seasar.dbflute.properties.assistant.DfConnectionProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DfDatabaseProperties
extends DfAbstractHelperProperties {
    private static final Log _log = LogFactory.getLog(DfDatabaseProperties.class);
    protected DatabaseInfo _databaseInfo = new DatabaseInfo();
    protected Map<String, List<String>> _columnExceptMap;
    protected Map<String, DfAdditionalSchemaInfo> _additionalSchemaMap;

    public DfDatabaseProperties(Properties prop) {
        super(prop);
    }

    public String getDatabaseDriver() {
        return this._databaseInfo.getDatabaseDriver();
    }

    public String getDatabaseUrl() {
        return this._databaseInfo.getDatabaseUrl();
    }

    public String getDatabaseSchema() {
        return this._databaseInfo.getDatabaseSchema();
    }

    public String getDatabaseUser() {
        return this._databaseInfo.getDatabaseUser();
    }

    public String getDatabasePassword() {
        return this._databaseInfo.getDatabasePassword();
    }

    public boolean isDifferentUserSchema() {
        String databaseSchema;
        String databaseUser = this.getDatabaseUser();
        return !databaseUser.equalsIgnoreCase(databaseSchema = this.getDatabaseSchema());
    }

    public Properties getDatabaseConnectionProperties() {
        return this._databaseInfo.getDatabaseConnectionProperties();
    }

    public List<String> getObjectTypeTargetList() {
        return this.getVairousStringList("objectTypeTargetList", this.getDatabaseTypeList());
    }

    public boolean hasObjectTypeSynonym() {
        return DfConnectionProperties.hasObjectTypeSynonym(this.getObjectTypeTargetList());
    }

    protected List<String> getDatabaseTypeList() {
        ArrayList<Object> defaultList = new ArrayList<Object>();
        defaultList.add("TABLE");
        defaultList.add("VIEW");
        ArrayList<String> resultList = new ArrayList<String>();
        List<Object> listProp = this.listProp("torque.database.type.list", defaultList);
        for (Object object : listProp) {
            resultList.add((String)object);
        }
        return resultList;
    }

    public List<String> getTableExceptList() {
        List<String> vairousList = this.getVairousStringList("tableExceptList");
        if (!vairousList.isEmpty()) {
            return vairousList;
        }
        ArrayList<String> resultList = new ArrayList<String>();
        List<Object> listProp = this.listProp("torque.table.except.list", DEFAULT_EMPTY_LIST);
        for (Object object : listProp) {
            resultList.add((String)object);
        }
        return resultList;
    }

    public List<String> getTableTargetList() {
        List<String> vairousList = this.getVairousStringList("tableTargetList");
        if (!vairousList.isEmpty()) {
            return vairousList;
        }
        ArrayList<String> resultList = new ArrayList<String>();
        List<Object> listProp = this.listProp("torque.table.target.list", DEFAULT_EMPTY_LIST);
        for (Object object : listProp) {
            resultList.add((String)object);
        }
        return resultList;
    }

    public Map<String, List<String>> getColumnExceptMap() {
        if (this._columnExceptMap != null) {
            return this._columnExceptMap;
        }
        List<String> oldStyleList = this.getVairousStringList("columnExceptList");
        if (!oldStyleList.isEmpty()) {
            String msg = "You should migrate 'columnExceptList' to 'columnExceptMap'";
            msg = msg + " in databaseInfoMap.dfprop: columnExceptList=" + oldStyleList;
            throw new IllegalStateException(msg);
        }
        StringKeyMap columnExceptMap = StringKeyMap.createAsFlexible();
        Map<String, Object> keyMap = this.getVairousStringKeyMap("columnExceptMap");
        if (keyMap.isEmpty()) {
            return columnExceptMap;
        }
        Set<Map.Entry<String, Object>> entrySet = keyMap.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String tableName = entry.getKey();
            Object obj = entry.getValue();
            if (!(obj instanceof List)) {
                String msg = "The type of element in the property 'columnExceptMap' should be List:";
                msg = msg + " type=" + (obj != null ? obj.getClass().getSimpleName() : null) + " value=" + obj;
                throw new DfIllegalPropertyTypeException(msg);
            }
            List columnList = (List)obj;
            columnExceptMap.put(tableName, columnList);
        }
        this._columnExceptMap = columnExceptMap;
        return this._columnExceptMap;
    }

    protected void assertOldStyleAdditionalSchema() {
        Object oldStyle = this.getVariousObject("additionalSchemaList");
        if (oldStyle != null) {
            String msg = "The property 'additionalSchemaList' have been unsupported!";
            msg = msg + " Please use the property 'additionalSchemaMap'.";
            throw new IllegalStateException(msg);
        }
    }

    public Map<String, DfAdditionalSchemaInfo> getAdditionalSchemaMap() {
        if (this._additionalSchemaMap != null) {
            return this._additionalSchemaMap;
        }
        this.assertOldStyleAdditionalSchema();
        this._additionalSchemaMap = new LinkedHashMap<String, DfAdditionalSchemaInfo>();
        Map<String, Object> additionalSchemaMap = this.getVairousStringKeyMap("additionalSchemaMap");
        if (additionalSchemaMap == null) {
            return this._additionalSchemaMap;
        }
        Set<Map.Entry<String, Object>> entrySet = additionalSchemaMap.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String msg;
            String schemaName = entry.getKey();
            Object obj = entry.getValue();
            if (obj == null) {
                msg = "The value of schema in the property 'additionalSchemaMap' should be required:";
                msg = msg + " schema=" + schemaName;
                msg = msg + " additionalSchemaMap=" + additionalSchemaMap;
                throw new DfRequiredPropertyNotFoundException(msg);
            }
            if (!(obj instanceof Map)) {
                msg = "The type of schema value in the property 'additionalSchemaMap' should be Map:";
                msg = msg + " type=" + (obj != null ? obj.getClass().getSimpleName() : null) + " value=" + obj;
                throw new DfIllegalPropertyTypeException(msg);
            }
            Map elementMap = (Map)obj;
            DfAdditionalSchemaInfo info = new DfAdditionalSchemaInfo();
            info.setSchemaName(schemaName);
            this.setupAdditionalSchemaObjectTypeTargetList(info, elementMap);
            this.setupAdditionalSchemaTableExceptList(info, elementMap);
            this.setupAdditionalSchemaTableTargetList(info, elementMap);
            info.setSuppressCommonColumn(this.isProperty("isSuppressCommonColumn", false, elementMap));
            this.setupAdditionalSchemaSupplementaryConnectionMap(info, elementMap);
            this._additionalSchemaMap.put(schemaName, info);
        }
        return this._additionalSchemaMap;
    }

    protected void setupAdditionalSchemaObjectTypeTargetList(DfAdditionalSchemaInfo info, Map<String, Object> elementMap) {
        Object obj = elementMap.get("objectTypeTargetList");
        if (obj == null) {
            List objectTypeTargetList = Collections.EMPTY_LIST;
            info.setObjectTypeTargetList(objectTypeTargetList);
        } else {
            if (!(obj instanceof List)) {
                String msg = "The type of objectTypeTargetList in the property 'additionalSchemaMap' should be List:";
                msg = msg + " type=" + (obj != null ? obj.getClass().getSimpleName() : null) + " value=" + obj;
                throw new DfIllegalPropertyTypeException(msg);
            }
            List objectTypeTargetList = (List)obj;
            info.setObjectTypeTargetList(objectTypeTargetList);
        }
    }

    protected void setupAdditionalSchemaTableExceptList(DfAdditionalSchemaInfo info, Map<String, Object> elementMap) {
        Object obj = elementMap.get("tableExceptList");
        if (obj == null) {
            List tableExceptList = Collections.EMPTY_LIST;
            info.setTableExceptList(tableExceptList);
        } else {
            if (!(obj instanceof List)) {
                String msg = "The type of tableExceptList in the property 'additionalSchemaMap' should be List:";
                msg = msg + " type=" + (obj != null ? obj.getClass().getSimpleName() : null) + " value=" + obj;
                throw new DfIllegalPropertyTypeException(msg);
            }
            List tableExceptList = (List)obj;
            info.setTableExceptList(tableExceptList);
        }
    }

    protected void setupAdditionalSchemaTableTargetList(DfAdditionalSchemaInfo info, Map<String, Object> elementMap) {
        Object obj = elementMap.get("tableTargetList");
        if (obj == null) {
            List tableTargetList = Collections.EMPTY_LIST;
            info.setTableTargetList(tableTargetList);
        } else {
            if (!(obj instanceof List)) {
                String msg = "The type of tableTargetList in the property 'additionalSchemaMap' should be List:";
                msg = msg + " type=" + (obj != null ? obj.getClass().getSimpleName() : null) + " value=" + obj;
                throw new DfIllegalPropertyTypeException(msg);
            }
            List tableTargetList = (List)obj;
            info.setTableTargetList(tableTargetList);
        }
    }

    protected void setupAdditionalSchemaSupplementaryConnectionMap(DfAdditionalSchemaInfo info, Map<String, Object> elementMap) {
        Object obj = elementMap.get("supplementaryConnectionMap");
        if (obj == null) {
            Map supplementaryConnectionMap = Collections.EMPTY_MAP;
            info.setSupplementaryConnectionMap(supplementaryConnectionMap);
        } else {
            if (!(obj instanceof Map)) {
                String msg = "The type of supplementaryConnectionMap in the property 'additionalSchemaMap' should be Map:";
                msg = msg + " type=" + (obj != null ? obj.getClass().getSimpleName() : null) + " value=" + obj;
                throw new DfIllegalPropertyTypeException(msg);
            }
            Map supplementaryConnectionMap = (Map)obj;
            info.setSupplementaryConnectionMap(supplementaryConnectionMap);
        }
    }

    public boolean hasAdditionalSchema() {
        return !this.getAdditionalSchemaMap().isEmpty();
    }

    public boolean isAdditionalSchema(String schema) {
        return this.getAdditionalSchemaMap().containsKey(schema);
    }

    protected Connection getAdditionalSchemaSupplementaryConnection(String schema) {
        if (!this.hasAdditionalSchemaSupplementaryConnection(schema)) {
            String msg = "The additional schema should have supplementary connection informations:";
            msg = msg + " schema=" + schema;
            throw new IllegalStateException(msg);
        }
        String driver = this.getDatabaseDriver();
        String url = this.getAdditionalSchemaSupplementaryConnectionUrl(schema);
        String user = this.getAdditionalSchemaSupplementaryConnectionUser(schema);
        String password = this.getAdditionalSchemaSupplementaryConnectionPassword(schema);
        return this.createConnection(driver, url, schema, user, password);
    }

    public boolean hasAdditionalSchemaSupplementaryConnection(String schema) {
        if (!this.isAdditionalSchema(schema)) {
            return false;
        }
        String user = this.getAdditionalSchemaMap().get(schema).getSupplementaryConnectionUser();
        return user != null && user.trim().length() > 0;
    }

    protected String getAdditionalSchemaSupplementaryConnectionUrl(String schema) {
        return this.getDatabaseUrl();
    }

    protected String getAdditionalSchemaSupplementaryConnectionUser(String schema) {
        if (!this.hasAdditionalSchemaSupplementaryConnection(schema)) {
            return null;
        }
        return this.getAdditionalSchemaMap().get(schema).getSupplementaryConnectionUser();
    }

    protected String getAdditionalSchemaSupplementaryConnectionPassword(String schema) {
        if (!this.hasAdditionalSchemaSupplementaryConnection(schema)) {
            return null;
        }
        return this.getAdditionalSchemaMap().get(schema).getSupplementaryConnectionPassword();
    }

    protected List<String> getVairousStringList(String key) {
        return this.getVairousStringList(key, Collections.EMPTY_LIST);
    }

    protected List<String> getVairousStringList(String key, List<String> defaultList) {
        Object value = this.getVariousObject(key);
        if (value == null) {
            return defaultList != null ? defaultList : Collections.EMPTY_LIST;
        }
        this.assertVariousPropertyList(key, value);
        return (List)value;
    }

    protected void assertVariousPropertyList(String name, Object value) {
        if (!(value instanceof List)) {
            String msg = "The property '" + name + "' should be List: " + value;
            throw new IllegalStateException(msg);
        }
    }

    protected Map<String, Object> getVairousStringKeyMap(String key) {
        return this.getVairousStringKeyMap(key, Collections.EMPTY_MAP);
    }

    protected Map<String, Object> getVairousStringKeyMap(String key, Map<String, Object> defaultMap) {
        Object value = this.getVariousObject(key);
        if (value == null) {
            return defaultMap != null ? defaultMap : Collections.EMPTY_MAP;
        }
        this.assertVariousPropertyMap(key, value);
        return (Map)value;
    }

    protected void assertVariousPropertyMap(String name, Object value) {
        if (!(value instanceof Map)) {
            String msg = "The property '" + name + "' should be Map: " + value;
            throw new IllegalStateException(msg);
        }
    }

    protected Object getVariousObject(String key) {
        Map<String, Object> variousMap = this._databaseInfo.getDatabaseVariousMap();
        return variousMap.get(key);
    }

    public Connection createMainSchemaConnection() {
        String driver = this.getDatabaseDriver();
        String url = this.getDatabaseUrl();
        String schema = this.getDatabaseSchema();
        String user = this.getDatabaseUser();
        String password = this.getDatabasePassword();
        _log.info((Object)"...Creating a connection to main schema");
        return this.createConnection(driver, url, schema, user, password);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DatabaseInfo {
        private static final String KEY_DRIVER = "driver";
        private static final String KEY_URL = "url";
        private static final String KEY_SCHEMA = "schema";
        private static final String KEY_USER = "user";
        private static final String KEY_PASSWORD = "password";
        private static final String KEY_PROPERTIES_MAP = "propertiesMap";
        private static final String KEY_VARIOUS_MAP = "variousMap";
        protected Map<String, Object> _databaseInfoMap;

        public String getDatabaseDriver() {
            this.initializeDatabaseInfoMap();
            String key = KEY_DRIVER;
            String databaseInfoElement = this.getDatabaseInfoElement(KEY_DRIVER);
            if (databaseInfoElement != null) {
                return databaseInfoElement;
            }
            return DfDatabaseProperties.this.stringProp("torque.database.driver");
        }

        public String getDatabaseUrl() {
            this.initializeDatabaseInfoMap();
            String key = KEY_URL;
            String databaseInfoElement = this.getDatabaseInfoElement(KEY_URL);
            if (databaseInfoElement != null) {
                return databaseInfoElement + this.getDatabaseUriProperty();
            }
            return DfDatabaseProperties.this.stringProp("torque.database.url");
        }

        private String getDatabaseUriProperty() {
            this.initializeDatabaseInfoMap();
            StringBuilder sb = new StringBuilder();
            Set<String> keySet = this._databaseInfoMap.keySet();
            for (String key : keySet) {
                if (this.equalsKeys(key, KEY_DRIVER, KEY_URL, KEY_SCHEMA, KEY_USER, KEY_PASSWORD, KEY_PROPERTIES_MAP, KEY_VARIOUS_MAP)) continue;
                Object value = this._databaseInfoMap.get(key);
                sb.append(";").append(key).append("=").append(value);
            }
            return sb.toString();
        }

        private boolean equalsKeys(String target, String ... keys) {
            for (String key : keys) {
                if (!target.equals(key)) continue;
                return true;
            }
            return false;
        }

        public String getDatabaseSchema() {
            this.initializeDatabaseInfoMap();
            String key = KEY_SCHEMA;
            String databaseInfoElement = this.getDatabaseInfoElement(KEY_SCHEMA);
            if (databaseInfoElement != null) {
                return databaseInfoElement;
            }
            return DfDatabaseProperties.this.stringProp("torque.database.schema", "");
        }

        public String getDatabaseUser() {
            this.initializeDatabaseInfoMap();
            String key = KEY_USER;
            String databaseInfoElement = this.getDatabaseInfoElement(KEY_USER);
            if (databaseInfoElement != null) {
                return databaseInfoElement;
            }
            return DfDatabaseProperties.this.stringProp("torque.database.user");
        }

        public String getDatabasePassword() {
            this.initializeDatabaseInfoMap();
            String key = KEY_PASSWORD;
            String databaseInfoElement = this.getDatabaseInfoElement(KEY_PASSWORD);
            if (databaseInfoElement != null) {
                return databaseInfoElement;
            }
            return DfDatabaseProperties.this.stringProp("torque.database.password");
        }

        public Properties getDatabaseConnectionProperties() {
            this.initializeDatabaseInfoMap();
            String key = KEY_PROPERTIES_MAP;
            Map<String, String> propertiesMap = this.getDatabaseInfoElementAsPropertiesMap(KEY_PROPERTIES_MAP);
            Properties props = new Properties();
            if (propertiesMap.isEmpty()) {
                return props;
            }
            Set<String> keySet = propertiesMap.keySet();
            for (String propKey : keySet) {
                String propValue = propertiesMap.get(propKey);
                props.setProperty(propKey, propValue);
            }
            return props;
        }

        public Map<String, Object> getDatabaseVariousMap() {
            this.initializeDatabaseInfoMap();
            String key = KEY_VARIOUS_MAP;
            Map<String, Object> variousMap = this.getDatabaseInfoElementAsVariousMap(KEY_VARIOUS_MAP);
            return variousMap;
        }

        protected void initializeDatabaseInfoMap() {
            if (this._databaseInfoMap == null) {
                Map<String, Object> databaseInfoMap = DfDatabaseProperties.this.getOutsidePropMap("databaseInfo");
                if (databaseInfoMap.isEmpty()) {
                    databaseInfoMap = DfDatabaseProperties.this.getOutsidePropMap("databaseInfoMap");
                }
                if (!databaseInfoMap.isEmpty()) {
                    this._databaseInfoMap = databaseInfoMap;
                }
            }
        }

        protected boolean hasDatabaseInfoMap() {
            return this._databaseInfoMap != null;
        }

        protected String getDatabaseInfoElement(String key) {
            if (this._databaseInfoMap != null) {
                if (!this._databaseInfoMap.containsKey(key)) {
                    return "";
                }
                String value = (String)this._databaseInfoMap.get(key);
                return value != null ? value : "";
            }
            return null;
        }

        protected Map<String, String> getDatabaseInfoElementAsPropertiesMap(String key) {
            if (this._databaseInfoMap != null) {
                if (!this._databaseInfoMap.containsKey(key)) {
                    return new LinkedHashMap<String, String>();
                }
                Map valueList = (Map)this._databaseInfoMap.get(key);
                return valueList != null ? valueList : new LinkedHashMap();
            }
            return null;
        }

        protected Map<String, Object> getDatabaseInfoElementAsVariousMap(String key) {
            if (this._databaseInfoMap != null) {
                if (!this._databaseInfoMap.containsKey(key)) {
                    return new LinkedHashMap<String, Object>();
                }
                Map valueList = (Map)this._databaseInfoMap.get(key);
                return valueList != null ? valueList : new LinkedHashMap();
            }
            return null;
        }
    }
}

