/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.Table;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.properties.DfAbstractHelperProperties;
import org.seasar.dbflute.properties.DfAdditionalForeignKeyProperties;
import org.seasar.dbflute.properties.assistant.DfTableFinder;
import org.seasar.dbflute.util.DfStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DfBuriProperties
extends DfAbstractHelperProperties {
    private static final Log _log = LogFactory.getLog(DfBuriProperties.class);
    private static final String VIEW_ALL_ROUND_STATE = "BURI_ALL_ROUND_STATE";
    private static final String VIEW_ALL_ROUND_STATE_HISTORY = "BURI_ALL_ROUND_STATE_HISTORY";
    protected Map<String, Object> buriDefinitionMap;
    protected Map<String, Map<String, Map<String, List<String>>>> _activityDefinitionMap;
    protected Map<String, List<String>> _tableProcessMap;
    protected Map<String, String> _tableJavaNameCaseInsensitiveMap = StringKeyMap.createAsCaseInsensitive();
    protected Map<String, String> _columnJavaNameCaseInsensitiveMap;

    public DfBuriProperties(Properties prop) {
        super(prop);
        this.putTableJavaNameMap("BuriPath");
        this.putTableJavaNameMap("BuriData");
        this.putTableJavaNameMap("BuriBranch");
        this.putTableJavaNameMap("BuriState");
        this.putTableJavaNameMap("BuriStateUser");
        this.putTableJavaNameMap("BuriUser");
        this.putTableJavaNameMap("BuriTransaction");
        this.putTableJavaNameMap("BuriStateUndoLog");
        this.putTableJavaNameMap("BuriPathData");
        this.putTableJavaNameMap("BuriPathDataUser");
        this.putTableJavaNameMap("BuriPathHistoryData");
        this.putTableJavaNameMap("BuriPathHistoryDataUser");
        this.putTableJavaNameMap("BuriDataPathHistory");
        this._columnJavaNameCaseInsensitiveMap = StringKeyMap.createAsCaseInsensitive();
        this.putColumnJavaNameMap("StateId");
        this.putColumnJavaNameMap("PathId");
        this.putColumnJavaNameMap("DataId");
        this.putColumnJavaNameMap("BranchId");
        this.putColumnJavaNameMap("StateUserId");
        this.putColumnJavaNameMap("BuriUserId");
        this.putColumnJavaNameMap("StateUndoLogId");
        this.putColumnJavaNameMap("ParentBranchId");
        this.putColumnJavaNameMap("InsertUserId");
        this.putColumnJavaNameMap("HistoryId");
        this.putColumnJavaNameMap("UserIdVal");
        this.putColumnJavaNameMap("UserIdNum");
        this.putColumnJavaNameMap("PkeyVal");
        this.putColumnJavaNameMap("PkeyNum");
        this.putColumnJavaNameMap("DataType");
        this.putColumnJavaNameMap("TableName");
        this.putColumnJavaNameMap("ParticipantName");
        this.putColumnJavaNameMap("ParticipantType");
        this.putColumnJavaNameMap("Btid");
        this.putColumnJavaNameMap("PathName");
        this.putColumnJavaNameMap("RealPathName");
        this.putColumnJavaNameMap("PathType");
        this.putColumnJavaNameMap("Action");
        this.putColumnJavaNameMap("InsertDate");
        this.putColumnJavaNameMap("AutoRunTime");
        this.putColumnJavaNameMap("ProcessDate");
        this.putColumnJavaNameMap("AbortDate");
        this.putColumnJavaNameMap("VersionNo");
        this.putColumnJavaNameMap("DeleteDate");
        this.putColumnJavaNameMap("CreateBtid");
    }

    protected Map<String, Object> getBuriDefinitionMap() {
        if (this.buriDefinitionMap == null) {
            this.buriDefinitionMap = this.mapProp("torque.buriDefinitionMap", DEFAULT_EMPTY_MAP);
        }
        return this.buriDefinitionMap;
    }

    public boolean isUseBuri() {
        return this.hasBuriDefinitionMap();
    }

    protected boolean hasBuriDefinitionMap() {
        return !this.getBuriDefinitionMap().isEmpty();
    }

    public boolean isTargetTable(String tableName) {
        if (!this.isUseBuri()) {
            return false;
        }
        return this.getTargetProcessMap().containsKey(tableName);
    }

    public boolean isBuriAllRoundStateHistory(String tableName) {
        return VIEW_ALL_ROUND_STATE_HISTORY.equalsIgnoreCase(tableName);
    }

    public Map<String, Map<String, Map<String, List<String>>>> getActivityDefinitionMap() {
        if (this._activityDefinitionMap == null) {
            this._activityDefinitionMap = new LinkedHashMap<String, Map<String, Map<String, List<String>>>>();
            Map<String, Object> activityDefinitionMap = this.getBuriPropertyAsMap("activityDefinitionMap");
            if (activityDefinitionMap != null) {
                Set<String> packageNameSet = activityDefinitionMap.keySet();
                for (String packageName : packageNameSet) {
                    Object packageValue = activityDefinitionMap.get(packageName);
                    this.assertPackageValueIsMap(packageValue);
                    Map processMap = (Map)packageValue;
                    LinkedHashMap processResultMap = this.newLinkedHashMap();
                    Set processNameSet = processMap.keySet();
                    for (String processName : processNameSet) {
                        Object processValue = processMap.get(processName);
                        this.assertProcessValueIsMap(processValue);
                        Map activityMap = (Map)processValue;
                        processResultMap.put(processName, activityMap);
                    }
                    this._activityDefinitionMap.put(packageName, processResultMap);
                }
            }
        }
        return this._activityDefinitionMap;
    }

    protected void assertPackageValueIsMap(Object packageValue) {
        if (!(packageValue instanceof Map)) {
            String msg = "The type of package value should be Map: " + packageValue;
            throw new IllegalStateException(msg);
        }
    }

    protected void assertProcessValueIsMap(Object processValue) {
        if (!(processValue instanceof Map)) {
            String msg = "The type of process value should be Map: " + processValue;
            throw new IllegalStateException(msg);
        }
    }

    public Map<String, Map<String, List<String>>> getProcessMap(String packageName) {
        HashMap map = this.getActivityDefinitionMap().get(packageName);
        return map != null ? map : new HashMap();
    }

    public List<String> getPackageProcessPathList() {
        ArrayList<String> packageProcessPathList = new ArrayList<String>();
        Map<String, Map<String, Map<String, List<String>>>> activityDefinitionMap = this.getActivityDefinitionMap();
        Set<String> packageNameSet = activityDefinitionMap.keySet();
        for (String packageName : packageNameSet) {
            Map<String, Map<String, List<String>>> processMap = activityDefinitionMap.get(packageName);
            Set<String> processName = processMap.keySet();
            packageProcessPathList.add(packageName + "." + processName);
        }
        return packageProcessPathList;
    }

    public List<String> getStatusList(String packageName, String processName) {
        Map<String, Map<String, List<String>>> processMap = this.getProcessMap(packageName);
        if (processMap == null) {
            return new ArrayList<String>();
        }
        Map<String, List<String>> map = processMap.get(processName);
        ArrayList statusList = map.get("status");
        return statusList != null ? statusList : new ArrayList();
    }

    public List<String> getActionList(String packageName, String processName) {
        Map<String, Map<String, List<String>>> processMap = this.getProcessMap(packageName);
        if (processMap == null) {
            return new ArrayList<String>();
        }
        Map<String, List<String>> map = processMap.get(processName);
        ArrayList actionList = map.get("action");
        return actionList != null ? actionList : new ArrayList();
    }

    protected Map<String, List<String>> getTargetProcessMap() {
        if (this._tableProcessMap == null) {
            this._tableProcessMap = StringKeyMap.createAsFlexible();
            Map<String, Object> buriPropertyAsMap = this.getBuriPropertyAsMap("tableProcessMap");
            if (buriPropertyAsMap != null) {
                Set<String> tableNameSet = buriPropertyAsMap.keySet();
                for (String tableName : tableNameSet) {
                    Object processMappingValue = buriPropertyAsMap.get(tableName);
                    if (processMappingValue == null) continue;
                    this.assertProcessMappingValueIsList(processMappingValue);
                    List processList = (List)processMappingValue;
                    this._tableProcessMap.put(tableName, processList);
                }
            }
        }
        return this._tableProcessMap;
    }

    public List<String> getTableProcessForMethodNameList(String tableName) {
        List<String> processList = this.getTargetProcessMap().get(tableName);
        if (processList == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> resultList = new ArrayList<String>();
        for (String process : processList) {
            resultList.add(DfStringUtil.replace((String)process, (String)".", (String)"_"));
        }
        return resultList;
    }

    protected void assertProcessMappingValueIsList(Object processMappingValue) {
        if (!(processMappingValue instanceof List)) {
            String msg = "The type of process mapping value should be List: " + processMappingValue;
            throw new IllegalStateException(msg);
        }
    }

    protected void putTableJavaNameMap(String tableName) {
        this._tableJavaNameCaseInsensitiveMap.put(tableName, tableName);
    }

    public boolean isBuriInternalTable(String javaName) {
        if (javaName == null || javaName.trim().length() == 0) {
            return false;
        }
        return this.arrangeBuriTableJavaName(javaName) != null;
    }

    public String arrangeBuriTableJavaName(String javaName) {
        if (javaName == null || javaName.trim().length() == 0) {
            return null;
        }
        String key = javaName.trim().toLowerCase();
        return this._tableJavaNameCaseInsensitiveMap.get(key);
    }

    protected void putColumnJavaNameMap(String columnName) {
        this._columnJavaNameCaseInsensitiveMap.put(columnName, columnName);
    }

    public String arrangeBuriColumnJavaName(String javaName) {
        if (javaName == null || javaName.trim().length() == 0) {
            return null;
        }
        String key = javaName.trim().toLowerCase();
        return this._columnJavaNameCaseInsensitiveMap.get(key);
    }

    public void setupImplicitAdditionalForeignKey(DfTableFinder finder) {
        if (!this.isUseBuri()) {
            return;
        }
        _log.info((Object)"/===========================================");
        _log.info((Object)"...Setting up implicit foreign key for Buri.");
        DfAdditionalForeignKeyProperties fkprop = this.getAdditionalForeignKeyProperties();
        Map<String, Map<String, String>> fkMap = fkprop.getAdditionalForeignKeyMap();
        String entityPackage = this.getBasicProperties().getExtendedEntityPackage();
        Map<String, List<String>> targetProcessMap = this.getTargetProcessMap();
        Set<String> tableNameSet = targetProcessMap.keySet();
        for (String current : tableNameSet) {
            List<String> relatedProcessList = targetProcessMap.get(current);
            String tableName = current.toUpperCase();
            int id = 1;
            for (String process : relatedProcessList) {
                boolean statMade = this.createStateViewFk(fkMap, finder, tableName, entityPackage, process, id);
                boolean histMade = this.createStateHistoryViewFK(fkMap, finder, tableName, entityPackage, process, id);
                if (!statMade && !histMade) continue;
                ++id;
            }
        }
        _log.info((Object)"==========/");
    }

    protected boolean createStateViewFk(Map<String, Map<String, String>> fkMap, DfTableFinder finder, String tableName, String entityPackage, String relatedProcess, int identity) {
        String viewName = VIEW_ALL_ROUND_STATE;
        String foreignName = "FK_" + tableName + "_" + VIEW_ALL_ROUND_STATE + "_" + identity;
        if (fkMap.containsKey(foreignName)) {
            return false;
        }
        LinkedHashMap elementMap = this.newLinkedHashMap();
        Table table = finder.findTable(tableName);
        if (table == null) {
            String msg = "The table was not found: " + tableName;
            throw new IllegalStateException(msg);
        }
        if (table.hasTwoOrMorePrimaryKeys()) {
            String msg = "The table should have the only one primary key: " + tableName;
            throw new IllegalStateException(msg);
        }
        elementMap.put("localTableName", tableName);
        elementMap.put("foreignTableName", VIEW_ALL_ROUND_STATE);
        String primaryKeyName = table.getPrimaryKeyAsOne().getName();
        elementMap.put("localColumnName", primaryKeyName);
        elementMap.put("foreignColumnName", "INTERNAL_PK_VALUE");
        String entityName = table.getExtendedEntityClassName();
        String fqcn = entityPackage + "." + entityName;
        StringBuilder sb = new StringBuilder();
        sb.append("$$foreignAlias$$.STATUS_PATH_NAME like '").append(relatedProcess).append(".%'");
        sb.append(" and $$foreignAlias$$.INTERNAL_DATA_TYPE = '").append(fqcn).append("'");
        elementMap.put("fixedCondition", sb.toString());
        String processExpression = DfStringUtil.replace((String)relatedProcess, (String)".", (String)"_");
        elementMap.put("fixedSuffix", "_" + processExpression);
        fkMap.put(foreignName, elementMap);
        _log.info((Object)foreignName);
        return true;
    }

    protected boolean createStateHistoryViewFK(Map<String, Map<String, String>> fkMap, DfTableFinder finder, String tableName, String entityPackage, String relatedProcess, int identity) {
        if (!this.hasBuriAllRoundStateHistory(finder)) {
            return false;
        }
        String viewName = VIEW_ALL_ROUND_STATE_HISTORY;
        String foreignName = "FK_BURI_ALL_ROUND_STATE_HISTORY_" + tableName + "_" + identity;
        if (fkMap.containsKey(foreignName)) {
            return false;
        }
        LinkedHashMap elementMap = this.newLinkedHashMap();
        Table table = finder.findTable(tableName);
        if (table == null) {
            String msg = "The table was not found: " + tableName;
            throw new IllegalStateException(msg);
        }
        if (table.hasTwoOrMorePrimaryKeys()) {
            String msg = "The table should have the only one primary key: " + tableName;
            throw new IllegalStateException(msg);
        }
        elementMap.put("localTableName", VIEW_ALL_ROUND_STATE_HISTORY);
        elementMap.put("foreignTableName", tableName);
        String primaryKeyName = table.getPrimaryKeyAsOne().getName();
        elementMap.put("localColumnName", "INTERNAL_PK_VALUE");
        elementMap.put("foreignColumnName", primaryKeyName);
        String entityName = table.getExtendedEntityClassName();
        String fqcn = entityPackage + "." + entityName;
        StringBuilder sb = new StringBuilder();
        sb.append("$$localAlias$$.INTERNAL_DATA_TYPE = '").append(fqcn).append("'");
        elementMap.put("fixedCondition", sb.toString());
        String processExpression = DfStringUtil.replace((String)relatedProcess, (String)".", (String)"_");
        elementMap.put("fixedSuffix", "_" + processExpression);
        fkMap.put(foreignName, elementMap);
        _log.info((Object)foreignName);
        return true;
    }

    public boolean hasBuriAllRoundStateHistory(DfTableFinder finder) {
        String viewName = VIEW_ALL_ROUND_STATE_HISTORY;
        return finder.findTable(VIEW_ALL_ROUND_STATE_HISTORY) != null;
    }

    protected String getBuriPropertyRequired(String key) {
        String value = this.getBuriProperty(key);
        if (value == null || value.trim().length() == 0) {
            String msg = "The property '" + key + "' should not be null or empty:";
            msg = msg + " buriDefinitionMap=" + this.getBuriDefinitionMap();
            throw new IllegalStateException(msg);
        }
        return value;
    }

    protected String getBuriPropertyIfNullEmpty(String key) {
        String value = this.getBuriProperty(key);
        if (value == null) {
            return "";
        }
        return value;
    }

    protected String getBuriProperty(String key) {
        String value = (String)this.getBuriDefinitionMap().get(key);
        return value;
    }

    protected boolean isBuriProperty(String key) {
        String value = (String)this.getBuriDefinitionMap().get(key);
        return value != null && value.trim().equalsIgnoreCase("true");
    }

    protected Map<String, Object> getBuriPropertyAsMap(String key) {
        return (Map)this.getBuriDefinitionMap().get(key);
    }

    protected List<String> getBuriPropertyAsList(String key) {
        return (List)this.getBuriDefinitionMap().get(key);
    }
}

