/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.pmb;

import java.util.List;
import java.util.Map;
import org.seasar.dbflute.logic.pmb.PmbMetaDataPropertyOptionFinder;
import org.seasar.dbflute.properties.DfClassificationProperties;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PmbMetaDataPropertyOptionClassification {
    protected static final String OPTION_PREFIX = "cls(";
    protected static final String OPTION_SUFFIX = ")";
    protected String _className;
    protected String _propertyName;
    protected DfClassificationProperties _classificationProperties;
    protected PmbMetaDataPropertyOptionFinder _pmbMetaDataPropertyOptionFinder;

    public PmbMetaDataPropertyOptionClassification(String className, String propertyName, DfClassificationProperties classificationProperties, PmbMetaDataPropertyOptionFinder pmbMetaDataPropertyOptionFinder) {
        this._className = className;
        this._propertyName = propertyName;
        this._classificationProperties = classificationProperties;
        this._pmbMetaDataPropertyOptionFinder = pmbMetaDataPropertyOptionFinder;
    }

    public boolean isPmbMetaDataPropertyOptionClassification() {
        return this.extractClassificationNameFromOption(this._className, this._propertyName, false) != null;
    }

    public String getPmbMetaDataPropertyOptionClassificationName() {
        return this.extractClassificationNameFromOption(this._className, this._propertyName, true);
    }

    public List<Map<String, String>> getPmbMetaDataPropertyOptionClassificationMapList() {
        String classificationName = this.extractClassificationNameFromOption(this._className, this._propertyName, true);
        List<Map<String, String>> classificationMapList = this._classificationProperties.getClassificationMapList(classificationName);
        if (classificationMapList == null) {
            String msg = "Look the message below:" + this.ln();
            msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * " + this.ln();
            msg = msg + "The classification was not found:" + this.ln();
            msg = msg + " " + this._className + " " + this._propertyName;
            msg = msg + ":" + OPTION_PREFIX + classificationName + OPTION_SUFFIX + this.ln();
            msg = msg + "* * * * * * * * * */";
            throw new IllegalStateException(msg);
        }
        return classificationMapList;
    }

    protected String extractClassificationNameFromOption(String className, String propertyName, boolean check) {
        String pmbMetaDataPropertyOption = this.getPmbMetaDataPropertyOption();
        if (pmbMetaDataPropertyOption == null) {
            if (check) {
                String msg = "The property name didn't have its option:";
                msg = msg + " " + className + "." + propertyName;
                throw new IllegalStateException(msg);
            }
            return null;
        }
        String option = pmbMetaDataPropertyOption.trim();
        if (option.trim().length() == 0) {
            if (check) {
                String msg = "The option of the property name should not be empty:";
                msg = msg + " property=" + className + "." + propertyName;
                throw new IllegalStateException(msg);
            }
            return null;
        }
        List<String> splitOption = this.splitOption(option);
        String firstOption = null;
        for (String element : splitOption) {
            if (!(element = element.trim()).startsWith(OPTION_PREFIX) || !element.endsWith(OPTION_SUFFIX)) continue;
            firstOption = element;
            break;
        }
        if (firstOption == null) {
            if (check) {
                String msg = "The option of class name and the property name should be 'cls(xxx)':";
                msg = msg + " property=" + className + "." + propertyName + ":" + option;
                throw new IllegalStateException(msg);
            }
            return null;
        }
        option = firstOption;
        int clsIdx = OPTION_PREFIX.length();
        int clsEndIdx = option.length() - OPTION_SUFFIX.length();
        try {
            return option.substring(clsIdx, clsEndIdx);
        }
        catch (StringIndexOutOfBoundsException e) {
            String msg = "Look the message below:" + this.ln();
            msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * " + this.ln();
            msg = msg + "IndexOutOfBounds ocurred:" + this.ln();
            msg = msg + " " + this._className + " " + this._propertyName;
            msg = msg + ":" + option + this.ln();
            msg = msg + "{" + option + "}.substring(" + clsIdx + ", " + clsEndIdx + OPTION_SUFFIX + this.ln();
            msg = msg + "* * * * * * * * * */";
            throw new IllegalStateException(msg, e);
        }
    }

    protected String getPmbMetaDataPropertyOption() {
        return this._pmbMetaDataPropertyOptionFinder.findPmbMetaDataPropertyOption(this._className, this._propertyName);
    }

    protected List<String> splitOption(String option) {
        return PmbMetaDataPropertyOptionFinder.splitOption(option);
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }
}

