/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.pmb;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.torque.engine.database.model.AppData;
import org.apache.torque.engine.database.model.Column;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.helper.language.DfLanguageDependencyInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureColumnMetaInfo;
import org.seasar.dbflute.logic.pmb.DfParameterBeanMetaData;
import org.seasar.dbflute.logic.pmb.PmbMetaDataPropertyOptionClassification;
import org.seasar.dbflute.logic.pmb.PmbMetaDataPropertyOptionFinder;
import org.seasar.dbflute.logic.pmb.PmbMetaDataPropertyOptionReference;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfClassificationProperties;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfParameterBeanBasicHandler {
    protected Map<String, DfParameterBeanMetaData> _pmbMetaDataMap;
    protected DfBasicProperties _basicProperties;
    protected DfClassificationProperties _classificationProperties;

    public DfParameterBeanBasicHandler(Map<String, DfParameterBeanMetaData> pmbMetaDataMap, DfBasicProperties basicProperties, DfClassificationProperties classificationProperties) {
        this._pmbMetaDataMap = pmbMetaDataMap;
        this._basicProperties = basicProperties;
        this._classificationProperties = classificationProperties;
    }

    public boolean isExistPmbMetaData() {
        return this._pmbMetaDataMap != null && !this._pmbMetaDataMap.isEmpty();
    }

    public Collection<DfParameterBeanMetaData> getPmbMetaDataList() {
        if (this._pmbMetaDataMap == null || this._pmbMetaDataMap.isEmpty()) {
            String msg = "The pmbMetaDataMap should not be null or empty.";
            throw new IllegalStateException(msg);
        }
        return this._pmbMetaDataMap.values();
    }

    public String getPmbMetaDataSuperClassDefinition(String className) {
        this.assertArgumentPmbMetaDataClassName(className);
        DfParameterBeanMetaData metaData = this.findPmbMetaData(className);
        String superClassName = metaData.getSuperClassName();
        if (superClassName == null || superClassName.trim().length() == 0) {
            return "";
        }
        if (DfBuildProperties.getInstance().isVersionJavaOverNinety() && superClassName.contains("SimplePagingBean")) {
            superClassName = "org.seasar.dbflute.cbean.SimplePagingBean";
        }
        DfLanguageDependencyInfo languageDependencyInfo = this._basicProperties.getLanguageDependencyInfo();
        return " " + languageDependencyInfo.getGrammarInfo().getExtendsStringMark() + " " + superClassName;
    }

    public boolean hasPmbMetaDataSafetyResultDefitinion(String className) {
        if (this.isPmbMetaDataForProcedure(className)) {
            return false;
        }
        String classDefinition = this.getPmbMetaDataSuperClassDefinition(className);
        return classDefinition == null || classDefinition.trim().length() == 0;
    }

    public Map<String, String> getPmbMetaDataPropertyNameTypeMap(String className) {
        this.assertArgumentPmbMetaDataClassName(className);
        DfParameterBeanMetaData metaData = this.findPmbMetaData(className);
        return metaData.getPropertyNameTypeMap();
    }

    public Map<String, String> getPmbMetaDataPropertyNameColumnNameMap(String className) {
        this.assertArgumentPmbMetaDataClassName(className);
        DfParameterBeanMetaData metaData = this.findPmbMetaData(className);
        return metaData.getPropertyNameColumnNameMap();
    }

    public Map<String, String> getPmbMetaDataPropertyNameOptionMap(String className) {
        this.assertArgumentPmbMetaDataClassName(className);
        DfParameterBeanMetaData metaData = this.findPmbMetaData(className);
        return metaData.getPropertyNameOptionMap();
    }

    private DfParameterBeanMetaData findPmbMetaData(String className) {
        if (this._pmbMetaDataMap == null || this._pmbMetaDataMap.isEmpty()) {
            String msg = "The pmbMetaDataMap should not be null or empty: className=" + className;
            throw new IllegalStateException(msg);
        }
        DfParameterBeanMetaData metaData = this._pmbMetaDataMap.get(className);
        if (metaData == null) {
            String msg = "The className has no meta data: className=" + className;
            throw new IllegalStateException(msg);
        }
        return metaData;
    }

    public Set<String> getPmbMetaDataPropertySet(String className) {
        this.assertArgumentPmbMetaDataClassName(className);
        return this.getPmbMetaDataPropertyNameTypeMap(className).keySet();
    }

    public String getPmbMetaDataPropertyType(String className, String propertyName) {
        this.assertArgumentPmbMetaDataClassName(className);
        this.assertArgumentPmbMetaDataPropertyName(propertyName);
        return this.getPmbMetaDataPropertyNameTypeMap(className).get(propertyName);
    }

    public String getPmbMetaDataPropertyColumnName(String className, String propertyName) {
        this.assertArgumentPmbMetaDataClassName(className);
        this.assertArgumentPmbMetaDataPropertyName(propertyName);
        return this.getPmbMetaDataPropertyNameColumnNameMap(className).get(propertyName);
    }

    public boolean isPmbMetaDataForProcedure(String className) {
        return this.findPmbMetaData(className).getProcedureName() != null;
    }

    public String getPmbMetaDataProcedureName(String className) {
        return this.findPmbMetaData(className).getProcedureName();
    }

    public boolean isPmbMetaDataPropertyOptionProcedureParameterIn(String className, String propertyName) {
        String option = this.findPmbMetaDataPropertyOption(className, propertyName);
        return option != null && option.trim().equalsIgnoreCase(DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnIn.toString());
    }

    public boolean isPmbMetaDataPropertyOptionProcedureParameterOut(String className, String propertyName) {
        String option = this.findPmbMetaDataPropertyOption(className, propertyName);
        return option != null && option.trim().equalsIgnoreCase(DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnOut.toString());
    }

    public boolean isPmbMetaDataPropertyOptionProcedureParameterInOut(String className, String propertyName) {
        String option = this.findPmbMetaDataPropertyOption(className, propertyName);
        return option != null && option.trim().equalsIgnoreCase(DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnInOut.toString());
    }

    public boolean isPmbMetaDataPropertyOptionProcedureParameterReturn(String className, String propertyName) {
        String option = this.findPmbMetaDataPropertyOption(className, propertyName);
        return option != null && option.trim().equalsIgnoreCase(DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnReturn.toString());
    }

    public boolean hasPmbMetaDataPropertyOptionOriginalOnlyOneSetter(String className, String propertyName) {
        return this.hasPmbMetaDataPropertyOptionAnyLikeSearch(className, propertyName) || this.hasPmbMetaDataPropertyOptionAnyFromTo(className, propertyName);
    }

    public boolean hasPmbMetaDataPropertyOptionAnyLikeSearch(String className) {
        DfParameterBeanMetaData metaData = this._pmbMetaDataMap.get(className);
        if (metaData == null) {
            return false;
        }
        Set<String> propertyNameSet = metaData.getPropertyNameTypeMap().keySet();
        for (String propertyName : propertyNameSet) {
            if (!this.hasPmbMetaDataPropertyOptionAnyLikeSearch(className, propertyName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPmbMetaDataPropertyOptionAnyLikeSearch(String className, String propertyName) {
        return this.isPmbMetaDataPropertyOptionLikeSearch(className, propertyName) || this.isPmbMetaDataPropertyOptionPrefixSearch(className, propertyName) || this.isPmbMetaDataPropertyOptionContainSearch(className, propertyName) || this.isPmbMetaDataPropertyOptionSuffixSearch(className, propertyName);
    }

    public boolean isPmbMetaDataPropertyOptionLikeSearch(String className, String propertyName) {
        return this.isPmbMetaDataPropertyOption(className, propertyName, "like");
    }

    public boolean isPmbMetaDataPropertyOptionPrefixSearch(String className, String propertyName) {
        return this.isPmbMetaDataPropertyOption(className, propertyName, "likePrefix");
    }

    public boolean isPmbMetaDataPropertyOptionContainSearch(String className, String propertyName) {
        return this.isPmbMetaDataPropertyOption(className, propertyName, "likeContain");
    }

    public boolean isPmbMetaDataPropertyOptionSuffixSearch(String className, String propertyName) {
        return this.isPmbMetaDataPropertyOption(className, propertyName, "likeSuffix");
    }

    public boolean hasPmbMetaDataPropertyOptionAnyFromTo(String className) {
        DfParameterBeanMetaData metaData = this._pmbMetaDataMap.get(className);
        if (metaData == null) {
            return false;
        }
        Set<String> propertyNameSet = metaData.getPropertyNameTypeMap().keySet();
        for (String propertyName : propertyNameSet) {
            if (!this.hasPmbMetaDataPropertyOptionAnyFromTo(className, propertyName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPmbMetaDataPropertyOptionAnyFromTo(String className, String propertyName) {
        return this.isPmbMetaDataPropertyOptionFromDate(className, propertyName) || this.isPmbMetaDataPropertyOptionToDate(className, propertyName);
    }

    public boolean isPmbMetaDataPropertyOptionFromDate(String className, String propertyName) {
        return this.isPmbMetaDataPropertyOption(className, propertyName, "fromDate");
    }

    public boolean isPmbMetaDataPropertyOptionToDate(String className, String propertyName) {
        return this.isPmbMetaDataPropertyOption(className, propertyName, "toDate");
    }

    public boolean isPmbMetaDataPropertyOptionClassification(String className, String propertyName) {
        PmbMetaDataPropertyOptionClassification obj = this.createPmbMetaDataPropertyOptionClassification(className, propertyName);
        return obj.isPmbMetaDataPropertyOptionClassification();
    }

    public String getPmbMetaDataPropertyOptionClassificationName(String className, String propertyName) {
        PmbMetaDataPropertyOptionClassification obj = this.createPmbMetaDataPropertyOptionClassification(className, propertyName);
        return obj.getPmbMetaDataPropertyOptionClassificationName();
    }

    public List<Map<String, String>> getPmbMetaDataPropertyOptionClassificationMapList(String className, String propertyName) {
        PmbMetaDataPropertyOptionClassification obj = this.createPmbMetaDataPropertyOptionClassification(className, propertyName);
        return obj.getPmbMetaDataPropertyOptionClassificationMapList();
    }

    public boolean hasPmbMetaDataPropertyOptionReference(String className) {
        DfParameterBeanMetaData metaData = this._pmbMetaDataMap.get(className);
        if (metaData == null) {
            return false;
        }
        Set<String> propertyNameSet = metaData.getPropertyNameTypeMap().keySet();
        for (String propertyName : propertyNameSet) {
            if (!this.hasPmbMetaDataPropertyOptionAnyFromTo(className, propertyName)) continue;
            return true;
        }
        return false;
    }

    public String getPmbMetaDataPropertyRefName(String className, String propertyName, AppData appData) {
        Column column = this.getPmbMetaDataPropertyOptionReferenceColumn(className, propertyName, appData);
        return column != null ? column.getName() : "";
    }

    public String getPmbMetaDataPropertyRefAlias(String className, String propertyName, AppData appData) {
        Column column = this.getPmbMetaDataPropertyOptionReferenceColumn(className, propertyName, appData);
        return column != null ? column.getAliasExpression() : "";
    }

    public String getPmbMetaDataPropertyRefLineDisp(String className, String propertyName, AppData appData) {
        Column column = this.getPmbMetaDataPropertyOptionReferenceColumn(className, propertyName, appData);
        return column != null ? "{" + column.getColumnDefinitionLineDisp() + "}" : "";
    }

    public boolean isPmbMetaDataPropertyRefColumnChar(String className, String propertyName, AppData appData) {
        Column column = this.getPmbMetaDataPropertyOptionReferenceColumn(className, propertyName, appData);
        return column != null ? column.isJdbcTypeChar() : false;
    }

    public String getPmbMetaDataPropertyRefDbType(String className, String propertyName, AppData appData) {
        Column column = this.getPmbMetaDataPropertyOptionReferenceColumn(className, propertyName, appData);
        return column != null ? column.getDbType() : "";
    }

    public String getPmbMetaDataPropertyRefSize(String className, String propertyName, AppData appData) {
        Column column = this.getPmbMetaDataPropertyOptionReferenceColumn(className, propertyName, appData);
        return column != null ? column.getColumnSizeSettingExpression() : "";
    }

    protected Column getPmbMetaDataPropertyOptionReferenceColumn(String className, String propertyName, AppData appData) {
        PmbMetaDataPropertyOptionReference reference = this.createPmbMetaDataPropertyOptionReference(className, propertyName);
        return reference.getPmbMetaDataPropertyOptionReferenceColumn(appData);
    }

    protected boolean isPmbMetaDataPropertyOption(String className, String propertyName, String option) {
        String specified = this.findPmbMetaDataPropertyOption(className, propertyName);
        if (specified == null) {
            return false;
        }
        List<String> splitList = this.splitOption(specified);
        for (String element : splitList) {
            if (!element.trim().equalsIgnoreCase(option)) continue;
            return true;
        }
        return false;
    }

    protected List<String> splitOption(String option) {
        return PmbMetaDataPropertyOptionFinder.splitOption(option);
    }

    protected PmbMetaDataPropertyOptionClassification createPmbMetaDataPropertyOptionClassification(String className, String propertyName) {
        PmbMetaDataPropertyOptionFinder finder = this.createPmbMetaDataPropertyOptionFinder(className, propertyName);
        return new PmbMetaDataPropertyOptionClassification(className, propertyName, this._classificationProperties, finder);
    }

    protected PmbMetaDataPropertyOptionReference createPmbMetaDataPropertyOptionReference(String className, String propertyName) {
        PmbMetaDataPropertyOptionFinder finder = this.createPmbMetaDataPropertyOptionFinder(className, propertyName);
        return new PmbMetaDataPropertyOptionReference(className, propertyName, finder);
    }

    protected String findPmbMetaDataPropertyOption(String className, String propertyName) {
        PmbMetaDataPropertyOptionFinder finder = this.createPmbMetaDataPropertyOptionFinder(className, propertyName);
        return finder.findPmbMetaDataPropertyOption(className, propertyName);
    }

    protected PmbMetaDataPropertyOptionFinder createPmbMetaDataPropertyOptionFinder(String className, String propertyName) {
        return new PmbMetaDataPropertyOptionFinder(className, propertyName, this._pmbMetaDataMap);
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    protected void assertArgumentPmbMetaDataClassName(String className) {
        if (className == null || className.trim().length() == 0) {
            String msg = "The className should not be null or empty: [" + className + "]";
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertArgumentPmbMetaDataPropertyName(String propertyName) {
        if (propertyName == null || propertyName.trim().length() == 0) {
            String msg = "The propertyName should not be null or empty: [" + propertyName + "]";
            throw new IllegalArgumentException(msg);
        }
    }
}

