/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.pkgresolver;

import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.util.DfStringUtil;

public class DfStandardApiPackageResolver {
    protected DfBasicProperties _basicProperties;

    public DfStandardApiPackageResolver(DfBasicProperties basicProperties) {
        this._basicProperties = basicProperties;
    }

    public String resolvePackageName(String typeName) {
        if (typeName == null) {
            return typeName;
        }
        DfBasicProperties prop = this._basicProperties;
        if (prop.isTargetLanguageJava()) {
            if (typeName.startsWith("List<") && typeName.endsWith(">")) {
                return "java.util." + typeName;
            }
            if (typeName.startsWith("Map<") && typeName.endsWith(">")) {
                return "java.util." + typeName;
            }
            if (typeName.equals("BigDecimal")) {
                return "java.math." + typeName;
            }
            if (typeName.equals("Time")) {
                return "java.sql." + typeName;
            }
            if (typeName.equals("Timestamp")) {
                return "java.sql." + typeName;
            }
            if (typeName.equals("Date")) {
                return "java.util." + typeName;
            }
        } else if (prop.isTargetLanguageCSharp() && typeName.startsWith("IList<") && typeName.endsWith(">")) {
            return "System.Collections.Generic." + typeName;
        }
        if (typeName.startsWith("$$CDef$$")) {
            String pkg = prop.getBaseCommonPackage();
            String prefix = prop.getProjectPrefix();
            typeName = DfStringUtil.replace((String)typeName, (String)"$$CDef$$", (String)(pkg + "." + prefix + "CDef"));
            return typeName;
        }
        return typeName;
    }
}

