/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.outsidesql;

import java.util.List;
import org.seasar.dbflute.exception.DfCustomizeEntityMarkInvalidException;
import org.seasar.dbflute.exception.DfParameterBeanMarkInvalidException;
import org.seasar.dbflute.exception.DfRequiredOutsideSqlDescriptionNotFoundException;
import org.seasar.dbflute.exception.DfRequiredOutsideSqlTitleNotFoundException;
import org.seasar.dbflute.logic.outsidesql.DfOutsideSqlMarkAnalyzer;
import org.seasar.dbflute.twowaysql.SqlAnalyzer;
import org.seasar.dbflute.twowaysql.node.IfCommentEvaluator;
import org.seasar.dbflute.twowaysql.node.ParameterFinder;
import org.seasar.dbflute.util.DfStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfOutsideSqlChecker {
    protected boolean _ifCommentExpressionCheck;
    protected boolean _requiredTitleCheck;
    protected boolean _requiredDescriptionCheck;

    public void check(String fileName, String sql) {
        List<String> splitList = this.splitList(sql, "\n");
        this.checkSql2EntityMark(splitList, fileName, sql);
        SqlAnalyzer analyzer = new SqlAnalyzer(sql, false);
        List ifCommentList = analyzer.researchIfComment();
        analyzer.analyze();
        this.checkIfCommentExpression(ifCommentList, sql);
        this.checkRequiredTitle(fileName, sql);
        this.checkRequiredDescription(fileName, sql);
    }

    protected void checkSql2EntityMark(List<String> splitList, String fileName, String sql) {
        for (String line : splitList) {
            if (!(line = line.trim()).contains("--")) continue;
            if (line.contains("#df;entity#") || line.contains("#df:pmb#") || line.contains("#df:emtity#")) {
                this.throwCustomizeEntityMarkInvalidException(line, fileName, sql);
                continue;
            }
            if (!line.contains("!df;pmb!") && !line.contains("!df:entity!") && !line.contains("!df:pnb!")) continue;
            this.throwParameterBeanMarkInvalidException(line, fileName, sql);
        }
    }

    protected void checkIfCommentExpression(List<String> ifCommentList, String sql) {
        if (!this._ifCommentExpressionCheck) {
            return;
        }
        for (String expr : ifCommentList) {
            IfCommentEvaluator evaluator = new IfCommentEvaluator(new ParameterFinder(){

                public Object find(String name) {
                    return null;
                }
            }, expr, sql);
            evaluator.assertExpression();
        }
    }

    protected void throwCustomizeEntityMarkInvalidException(String line, String fileName, String sql) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The customize entity mark was invalid!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm your mark." + this.ln();
        msg = msg + "  For example:" + this.ln();
        msg = msg + "    (x) - -- #df;entity#  *NOT semicolon" + this.ln();
        msg = msg + "    (x) - -- #df:pmb#     *NOT parameter bean" + this.ln();
        msg = msg + "    (x) - -- #df;emtity#  *NOT emtity ('entity' is right)" + this.ln();
        msg = msg + "    (o) - -- #df:entity#" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Customize Entity Mark]" + this.ln() + line + this.ln();
        msg = msg + this.ln();
        msg = msg + "[File]" + this.ln() + fileName + this.ln();
        msg = msg + this.ln();
        msg = msg + "[SQL]" + this.ln() + sql + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new DfCustomizeEntityMarkInvalidException(msg);
    }

    protected void throwParameterBeanMarkInvalidException(String line, String fileName, String sql) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The parameter bean mark was invalid!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm your mark." + this.ln();
        msg = msg + "  For example:" + this.ln();
        msg = msg + "    (x) - -- !df;pmb!     *NOT semicolun" + this.ln();
        msg = msg + "    (x) - -- !df:entity!  *NOT customize entity" + this.ln();
        msg = msg + "    (x) - -- !df;pnb!     *NOT pnb ('pmb' is right)" + this.ln();
        msg = msg + "    (o) - -- !df:pmb!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Parameter Bean Mark]" + this.ln() + line + this.ln();
        msg = msg + this.ln();
        msg = msg + "[File]" + this.ln() + fileName + this.ln();
        msg = msg + this.ln();
        msg = msg + "[SQL]" + this.ln() + sql + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new DfParameterBeanMarkInvalidException(msg);
    }

    protected void checkRequiredTitle(String fileName, String sql) {
        if (!this._requiredTitleCheck) {
            return;
        }
        DfOutsideSqlMarkAnalyzer analyzer = new DfOutsideSqlMarkAnalyzer();
        String title = analyzer.getTitle(sql);
        if (DfStringUtil.isNullOrTrimmedEmpty((String)title)) {
            this.throwRequiredOutsideSqlTitleNotFoundException(fileName, sql);
        }
    }

    protected void throwRequiredOutsideSqlTitleNotFoundException(String fileName, String sql) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The outsideSql title was NOT found!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "A outsideSql title is required at this project." + this.ln();
        msg = msg + "(The property 'isRequiredSqlTitle' of outsideSqlDefinition is true)" + this.ln();
        msg = msg + "  For example: @OutsideSql" + this.ln();
        msg = msg + "    (o):" + this.ln();
        msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.ln();
        msg = msg + "    /*" + this.ln();
        msg = msg + "     [df:title]" + this.ln();
        msg = msg + "     Simple Member Select" + this.ln();
        msg = msg + "    */" + this.ln();
        msg = msg + "    - - - - - - - - - -/" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[File]" + this.ln() + fileName + this.ln();
        msg = msg + this.ln();
        msg = msg + "[SQL]" + this.ln() + sql + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new DfRequiredOutsideSqlTitleNotFoundException(msg);
    }

    protected void checkRequiredDescription(String fileName, String sql) {
        if (!this._requiredDescriptionCheck) {
            return;
        }
        DfOutsideSqlMarkAnalyzer analyzer = new DfOutsideSqlMarkAnalyzer();
        String description = analyzer.getDescription(sql);
        if (DfStringUtil.isNullOrTrimmedEmpty((String)description)) {
            this.throwRequiredOutsideSqlDescriptionNotFoundException(fileName, sql);
        }
    }

    protected void throwRequiredOutsideSqlDescriptionNotFoundException(String fileName, String sql) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The outsideSql description was NOT found!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "A outsideSql description is required at this project." + this.ln();
        msg = msg + "(The property 'isRequiredSqlDescription' of outsideSqlDefinition is true)" + this.ln();
        msg = msg + "  For example: @OutsideSql" + this.ln();
        msg = msg + "    (o):" + this.ln();
        msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.ln();
        msg = msg + "    /*" + this.ln();
        msg = msg + "     [df:description]" + this.ln();
        msg = msg + "     This SQL is ..." + this.ln();
        msg = msg + "     It uses 'union all' for performance ..." + this.ln();
        msg = msg + "    */" + this.ln();
        msg = msg + "    - - - - - - - - - -/" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[File]" + this.ln() + fileName + this.ln();
        msg = msg + this.ln();
        msg = msg + "[SQL]" + this.ln() + sql + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new DfRequiredOutsideSqlDescriptionNotFoundException(msg);
    }

    protected List<String> splitList(String str, String delimiter) {
        return DfStringUtil.splitList((String)str, (String)delimiter);
    }

    protected String ln() {
        return "\n";
    }

    public void enableIfCommentExpressionCheck() {
        this._ifCommentExpressionCheck = true;
    }

    public void enableRequiredTitleCheck() {
        this._requiredTitleCheck = true;
    }

    public void enableRequiredDescriptionCheck() {
        this._requiredDescriptionCheck = true;
    }
}

