/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.sequence;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.exception.SQLFailureException;
import org.seasar.dbflute.logic.jdbc.handler.DfUniqueKeyHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfPrimaryKeyMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.sequence.DfSequenceHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DfSequenceHandlerJdbc
implements DfSequenceHandler {
    private static final Log _log = LogFactory.getLog(DfSequenceHandlerJdbc.class);
    protected DataSource _dataSource;
    protected String _schema;
    protected List<String> _allSchemaList;

    public DfSequenceHandlerJdbc(DataSource dataSource, String schema, List<String> allSchemaList) {
        this._dataSource = dataSource;
        this._schema = schema;
        this._allSchemaList = allSchemaList;
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    @Override
    public void incrementSequenceToDataMax(Map<String, String> tableSequenceMap) {
        String tableName;
        LinkedHashMap<String, List<String>> skippedMap;
        block20: {
            SQLException ignored22;
            String sequenceName;
            Statement st;
            Connection conn;
            block19: {
                DfUniqueKeyHandler uniqueKeyHandler = new DfUniqueKeyHandler();
                skippedMap = new LinkedHashMap<String, List<String>>();
                _log.info((Object)"...Incrementing sequences to max value of table data");
                conn = null;
                st = null;
                sequenceName = null;
                conn = this._dataSource.getConnection();
                st = conn.createStatement();
                Set<Map.Entry<String, String>> entrySet = tableSequenceMap.entrySet();
                for (Map.Entry<String, String> entry : entrySet) {
                    Integer actualValue;
                    tableName = entry.getKey();
                    sequenceName = entry.getValue();
                    if (sequenceName == null || sequenceName.trim().length() == 0) {
                        String msg = "Not found the sequence name of the table:";
                        msg = msg + " tableName=" + tableName;
                        throw new IllegalStateException(msg);
                    }
                    DatabaseMetaData metaData = conn.getMetaData();
                    DfPrimaryKeyMetaInfo pkInfo = uniqueKeyHandler.getPrimaryKey(metaData, this._schema, tableName);
                    List<String> pkList = pkInfo.getPrimaryKeyList();
                    if (pkList.size() != 1) {
                        skippedMap.put(tableName, pkList);
                        continue;
                    }
                    String primaryKeyColumnName = pkList.get(0);
                    Integer count = this.selectCount(st, tableName);
                    if (count == null || count == 0 || (actualValue = this.selectDataMax(st, tableName, primaryKeyColumnName)) == null) continue;
                    this.callSequenceLoop(st, sequenceName, actualValue);
                }
                Object var18_22 = null;
                if (st == null) break block19;
                try {
                    st.close();
                }
                catch (SQLException ignored22) {
                    _log.info((Object)"Statement.close() threw the exception!", (Throwable)ignored22);
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ignored22) {
                    _log.info((Object)"Connection.close() threw the exception!", (Throwable)ignored22);
                }
            }
            break block20;
            {
                catch (SQLException e) {
                    String msg = "Look! Read the message below." + this.ln();
                    msg = msg + "/- - - - - - - - - - - - - - - - - - - - - - - - - - - -" + this.ln();
                    msg = msg + "Failed to increment sequences:" + this.ln();
                    msg = msg + this.ln();
                    msg = msg + "current = " + sequenceName + this.ln();
                    msg = msg + "tableSequenceMap:" + this.ln();
                    Set<Map.Entry<String, String>> entrySet = tableSequenceMap.entrySet();
                    for (Map.Entry<String, String> entry : entrySet) {
                        msg = msg + "  " + entry.getKey() + " = " + entry.getValue() + this.ln();
                    }
                    msg = msg + this.ln();
                    msg = msg + "SQLException = " + e.getMessage() + this.ln();
                    msg = msg + " - - - - - - - - - -/";
                    throw new SQLFailureException(msg, e);
                }
            }
            catch (Throwable throwable) {
                SQLException ignored22;
                Object var18_23 = null;
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException ignored22) {
                        _log.info((Object)"Statement.close() threw the exception!", (Throwable)ignored22);
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ignored22) {
                        _log.info((Object)"Connection.close() threw the exception!", (Throwable)ignored22);
                    }
                }
                throw throwable;
            }
        }
        if (!skippedMap.isEmpty()) {
            _log.info((Object)"*Unsupported incrementing sequences(multiple-PK):");
            Set skippedEntrySet = skippedMap.entrySet();
            for (Map.Entry<String, String> skippedEntry : skippedEntrySet) {
                tableName = skippedEntry.getKey();
                List pkList = (List)((Object)skippedEntry.getValue());
                _log.info((Object)("    " + tableName + ": pk=" + pkList));
            }
        }
    }

    protected void callSequenceLoop(Statement st, String sequenceName, Integer actualValue) throws SQLException {
        Integer sequenceValue;
        Integer startPoint = sequenceValue = this.selectNextVal(st, sequenceName);
        boolean decrementChecked = false;
        while (actualValue > sequenceValue) {
            sequenceValue = this.selectNextVal(st, sequenceName);
            if (decrementChecked) continue;
            if (startPoint >= sequenceValue) {
                String msg = "    " + sequenceName + ": " + startPoint + " to " + sequenceValue;
                msg = msg + " (unsupported for decrement)";
                _log.info((Object)msg);
                return;
            }
            decrementChecked = true;
        }
        _log.info((Object)("    " + sequenceName + ": " + startPoint + " to " + sequenceValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer selectCount(Statement statement, String tableName) throws SQLException {
        Integer n;
        block9: {
            ResultSet rs;
            block7: {
                Integer n2;
                block8: {
                    rs = null;
                    try {
                        rs = statement.executeQuery("select count(*) from " + tableName);
                        if (rs.next()) break block7;
                        n2 = null;
                        Object var6_6 = null;
                        if (rs == null) break block8;
                    }
                    catch (Throwable throwable) {
                        block10: {
                            Object var6_8 = null;
                            if (rs == null) break block10;
                            try {
                                rs.close();
                            }
                            catch (SQLException ignored) {
                                _log.info((Object)"ResultSet.close() threw the exception!", (Throwable)ignored);
                            }
                        }
                        throw throwable;
                    }
                    try {
                        rs.close();
                    }
                    catch (SQLException ignored) {
                        _log.info((Object)"ResultSet.close() threw the exception!", (Throwable)ignored);
                    }
                }
                return n2;
            }
            n = rs.getInt(1);
            Object var6_7 = null;
            if (rs == null) break block9;
            try {
                rs.close();
            }
            catch (SQLException ignored) {
                _log.info((Object)"ResultSet.close() threw the exception!", (Throwable)ignored);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer selectDataMax(Statement statement, String tableName, String primaryKeyColumnName) throws SQLException {
        Integer n;
        block15: {
            Integer actualValue;
            String value;
            ResultSet rs;
            block13: {
                Integer n2;
                block14: {
                    block11: {
                        Integer n3;
                        block12: {
                            String sql = "select max(" + primaryKeyColumnName + ") as MAX_VALUE from " + tableName;
                            rs = null;
                            try {
                                rs = statement.executeQuery(sql);
                                if (rs.next()) break block11;
                                n3 = null;
                                Object var11_8 = null;
                                if (rs == null) break block12;
                            }
                            catch (Throwable throwable) {
                                block16: {
                                    Object var11_11 = null;
                                    if (rs == null) break block16;
                                    try {
                                        rs.close();
                                    }
                                    catch (SQLException ignored) {
                                        _log.info((Object)"ResultSet.close() threw the exception!", (Throwable)ignored);
                                    }
                                }
                                throw throwable;
                            }
                            try {
                                rs.close();
                            }
                            catch (SQLException ignored) {
                                _log.info((Object)"ResultSet.close() threw the exception!", (Throwable)ignored);
                            }
                        }
                        return n3;
                    }
                    value = rs.getString(1);
                    if (value != null) break block13;
                    n2 = null;
                    Object var11_9 = null;
                    if (rs == null) break block14;
                    try {
                        rs.close();
                    }
                    catch (SQLException ignored) {
                        _log.info((Object)"ResultSet.close() threw the exception!", (Throwable)ignored);
                    }
                }
                return n2;
            }
            try {
                actualValue = Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                String msg = "The type of primary key related to sequece should be Number:";
                msg = msg + " table=" + tableName + " primaryKey=" + primaryKeyColumnName;
                msg = msg + " value=" + value;
                throw new IllegalStateException(msg);
            }
            n = actualValue;
            Object var11_10 = null;
            if (rs == null) break block15;
            try {
                rs.close();
            }
            catch (SQLException ignored) {
                _log.info((Object)"ResultSet.close() threw the exception!", (Throwable)ignored);
            }
        }
        return n;
    }

    protected abstract Integer selectNextVal(Statement var1, String var2) throws SQLException;

    protected String ln() {
        return "\n";
    }
}

