/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.info;

import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.logic.jdbc.handler.DfColumnHandler;
import org.seasar.dbflute.properties.DfDocumentProperties;
import org.seasar.dbflute.util.DfStringUtil;

public class DfProcedureColumnMetaInfo {
    protected String columnName;
    protected int jdbcType;
    protected String dbTypeName;
    protected Integer columnSize;
    protected Integer decimalDigits;
    protected String columnComment;
    protected DfProcedureColumnType procedureColumnType;

    public String getColumnDisplayNameForSchemaHtml() {
        StringBuilder sb = new StringBuilder();
        if (DfStringUtil.isNotNullAndNotTrimmedEmpty((String)this.columnName)) {
            sb.append(this.columnName);
        } else if (DfProcedureColumnType.procedureColumnReturn.equals((Object)this.procedureColumnType)) {
            sb.append("(result)");
        } else {
            sb.append("(arg)");
        }
        sb.append(" - ").append(this.dbTypeName);
        if (DfColumnHandler.isColumnSizeValid(this.columnSize)) {
            sb.append("(").append(this.columnSize);
            if (DfColumnHandler.isDecimalDigitsValid(this.decimalDigits)) {
                sb.append(", ").append(this.decimalDigits);
            }
            sb.append(")");
        }
        sb.append(" <span class=\"type\">(").append(this.procedureColumnType.alias()).append(")</span>");
        return sb.toString();
    }

    public boolean hasColumnComment() {
        return DfStringUtil.isNotNullAndNotTrimmedEmpty((String)this.getColumnComment());
    }

    public String getColumnCommentForSchemaHtml() {
        DfDocumentProperties prop = DfBuildProperties.getInstance().getDocumentProperties();
        String comment = this.columnComment;
        comment = prop.resolvePreTextForSchemaHtml(comment);
        return comment;
    }

    public String toString() {
        return "{" + this.columnName + ", " + (Object)((Object)this.procedureColumnType) + ", " + this.jdbcType + ", " + this.dbTypeName + "(" + this.columnSize + ", " + this.decimalDigits + ")" + this.columnComment + "}";
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public DfProcedureColumnType getProcedureColumnType() {
        return this.procedureColumnType;
    }

    public void setProcedureColumnType(DfProcedureColumnType procedureColumnType) {
        this.procedureColumnType = procedureColumnType;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public void setJdbcType(int jdbcType) {
        this.jdbcType = jdbcType;
    }

    public String getDbTypeName() {
        return this.dbTypeName;
    }

    public void setDbTypeName(String dbTypeName) {
        this.dbTypeName = dbTypeName;
    }

    public Integer getColumnSize() {
        return this.columnSize;
    }

    public void setColumnSize(Integer columnSize) {
        this.columnSize = columnSize;
    }

    public Integer getDecimalDigits() {
        return this.decimalDigits;
    }

    public void setDecimalDigits(Integer decimalDigits) {
        this.decimalDigits = decimalDigits;
    }

    public String getColumnComment() {
        return this.columnComment;
    }

    public void setColumnComment(String columnComment) {
        this.columnComment = columnComment;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DfProcedureColumnType {
        procedureColumnUnknown("Unknown"),
        procedureColumnIn("In"),
        procedureColumnInOut("InOut"),
        procedureColumnOut("Out"),
        procedureColumnReturn("Return"),
        procedureColumnResult("Result");

        private final String _alias;

        private DfProcedureColumnType(String alias) {
            this._alias = alias;
        }

        public String alias() {
            return this._alias;
        }
    }
}

