/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.factory;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.seasar.dbflute.logic.jdbc.metadata.sequence.DfSequenceHandler;
import org.seasar.dbflute.logic.jdbc.metadata.sequence.DfSequenceHandlerDB2;
import org.seasar.dbflute.logic.jdbc.metadata.sequence.DfSequenceHandlerH2;
import org.seasar.dbflute.logic.jdbc.metadata.sequence.DfSequenceHandlerOracle;
import org.seasar.dbflute.logic.jdbc.metadata.sequence.DfSequenceHandlerPostgreSQL;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfDatabaseProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSequenceHandlerFactory {
    protected DataSource _dataSource;
    protected DfBasicProperties _basicProperties;
    protected DfDatabaseProperties _databaseProperties;

    public DfSequenceHandlerFactory(DataSource dataSource, DfBasicProperties basicProperties, DfDatabaseProperties databaseProperties) {
        this._dataSource = dataSource;
        this._basicProperties = basicProperties;
        this._databaseProperties = databaseProperties;
    }

    public DfSequenceHandler createSequenceHandler() {
        String schema = this._databaseProperties.getDatabaseSchema();
        List<String> allSchemaList = this.createAllSchemaList();
        if (this._basicProperties.isDatabasePostgreSQL()) {
            return new DfSequenceHandlerPostgreSQL(this._dataSource, schema, allSchemaList);
        }
        if (this._basicProperties.isDatabaseOracle()) {
            return new DfSequenceHandlerOracle(this._dataSource, schema, allSchemaList);
        }
        if (this._basicProperties.isDatabaseDB2()) {
            return new DfSequenceHandlerDB2(this._dataSource, schema, allSchemaList);
        }
        if (this._basicProperties.isDatabaseH2()) {
            return new DfSequenceHandlerH2(this._dataSource, schema, allSchemaList);
        }
        return null;
    }

    protected List<String> createAllSchemaList() {
        ArrayList<String> schemaList = new ArrayList<String>();
        String mainSchema = this._databaseProperties.getDatabaseSchema();
        if (mainSchema != null && mainSchema.trim().length() > 0) {
            schemaList.add(this._databaseProperties.getDatabaseSchema());
        }
        schemaList.addAll(this._databaseProperties.getAdditionalSchemaMap().keySet());
        return schemaList;
    }
}

