/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.factory;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.seasar.dbflute.logic.jdbc.metadata.sequence.DfSequenceExtractor;
import org.seasar.dbflute.logic.jdbc.metadata.sequence.DfSequenceExtractorDB2;
import org.seasar.dbflute.logic.jdbc.metadata.sequence.DfSequenceExtractorH2;
import org.seasar.dbflute.logic.jdbc.metadata.sequence.DfSequenceExtractorOracle;
import org.seasar.dbflute.logic.jdbc.metadata.sequence.DfSequenceExtractorPostgreSQL;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfDatabaseProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSequenceExtractorFactory {
    protected DataSource _dataSource;
    protected DfBasicProperties _basicProperties;
    protected DfDatabaseProperties _databaseProperties;

    public DfSequenceExtractorFactory(DataSource dataSource, DfBasicProperties basicProperties, DfDatabaseProperties databaseProperties) {
        this._dataSource = dataSource;
        this._basicProperties = basicProperties;
        this._databaseProperties = databaseProperties;
    }

    public DfSequenceExtractor createSequenceExtractor() {
        List<String> allSchemaList = this.createAllSchemaList();
        if (this._basicProperties.isDatabasePostgreSQL()) {
            return new DfSequenceExtractorPostgreSQL(this._dataSource, allSchemaList);
        }
        if (this._basicProperties.isDatabaseOracle()) {
            return new DfSequenceExtractorOracle(this._dataSource, allSchemaList);
        }
        if (this._basicProperties.isDatabaseDB2()) {
            return new DfSequenceExtractorDB2(this._dataSource, allSchemaList);
        }
        if (this._basicProperties.isDatabaseH2()) {
            return new DfSequenceExtractorH2(this._dataSource, allSchemaList);
        }
        return null;
    }

    protected List<String> createAllSchemaList() {
        ArrayList<String> schemaList = new ArrayList<String>();
        String mainSchema = this._databaseProperties.getDatabaseSchema();
        if (mainSchema != null && mainSchema.trim().length() > 0) {
            schemaList.add(this._databaseProperties.getDatabaseSchema());
        }
        schemaList.addAll(this._databaseProperties.getAdditionalSchemaMap().keySet());
        return schemaList;
    }
}

