/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.jdbc.sqlfile;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.exception.SQLFailureException;
import org.seasar.dbflute.helper.jdbc.DfRunnerInformation;
import org.seasar.dbflute.helper.jdbc.sqlfile.DfSqlFileRunnerBase;
import org.seasar.dbflute.helper.jdbc.sqlfile.DfSqlFileRunnerDispatcher;

public class DfSqlFileRunnerExecute
extends DfSqlFileRunnerBase {
    private static Log _log = LogFactory.getLog(DfSqlFileRunnerExecute.class);
    protected DfSqlFileRunnerDispatcher _dispatcher;

    public DfSqlFileRunnerExecute(DfRunnerInformation runInfo, DataSource dataSource) {
        super(runInfo, dataSource);
    }

    protected void execSQL(String sql) {
        boolean lazyConnectFailed = false;
        try {
            boolean dispatched = this.dispatch(sql);
            if (!dispatched) {
                try {
                    this.lazyConnectIfNeeds();
                }
                catch (SQLException e) {
                    lazyConnectFailed = true;
                    throw e;
                }
                this.checkStatement(sql);
                this._currentStatement.execute(sql);
            }
            ++this._goodSqlCount;
        }
        catch (SQLException e) {
            if (!lazyConnectFailed && this._runInfo.isErrorContinue()) {
                this.showContinueWarnLog(e, sql);
                this._result.addErrorContinuedSql(e, sql);
                return;
            }
            String msg = "Look! Read the message below." + this.ln();
            msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
            msg = msg + "It failed to execute the SQL!" + this.ln();
            msg = msg + this.ln();
            msg = msg + "[SQL File]" + this.ln() + this._sqlFile + this.ln();
            msg = msg + this.ln();
            msg = msg + "[Executed SQL]" + this.ln() + sql + this.ln();
            msg = msg + this.ln();
            msg = msg + "[SQLState]" + this.ln() + e.getSQLState() + this.ln();
            msg = msg + this.ln();
            msg = msg + "[ErrorCode]" + this.ln() + e.getErrorCode() + this.ln();
            msg = msg + this.ln();
            msg = msg + "[SQLException]" + this.ln() + e.getClass().getName() + this.ln();
            msg = msg + this.extractMessage(e) + this.ln();
            SQLException nextEx = e.getNextException();
            if (nextEx != null) {
                msg = msg + this.ln();
                msg = msg + "[NextException]" + this.ln();
                msg = msg + nextEx.getClass().getName() + this.ln();
                msg = msg + this.extractMessage(nextEx) + this.ln();
                SQLException nextNextEx = nextEx.getNextException();
                if (nextNextEx != null) {
                    msg = msg + this.ln();
                    msg = msg + "[NextNextException]" + this.ln();
                    msg = msg + nextNextEx.getClass().getName() + this.ln();
                    msg = msg + this.extractMessage(nextNextEx) + this.ln();
                }
            }
            msg = msg + "* * * * * * * * * */";
            throw new SQLFailureException(msg, e);
        }
    }

    protected boolean dispatch(String sql) throws SQLException {
        return this._dispatcher != null && this._dispatcher.dispatch(this._sqlFile, this._currentStatement, sql);
    }

    protected void lazyConnectIfNeeds() throws SQLException {
    }

    protected void showContinueWarnLog(SQLException e, String sql) {
        StringBuilder sb = new StringBuilder();
        sb.append("*Failure: ").append(e.getClass().getName()).append(this.ln());
        sb.append("/nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn");
        sb.append("nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn");
        sb.append(this.ln());
        sb.append(sql).append(this.ln());
        e.getSQLState();
        sb.append("- - - - - - - - - -").append(this.ln());
        sb.append(this.extractMessage(e)).append(this.ln());
        this.buildAdditionalErrorInfo(sb, e).append(this.ln());
        SQLException nextEx = e.getNextException();
        if (nextEx != null) {
            sb.append("- - - - - - - - - -").append(this.ln());
            sb.append(this.extractMessage(nextEx)).append(this.ln());
            this.buildAdditionalErrorInfo(sb, nextEx).append(this.ln());
            SQLException nextNextEx = nextEx.getNextException();
            if (nextNextEx != null) {
                sb.append("- - - - - - - - - -").append(this.ln());
                sb.append(this.extractMessage(nextNextEx)).append(this.ln());
                this.buildAdditionalErrorInfo(sb, nextNextEx).append(this.ln());
            }
        }
        sb.append("nnnnnnnnnnnnnnnnnnnn/").append(this.ln());
        _log.warn((Object)sb.toString());
    }

    protected String extractMessage(SQLException e) {
        String message = e.getMessage();
        return message != null ? message.trim() : message;
    }

    protected StringBuilder buildAdditionalErrorInfo(StringBuilder sb, SQLException e) {
        sb.append("(SQLState=").append(e.getSQLState()).append(" ErrorCode=").append(e.getErrorCode()).append(")");
        return sb;
    }

    public DfSqlFileRunnerDispatcher getDispatcher() {
        return this._dispatcher;
    }

    public void setDispatcher(DfSqlFileRunnerDispatcher dispatcher) {
        this._dispatcher = dispatcher;
    }
}

