/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.jdbc.sqlfile;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSqlFileGetter {
    protected FileFilter _sqlFileFileter;
    protected FileFilter _directoryOnlyFilter;

    public List<File> getSqlFileList(String sqlDirectory) {
        ArrayList<File> fileList = new ArrayList<File>();
        File dir = new File(sqlDirectory);
        if (!dir.exists()) {
            String msg = "The sqlDirectory does not exist: " + dir;
            throw new IllegalStateException(msg);
        }
        if (!dir.isDirectory()) {
            String msg = "The sqlDirectory should be directory. but file...: " + dir;
            throw new IllegalStateException(msg);
        }
        this.registerFile(fileList, dir);
        return fileList;
    }

    protected void registerFile(List<File> fileList, File dir) {
        File[] directories;
        File[] sqlFiles;
        FileFilter sqlFileFileter = this._sqlFileFileter != null ? this._sqlFileFileter : this.createDefaultSqlFileFileFilter();
        for (File sqlFile : sqlFiles = dir.listFiles(sqlFileFileter)) {
            fileList.add(sqlFile);
        }
        FileFilter directoryOnlyFilter = this._sqlFileFileter != null ? this._directoryOnlyFilter : this.createDefaultDirectoryOnlyFileFilter();
        for (File subdir : directories = dir.listFiles(directoryOnlyFilter)) {
            this.registerFile(fileList, subdir);
        }
    }

    protected FileFilter createDefaultSqlFileFileFilter() {
        return new FileFilter(){

            public boolean accept(File file) {
                return DfSqlFileGetter.this.acceptSqlFile(file);
            }
        };
    }

    protected boolean acceptSqlFile(File file) {
        return file.getName().toLowerCase().endsWith(".sql");
    }

    protected FileFilter createDefaultDirectoryOnlyFileFilter() {
        return new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
    }

    public FileFilter getSqlFileFileter() {
        return this._sqlFileFileter;
    }

    public void setSqlFileFileter(FileFilter sqlFileFileter) {
        this._sqlFileFileter = sqlFileFileter;
    }
}

