/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.io.data.impl;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.TypeMap;
import org.seasar.dbflute.exception.DfTableDataRegistrationFailureException;
import org.seasar.dbflute.logic.jdbc.handler.DfColumnHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfColumnMetaInfo;
import org.seasar.dbflute.util.DfSystemUtil;
import org.seasar.dbflute.util.DfTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DfAbsractDataWriter {
    private static final Log _log = LogFactory.getLog(DfAbsractDataWriter.class);
    protected DfColumnHandler _columnHandler = new DfColumnHandler();

    protected boolean processNotNullNotString(String tableName, String columnName, Object obj, PreparedStatement statement, int bindCount) throws SQLException {
        if (!this.isNotNullNotString(obj)) {
            return false;
        }
        if (obj instanceof Time) {
            statement.setTime(bindCount, (Time)obj);
        } else if (obj instanceof Timestamp) {
            statement.setTimestamp(bindCount, (Timestamp)obj);
        } else if (obj instanceof Date) {
            statement.setDate(bindCount, DfTypeUtil.toSqlDate((Object)((Date)obj)));
        } else if (obj instanceof BigDecimal) {
            statement.setBigDecimal(bindCount, (BigDecimal)obj);
        } else if (obj instanceof Boolean) {
            statement.setBoolean(bindCount, (Boolean)obj);
        } else {
            statement.setObject(bindCount, obj);
        }
        return true;
    }

    protected boolean isNotNullNotString(Object obj) {
        return obj != null && !(obj instanceof String);
    }

    protected boolean processNull(String tableName, String columnName, Object value, PreparedStatement statement, int bindCount, Map<String, DfColumnMetaInfo> columnMetaInfoMap) throws SQLException {
        if (!this.isNullValue(value)) {
            return false;
        }
        DfColumnMetaInfo columnMetaInfo = columnMetaInfoMap.get(columnName);
        if (columnMetaInfo == null) {
            return false;
        }
        int jdbcType = columnMetaInfo.getJdbcDefValue();
        try {
            statement.setNull(bindCount, jdbcType);
        }
        catch (SQLException e) {
            if (jdbcType != 1111) {
                throw e;
            }
            String torqueType = this._columnHandler.getColumnJdbcType(columnMetaInfo);
            Integer mappedJdbcType = TypeMap.getJdbcDefValueByJdbcType(torqueType);
            try {
                statement.setNull(bindCount, mappedJdbcType);
            }
            catch (SQLException ignored) {
                String msg = "Failed to re-try setNull(" + columnName + ", " + mappedJdbcType + "):";
                msg = msg + " " + ignored.getMessage();
                _log.info((Object)msg);
                throw e;
            }
        }
        return true;
    }

    protected boolean isNullValue(Object value) {
        return value == null;
    }

    protected boolean processTimestamp(String tableName, String columnName, String value, PreparedStatement ps, int bindCount, Map<String, DfColumnMetaInfo> columnMetaInfoMap) throws SQLException {
        if (value == null) {
            return false;
        }
        DfColumnMetaInfo columnMetaInfo = columnMetaInfoMap.get(columnName);
        boolean typeChecked = false;
        if (columnMetaInfo != null) {
            Class<?> columnType = this.getColumnType4Judgement(columnMetaInfo);
            if (columnType != null && !Date.class.isAssignableFrom(columnType)) {
                return false;
            }
            if (columnType != null && Time.class.isAssignableFrom(columnType)) {
                return false;
            }
            typeChecked = true;
        }
        try {
            Timestamp timestamp = DfTypeUtil.toTimestamp((Object)value);
            ps.setTimestamp(bindCount, timestamp);
            return true;
        }
        catch (DfTypeUtil.ParseTimestampOutOfCalendarException e) {
            if (typeChecked) {
                String msg = "Look! Read the message below." + this.ln();
                msg = msg + "/- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -" + this.ln();
                msg = msg + "Failed to set the timestamp because the value was out of calendar!" + this.ln();
                msg = msg + this.ln();
                msg = msg + "[Table]" + this.ln() + tableName + this.ln();
                msg = msg + this.ln();
                msg = msg + "[Column]" + this.ln() + columnName + this.ln();
                msg = msg + this.ln();
                msg = msg + "[Value]" + this.ln() + value + this.ln();
                msg = msg + "- - - - - - - - - -/";
                throw new DfTableDataRegistrationFailureException(msg, e);
            }
            return false;
        }
        catch (DfTypeUtil.ParseTimestampException ignored) {
            return false;
        }
    }

    protected boolean processTime(String tableName, String columnName, String value, PreparedStatement ps, int bindCount, Map<String, DfColumnMetaInfo> columnMetaInfoMap) throws SQLException {
        Class<?> columnType;
        if (value == null) {
            return false;
        }
        DfColumnMetaInfo columnMetaInfo = columnMetaInfoMap.get(columnName);
        if (columnMetaInfo != null && (columnType = this.getColumnType4Judgement(columnMetaInfo)) != null && !Time.class.isAssignableFrom(columnType)) {
            return false;
        }
        try {
            Time time = DfTypeUtil.toTime((Object)value);
            ps.setTime(bindCount, time);
            return true;
        }
        catch (DfTypeUtil.ParseTimeOutOfCalendarException e) {
            String msg = "Look! Read the message below." + this.ln();
            msg = msg + "/- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -" + this.ln();
            msg = msg + "Failed to set the time because the value was out of calendar!" + this.ln();
            msg = msg + this.ln();
            msg = msg + "[Table]" + this.ln() + tableName + this.ln();
            msg = msg + this.ln();
            msg = msg + "[Column]" + this.ln() + columnName + this.ln();
            msg = msg + this.ln();
            msg = msg + "[Value]" + this.ln() + value + this.ln();
            msg = msg + "- - - - - - - - - -/";
            throw new DfTableDataRegistrationFailureException(msg, e);
        }
        catch (DfTypeUtil.ParseTimeException ignored) {
            return false;
        }
    }

    protected boolean processBoolean(String tableName, String columnName, String value, PreparedStatement ps, int bindCount, Map<String, DfColumnMetaInfo> columnMetaInfoMap) throws SQLException {
        Class<?> columnType;
        if (value == null) {
            return false;
        }
        DfColumnMetaInfo columnMetaInfo = columnMetaInfoMap.get(columnName);
        if (columnMetaInfo != null && (columnType = this.getColumnType4Judgement(columnMetaInfo)) != null && !Boolean.class.isAssignableFrom(columnType)) {
            return false;
        }
        try {
            Boolean booleanValue = DfTypeUtil.toBoolean((Object)value);
            ps.setBoolean(bindCount, booleanValue);
            return true;
        }
        catch (DfTypeUtil.ToBooleanParseException ignored) {
            return false;
        }
    }

    protected boolean processNumber(String tableName, String columnName, String value, PreparedStatement ps, int bindCount, Map<String, DfColumnMetaInfo> columnMetaInfoMap) throws SQLException {
        Class<?> columnType;
        if (value == null) {
            return false;
        }
        DfColumnMetaInfo columnMetaInfo = columnMetaInfoMap.get(columnName);
        if (columnMetaInfo != null && (columnType = this.getColumnType4Judgement(columnMetaInfo)) != null && !Number.class.isAssignableFrom(columnType)) {
            return false;
        }
        if (!this.isBigDecimalValue(value = this.filterBigDecimalValue(value))) {
            return false;
        }
        BigDecimal bigDecimalValue = this.getBigDecimalValue(columnName, value);
        try {
            long longValue = bigDecimalValue.longValueExact();
            ps.setLong(bindCount, longValue);
            return true;
        }
        catch (ArithmeticException e) {
            ps.setBigDecimal(bindCount, bigDecimalValue);
            return true;
        }
    }

    protected String filterBigDecimalValue(String value) {
        if (value == null) {
            return null;
        }
        value = value.trim();
        return value;
    }

    protected boolean isBigDecimalValue(String value) {
        if (value == null) {
            return false;
        }
        try {
            new BigDecimal(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    protected BigDecimal getBigDecimalValue(String columnName, String value) {
        try {
            return new BigDecimal(value);
        }
        catch (RuntimeException e) {
            String msg = "The value should be big decimal: ";
            msg = msg + " columnName=" + columnName + " value=" + value;
            throw new IllegalStateException(msg, e);
        }
    }

    protected boolean processUUID(String tableName, String columnName, String value, PreparedStatement ps, int bindCount, Map<String, DfColumnMetaInfo> columnMetaInfoMap) throws SQLException {
        DfColumnMetaInfo columnMetaInfo = columnMetaInfoMap.get(columnName);
        if (columnMetaInfo != null) {
            if (columnMetaInfo.getJdbcDefValue() != 1111 || !"uuid".equalsIgnoreCase(columnMetaInfo.getDbTypeName())) {
                return false;
            }
            value = this.filterUUIDValue(value);
            ps.setObject(bindCount, (Object)value, 1111);
            return true;
        }
        return false;
    }

    protected String filterUUIDValue(String value) {
        if (value == null) {
            return null;
        }
        value = value.trim();
        return value;
    }

    protected boolean processArray(String tableName, String columnName, String value, PreparedStatement ps, int bindCount, Map<String, DfColumnMetaInfo> columnMetaInfoMap) throws SQLException {
        DfColumnMetaInfo columnMetaInfo = columnMetaInfoMap.get(columnName);
        if (columnMetaInfo != null) {
            if (columnMetaInfo.getJdbcDefValue() != 2003 || !columnMetaInfo.getDbTypeName().startsWith("_")) {
                return false;
            }
            value = this.filterArrayValue(value);
            ps.setObject(bindCount, (Object)value, 1111);
            return true;
        }
        return false;
    }

    protected String filterArrayValue(String value) {
        if (value == null) {
            return null;
        }
        value = value.trim();
        return value;
    }

    protected Class<?> getColumnType4Judgement(DfColumnMetaInfo columnMetaInfo) {
        Class<?> clazz;
        block7: {
            String torqueType = this._columnHandler.getColumnJdbcType(columnMetaInfo);
            int columnSize = columnMetaInfo.getColumnSize();
            int decimalDigits = columnMetaInfo.getDecimalDigits();
            String javaNativeString = TypeMap.findJavaNativeByJdbcType(torqueType, columnSize, decimalDigits);
            clazz = null;
            try {
                clazz = Class.forName(javaNativeString);
            }
            catch (ClassNotFoundException e) {
                String fullName = "java.lang." + javaNativeString;
                try {
                    clazz = Class.forName(fullName);
                }
                catch (ClassNotFoundException ignored) {
                    int jdbcType = columnMetaInfo.getJdbcDefValue();
                    if (jdbcType == 93 || jdbcType == 91) {
                        return Date.class;
                    }
                    if (jdbcType == 92) {
                        return Time.class;
                    }
                    if (jdbcType == -7 || jdbcType == 16) {
                        return Boolean.class;
                    }
                    if (jdbcType != 2 && jdbcType != 4 && jdbcType != 5 && jdbcType != 6 && jdbcType != 3 && jdbcType != 7 && jdbcType != -6) break block7;
                    return Number.class;
                }
            }
        }
        return clazz;
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }
}

