/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.dataset.states;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.helper.dataset.DfDataRow;
import org.seasar.dbflute.helper.dataset.states.DfDtsRowState;
import org.seasar.dbflute.helper.dataset.states.DfDtsSqlContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DfDtsAbstractRowState
implements DfDtsRowState {
    private static final Log _log = LogFactory.getLog(DfDtsAbstractRowState.class);

    DfDtsAbstractRowState() {
    }

    @Override
    public void update(DataSource dataSource, DfDataRow row) {
        DfDtsSqlContext ctx = this.getSqlContext(row);
        this.execute(dataSource, ctx.getSql(), ctx.getArgs(), ctx.getArgTypes(), row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(DataSource dataSource, String sql, Object[] args, Class<?>[] argTypes, DfDataRow row) {
        String tableName = row.getTable().getTableName();
        Connection conn = DfDtsAbstractRowState.getConnection(dataSource);
        try {
            block9: {
                PreparedStatement ps = DfDtsAbstractRowState.prepareStatement(conn, sql);
                try {
                    try {
                        _log.info((Object)this.getSql4Log(tableName, Arrays.asList(args)));
                        this.bindArgs(ps, args, argTypes);
                        ps.executeUpdate();
                    }
                    catch (SQLException e) {
                        String msg = "The SQL threw the exception: " + sql;
                        throw new IllegalStateException(msg, e);
                    }
                    Object var12_9 = null;
                    if (ps == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var12_10 = null;
                    if (ps == null) throw throwable;
                    try {
                        ps.close();
                        throw throwable;
                    }
                    catch (SQLException ignored) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (SQLException ignored) {}
                ps.close();
            }
            Object var15_16 = null;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            DfDtsAbstractRowState.close(conn);
            throw throwable;
        }
        DfDtsAbstractRowState.close(conn);
    }

    protected String getSql4Log(String tableName, List<? extends Object> bindParameters) {
        String bindParameterString = bindParameters.toString();
        bindParameterString = bindParameterString.substring(1, bindParameterString.length() - 1);
        return tableName + ":{" + bindParameterString + "}";
    }

    protected void bindArgs(PreparedStatement ps, Object[] args, Class<?>[] argTypes) throws SQLException {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            Timestamp timestamp;
            Object value = args[i];
            Class<?> type = argTypes[i];
            int parameterIndex = i + 1;
            if (String.class.isAssignableFrom(type)) {
                if (value != null) {
                    if (this.isTimestampValue((String)value)) {
                        timestamp = this.getTimestampValue((String)value);
                        ps.setTimestamp(parameterIndex, timestamp);
                        continue;
                    }
                    ps.setString(parameterIndex, (String)value);
                    continue;
                }
                ps.setNull(parameterIndex, 12);
                continue;
            }
            if (Number.class.isAssignableFrom(type)) {
                if (value != null) {
                    ps.setBigDecimal(parameterIndex, new BigDecimal(value.toString()));
                    continue;
                }
                ps.setNull(parameterIndex, 2);
                continue;
            }
            if (Date.class.isAssignableFrom(type)) {
                if (value != null) {
                    if (value instanceof String) {
                        timestamp = this.getTimestampValue((String)value);
                        ps.setTimestamp(parameterIndex, timestamp);
                        continue;
                    }
                    if (value instanceof Timestamp) {
                        ps.setTimestamp(parameterIndex, (Timestamp)value);
                        continue;
                    }
                    ps.setDate(parameterIndex, new java.sql.Date(((Date)value).getTime()));
                    continue;
                }
                ps.setNull(parameterIndex, 91);
                continue;
            }
            if (value != null) {
                ps.setObject(parameterIndex, value);
                continue;
            }
            ps.setNull(parameterIndex, 12);
        }
    }

    protected boolean isTimestampValue(String value) {
        if (value == null) {
            return false;
        }
        value = this.filterTimestampValue(value);
        try {
            Timestamp.valueOf(value);
            return true;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    protected Timestamp getTimestampValue(String value) {
        String filteredTimestampValue = this.filterTimestampValue(value);
        try {
            return Timestamp.valueOf(filteredTimestampValue);
        }
        catch (RuntimeException e) {
            String msg = "The value cannot be convert to timestamp:";
            msg = msg + " value=" + value + " filtered=" + filteredTimestampValue;
            throw new IllegalStateException(msg, e);
        }
    }

    protected String filterTimestampValue(String value) {
        if ((value = value.trim()).indexOf("/") == 4 && value.lastIndexOf("/") == 7) {
            value = value.replaceAll("/", "-");
        }
        if (value.indexOf("-") == 4 && value.lastIndexOf("-") == 7 && value.length() == "2007-07-09".length()) {
            value = value + " 00:00:00";
        }
        return value;
    }

    protected abstract DfDtsSqlContext getSqlContext(DfDataRow var1);

    private static Connection getConnection(DataSource dataSource) {
        try {
            return dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    private static PreparedStatement prepareStatement(Connection conn, String sql) {
        try {
            return conn.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void close(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }
}

