/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.model;

import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.exception.DfJDBCTypeNotFoundException;
import org.seasar.dbflute.helper.language.DfLanguageDependencyInfo;
import org.seasar.dbflute.helper.language.metadata.LanguageMetaData;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfLittleAdjustmentProperties;

public class TypeMap {
    public static final Log _log = LogFactory.getLog(TypeMap.class);
    public static final String CHAR = "CHAR";
    public static final String VARCHAR = "VARCHAR";
    public static final String LONGVARCHAR = "LONGVARCHAR";
    public static final String CLOB = "CLOB";
    public static final String NUMERIC = "NUMERIC";
    public static final String DECIMAL = "DECIMAL";
    public static final String BIT = "BIT";
    public static final String BOOLEAN = "BOOLEAN";
    public static final String TINYINT = "TINYINT";
    public static final String SMALLINT = "SMALLINT";
    public static final String INTEGER = "INTEGER";
    public static final String BIGINT = "BIGINT";
    public static final String REAL = "REAL";
    public static final String FLOAT = "FLOAT";
    public static final String DOUBLE = "DOUBLE";
    public static final String BINARY = "BINARY";
    public static final String VARBINARY = "VARBINARY";
    public static final String LONGVARBINARY = "LONGVARBINARY";
    public static final String BLOB = "BLOB";
    public static final String DATE = "DATE";
    public static final String TIME = "TIME";
    public static final String TIMESTAMP = "TIMESTAMP";
    public static final String ARRAY = "ARRAY";
    public static final String UUID = "UUID";
    public static final String CHAR_NATIVE_TYPE = "String";
    public static final String VARCHAR_NATIVE_TYPE = "String";
    public static final String LONGVARCHAR_NATIVE_TYPE = "String";
    public static final String CLOB_NATIVE_TYPE = "String";
    public static final String NUMERIC_NATIVE_TYPE = "java.math.BigDecimal";
    public static final String DECIMAL_NATIVE_TYPE = "java.math.BigDecimal";
    public static final String BIT_NATIVE_TYPE = "Boolean";
    public static final String BOOLEAN_NATIVE_TYPE = "Boolean";
    public static final String TINYINT_NATIVE_TYPE = "Integer";
    public static final String SMALLINT_NATIVE_TYPE = "Integer";
    public static final String INTEGER_NATIVE_TYPE = "Integer";
    public static final String BIGINT_NATIVE_TYPE = "Long";
    public static final String REAL_NATIVE_TYPE = "java.math.BigDecimal";
    public static final String FLOAT_NATIVE_TYPE = "java.math.BigDecimal";
    public static final String DOUBLE_NATIVE_TYPE = "java.math.BigDecimal";
    public static final String BINARY_NATIVE_TYPE = "byte[]";
    public static final String VARBINARY_NATIVE_TYPE = "byte[]";
    public static final String LONGVARBINARY_NATIVE_TYPE = "byte[]";
    public static final String BLOB_NATIVE_TYPE = "byte[]";
    public static final String DATE_NATIVE_TYPE = "java.util.Date";
    public static final String TIME_NATIVE_TYPE = "java.sql.Time";
    public static final String TIMESTAMP_NATIVE_TYPE = "java.sql.Timestamp";
    public static final String ARRAY_NATIVE_TYPE = "String";
    public static final String UUID_NATIVE_TYPE = "java.util.UUID";
    private static Hashtable<String, String> _jdbcTypeToJavaNativeMap = null;
    private static Hashtable<Integer, String> _jdbcDefValueToJdbcTypeMap = null;
    private static Hashtable<String, Integer> _jdbcTypeToJdbcDefValueMap = null;
    private static Hashtable<String, String> _javaNativeToFlexNativeMap = null;
    protected static Map<String, Object> _propertyJdbcTypeToJavaNativeMap;
    protected static Map<String, String> _propertyJavaNativeToFlexNativeMap;
    private static boolean _initialized;

    protected static void setupPropertyNativeMap() {
        DfBuildProperties prop = DfBuildProperties.getInstance();
        _propertyJdbcTypeToJavaNativeMap = prop.getTypeMappingProperties().getJdbcToJavaNativeMap();
        _propertyJavaNativeToFlexNativeMap = prop.getFlexDtoProperties().getJavaToFlexNativeMap();
    }

    public static void reload() {
        TypeMap.setupPropertyNativeMap();
        _initialized = false;
        TypeMap.initialize();
    }

    public static synchronized void initialize() {
        if (_initialized) {
            return;
        }
        _jdbcTypeToJavaNativeMap = new Hashtable();
        _jdbcTypeToJavaNativeMap.put(CHAR, TypeMap.initializeJavaNative(CHAR, "String"));
        _jdbcTypeToJavaNativeMap.put(VARCHAR, TypeMap.initializeJavaNative(VARCHAR, "String"));
        _jdbcTypeToJavaNativeMap.put(LONGVARCHAR, TypeMap.initializeJavaNative(LONGVARCHAR, "String"));
        _jdbcTypeToJavaNativeMap.put(CLOB, TypeMap.initializeJavaNative(CLOB, "String"));
        _jdbcTypeToJavaNativeMap.put(NUMERIC, TypeMap.initializeJavaNative(NUMERIC, TypeMap.getDefaultNumericJavaNativeType()));
        _jdbcTypeToJavaNativeMap.put(DECIMAL, TypeMap.initializeJavaNative(DECIMAL, TypeMap.getDefaultDecimalJavaNativeType()));
        _jdbcTypeToJavaNativeMap.put(BIT, TypeMap.initializeJavaNative(BIT, "Boolean"));
        _jdbcTypeToJavaNativeMap.put(BOOLEAN, TypeMap.initializeJavaNative(BOOLEAN, "Boolean"));
        _jdbcTypeToJavaNativeMap.put(TINYINT, TypeMap.initializeJavaNative(TINYINT, "Integer"));
        _jdbcTypeToJavaNativeMap.put(SMALLINT, TypeMap.initializeJavaNative(SMALLINT, "Integer"));
        _jdbcTypeToJavaNativeMap.put(INTEGER, TypeMap.initializeJavaNative(INTEGER, "Integer"));
        _jdbcTypeToJavaNativeMap.put(BIGINT, TypeMap.initializeJavaNative(BIGINT, BIGINT_NATIVE_TYPE));
        _jdbcTypeToJavaNativeMap.put(REAL, TypeMap.initializeJavaNative(REAL, "java.math.BigDecimal"));
        _jdbcTypeToJavaNativeMap.put(FLOAT, TypeMap.initializeJavaNative(FLOAT, "java.math.BigDecimal"));
        _jdbcTypeToJavaNativeMap.put(DOUBLE, TypeMap.initializeJavaNative(DOUBLE, "java.math.BigDecimal"));
        _jdbcTypeToJavaNativeMap.put(BINARY, TypeMap.initializeJavaNative(BINARY, "byte[]"));
        _jdbcTypeToJavaNativeMap.put(VARBINARY, TypeMap.initializeJavaNative(VARBINARY, "byte[]"));
        _jdbcTypeToJavaNativeMap.put(LONGVARBINARY, TypeMap.initializeJavaNative(LONGVARBINARY, "byte[]"));
        _jdbcTypeToJavaNativeMap.put(BLOB, TypeMap.initializeJavaNative(BLOB, "byte[]"));
        _jdbcTypeToJavaNativeMap.put(DATE, TypeMap.initializeJavaNative(DATE, DATE_NATIVE_TYPE));
        _jdbcTypeToJavaNativeMap.put(TIME, TypeMap.initializeJavaNative(TIME, TIME_NATIVE_TYPE));
        _jdbcTypeToJavaNativeMap.put(TIMESTAMP, TypeMap.initializeJavaNative(TIMESTAMP, TIMESTAMP_NATIVE_TYPE));
        _jdbcTypeToJavaNativeMap.put(ARRAY, TypeMap.initializeJavaNative(ARRAY, "String"));
        _jdbcTypeToJavaNativeMap.put(UUID, TypeMap.initializeJavaNative(UUID, UUID_NATIVE_TYPE));
        Set<String> propertyJdbcTypeSet = _propertyJdbcTypeToJavaNativeMap.keySet();
        for (String propertyJdbcType : propertyJdbcTypeSet) {
            if (_jdbcTypeToJavaNativeMap.containsKey(propertyJdbcType)) continue;
            String propertyJavaNative = (String)_propertyJdbcTypeToJavaNativeMap.get(propertyJdbcType);
            _jdbcTypeToJavaNativeMap.put(propertyJdbcType, propertyJavaNative);
        }
        _jdbcDefValueToJdbcTypeMap = new Hashtable();
        _jdbcDefValueToJdbcTypeMap.put(new Integer(1), CHAR);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(12), VARCHAR);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(-1), LONGVARCHAR);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(2005), CLOB);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(2), NUMERIC);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(3), DECIMAL);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(-7), BIT);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(16), BOOLEAN);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(-6), TINYINT);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(5), SMALLINT);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(4), INTEGER);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(-5), BIGINT);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(7), REAL);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(6), FLOAT);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(8), DOUBLE);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(-2), BINARY);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(-3), VARBINARY);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(-4), LONGVARBINARY);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(2004), BLOB);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(91), DATE);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(92), TIME);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(93), TIMESTAMP);
        _jdbcDefValueToJdbcTypeMap.put(new Integer(2003), ARRAY);
        _jdbcTypeToJdbcDefValueMap = new Hashtable();
        Set<Integer> keySet = _jdbcDefValueToJdbcTypeMap.keySet();
        for (Integer jdbcDefValue : keySet) {
            String jdbcType = _jdbcDefValueToJdbcTypeMap.get(jdbcDefValue);
            _jdbcTypeToJdbcDefValueMap.put(jdbcType, jdbcDefValue);
        }
        _javaNativeToFlexNativeMap = new Hashtable();
        _javaNativeToFlexNativeMap.put("String", TypeMap.initializeFlexNative("String", "String"));
        _javaNativeToFlexNativeMap.put("Short", TypeMap.initializeFlexNative("Short", "int"));
        _javaNativeToFlexNativeMap.put("Integer", TypeMap.initializeFlexNative("Integer", "int"));
        _javaNativeToFlexNativeMap.put(BIGINT_NATIVE_TYPE, TypeMap.initializeFlexNative(BIGINT_NATIVE_TYPE, "Number"));
        _javaNativeToFlexNativeMap.put("Float", TypeMap.initializeFlexNative("Float", "Number"));
        _javaNativeToFlexNativeMap.put("Double", TypeMap.initializeFlexNative("Double", "Number"));
        _javaNativeToFlexNativeMap.put("Number", TypeMap.initializeFlexNative("Number", "Number"));
        _javaNativeToFlexNativeMap.put("java.math.BigDecimal", TypeMap.initializeFlexNative("java.math.BigDecimal", "Number"));
        _javaNativeToFlexNativeMap.put(DATE_NATIVE_TYPE, TypeMap.initializeFlexNative(DATE_NATIVE_TYPE, "Date"));
        _javaNativeToFlexNativeMap.put(TIME_NATIVE_TYPE, TypeMap.initializeFlexNative(TIME_NATIVE_TYPE, "Date"));
        _javaNativeToFlexNativeMap.put(TIMESTAMP_NATIVE_TYPE, TypeMap.initializeFlexNative(TIMESTAMP_NATIVE_TYPE, "Date"));
        _javaNativeToFlexNativeMap.put("byte[]", TypeMap.initializeFlexNative("byte[]", "Object"));
        _javaNativeToFlexNativeMap.put("Object", TypeMap.initializeFlexNative("Object", "Object"));
        _initialized = true;
    }

    protected static String initializeJavaNative(String jdbcType, String defaultJavaNative) {
        String javaNative = (String)_propertyJdbcTypeToJavaNativeMap.get(jdbcType);
        if (javaNative == null) {
            return defaultJavaNative;
        }
        return javaNative;
    }

    protected static String initializeFlexNative(String javaNative, String defaultFlexNative) {
        String flexNative = _propertyJavaNativeToFlexNativeMap.get(javaNative);
        if (flexNative == null) {
            return defaultFlexNative;
        }
        return flexNative;
    }

    public static String findJdbcTypeByJdbcDefValue(Integer jdbcDefValue) {
        if (!_initialized) {
            TypeMap.initialize();
        }
        if (1111 == jdbcDefValue) {
            return null;
        }
        if (!_jdbcDefValueToJdbcTypeMap.containsKey(jdbcDefValue)) {
            String msg = "_jdbcDefValueToJdbcTypeMap doesn't contain the type as key: ";
            msg = msg + "key=" + jdbcDefValue + " map=" + _jdbcDefValueToJdbcTypeMap;
            throw new DfJDBCTypeNotFoundException(msg);
        }
        return _jdbcDefValueToJdbcTypeMap.get(jdbcDefValue);
    }

    public static Integer getJdbcDefValueByJdbcType(String jdbcType) {
        if (!_initialized) {
            TypeMap.initialize();
        }
        if (!_jdbcTypeToJdbcDefValueMap.containsKey(jdbcType)) {
            String msg = "_jdbcTypeToJdbcDefValueMap doesn't contain the type as key: ";
            msg = msg + "key=" + jdbcType + " map=" + _jdbcTypeToJdbcDefValueMap;
            throw new DfJDBCTypeNotFoundException(msg);
        }
        return _jdbcTypeToJdbcDefValueMap.get(jdbcType);
    }

    public static String findJavaNativeByJdbcType(String jdbcType, Integer columnSize, Integer decimalDigits) {
        DfLittleAdjustmentProperties prop = DfBuildProperties.getInstance().getLittleAdjustmentProperties();
        String javaType = TypeMap.getJavaNative(jdbcType);
        if (TypeMap.isAutoMappingTargetType(jdbcType) && javaType.equalsIgnoreCase("$$AutoMapping$$")) {
            String defaultJavaNativeType = NUMERIC.equalsIgnoreCase(jdbcType) ? TypeMap.getDefaultNumericJavaNativeType() : TypeMap.getDefaultDecimalJavaNativeType();
            if (decimalDigits != null && decimalDigits > 0) {
                return defaultJavaNativeType;
            }
            if (columnSize == null) {
                return TypeMap.getJavaNative(BIGINT);
            }
            if (columnSize > 9) {
                if (columnSize > 18) {
                    if (prop.isCompatibleAutoMappingOldStyle()) {
                        return TypeMap.getJavaNative(BIGINT);
                    }
                    return defaultJavaNativeType;
                }
                return TypeMap.getJavaNative(BIGINT);
            }
            return TypeMap.getJavaNative(INTEGER);
        }
        return javaType;
    }

    public static String findFlexNativeByJavaNative(String javaNative) {
        return TypeMap.getFlexNative(javaNative);
    }

    protected static boolean isAutoMappingTargetType(String torqueType) {
        return NUMERIC.equals(torqueType) || DECIMAL.equals(torqueType);
    }

    protected static String getDefaultNumericJavaNativeType() {
        DfBuildProperties prop = DfBuildProperties.getInstance();
        DfBasicProperties basicProperties = prop.getBasicProperties();
        if (basicProperties.isTargetLanguageJava()) {
            return "java.math.BigDecimal";
        }
        DfLanguageDependencyInfo languageDependencyInfo = basicProperties.getLanguageDependencyInfo();
        LanguageMetaData languageMetaData = languageDependencyInfo.createLanguageMetaData();
        Map<String, Object> jdbcToJavaNativeMap = languageMetaData.getJdbcToJavaNativeMap();
        return (String)jdbcToJavaNativeMap.get(NUMERIC);
    }

    public static String getDefaultDecimalJavaNativeType() {
        DfBuildProperties prop = DfBuildProperties.getInstance();
        DfBasicProperties basicProperties = prop.getBasicProperties();
        if (basicProperties.isTargetLanguageJava()) {
            return "java.math.BigDecimal";
        }
        DfLanguageDependencyInfo languageDependencyInfo = basicProperties.getLanguageDependencyInfo();
        LanguageMetaData languageMetaData = languageDependencyInfo.createLanguageMetaData();
        Map<String, Object> jdbcToJavaNativeMap = languageMetaData.getJdbcToJavaNativeMap();
        return (String)jdbcToJavaNativeMap.get(DECIMAL);
    }

    protected static String getJavaNative(String jdbcType) {
        if (!_initialized) {
            TypeMap.initialize();
        }
        if (!_jdbcTypeToJavaNativeMap.containsKey(jdbcType)) {
            String msg = "_jdbcTypeToJavaNativeMap doesn't contain the type as key: ";
            msg = msg + "key=" + jdbcType + " map=" + _jdbcTypeToJavaNativeMap;
            _log.warn((Object)msg);
            throw new IllegalStateException(msg);
        }
        return _jdbcTypeToJavaNativeMap.get(jdbcType);
    }

    protected static String getFlexNative(String javaNative) {
        if (!_initialized) {
            TypeMap.initialize();
        }
        if (!_javaNativeToFlexNativeMap.containsKey(javaNative)) {
            String msg = "_javaNativeToFlexNativeMap doesn't contain the type as key: ";
            msg = msg + "key=" + javaNative + " map=" + _javaNativeToFlexNativeMap;
            _log.warn((Object)msg);
            throw new IllegalStateException(msg);
        }
        return _javaNativeToFlexNativeMap.get(javaNative);
    }

    static {
        TypeMap.setupPropertyNativeMap();
        _initialized = false;
    }
}

