/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.model;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.ConstraintNameGenerator;
import org.apache.torque.engine.database.model.JavaNameGenerator;
import org.apache.torque.engine.database.model.NameGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameFactory {
    public static final String JAVA_GENERATOR = JavaNameGenerator.class.getName();
    public static final String CONSTRAINT_GENERATOR = ConstraintNameGenerator.class.getName();
    private static NameFactory instance = new NameFactory();
    private Hashtable<String, NameGenerator> algorithms = new Hashtable(5);

    protected NameFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NameGenerator getAlgorithm(String name) throws EngineException {
        Hashtable<String, NameGenerator> hashtable = this.algorithms;
        synchronized (hashtable) {
            NameGenerator algorithm = this.algorithms.get(name);
            if (algorithm == null) {
                try {
                    algorithm = (NameGenerator)Class.forName(name).newInstance();
                }
                catch (InstantiationException e) {
                    throw new EngineException("Unable to instantiate class " + name + ": Make sure it's in your run-time classpath", e);
                }
                catch (Exception e) {
                    throw new EngineException(e);
                }
                this.algorithms.put(name, algorithm);
            }
            return algorithm;
        }
    }

    public static String generateName(String algorithmName, List<?> inputs) throws EngineException {
        NameGenerator algorithm = instance.getAlgorithm(algorithmName);
        return algorithm.generateName(inputs);
    }

    public static String generateJavaNameByMethodUnderscore(String name) {
        try {
            NameGenerator algorithm = instance.getAlgorithm(JAVA_GENERATOR);
            ArrayList<String> inputs = new ArrayList<String>();
            inputs.add(name);
            inputs.add("underscore");
            return algorithm.generateName(inputs);
        }
        catch (EngineException e) {
            String msg = "generateName() threw the exception: name=" + name;
            throw new RuntimeException(msg, (Throwable)((Object)e));
        }
    }
}

