/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.NameFactory;
import org.apache.torque.engine.database.model.Table;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Index {
    public static final Integer FIRST_POSITION = 1;
    private String _indexName;
    private Table _table;
    private final Map<Integer, String> _indexColumnMap = new LinkedHashMap<Integer, String>();

    private void createName() throws EngineException {
        Table table = this.getTable();
        ArrayList<Object> inputs = new ArrayList<Object>(4);
        inputs.add(table.getDatabase());
        inputs.add(table.getName());
        if (this.isUnique()) {
            inputs.add("U");
        } else {
            inputs.add("I");
        }
        inputs.add(new Integer(table.getIndices().length + 1));
        this._indexName = NameFactory.generateName(NameFactory.CONSTRAINT_GENERATOR, inputs);
    }

    public void loadFromXML(Attributes attrib) {
        this._indexName = attrib.getValue("name");
    }

    public void addColumn(Attributes attrib) {
        String columnName = attrib.getValue("name");
        String ordinalPositionString = attrib.getValue("position");
        Integer ordinalPosition = Integer.parseInt(ordinalPositionString);
        this._indexColumnMap.put(ordinalPosition, columnName);
    }

    public boolean hasSameColumnSet(List<Column> columnList) {
        for (Column column : columnList) {
            if (this.getIndexColumnMap().containsValue(column.getName())) continue;
            return false;
        }
        return this.getIndexColumnMap().size() == columnList.size();
    }

    public boolean hasSameFirstColumn(Column column) {
        String first = this.getIndexColumnMap().get(FIRST_POSITION);
        if (first == null) {
            return false;
        }
        return first.equalsIgnoreCase(column.getName());
    }

    public boolean hasSameColumn(Column column) {
        Map<Integer, String> indexColumnMap = this.getIndexColumnMap();
        Set<Map.Entry<Integer, String>> entrySet = indexColumnMap.entrySet();
        for (Map.Entry<Integer, String> entry : entrySet) {
            String columnName = entry.getValue();
            if (!column.getName().equalsIgnoreCase(columnName)) continue;
            return true;
        }
        return false;
    }

    public boolean isUnique() {
        return false;
    }

    public boolean isTwoOrMoreColumn() {
        return this._indexColumnMap.size() > 1;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(" <index name=\"").append(this.getName()).append("\"");
        result.append(">\n");
        Set<Integer> keySet = this._indexColumnMap.keySet();
        for (Integer position : keySet) {
            String columnName = this._indexColumnMap.get(position);
            result.append("  <index-column name=\"").append(columnName).append("\" position=\"" + position + "\"/>\n");
        }
        result.append(" </index>\n");
        return result.toString();
    }

    public String getName() {
        if (this._indexName == null) {
            try {
                this.createName();
            }
            catch (EngineException engineException) {
                // empty catch block
            }
        }
        return this._indexName;
    }

    public void setName(String indexName) {
        this._indexName = indexName;
    }

    public Table getTable() {
        return this._table;
    }

    public void setTable(Table parent) {
        this._table = parent;
    }

    public Map<Integer, String> getIndexColumnMap() {
        return this._indexColumnMap;
    }

    public void addColumn(String columnName) {
        Integer position = this._indexColumnMap.isEmpty() ? FIRST_POSITION : Integer.valueOf(this._indexColumnMap.size() + 1);
        this._indexColumnMap.put(position, columnName);
    }
}

