/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.testing;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.TransactionManager;
import junit.framework.TestCase;
import org.seasar.cms.pluggable.Configuration;
import org.seasar.cms.pluggable.impl.ConfigurationImpl;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.kvasir.util.ClassUtils;
import org.seasar.kvasir.util.io.Resource;
import org.seasar.kvasir.util.io.impl.FileResource;
import org.seasar.ymir.Dispatcher;
import org.seasar.ymir.FormFile;
import org.seasar.ymir.HttpMethod;
import org.seasar.ymir.Path;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.Ymir;
import org.seasar.ymir.YmirContext;
import org.seasar.ymir.id.action.GetAction;
import org.seasar.ymir.message.Notes;
import org.seasar.ymir.mock.servlet.MockFilterChain;
import org.seasar.ymir.mock.servlet.MockFilterChainImpl;
import org.seasar.ymir.mock.servlet.MockHttpServletRequest;
import org.seasar.ymir.mock.servlet.MockHttpServletRequestImpl;
import org.seasar.ymir.mock.servlet.MockHttpServletResponse;
import org.seasar.ymir.mock.servlet.MockHttpServletResponseImpl;
import org.seasar.ymir.mock.servlet.MockHttpSession;
import org.seasar.ymir.mock.servlet.MockRequestDispatcherImpl;
import org.seasar.ymir.mock.servlet.MockServletContext;
import org.seasar.ymir.mock.servlet.MockServletContextImpl;
import org.seasar.ymir.mock.servlet.RequestDispatcherFactory;
import org.seasar.ymir.servlet.YmirListener;
import org.seasar.ymir.testing.RequestInitializer;
import org.seasar.ymir.util.ContainerUtils;
import org.seasar.ymir.util.ServletUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class YmirTestCase
extends TestCase {
    private static final String DEFAULT_WEBAPPROOT = "src/main/webapp";
    private static final Object[] EMPTY_PARAMS = new Object[0];
    private String characterEncoding_ = "UTF-8";
    private String contextPath_ = "/context";
    private Locale locale_ = new Locale("");
    private String webappRoot_ = "src/main/webapp";
    private String[] additionalConfigPaths_;
    private S2Container container_;
    private YmirListener ymirListener_;
    private MockServletContext servletContext_;
    private Ymir ymir_;
    private MockHttpServletRequest httpRequest_;
    private MockHttpServletResponse httpResponse_;

    public void setUpEnvironment() {
    }

    public String getCharacterEncoding() {
        return this.characterEncoding_;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding_ = characterEncoding;
    }

    public String getContextPath() {
        return this.contextPath_;
    }

    public void setContextPath(String contextPath) {
        this.contextPath_ = contextPath;
    }

    public Locale getLocale() {
        return this.locale_;
    }

    public void setLocale(Locale locale) {
        this.locale_ = locale;
    }

    public void setWebappRoot(String webappRoot) {
        this.webappRoot_ = webappRoot;
    }

    public String[] getAdditionalConfigPaths() {
        return this.additionalConfigPaths_;
    }

    public void setAdditionalConfigPaths(String ... additionalConfigPaths) {
        this.additionalConfigPaths_ = additionalConfigPaths;
    }

    public void setUpConfiguration(Configuration configuration) {
    }

    public void disableBeginCheck(Configuration configuration) {
        configuration.setProperty("core.conversation.disableBeginCheck", String.valueOf(true));
    }

    public void useSessionScopeAsConversationScope(Configuration configuration) {
        configuration.setProperty("core.conversation.useSessionScopeAsConversationScope", String.valueOf(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        this.setUpYmir();
        try {
            this.setUp();
            try {
                this.runTest();
            }
            finally {
                this.tearDown();
            }
        }
        finally {
            this.tearDownYmir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest() throws Throwable {
        TransactionManager tm = null;
        if (this.needTransaction()) {
            try {
                tm = this.getComponent(TransactionManager.class);
                tm.begin();
            }
            catch (Throwable t) {
                System.err.println(t);
            }
        }
        try {
            super.runTest();
        }
        finally {
            if (tm != null) {
                tm.rollback();
            }
        }
    }

    protected boolean needTransaction() {
        return this.getName().endsWith("Tx");
    }

    protected void setUpYmir() {
        this.servletContext_ = new MockServletContextImpl(this.getContextPath());
        this.servletContext_.setRequestDispatcherFactory((RequestDispatcherFactory)new InternalRequestDispatcherFactory());
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("app.properties");
        if (resource == null) {
            throw new RuntimeException("'app.properties' not found.");
        }
        this.servletContext_.setRoot((Resource)new FileResource(this.findWebappRoot(ClassUtils.getFileOfResource((URL)resource).getParentFile())));
        this.servletContext_.setInitParameter("org.seasar.framework.container.configPath", "ymir.dicon");
        this.ymirListener_ = new YmirListener(){

            public void preInit(ServletContextEvent sce) {
                ConfigurationImpl configuration = (ConfigurationImpl)SingletonS2ContainerFactory.getContainer().getComponent(ConfigurationImpl.class);
                if (YmirTestCase.this.additionalConfigPaths_ != null) {
                    for (String configPath : YmirTestCase.this.additionalConfigPaths_) {
                        configuration.load(configPath);
                    }
                }
                YmirTestCase.this.setUpConfiguration((Configuration)configuration);
                super.preInit(sce);
            }
        };
        this.ymirListener_.contextInitialized(new ServletContextEvent((ServletContext)this.servletContext_));
        this.container_ = SingletonS2ContainerFactory.getContainer();
        this.ymir_ = YmirContext.getYmir();
    }

    public void setUp() {
    }

    File findWebappRoot(File dir) {
        return new File(this.findProjectRoot(dir), this.webappRoot_);
    }

    File findProjectRoot(File file) {
        File f = file;
        do {
            if (!new File(f, "pom.xml").exists()) continue;
            return f;
        } while ((f = f.getParentFile()) != null);
        return file;
    }

    protected void tearDownYmir() {
        this.ymirListener_.contextDestroyed(new ServletContextEvent((ServletContext)this.servletContext_));
    }

    public S2Container getContainer(String path) throws IllegalArgumentException {
        S2Container container = this.findContainer(path, this.getContainer());
        if (container == null) {
            throw new IllegalArgumentException("Can't find container: " + path);
        }
        return container;
    }

    private S2Container findContainer(String path, S2Container container) {
        if (container.getPath().endsWith("/" + path)) {
            return container;
        }
        int size = container.getChildSize();
        for (int i = 0; i < size; ++i) {
            S2Container c = this.findContainer(path, container.getChild(i));
            if (c == null) continue;
            return c;
        }
        return null;
    }

    public Object getComponent(Object componentKey) {
        return this.getContainer().getComponent(componentKey);
    }

    public <T> T getComponent(Class<T> componentClass) {
        return (T)this.getContainer().getComponent(componentClass);
    }

    public S2Container getContainer() {
        return this.container_;
    }

    public Ymir getYmir() {
        return this.ymir_;
    }

    public ServletContext getServletContext() {
        return this.servletContext_;
    }

    public MockHttpServletRequest getHttpServletRequest() {
        return this.httpRequest_;
    }

    public MockHttpSession getHttpSession() {
        return this.getHttpSession(true);
    }

    public MockHttpSession getHttpSession(boolean create) {
        return (MockHttpSession)this.getHttpServletRequest().getSession(create);
    }

    public MockHttpServletResponse getHttpServletResponse() {
        return this.httpResponse_;
    }

    public void process(ServletContext servletContext, HttpServletRequest httpRequest, HttpServletResponse httpResponse, Dispatcher dispatcher, String path, HttpMethod method, Map<String, FormFile[]> fileParameterMap, FilterChain chain) throws IOException, ServletException {
        this.ymir_.process(servletContext, httpRequest, httpResponse, dispatcher, path, method, fileParameterMap, chain);
    }

    public FilterChain process(String path) throws IOException, ServletException {
        return this.process(path, HttpMethod.GET, (RequestInitializer)null, null, (String)null, EMPTY_PARAMS);
    }

    public FilterChain process(String path, String param, Object ... params) throws IOException, ServletException {
        return this.process(path, HttpMethod.GET, (RequestInitializer)null, null, param, params);
    }

    public FilterChain process(String path, Class<? extends GetAction> actionInterface, Object ... params) throws IOException, ServletException {
        return this.process(path, HttpMethod.GET, (RequestInitializer)null, null, actionInterface, params);
    }

    public FilterChain process(String path, HttpMethod method) throws IOException, ServletException {
        return this.process(path, method, (RequestInitializer)null, null, (String)null, EMPTY_PARAMS);
    }

    public FilterChain process(String path, HttpMethod method, String param, Object ... params) throws IOException, ServletException {
        return this.process(path, method, (RequestInitializer)null, null, param, params);
    }

    public FilterChain process(String path, HttpMethod method, Class<? extends GetAction> actionInterface, Object ... params) throws IOException, ServletException {
        return this.process(path, method, (RequestInitializer)null, null, actionInterface, params);
    }

    public FilterChain process(String path, RequestInitializer initializer) throws IOException, ServletException {
        return this.process(path, HttpMethod.GET, initializer, null, (String)null, EMPTY_PARAMS);
    }

    public FilterChain process(String path, RequestInitializer initializer, String param, Object ... params) throws IOException, ServletException {
        return this.process(path, HttpMethod.GET, initializer, null, param, params);
    }

    public FilterChain process(String path, RequestInitializer initializer, Class<? extends GetAction> actionInterface, Object ... params) throws IOException, ServletException {
        return this.process(path, HttpMethod.GET, initializer, null, actionInterface, params);
    }

    public FilterChain process(String path, MockFilterChain chain) throws IOException, ServletException {
        return this.process(path, HttpMethod.GET, (RequestInitializer)null, chain, (String)null, EMPTY_PARAMS);
    }

    public FilterChain process(String path, MockFilterChain chain, String param, Object ... params) throws IOException, ServletException {
        return this.process(path, HttpMethod.GET, (RequestInitializer)null, chain, param, params);
    }

    public FilterChain process(String path, MockFilterChain chain, Class<? extends GetAction> actionInterface, Object ... params) throws IOException, ServletException {
        return this.process(path, HttpMethod.GET, (RequestInitializer)null, chain, actionInterface, params);
    }

    public FilterChain process(String path, HttpMethod method, RequestInitializer initializer, MockFilterChain chain) throws IOException, ServletException {
        return this.process(path, method, initializer, chain, (String)null, EMPTY_PARAMS);
    }

    public FilterChain process(String path, HttpMethod method, RequestInitializer initializer, MockFilterChain chain, String param, Object ... params) throws IOException, ServletException {
        if (chain == null) {
            chain = new MockFilterChainImpl();
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (param != null) {
            paramList.add(param);
        }
        if (params != null) {
            paramList.addAll(Arrays.asList(params));
        }
        params = paramList.toArray();
        LinkedHashMap parameterMap = new LinkedHashMap();
        LinkedHashMap<String, FormFile[]> fileParameterMap = new LinkedHashMap<String, FormFile[]>();
        for (int i = 0; i < params.length; i += 2) {
            Object value = i + 1 < params.length ? params[i + 1] : "";
            ServletUtils.addParameter((Object)params[i], (Object)value, parameterMap, fileParameterMap);
        }
        Path p = new Path(path, this.getCharacterEncoding());
        for (Map.Entry entry : parameterMap.entrySet()) {
            for (String value : (String[])entry.getValue()) {
                p.addParameter((String)entry.getKey(), value);
            }
        }
        String actualPath = p.asString();
        this.acceptRequest(actualPath, method, initializer);
        this.process(this.getServletContext(), (HttpServletRequest)this.getHttpServletRequest(), (HttpServletResponse)this.getHttpServletResponse(), Dispatcher.REQUEST, ServletUtils.getNativePath((HttpServletRequest)this.getHttpServletRequest()), method, fileParameterMap, (FilterChain)chain);
        if (chain.isCalled()) {
            return chain;
        }
        return null;
    }

    public FilterChain process(String path, HttpMethod method, RequestInitializer initializer, MockFilterChain chain, Class<? extends GetAction> actionInterface, Object ... params) throws IOException, ServletException {
        Object[] pms = new Object[1 + params.length];
        pms[0] = "";
        System.arraycopy(params, 0, pms, 1, params.length);
        try {
            return this.process(path, method, initializer, chain, (String)actionInterface.getField("KEY").get(null), pms);
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot get action key from action method '" + actionInterface + "'. Try to re-generate Page class.", t);
        }
    }

    public FilterChain toTheEndOf(FilterChain chain) throws IOException, ServletException {
        if (chain != null) {
            return chain;
        }
        MockHttpServletResponse httpResponse = this.getHttpServletResponse();
        if (httpResponse == null) {
            return chain;
        }
        String redirectPath = httpResponse.getRedirectPath();
        if (redirectPath == null) {
            return chain;
        }
        if (!redirectPath.startsWith(this.getContextPath() + "/")) {
            return chain;
        }
        return this.toTheEndOf(this.process(redirectPath.substring(this.getContextPath().length())));
    }

    public FilterChain process(Class<?> pageClass) throws IOException, ServletException {
        return this.process(this.getPathOfPageClass(pageClass));
    }

    public FilterChain process(Class<?> pageClass, String param, Object ... params) throws IOException, ServletException {
        return this.process(this.getPathOfPageClass(pageClass), param, params);
    }

    public FilterChain process(Class<?> pageClass, Class<? extends GetAction> actionInterface, Object ... params) throws IOException, ServletException {
        return this.process(this.getPathOfPageClass(pageClass), actionInterface, params);
    }

    public FilterChain process(Class<?> pageClass, HttpMethod method) throws IOException, ServletException {
        return this.process(this.getPathOfPageClass(pageClass), method);
    }

    public FilterChain process(Class<?> pageClass, HttpMethod method, String param, Object ... params) throws IOException, ServletException {
        return this.process(this.getPathOfPageClass(pageClass), method, param, params);
    }

    public FilterChain process(Class<?> pageClass, RequestInitializer initializer) throws IOException, ServletException {
        return this.process(this.getPathOfPageClass(pageClass), initializer);
    }

    public FilterChain process(Class<?> pageClass, RequestInitializer initializer, String param, Object ... params) throws IOException, ServletException {
        return this.process(this.getPathOfPageClass(pageClass), initializer, param, params);
    }

    public FilterChain process(Class<?> pageClass, MockFilterChain chain) throws IOException, ServletException {
        return this.process(this.getPathOfPageClass(pageClass), chain);
    }

    public FilterChain process(Class<?> pageClass, MockFilterChain chain, String param, Object ... params) throws IOException, ServletException {
        return this.process(this.getPathOfPageClass(pageClass), chain, param, params);
    }

    public FilterChain process(Class<?> pageClass, HttpMethod method, RequestInitializer initializer, MockFilterChain chain) throws IOException, ServletException {
        return this.process(this.getPathOfPageClass(pageClass), method, initializer, chain);
    }

    public FilterChain process(Class<?> pageClass, HttpMethod method, RequestInitializer initializer, MockFilterChain chain, String param, Object ... params) throws IOException, ServletException {
        return this.process(this.getPathOfPageClass(pageClass), method, initializer, chain, param, params);
    }

    public void acceptRequest(String path, HttpMethod method, RequestInitializer requestInitializer) {
        MockHttpSession session = null;
        if (this.httpRequest_ != null) {
            session = (MockHttpSession)this.httpRequest_.getSession(false);
        }
        this.httpRequest_ = this.newHttpServletRequest(this.servletContext_, method, path, session);
        try {
            this.httpRequest_.setCharacterEncoding(this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        this.httpRequest_.setLocale(this.getLocale());
        this.httpRequest_.setRequestDispatcherFactory((RequestDispatcherFactory)new InternalRequestDispatcherFactory());
        this.httpResponse_ = this.newHttpServletResponse(this.httpRequest_);
        ContainerUtils.setRequest((S2Container)this.container_, (HttpServletRequest)this.httpRequest_);
        ContainerUtils.setResponse((S2Container)this.container_, (HttpServletResponse)this.httpResponse_);
        if (requestInitializer != null) {
            requestInitializer.initialize();
        }
    }

    public final Class<?> getPageClass(String path) {
        Class pageClass = this.ymir_.getPageClassOfPath(path);
        if (pageClass == null) {
            throw new IllegalArgumentException("Can't find page class corresponding path (" + path + ")");
        }
        return pageClass;
    }

    public final String getPathOfPageClass(Class<?> pageClass) {
        String path = this.ymir_.getPathOfPageClass(pageClass);
        if (path == null) {
            throw new IllegalArgumentException("Can't find path corresponding page class (" + pageClass.getName() + ")");
        }
        return path;
    }

    protected MockHttpServletResponse newHttpServletResponse(MockHttpServletRequest httpRequest) {
        return new MockHttpServletResponseImpl((HttpServletRequest)httpRequest);
    }

    protected MockHttpServletRequest newHttpServletRequest(MockServletContext servletContext, HttpMethod method, String path, MockHttpSession session) {
        return new MockHttpServletRequestImpl((ServletContext)servletContext, method.name(), path, session);
    }

    public Notes getNotes() {
        return (Notes)this.httpRequest_.getAttribute("notes");
    }

    public Request getRequest() {
        return (Request)this.httpRequest_.getAttribute("org.seasar.ymir..request");
    }

    public Response getResponse() {
        return (Response)this.httpRequest_.getAttribute("org.seasar.ymir..response");
    }

    protected <P> P getPage(Class<? extends P> pageClass) {
        return this.getComponent(pageClass);
    }

    protected class InternalRequestDispatcher
    extends MockRequestDispatcherImpl {
        public InternalRequestDispatcher(String path, HttpServletRequest request) {
            super(path, request);
        }

        public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            super.forward(request, response);
            YmirTestCase.this.process((ServletContext)YmirTestCase.this.servletContext_, (HttpServletRequest)YmirTestCase.this.httpRequest_, (HttpServletResponse)YmirTestCase.this.httpResponse_, Dispatcher.FORWARD, ServletUtils.getNativePath((HttpServletRequest)YmirTestCase.this.getHttpServletRequest()), HttpMethod.enumOf((String)YmirTestCase.this.httpRequest_.getMethod()), null, (FilterChain)new MockFilterChainImpl());
        }

        public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            super.include(request, response);
            YmirTestCase.this.process((ServletContext)YmirTestCase.this.servletContext_, (HttpServletRequest)YmirTestCase.this.httpRequest_, (HttpServletResponse)YmirTestCase.this.httpResponse_, Dispatcher.INCLUDE, ServletUtils.getNativePath((HttpServletRequest)YmirTestCase.this.getHttpServletRequest()), HttpMethod.enumOf((String)YmirTestCase.this.httpRequest_.getMethod()), null, (FilterChain)new MockFilterChainImpl());
        }
    }

    protected class InternalRequestDispatcherFactory
    implements RequestDispatcherFactory {
        protected InternalRequestDispatcherFactory() {
        }

        public RequestDispatcher newInstance(String path, HttpServletRequest request) {
            return new InternalRequestDispatcher(path, request);
        }
    }
}

