/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.zpt;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.skirnir.freyja.EvaluationRuntimeException;
import net.skirnir.freyja.ExpressionEvaluator;
import net.skirnir.freyja.TagEvaluator;
import net.skirnir.freyja.TagEvaluatorWrapper;
import net.skirnir.freyja.TemplateContext;
import net.skirnir.freyja.TemplateEvaluator;
import net.skirnir.freyja.impl.TemplateEvaluatorImpl;
import net.skirnir.freyja.zpt.tales.PathResolver;
import net.skirnir.freyja.zpt.tales.TalesExpressionEvaluator;
import net.skirnir.freyja.zpt.tales.TypePrefixHandler;
import net.skirnir.freyja.zpt.webapp.PageTypePrefixHandler;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.ymir.HttpMethod;
import org.seasar.ymir.Request;
import org.seasar.ymir.extension.creator.DescPool;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.extension.creator.Template;
import org.seasar.ymir.extension.creator.TemplateAnalyzer;
import org.seasar.ymir.extension.zpt.AnalyzerContext;
import org.seasar.ymir.extension.zpt.AnalyzerFormatTypePrefixHandler;
import org.seasar.ymir.extension.zpt.AnalyzerJavaTypePrefixHandler;
import org.seasar.ymir.extension.zpt.AnalyzerNotTypePrefixHandler;
import org.seasar.ymir.extension.zpt.AnalyzerPageTypePrefixHandler;
import org.seasar.ymir.extension.zpt.AnalyzerPathResolver;
import org.seasar.ymir.extension.zpt.AnalyzerTalTagEvaluator;
import org.seasar.ymir.extension.zpt.AnalyzerTemplateSet;
import org.seasar.ymir.extension.zpt.DefaultZpt;
import org.seasar.ymir.extension.zpt.Zpt;
import org.seasar.ymir.util.ServletUtils;
import org.seasar.ymir.zpt.YmirVariableResolver;

public class ZptAnalyzer
implements TemplateAnalyzer {
    private TemplateEvaluator evaluator_;
    private SourceCreator sourceCreator_;
    private Zpt zpt_;

    @Binding(bindingType=BindingType.MAY)
    public void setZpt(Zpt zpt) {
        this.zpt_ = zpt;
        this.setTemplateEvaluator(this.zpt_.getTemplateEvaluator());
    }

    @Binding(bindingType=BindingType.MUST)
    public void setSourceCreator(SourceCreator sourceCreator) {
        this.sourceCreator_ = sourceCreator;
    }

    @Binding(bindingType=BindingType.NONE)
    public void setTemplateEvaluator(TemplateEvaluator templateEvaluator) {
        Object tagEvaluator = templateEvaluator.getTagEvaluator();
        if (tagEvaluator instanceof TagEvaluatorWrapper) {
            ((TagEvaluatorWrapper)tagEvaluator).setTagEvaluator((TagEvaluator)this.newAnalyzerTalTagEvaluator());
        } else {
            tagEvaluator = this.newAnalyzerTalTagEvaluator();
        }
        ExpressionEvaluator expressionEvaluator = templateEvaluator.getExpressionEvaluator();
        if (expressionEvaluator instanceof TalesExpressionEvaluator) {
            TalesExpressionEvaluator evaluator = (TalesExpressionEvaluator)expressionEvaluator;
            evaluator.addTypePrefix("not", (TypePrefixHandler)new AnalyzerNotTypePrefixHandler()).addTypePrefix("page", (TypePrefixHandler)new AnalyzerPageTypePrefixHandler((PageTypePrefixHandler)evaluator.getTypePrefixHandler("page"))).addTypePrefix("java", (TypePrefixHandler)new AnalyzerJavaTypePrefixHandler()).addTypePrefix("format", (TypePrefixHandler)new AnalyzerFormatTypePrefixHandler());
            evaluator.addPathResolver((PathResolver)new AnalyzerPathResolver());
        }
        this.evaluator_ = new TemplateEvaluatorImpl(templateEvaluator.getTemplateParser(), tagEvaluator, expressionEvaluator, templateEvaluator.getTagRenderer());
    }

    synchronized Zpt getZpt() {
        if (this.zpt_ == null) {
            this.setZpt(new DefaultZpt());
        }
        return this.zpt_;
    }

    AnalyzerTalTagEvaluator newAnalyzerTalTagEvaluator() {
        return new AnalyzerTalTagEvaluator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyze(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, Request ymirRequest, String path, HttpMethod method, Template template, String className, DescPool pool, String[] ignoreVariables) {
        try {
            DescPool.setDefault(pool);
            Zpt zpt = this.getZpt();
            this.emulateZptYmirProcessResponse(request, response, ymirRequest);
            path = zpt.getTemplatePathResolver().resolve(ServletUtils.normalizePath((String)path), request);
            AnalyzerContext context = (AnalyzerContext)this.evaluator_.newContext();
            context.setPath(path);
            context.setIgnoreVariables(ignoreVariables);
            zpt.buildTemplateContext((TemplateContext)context, servletContext, request, response, Locale.getDefault(), path);
            context.setTemplateSet(new AnalyzerTemplateSet(this.evaluator_, context.getTemplateSet(), this.sourceCreator_, zpt.getTemplatePathResolver()));
            context.setSourceCreator(this.sourceCreator_);
            context.setMethod(method);
            context.setPageClassName(className);
            context.setRepeatedPropertyGeneratedAsList(this.sourceCreator_.getSourceCreatorSetting().isRepeatedPropertyGeneratedAsList());
            InputStream inputStream = null;
            try {
                inputStream = template.getInputStream();
                try {
                    this.evaluator_.evaluate((TemplateContext)context, (Reader)new InputStreamReader(inputStream, template.getEncoding()));
                }
                catch (EvaluationRuntimeException ex) {
                    ex.setTemplateName(template.getName());
                    throw ex;
                }
                context.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        finally {
            DescPool.setDefault(null);
        }
    }

    private void emulateZptYmirProcessResponse(HttpServletRequest request, HttpServletResponse response, Request ymirRequest) {
        String contentType = response.getContentType();
        if (contentType != null) {
            request.setAttribute("net.skirnir.freyja.responseContentType", (Object)contentType);
        }
        request.setAttribute("net.skirnir.freyja.variableResolver", (Object)new YmirVariableResolver(ymirRequest, request, this.sourceCreator_.getApplication().getS2Container()));
    }
}

