/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.zpt;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.skirnir.freyja.EvaluationRuntimeException;
import net.skirnir.freyja.VariableResolver;
import net.skirnir.freyja.zpt.ZptTemplateContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.ymir.HttpMethod;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.ClassHint;
import org.seasar.ymir.extension.creator.ClassType;
import org.seasar.ymir.extension.creator.DescPool;
import org.seasar.ymir.extension.creator.FormDesc;
import org.seasar.ymir.extension.creator.PropertyDesc;
import org.seasar.ymir.extension.creator.PropertyTypeHint;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.extension.creator.TypeDesc;
import org.seasar.ymir.extension.creator.impl.ClassDescImpl;
import org.seasar.ymir.extension.creator.util.DescUtils;
import org.seasar.ymir.extension.creator.util.type.Token;
import org.seasar.ymir.extension.creator.util.type.TokenVisitor;
import org.seasar.ymir.extension.creator.util.type.TypeToken;
import org.seasar.ymir.extension.zpt.AnalyzerVariableResolver;
import org.seasar.ymir.extension.zpt.DescWrapper;
import org.seasar.ymir.util.BeanUtils;
import org.seasar.ymir.util.ClassUtils;
import org.seasar.ymir.util.FlexibleList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyzerContext
extends ZptTemplateContext {
    private static final String MULTIPLE_SUFFIX = "ies";
    private static final String SINGULAR_SUFFIX = "y";
    private static final String MULTIPLE_SUFFIX2 = "s";
    private static final String SINGULAR_SUFFIX2 = "";
    static final char CHAR_ARRAY_LPAREN = '[';
    static final char CHAR_ARRAY_RPAREN = ']';
    private static final String PROP_LENGTH = "length";
    private static final String PROP_SIZE = "size";
    public static final int PROBABILITY_BOOLEAN_ATTRIBUTE = 2000;
    public static final int PROBABILITY_NAME = 3000;
    public static final int PROBABILITY_COMPONENT_TYPE = 3000;
    public static final int PROBABILITY_COLLECTION = 4000;
    public static final int PROBABILITY_TYPE = 5000;
    private SourceCreator sourceCreator_;
    private HttpMethod method_;
    private String pageClassName_;
    private FormDesc formDesc_;
    private boolean repeatedPropertyGeneratedAsList_;
    private VariableResolver variableResolver_;
    private Set<String> usedClassNameSet_ = new HashSet<String>();
    private Set<String> ignoreVariableSet_ = new HashSet<String>();
    private String path_;
    private Stack<Map<String, String>> variableExpressions_ = new Stack();
    private Map<String, String> globalVariableExpression_ = new HashMap<String, String>();
    private int repeatDepth_;
    private static final Log log_ = LogFactory.getLog(AnalyzerContext.class);

    public VariableResolver getVariableResolver() {
        if (this.variableResolver_ == null) {
            this.variableResolver_ = new AnalyzerVariableResolver(super.getVariableResolver());
        }
        return this.variableResolver_;
    }

    public void setVariableResolver(VariableResolver varResolver) {
        super.setVariableResolver(varResolver);
        this.variableResolver_ = null;
    }

    public void setIgnoreVariables(String[] ignoreVariables) {
        if (ignoreVariables == null) {
            this.ignoreVariableSet_.clear();
        } else {
            this.ignoreVariableSet_.addAll(Arrays.asList(ignoreVariables));
        }
    }

    public boolean shouldIgnoreVariable(String name) {
        return this.ignoreVariableSet_.contains(name);
    }

    public void defineVariable(int scope, String name, Object value) {
        if (value instanceof DescWrapper) {
            ((DescWrapper)value).setVariableName(name, false, null, 3000);
        }
        super.defineVariable(scope, name, value);
    }

    public ZptTemplateContext.RepeatInfo pushRepeatInfo(String name, Object[] objs) {
        ++this.repeatDepth_;
        if (objs != null && objs.length == 1 && objs[0] instanceof DescWrapper) {
            DescWrapper wrapper = (DescWrapper)objs[0];
            wrapper.setVariableName(name, true, this.repeatedPropertyGeneratedAsList_ ? List.class.getName() : null, 3000);
            PropertyDesc pd = wrapper.getPropertyDesc();
            ClassDesc valueClassDesc = pd != null ? pd.getTypeDesc().getComponentClassDesc() : wrapper.getValueClassDesc();
            objs[0] = new DescWrapper(this, valueClassDesc);
        }
        return super.pushRepeatInfo(name, objs);
    }

    public PropertyDesc addProperty(ClassDesc classDesc, String propertyName, int mode, String propertyTypeAlias, boolean asCollection, String collectionClassName, int probability) {
        TypeDesc typeDesc;
        PropertyDesc propertyDesc = classDesc.addProperty(propertyName, mode);
        if (log_.isDebugEnabled()) {
            log_.debug((Object)("Adding property '" + propertyName + "' (object path is '" + this.getPathExpression(propertyDesc) + "' ..."));
        }
        if (propertyDesc.getTypeDesc().isExplicit()) {
            if (log_.isDebugEnabled()) {
                log_.debug((Object)"Nothing has been done because type of this property had been explicitly set.");
            }
            return propertyDesc;
        }
        if (propertyDesc.isTypeAlreadySet(probability)) {
            if (log_.isDebugEnabled()) {
                log_.debug((Object)"Nothing has been done because type of this property had been set.");
            }
            return propertyDesc;
        }
        String groupName = null;
        String className = classDesc.getName();
        PropertyTypeHint hint = this.getPropertyTypeHint(className, propertyName);
        if (hint != null) {
            typeDesc = classDesc.getDescPool().newTypeDesc(hint.getTypeName());
            typeDesc.setExplicit(true);
            probability = Integer.MAX_VALUE;
            groupName = this.getGroupName(propertyTypeAlias != null ? propertyTypeAlias : (asCollection ? this.toSingular(propertyName) : propertyName), typeDesc.getComponentClassDesc().getName());
        } else {
            PropertyDescriptor descriptor = this.sourceCreator_.getPropertyDescriptor(className, propertyName);
            if (descriptor != null) {
                String componentClassName;
                Method readMethod = descriptor.getReadMethod();
                if (readMethod != null) {
                    propertyDesc.setGetterName(readMethod.getName());
                }
                Class<?> componentClass = this.sourceCreator_.getClass(DescUtils.getComponentPropertyTypeName(descriptor));
                String interfaceClassName = null;
                if (componentClass.isInterface()) {
                    String gn = this.findGroupName(propertyDesc);
                    componentClassName = this.findPropertyClassName(propertyTypeAlias != null ? propertyTypeAlias : (gn != null ? gn + ClassUtils.getShorterName(componentClass) : Introspector.decapitalize(ClassUtils.getShorterName(componentClass))), className);
                    if (gn != null) {
                        probability = 5000;
                    }
                    interfaceClassName = componentClass.getName();
                } else {
                    componentClassName = componentClass.getName();
                    probability = 5000;
                    groupName = this.getGroupName(propertyTypeAlias != null ? propertyTypeAlias : (asCollection ? this.toSingular(propertyName) : propertyName), componentClassName);
                }
                String typeName = DescUtils.getGenericPropertyTypeName(descriptor);
                if (Collection.class.isAssignableFrom(descriptor.getPropertyType())) {
                    TypeToken typeToken = new TypeToken(typeName);
                    typeToken.getTypes()[0].setBaseName(componentClassName);
                    typeDesc = classDesc.getDescPool().newTypeDesc(typeToken.getAsString());
                } else {
                    typeDesc = descriptor.getPropertyType().isArray() ? classDesc.getDescPool().newTypeDesc(componentClassName + "[]") : classDesc.getDescPool().newTypeDesc(componentClassName);
                }
                if (interfaceClassName != null) {
                    typeDesc.getComponentClassDesc().setInterfaceTypeDescs(new TypeDesc[]{classDesc.getDescPool().newTypeDesc(interfaceClassName)});
                }
            } else {
                String seed = propertyTypeAlias != null ? propertyTypeAlias : (asCollection ? this.toSingular(propertyName) : propertyName);
                typeDesc = classDesc.getDescPool().newTypeDesc(this.inferPropertyClassName(seed, className));
                if (asCollection) {
                    this.setToCollection(typeDesc, collectionClassName);
                }
                groupName = this.getGroupName(seed, typeDesc.getComponentClassDesc().getName());
            }
        }
        if (groupName != null) {
            typeDesc.getComponentClassDesc().setAttribute("groupName", groupName);
        }
        if (typeDesc.isCollection() && List.class.getName().equals(typeDesc.getCollectionClassName())) {
            typeDesc.setCollectionImplementationClassName(propertyDesc.getTypeDesc().getCollectionImplementationClassName());
        }
        propertyDesc.setTypeDesc(typeDesc);
        propertyDesc.notifyTypeUpdated(probability);
        if (log_.isDebugEnabled()) {
            log_.debug((Object)("This' property's type has been inferred as '" + typeDesc + "'"));
        }
        return propertyDesc;
    }

    private String findGroupName(PropertyDesc propertyDesc) {
        for (PropertyDesc desc = propertyDesc; desc != null; desc = desc.getParent()) {
            String groupName;
            if (!(desc instanceof ClassDesc) || (groupName = (String)((ClassDesc)((Object)desc)).getAttribute("groupName")) == null) continue;
            return groupName;
        }
        return null;
    }

    private String getGroupName(String seed, String className) {
        if (!this.isOnDtoSearchPath(className)) {
            return null;
        }
        String suffix = ClassUtils.getShorterName((String)className);
        if (seed.endsWith(suffix)) {
            return seed.substring(0, seed.length() - suffix.length());
        }
        return null;
    }

    public PropertyDesc addProperty(ClassDesc classDesc, String propertyName, int mode) {
        return this.addProperty(classDesc, propertyName, mode, null, false, null, 1000);
    }

    public String inferPropertyClassName(String propertyName, String baseClassName) {
        String className = this.findPropertyClassName(propertyName, baseClassName);
        if (this.sourceCreator_.getClass(className) != null) {
            return className;
        }
        String classNameFromSearchPath = this.sourceCreator_.getSourceCreatorSetting().findDtoClassName(propertyName);
        if (classNameFromSearchPath != null) {
            className = classNameFromSearchPath;
        }
        return className;
    }

    public String findPropertyClassName(String propertyName, String baseClassName) {
        String rootPackageName;
        if (baseClassName == null) {
            baseClassName = this.pageClassName_;
        }
        if (baseClassName.startsWith((rootPackageName = this.sourceCreator_.getFirstRootPackageName()) + ".")) {
            String subPackageName = baseClassName.substring(rootPackageName.length(), baseClassName.lastIndexOf(46));
            int dot = subPackageName.indexOf(46, 1);
            subPackageName = dot >= 0 ? subPackageName.substring(dot) : SINGULAR_SUFFIX2;
            return this.findClassName(this.sourceCreator_.getDtoPackageName(), subPackageName, this.getDtoShortClassName(propertyName));
        }
        return this.findPropertyClassName(propertyName, this.pageClassName_);
    }

    private String findClassName(String packageName, String subPackageName, String shortClassName) {
        int idx;
        String fullClassName = packageName + subPackageName + "." + shortClassName;
        if (this.sourceCreator_.getClass(fullClassName) != null) {
            return fullClassName;
        }
        int pre = subPackageName.length();
        while ((idx = subPackageName.lastIndexOf(46, pre)) >= 0) {
            String className = packageName + subPackageName.substring(0, idx) + "." + shortClassName;
            if (this.sourceCreator_.getClass(className) != null) {
                return className;
            }
            pre = idx - 1;
        }
        return fullClassName;
    }

    String getDtoShortClassName(String propertyName) {
        if (propertyName == null) {
            return null;
        }
        return DescUtils.capFirst(propertyName) + ClassType.DTO.getSuffix();
    }

    public void popRepeatInfo(String name) {
        super.popRepeatInfo(name);
        --this.repeatDepth_;
    }

    public boolean isInRepeat() {
        return this.repeatDepth_ > 0;
    }

    public HttpMethod getMethod() {
        return this.method_;
    }

    public void setMethod(HttpMethod method) {
        this.method_ = method;
    }

    boolean isAvailable(String className) {
        return this.sourceCreator_.getClass(className) != null;
    }

    public String getPageClassName() {
        return this.pageClassName_;
    }

    public void setPageClassName(String pageClassName) {
        this.pageClassName_ = pageClassName;
    }

    public ClassDesc getPageClassDesc() {
        return DescPool.getDefault().getClassDesc(this.getPageClassName());
    }

    public SourceCreator getSourceCreator() {
        return this.sourceCreator_;
    }

    public void setSourceCreator(SourceCreator sourceCreator) {
        this.sourceCreator_ = sourceCreator;
    }

    public FormDesc getFormDesc() {
        return this.formDesc_;
    }

    public void setFormDesc(FormDesc formDesc) {
        this.formDesc_ = formDesc;
    }

    public void close() {
        this.getPageClassDesc();
        Iterator<ClassDesc> itr = DescPool.getDefault().iterator();
        while (itr.hasNext()) {
            ClassDesc classDesc = itr.next();
            if (this.isEmptyDto(classDesc)) {
                itr.remove();
                continue;
            }
            ClassHint hint = this.getClassHint(classDesc.getName());
            if (hint != null) {
                classDesc.setSuperclassName(hint.getSuperclassName());
            }
            classDesc.setBornOf(this.path_);
        }
        for (ClassDesc classDesc : DescPool.getDefault().getGeneratedClassDescs()) {
            for (PropertyDesc pd : classDesc.getPropertyDescs()) {
                if (pd.getTypeDesc().isExplicit()) continue;
                this.replaceSimpleDtoTypeToDefaultType(pd);
            }
        }
        HashSet<ClassDesc> usedClassDescSet = new HashSet<ClassDesc>();
        for (ClassDesc classDesc : DescPool.getDefault().getGeneratedClassDescs()) {
            if (!this.isPage(classDesc) && !this.isUsedClassName(classDesc.getName())) continue;
            this.registerDependingClassDescs(classDesc, usedClassDescSet);
        }
        Iterator<ClassDesc> itr2 = DescPool.getDefault().iterator();
        while (itr2.hasNext()) {
            ClassDesc classDesc;
            classDesc = itr2.next();
            if (usedClassDescSet.contains(classDesc) && !this.isOuter(classDesc)) continue;
            itr2.remove();
        }
    }

    public boolean isOnDtoSearchPath(String className) {
        return this.sourceCreator_.getSourceCreatorSetting().isOnDtoSearchPath(className);
    }

    void replaceSimpleDtoTypeToDefaultType(final PropertyDesc propertyDesc) {
        final TypeDesc typeDesc = propertyDesc.getTypeDesc();
        TypeToken typeToken = new TypeToken(typeDesc.getCompleteName());
        typeToken.accept(new TokenVisitor<Object>(){

            public Object visit(Token acceptor) {
                String componentName = DescUtils.getComponentName(acceptor.getBaseName());
                boolean array = DescUtils.isArray(acceptor.getBaseName());
                if (AnalyzerContext.this.isDto(componentName) && !typeDesc.getDescPool().contains(componentName)) {
                    acceptor.setBaseName(DescUtils.getClassName(propertyDesc.isMayBoolean() && propertyDesc.getReferCount() == 0 ? Boolean.TYPE.getName() : String.class.getName(), array));
                }
                return null;
            }
        });
        typeDesc.setName(typeToken.getAsString());
    }

    void registerDependingClassDescs(ClassDesc classDesc, Set<ClassDesc> usedClassDescSet) {
        if (!usedClassDescSet.add(classDesc)) {
            return;
        }
        for (PropertyDesc pd : classDesc.getPropertyDescs()) {
            for (String className : pd.getTypeDesc().getImportClassNames()) {
                ClassDesc cd = classDesc.getDescPool().getClassDesc(className);
                if (!this.sourceCreator_.isDtoClass(cd.getName())) continue;
                this.registerDependingClassDescs(cd, usedClassDescSet);
            }
        }
    }

    public boolean isOuter(ClassDesc classDesc) {
        return this.isOuter(classDesc.getName());
    }

    public boolean isOuter(String typeName) {
        return !this.sourceCreator_.isGeneratedClass(DescUtils.getNonGenericClassName(typeName));
    }

    private boolean isPage(ClassDesc classDesc) {
        return this.isTypeOf(classDesc, ClassType.PAGE);
    }

    private boolean isDto(String className) {
        return this.isDto(new ClassDescImpl(null, className));
    }

    private boolean isDto(ClassDesc classDesc) {
        return this.isTypeOf(classDesc, ClassType.DTO);
    }

    private boolean isTypeOf(ClassDesc classDesc, ClassType type) {
        return classDesc.isTypeOf(type) && !this.isOuter(classDesc);
    }

    private boolean isEmptyDto(ClassDesc classDesc) {
        return this.isTypeOf(classDesc, ClassType.DTO) && classDesc.isEmpty();
    }

    public PropertyDesc getRequestParameterPropertyDesc(ClassDesc classDesc, String requestParameterName, int mode) {
        int dot = requestParameterName.indexOf(46);
        if (dot < 0) {
            return this.getSingleRequestParameterPropertyDesc(classDesc, requestParameterName, mode);
        }
        String baseName = requestParameterName.substring(0, dot);
        PropertyDesc propertyDesc = this.getSingleRequestParameterPropertyDesc(classDesc, baseName, 1);
        this.replaceTypeToGeneratedClassIfNeedToAddProperty(propertyDesc, BeanUtils.getFirstSimpleSegment((String)requestParameterName.substring(dot + 1)), classDesc);
        return this.getRequestParameterPropertyDesc(propertyDesc.getTypeDesc().getComponentClassDesc(), requestParameterName.substring(dot + 1), mode);
    }

    public void replaceTypeToGeneratedClassIfNeedToAddProperty(PropertyDesc propertyDesc, String propertyName, ClassDesc classDesc) {
        if (!propertyDesc.getTypeDesc().isExplicit() && this.isOuter(propertyDesc.getTypeDesc().getComponentClassDesc()) && !this.hasProperty(propertyDesc.getTypeDesc().getComponentClassDesc().getName(), propertyName)) {
            TypeDesc typeDesc = classDesc.getDescPool().newTypeDesc(this.findPropertyClassName(propertyDesc.getName(), classDesc.getName()));
            propertyDesc.setTypeDesc(typeDesc);
            if (!propertyDesc.isTypeAlreadySet(1000)) {
                propertyDesc.notifyTypeUpdated(1000);
            }
        }
    }

    public boolean hasProperty(String className, String propertyName) {
        return this.sourceCreator_.getPropertyDescriptor(className, propertyName) != null;
    }

    private PropertyDesc getSingleRequestParameterPropertyDesc(ClassDesc classDesc, String requestParameterName, int mode) {
        boolean collection = false;
        String collectionClassName = null;
        String collectionImplementationClassName = null;
        int lparen = requestParameterName.indexOf(91);
        int rparen = requestParameterName.indexOf(93);
        if (lparen >= 0 && rparen > lparen) {
            collection = true;
            collectionClassName = List.class.getName();
            collectionImplementationClassName = FlexibleList.class.getName();
            requestParameterName = requestParameterName.substring(0, lparen);
        }
        PropertyDesc propertyDesc = classDesc.getPropertyDesc(requestParameterName);
        propertyDesc = this.addProperty(classDesc, requestParameterName, mode, null, collection, collectionClassName, 4000);
        if (collection) {
            propertyDesc.getTypeDesc().setCollectionImplementationClassName(collectionImplementationClassName);
        }
        propertyDesc.incrementReferCount();
        return propertyDesc;
    }

    private String toSingular(String name) {
        if (name == null) {
            return null;
        }
        if (name.endsWith(MULTIPLE_SUFFIX)) {
            return name.substring(0, name.length() - MULTIPLE_SUFFIX.length()) + SINGULAR_SUFFIX;
        }
        if (name.endsWith(MULTIPLE_SUFFIX2)) {
            return name.substring(0, name.length() - MULTIPLE_SUFFIX2.length()) + SINGULAR_SUFFIX2;
        }
        return name;
    }

    public boolean isUsedClassName(String className) {
        return this.usedClassNameSet_.contains(className);
    }

    public void setUsedClassName(String className) {
        this.usedClassNameSet_.add(className);
    }

    public String getPath() {
        return this.path_;
    }

    public void setPath(String path) {
        this.path_ = path;
    }

    public PropertyTypeHint getPropertyTypeHint(String className, String propertyName) {
        if (DescPool.getDefault().getHintBag() != null) {
            return DescPool.getDefault().getHintBag().getPropertyTypeHint(className, propertyName);
        }
        return null;
    }

    public ClassHint getClassHint(String className) {
        if (DescPool.getDefault().getHintBag() != null) {
            return DescPool.getDefault().getHintBag().getClassHint(className);
        }
        return null;
    }

    public void pushVariableScope() {
        super.pushVariableScope();
        this.variableExpressions_.push(new HashMap());
    }

    public void popVariableScope() {
        super.popVariableScope();
        this.variableExpressions_.pop();
    }

    public void defineVariableExpression(int scope, String name, String expression) {
        if (scope == 0) {
            this.variableExpressions_.peek().put(name, expression);
        } else if (scope == 1) {
            this.globalVariableExpression_.put(name, expression);
        } else {
            throw new EvaluationRuntimeException("Unknown scope: " + scope);
        }
    }

    public String getDefinedVariableExpression(String name) {
        String expression = null;
        if (!this.variableExpressions_.isEmpty()) {
            expression = this.variableExpressions_.peek().get(name);
        }
        if (expression == null) {
            expression = this.globalVariableExpression_.get(name);
        }
        return expression;
    }

    public boolean isRepeatedPropertyGeneratedAsList() {
        return this.repeatedPropertyGeneratedAsList_;
    }

    public void setRepeatedPropertyGeneratedAsList(boolean repeatedPropertyGeneratedAsList) {
        this.repeatedPropertyGeneratedAsList_ = repeatedPropertyGeneratedAsList;
    }

    public void setToCollection(TypeDesc typeDesc, String collectionClassName) {
        if (collectionClassName == null) {
            this.removePropertyIfNotExistActually(typeDesc.getComponentClassDesc(), PROP_LENGTH);
        } else {
            this.removePropertyIfNotExistActually(typeDesc.getComponentClassDesc(), PROP_SIZE);
        }
        typeDesc.setCollectionClassName(collectionClassName);
        typeDesc.setCollection(true);
    }

    private void removePropertyIfNotExistActually(ClassDesc classDesc, String propertyName) {
        if (this.sourceCreator_.getPropertyDescriptor(classDesc.getName(), propertyName) == null) {
            classDesc.removePropertyDesc(propertyName);
        }
    }

    String getPathExpression(PropertyDesc propertyDesc) {
        LinkedList<String> list = new LinkedList<String>();
        int count = 10;
        PropertyDesc desc = propertyDesc;
        do {
            if (desc instanceof PropertyDesc) {
                list.addFirst(desc.getName());
                continue;
            }
            if (!(desc instanceof ClassDesc)) continue;
            list.addFirst("[" + ((ClassDesc)((Object)desc)).getShortName() + "]");
        } while ((desc = desc.getParent()) != null && --count >= 0);
        StringBuilder sb = new StringBuilder();
        String delim = SINGULAR_SUFFIX2;
        for (String segment : list) {
            sb.append(delim).append(segment);
            delim = "/";
        }
        return sb.toString();
    }
}

