/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.regex.Pattern;
import net.skirnir.freyja.TemplateContext;
import net.skirnir.freyja.render.Note;
import net.skirnir.freyja.render.Notes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.cms.pluggable.ClassTraverser;
import org.seasar.framework.util.ClassTraversal;
import org.seasar.kvasir.util.PropertyUtils;
import org.seasar.kvasir.util.collection.MapProperties;
import org.seasar.ymir.Application;
import org.seasar.ymir.HttpMethod;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.extension.creator.util.SourceCreatorUtils;
import org.seasar.ymir.render.Selector;
import org.seasar.ymir.util.ServletUtils;

public class SourceCreatorSetting {
    public static final String APPKEY_SOURCECREATOR_ENABLE = "extension.sourceCreator.enable";
    public static final String APPKEYPREFIX_SOURCECREATOR_ENABLE = "extension.sourceCreator.enable.";
    public static final String APPKEY_SOURCECREATOR_TRYTOUPDATECLASSESWHENTEMPLATEMODIFIED = "extension.sourceCreator.tryToUpdateClassesWhenTemplateModified";
    @Deprecated
    public static final String APPKEY_SOURCECREATOR_USEFREYJARENDERCLASSES = "extension.sourceCreator.useFreyjaRenderClasses";
    public static final String APPKEY_SOURCECREATOR_DTOSEARCHPATH = "extension.sourceCreator.dtoSearchpath";
    public static final String APPKEY_SOURCECREATOR_GENERATEREPEATEDPROPERTYASLIST = "extension.sourceCreator.generateRepeatedPropertyAsList";
    public static final String APPKEY_SOURCECREATOR_SUPERCLASS = "extension.sourceCreator.superclass";
    public static final String APPKEYPREFIX_SOURCECREATOR_SUPERCLASS = "extension.sourceCreator.superclass.";
    public static final String APPKEY_SOURCECREATOR_FIELDSPECIALPREFIX = "extension.sourceCreator.fieldSpecialPrefix";
    public static final String APPKEY_SOURCECREATOR_FIELDPREFIX = "extension.sourceCreator.fieldPrefix";
    public static final String APPKEY_SOURCECREATOR_FIELDSUFFIX = "extension.sourceCreator.fieldSuffix";
    public static final String APPKEY_SOURCECREATOR_ENABLEINPLACEEDITOR = "extension.sourceCreator.enableInplaceEditor";
    public static final String APPKEY_SOURCECREATOR_ENABLECONTROLPANEL = "extension.sourceCreator.enableControlPanel";
    public static final String APPKEYPREFIX_SOURCECREATOR_ACTION_RETURNTYPE = "extension.sourceCreator.action.returnType.";
    public static final String APPKEY_SOURCECREATOR_FEATURE_CREATEMESSAGE_ENABLE = "extension.sourceCreator.feature.createMessage.enable";
    public static final String APPKEY_SOURCECREATOR_FEATURE_CREATEMESSAGES_ENABLE = "extension.sourceCreator.feature.createMessages.enable";
    public static final String APPKEY_SOURCECREATOR_FEATURE_CREATEFORMDTO_ENABLE = "extension.sourceCreator.feature.createFormDto.enable";
    public static final String APPKEY_SOURCECREATOR_FEATURE_CREATECONVERTER_ENABLE = "extension.sourceCreator.feature.createConverter.enable";
    public static final String APPKEY_SOURCECREATOR_FEATURE_CREATEDAO_ENABLE = "extension.sourceCreator.feature.createDao.enable";
    public static final String APPKEY_SOURCECREATOR_FEATURE_CREATEDXO_ENABLE = "extension.sourceCreator.feature.createDxo.enable";
    public static final String APPKEY_SOURCECREATOR_ECLIPSE_ENABLE = "extension.sourceCreator.eclipse.enable";
    public static final String APPKEY_SOURCECREATOR_ECLIPSE_PROJECTNAME = "extension.sourceCreator.eclipse.projectName";
    public static final String APPKEY_SOURCECREATOR_ECLIPSE_RESOURCESYNCHRONIZERURL = "extension.sourceCreator.eclipse.resourceSynchronizerURL";
    private static final String DEFAULT_RESOURCESYNCHRONIZERURL = "http://localhost:8386/";
    private static final String DEFAULT_SOURCECREATOR_FIELDPREFIX = "";
    private static final String DEFAULT_SOURCECREATOR_FIELDSUFFIX = "_";
    private static final String APPKEY_BEANTABLE_ENABLE = "beantable.enable";
    private static final String DEFAULT_ACTION_RETURNTYPE = "void";
    private SourceCreator sourceCreator_;
    private ClassNamePattern[] dtoClassNamePatterns_;
    private final Log log_ = LogFactory.getLog(SourceCreatorSetting.class);

    public SourceCreatorSetting(SourceCreator sourceCreator) {
        this.sourceCreator_ = sourceCreator;
    }

    protected String getProperty(String key) {
        return this.sourceCreator_.getApplication().getProperty(key);
    }

    protected String getProperty(String key, String defaultValue) {
        return this.sourceCreator_.getApplication().getProperty(key, defaultValue);
    }

    protected void setProperty(String key, String value) {
        this.sourceCreator_.getApplication().setProperty(key, value);
        this.save(key);
    }

    protected void removeProperty(String key) {
        this.sourceCreator_.getApplication().removeProperty(key);
        this.save(key);
    }

    protected void save(String ... keys) {
        if (keys.length == 0) {
            return;
        }
        Application application = this.sourceCreator_.getApplication();
        MapProperties orderedProp = SourceCreatorUtils.readAppPropertiesInOrder(application);
        for (String key : keys) {
            String value = application.getProperty(key);
            if (value == null) {
                orderedProp.removeProperty(key);
                continue;
            }
            orderedProp.setProperty(key, value);
        }
        String propertiesFilePath = application.getDefaultPropertiesFilePath();
        if (propertiesFilePath != null) {
            File file = new File(propertiesFilePath);
            file.getParentFile().mkdirs();
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(file);
                SourceCreatorUtils.writeHeader(fos, null);
                orderedProp.store((OutputStream)fos);
            }
            catch (IOException ex) {
                throw new RuntimeException("Can't write property file: " + file.getAbsolutePath());
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
    }

    public boolean isResourceSynchronized() {
        return PropertyUtils.valueOf((String)this.getProperty(APPKEY_SOURCECREATOR_ECLIPSE_ENABLE), (boolean)false) && this.constructResourceSynchronizerURL(DEFAULT_SOURCECREATOR_FIELDPREFIX) != null && this.getEclipseProjectName().length() > 0;
    }

    public URL constructResourceSynchronizerURL(String path) {
        String urlString = this.getProperty(APPKEY_SOURCECREATOR_ECLIPSE_RESOURCESYNCHRONIZERURL, DEFAULT_SOURCECREATOR_FIELDPREFIX);
        if (urlString.length() > 0) {
            if (!urlString.endsWith("/")) {
                urlString = urlString + "/";
            }
            try {
                return new URL(urlString + path);
            }
            catch (MalformedURLException ex) {
                this.log_.warn((Object)("Application property (extension.sourceCreator.eclipse.resourceSynchronizerURL) is not a valid URL: " + urlString), (Throwable)ex);
                return null;
            }
        }
        return null;
    }

    public String getResourceSynchronizerURL() {
        return this.getProperty(APPKEY_SOURCECREATOR_ECLIPSE_RESOURCESYNCHRONIZERURL, DEFAULT_RESOURCESYNCHRONIZERURL);
    }

    public String getEclipseProjectName() {
        return this.getProperty(APPKEY_SOURCECREATOR_ECLIPSE_PROJECTNAME, DEFAULT_SOURCECREATOR_FIELDPREFIX);
    }

    public boolean isEclipseEnabled() {
        return PropertyUtils.valueOf((String)this.getProperty(APPKEY_SOURCECREATOR_ECLIPSE_ENABLE), (boolean)false);
    }

    public boolean isConverterCreationFeatureEnabled() {
        return PropertyUtils.valueOf((String)this.getProperty(APPKEY_SOURCECREATOR_FEATURE_CREATECONVERTER_ENABLE), (boolean)false);
    }

    public boolean isDaoCreationFeatureEnabled() {
        return PropertyUtils.valueOf((String)this.getProperty(APPKEY_SOURCECREATOR_FEATURE_CREATEDAO_ENABLE), (boolean)true);
    }

    public boolean isDxoCreationFeatureEnabled() {
        return PropertyUtils.valueOf((String)this.getProperty(APPKEY_SOURCECREATOR_FEATURE_CREATEDXO_ENABLE), (boolean)true);
    }

    public boolean isSourceCreatorEnabled() {
        return PropertyUtils.valueOf((String)this.getProperty(APPKEY_SOURCECREATOR_ENABLE), (boolean)true);
    }

    public boolean isSourceCreatorEnabledWith(String path) {
        return PropertyUtils.valueOf((String)this.getProperty(APPKEYPREFIX_SOURCECREATOR_ENABLE + ServletUtils.normalizePath((String)path)), (boolean)true);
    }

    public void setSourceCreatorEnabledWith(String path, boolean enabled) {
        if (enabled) {
            this.removeProperty(APPKEYPREFIX_SOURCECREATOR_ENABLE + ServletUtils.normalizePath((String)path));
        } else {
            this.setProperty(APPKEYPREFIX_SOURCECREATOR_ENABLE + ServletUtils.normalizePath((String)path), String.valueOf(enabled));
        }
    }

    public boolean isTryingToUpdateClassesWhenTemplateModified() {
        return PropertyUtils.valueOf((String)this.getProperty(APPKEY_SOURCECREATOR_TRYTOUPDATECLASSESWHENTEMPLATEMODIFIED), (boolean)true);
    }

    public String getSuperclassName(String className) {
        Application application = this.sourceCreator_.getApplication();
        Enumeration enm = application.propertyNames();
        while (enm.hasMoreElements()) {
            String key = (String)enm.nextElement();
            if (!key.startsWith(APPKEYPREFIX_SOURCECREATOR_SUPERCLASS) || !Pattern.compile(key.substring(APPKEYPREFIX_SOURCECREATOR_SUPERCLASS.length())).matcher(className).find()) continue;
            return application.getProperty(key);
        }
        return null;
    }

    public String getPageSuperclassName() {
        return this.getProperty(APPKEY_SOURCECREATOR_SUPERCLASS);
    }

    public boolean isInPlaceEditorEnabled() {
        return PropertyUtils.valueOf((String)this.getProperty(APPKEY_SOURCECREATOR_ENABLEINPLACEEDITOR), (boolean)true);
    }

    public boolean isControlPanelEnabled() {
        return PropertyUtils.valueOf((String)this.getProperty(APPKEY_SOURCECREATOR_ENABLECONTROLPANEL), (boolean)true);
    }

    public boolean isMessageCreatingFeatureEnabled() {
        return PropertyUtils.valueOf((String)this.getProperty(APPKEY_SOURCECREATOR_FEATURE_CREATEMESSAGE_ENABLE), (boolean)true);
    }

    public boolean isMessagesCreationFeatureEnabled() {
        return PropertyUtils.valueOf((String)this.getProperty(APPKEY_SOURCECREATOR_FEATURE_CREATEMESSAGES_ENABLE), (boolean)true);
    }

    public String getFieldSpecialPrefix() {
        return this.getProperty(APPKEY_SOURCECREATOR_FIELDSPECIALPREFIX, DEFAULT_SOURCECREATOR_FIELDPREFIX);
    }

    public String getFieldPrefix() {
        return this.getProperty(APPKEY_SOURCECREATOR_FIELDPREFIX, DEFAULT_SOURCECREATOR_FIELDPREFIX);
    }

    public String getFieldSuffix() {
        return this.getProperty(APPKEY_SOURCECREATOR_FIELDSUFFIX, DEFAULT_SOURCECREATOR_FIELDSUFFIX);
    }

    public boolean isOnDtoSearchPath(String className) {
        this.setUpForDtoSearchPath();
        for (ClassNamePattern pattern : this.dtoClassNamePatterns_) {
            if (!className.equals(pattern.getClassName())) continue;
            return true;
        }
        return false;
    }

    public String findDtoClassName(String propertyName) {
        this.setUpForDtoSearchPath();
        String name = this.capFirst(propertyName);
        for (ClassNamePattern pattern : this.dtoClassNamePatterns_) {
            String className = pattern.getClassNameIfMatched(name);
            if (className == null) continue;
            return className;
        }
        return null;
    }

    void setUpForDtoSearchPath() {
        if (this.dtoClassNamePatterns_ != null) {
            return;
        }
        ClassTraverser traverser = new ClassTraverser();
        final ArrayList<ClassNamePattern> list = new ArrayList<ClassNamePattern>();
        for (String entry : PropertyUtils.toLines((String)this.getProperty(APPKEY_SOURCECREATOR_DTOSEARCHPATH))) {
            if (entry.endsWith(".*")) {
                traverser.addClassPattern(entry.substring(0, entry.length() - 2), ".+");
                continue;
            }
            int dot = entry.lastIndexOf(".");
            String shortClassName = dot >= 0 ? entry.substring(dot + 1) : entry;
            list.add(new ClassNamePattern(shortClassName, entry));
            Class<?> clazz = this.sourceCreator_.getClass(entry);
            if (clazz == null) continue;
            traverser.addReferenceClass(clazz);
        }
        if (PropertyUtils.valueOf((String)this.getProperty(APPKEY_SOURCECREATOR_USEFREYJARENDERCLASSES), (boolean)true)) {
            traverser.addClassPattern("net.skirnir.freyja.render", ".+");
        }
        traverser.addReferenceClass(Selector.class);
        traverser.addReferenceClass(TemplateContext.class);
        traverser.setClassHandler(new ClassTraversal.ClassHandler(){

            public void processClass(String packageName, String shortClassName) {
                String className = packageName + "." + shortClassName;
                if (className.equals(Notes.class.getName())) {
                    className = org.seasar.ymir.message.Notes.class.getName();
                } else if (className.equals(Note.class.getName())) {
                    className = org.seasar.ymir.message.Note.class.getName();
                }
                list.add(new ClassNamePattern(shortClassName, className));
            }
        });
        traverser.traverse();
        Collections.sort(list);
        this.dtoClassNamePatterns_ = list.toArray(new ClassNamePattern[0]);
    }

    private String capFirst(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public boolean isRepeatedPropertyGeneratedAsList() {
        return PropertyUtils.valueOf((String)this.getProperty(APPKEY_SOURCECREATOR_GENERATEREPEATEDPROPERTYASLIST), (boolean)false);
    }

    public boolean isFormDtoCreationFeatureEnabled() {
        return PropertyUtils.valueOf((String)this.getProperty(APPKEY_SOURCECREATOR_FEATURE_CREATEFORMDTO_ENABLE), (boolean)true);
    }

    public boolean isBeantableEnabled() {
        return PropertyUtils.valueOf((String)this.getProperty(APPKEY_BEANTABLE_ENABLE), (boolean)false);
    }

    public String getActionReturnType(HttpMethod method) {
        return this.getProperty(APPKEYPREFIX_SOURCECREATOR_ACTION_RETURNTYPE + method.name(), DEFAULT_ACTION_RETURNTYPE);
    }

    public String getFieldName(String propertyName) {
        if (propertyName == null) {
            return null;
        }
        return this.getFieldPrefix() + propertyName + this.getFieldSuffix();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ClassNamePattern
    implements Comparable<ClassNamePattern> {
        private Pattern pattern_;
        private String shortName_;
        private String className_;

        public ClassNamePattern(String shortName, String className) {
            this.pattern_ = Pattern.compile(".*" + shortName + "s?");
            this.shortName_ = shortName;
            this.className_ = className;
        }

        public String getClassName() {
            return this.className_;
        }

        public String getClassNameIfMatched(String name) {
            if (name == null) {
                return null;
            }
            if (this.pattern_.matcher(name).matches()) {
                return this.className_;
            }
            return null;
        }

        public String getClassNameEquals(String name) {
            if (this.shortName_.equals(name)) {
                return this.className_;
            }
            return null;
        }

        @Override
        public int compareTo(ClassNamePattern o) {
            int cmp = o.shortName_.length() - this.shortName_.length();
            if (cmp == 0) {
                cmp = this.shortName_.compareTo(o.shortName_);
            }
            return cmp;
        }

        public String toString() {
            return this.shortName_;
        }
    }
}

