/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Set;
import org.seasar.ymir.extension.creator.AnnotationDesc;
import org.seasar.ymir.extension.creator.BodyDesc;
import org.seasar.ymir.extension.creator.Desc;
import org.seasar.ymir.extension.creator.DescPool;
import org.seasar.ymir.extension.creator.MethodDesc;
import org.seasar.ymir.extension.creator.ParameterDesc;
import org.seasar.ymir.extension.creator.ThrowsDesc;
import org.seasar.ymir.extension.creator.TypeDesc;
import org.seasar.ymir.extension.creator.impl.AbstractAnnotatedDesc;
import org.seasar.ymir.extension.creator.impl.BodyDescImpl;
import org.seasar.ymir.extension.creator.impl.MetaAnnotationDescImpl;
import org.seasar.ymir.extension.creator.impl.ThrowsDescImpl;
import org.seasar.ymir.extension.creator.util.DescUtils;
import org.seasar.ymir.extension.creator.util.GenericsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDescImpl
extends AbstractAnnotatedDesc
implements MethodDesc {
    private DescPool pool_;
    private String name_;
    private ParameterDesc[] parameterDescs_ = new ParameterDesc[0];
    private TypeDesc returnTypeDesc_;
    private ThrowsDesc throwsDesc_ = new ThrowsDescImpl();
    private BodyDesc bodyDesc_;
    private Desc<?> parent_;

    public MethodDescImpl(DescPool pool, String name) {
        this.pool_ = pool;
        this.name_ = name;
        this.setReturnTypeDesc(Void.TYPE);
        this.applyBornOf(this.pool_.getBornOf());
    }

    public MethodDescImpl(DescPool pool, Method method) {
        int i;
        this.pool_ = pool;
        this.name_ = method.getName();
        this.setReturnTypeDesc(method.getGenericReturnType());
        Type[] types = method.getGenericParameterTypes();
        this.parameterDescs_ = new ParameterDesc[types.length];
        for (i = 0; i < types.length; ++i) {
            this.parameterDescs_[i] = this.pool_.newParameterDesc();
            this.parameterDescs_[i].setTypeDesc(this.pool_.newTypeDesc(types[i]));
        }
        types = method.getGenericExceptionTypes();
        for (i = 0; i < types.length; ++i) {
            this.throwsDesc_.addThrowable(GenericsUtils.toString(types[i]));
        }
        AnnotationDesc[] ads = DescUtils.newAnnotationDescs(method);
        for (int i2 = 0; i2 < ads.length; ++i2) {
            this.setAnnotationDesc(ads[i2]);
        }
        this.applyBornOf(this.pool_.getBornOf());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.returnTypeDesc_).append(" ").append(this.name_).append("(");
        String delim = "";
        for (int i = 0; i < this.parameterDescs_.length; ++i) {
            sb.append(delim).append(this.parameterDescs_[i]);
            delim = ", ";
        }
        sb.append(")");
        if (!this.throwsDesc_.isEmpty()) {
            String[] classNames = this.throwsDesc_.getThrowableClassNames();
            delim = " throws ";
            for (int i = 0; i < classNames.length; ++i) {
                sb.append(delim).append(classNames[i]);
                delim = ", ";
            }
        }
        return sb.toString();
    }

    @Override
    public DescPool getDescPool() {
        return this.pool_;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public TypeDesc getReturnTypeDesc() {
        return this.returnTypeDesc_;
    }

    @Override
    public void setReturnTypeDesc(TypeDesc returnTypeDesc) {
        this.returnTypeDesc_ = returnTypeDesc;
        this.returnTypeDesc_.setParent(this);
    }

    @Override
    public TypeDesc setReturnTypeDesc(Type type) {
        TypeDesc typeDesc = this.pool_.newTypeDesc(type);
        this.setReturnTypeDesc(typeDesc);
        return typeDesc;
    }

    @Override
    public TypeDesc setReturnTypeDesc(String typeName) {
        TypeDesc typeDesc = this.pool_.newTypeDesc(typeName);
        this.setReturnTypeDesc(typeDesc);
        return typeDesc;
    }

    @Override
    public ParameterDesc[] getParameterDescs() {
        return this.parameterDescs_;
    }

    @Override
    public void setParameterDescs(ParameterDesc ... parameterDescs) {
        for (ParameterDesc parameterDesc : this.parameterDescs_ = parameterDescs) {
            parameterDesc.setParent(this);
        }
    }

    @Override
    public BodyDesc getBodyDesc() {
        return this.bodyDesc_;
    }

    @Override
    public void setBodyDesc(BodyDesc bodyDesc) {
        this.bodyDesc_ = bodyDesc;
    }

    @Override
    public ThrowsDesc getThrowsDesc() {
        return this.throwsDesc_;
    }

    @Override
    public void setThrowsDesc(ThrowsDesc throwsDesc) {
        this.throwsDesc_ = throwsDesc;
    }

    @Override
    public MethodDesc transcriptTo(MethodDesc desc) {
        DescPool pool = desc.getDescPool();
        super.transcriptTo(desc);
        ArrayList<ParameterDesc> list = new ArrayList<ParameterDesc>();
        for (ParameterDesc parameterDesc : this.parameterDescs_) {
            list.add(parameterDesc.transcriptTo(pool.newParameterDesc()));
        }
        desc.setParameterDescs(list.toArray(new ParameterDesc[0]));
        desc.setReturnTypeDesc(this.returnTypeDesc_.transcriptTo(pool.newTypeDesc(this.returnTypeDesc_)));
        ThrowsDescImpl throwsDesc = new ThrowsDescImpl();
        for (String className : this.throwsDesc_.getThrowableClassNames()) {
            throwsDesc.addThrowable(className);
        }
        desc.setThrowsDesc(throwsDesc);
        if (this.bodyDesc_ != null) {
            desc.setBodyDesc(new BodyDescImpl(this.bodyDesc_.getKey(), this.bodyDesc_.getRoot(), this.bodyDesc_.getDependingClassNames()));
        }
        return desc;
    }

    @Override
    public <D extends Desc<?>> D getParent() {
        return (D)this.parent_;
    }

    @Override
    public void setParent(Desc<?> parent) {
        this.parent_ = parent;
    }

    @Override
    public void addDependingClassNamesTo(Set<String> set) {
        this.addDependingClassNamesTo0(set);
        for (ParameterDesc parameterDesc : this.parameterDescs_) {
            parameterDesc.addDependingClassNamesTo(set);
        }
        this.returnTypeDesc_.addDependingClassNamesTo(set);
        this.throwsDesc_.addDependingClassNamesTo(set);
    }

    @Override
    public void setTouchedClassNameSet(Set<String> set) {
        if (this.setTouchedClassNameSet0(set)) {
            return;
        }
        for (ParameterDesc parameterDesc : this.parameterDescs_) {
            parameterDesc.setTouchedClassNameSet(set);
        }
        this.returnTypeDesc_.setTouchedClassNameSet(set);
        this.throwsDesc_.setTouchedClassNameSet(set);
    }

    void applyBornOf(String bornOf) {
        if (bornOf == null) {
            return;
        }
        AnnotationDesc annotationDesc = DescUtils.newBornOfMetaAnnotationDesc(this.getMetaValue("bornOf"), bornOf);
        this.removeMetaAnnotationDesc("bornOf");
        this.setAnnotationDesc(annotationDesc);
    }

    @Override
    public boolean removeBornOf(String bornOf) {
        if (bornOf == null || bornOf.startsWith("request:")) {
            return false;
        }
        boolean removeThis = false;
        String[] values = this.getMetaValue("bornOf");
        if (values != null) {
            this.removeMetaAnnotationDesc("bornOf");
            ArrayList<String> valueList = new ArrayList<String>();
            for (String value : values) {
                if (value.equals(bornOf)) continue;
                valueList.add(value);
            }
            values = valueList.toArray(new String[0]);
            if (values.length == 0) {
                removeThis = true;
            } else {
                this.setAnnotationDesc(new MetaAnnotationDescImpl("bornOf", values));
            }
        }
        DescUtils.removeBornOfFromAttributes(bornOf, this.getAttributeMap());
        return removeThis;
    }
}

