/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.impl;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.Desc;
import org.seasar.ymir.extension.creator.DescPool;
import org.seasar.ymir.extension.creator.TypeDesc;
import org.seasar.ymir.extension.creator.util.DescUtils;
import org.seasar.ymir.extension.creator.util.GenericsUtils;
import org.seasar.ymir.extension.creator.util.type.Token;
import org.seasar.ymir.extension.creator.util.type.TokenVisitor;
import org.seasar.ymir.extension.creator.util.type.TypeToken;
import org.seasar.ymir.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDescImpl
implements TypeDesc {
    private DescPool pool_;
    private ClassDesc componentClassDesc_;
    private String componentTypeName_;
    private boolean collection_;
    private String collectionClassName_;
    private String collectionImplementationClassName_;
    private boolean explicit_;
    private Desc<?> parent_;
    private Set<String> touchedClassNameSet_ = new HashSet<String>();

    public TypeDescImpl(DescPool pool, Type type) {
        this(pool, type, null);
    }

    public TypeDescImpl(DescPool pool, Type type, String qualifier) {
        this(pool, GenericsUtils.toString(type), qualifier);
    }

    public TypeDescImpl(DescPool pool, String typeName) {
        this(pool, typeName, null);
    }

    public TypeDescImpl(DescPool pool, String typeName, String componentClassQualifier) {
        String componentClassName;
        String componentTypeName;
        this.pool_ = pool;
        typeName = GenericsUtils.getFullyQualifiedTypeName(typeName.replace('$', '.'));
        TypeToken token = new TypeToken(typeName);
        boolean collection = token.isArray();
        if (collection) {
            componentTypeName = GenericsUtils.getComponentName(typeName);
            componentClassName = GenericsUtils.getNonGenericClassName(componentTypeName);
        } else {
            componentTypeName = typeName;
            componentClassName = token.getBaseName();
            Class<?> clazz = this.pool_.getSourceCreator().getClass(componentClassName);
            if (clazz != null) {
                collection = Collection.class.isAssignableFrom(clazz);
            }
            if (collection) {
                this.collectionClassName_ = token.getBaseName();
                TypeToken[] types = token.getTypes();
                if (types.length == 0) {
                    componentTypeName = Object.class.getName();
                    componentClassName = Object.class.getName();
                } else {
                    componentTypeName = types[0].getAsString();
                    componentClassName = types[0].getBaseName();
                }
            }
        }
        this.collection_ = collection;
        this.componentTypeName_ = componentTypeName;
        this.componentClassDesc_ = this.pool_.getClassDesc(componentClassName, componentClassQualifier);
        this.componentClassDesc_.setParent(this);
    }

    public TypeDescImpl(DescPool pool, ClassDesc componentClassDesc) {
        this(pool, componentClassDesc, false, null);
    }

    public TypeDescImpl(DescPool pool, ClassDesc componentClassDesc, boolean collection, String collectionClassName) {
        this.pool_ = pool;
        this.componentTypeName_ = componentClassDesc.getName();
        this.componentClassDesc_ = componentClassDesc;
        if (this.componentClassDesc_.getDescPool() != this.pool_) {
            throw new IllegalArgumentException("Can't set ClassDesc born from another DescPool");
        }
        this.componentClassDesc_.setParent(this);
        this.collection_ = collection;
        this.collectionClassName_ = collectionClassName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.collectionClassName_ == null ? 0 : this.collectionClassName_.hashCode());
        result = 31 * result + (this.collectionImplementationClassName_ == null ? 0 : this.collectionImplementationClassName_.hashCode());
        result = 31 * result + (this.collection_ ? 1231 : 1237);
        result = 31 * result + (this.componentClassDesc_ == null ? 0 : this.componentClassDesc_.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeDescImpl other = (TypeDescImpl)obj;
        if (this.collectionClassName_ == null ? other.collectionClassName_ != null : !this.collectionClassName_.equals(other.collectionClassName_)) {
            return false;
        }
        if (this.collectionImplementationClassName_ == null ? other.collectionImplementationClassName_ != null : !this.collectionImplementationClassName_.equals(other.collectionImplementationClassName_)) {
            return false;
        }
        if (this.collection_ != other.collection_) {
            return false;
        }
        return !(this.componentClassDesc_ == null ? other.componentClassDesc_ != null : !this.componentClassDesc_.equals(other.componentClassDesc_));
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public DescPool getDescPool() {
        return this.pool_;
    }

    @Override
    public ClassDesc getComponentClassDesc() {
        return this.componentClassDesc_;
    }

    @Override
    public void setComponentClassDesc(ClassDesc classDesc) {
        this.componentTypeName_ = classDesc.getName();
        this.componentClassDesc_ = classDesc;
        this.componentClassDesc_.setParent(this);
    }

    @Override
    public void setComponentClassDesc(Class<?> clazz) {
        this.setComponentClassDesc(this.pool_.getClassDesc(clazz));
    }

    @Override
    public String getComponentTypeName() {
        return this.componentTypeName_;
    }

    @Override
    public boolean isCollection() {
        return this.collection_;
    }

    @Override
    public void setCollection(boolean collection) {
        this.collection_ = collection;
    }

    @Override
    public String getCollectionClassName() {
        return this.collectionClassName_;
    }

    @Override
    public void setCollectionClassName(String collectionClassName) {
        this.collectionClassName_ = collectionClassName;
    }

    @Override
    public void setCollectionClass(Class<?> collectionClass) {
        this.setCollectionClassName(collectionClass != null ? collectionClass.getName() : null);
    }

    @Override
    public String getCollectionImplementationClassName() {
        return this.collectionImplementationClassName_;
    }

    @Override
    public void setCollectionImplementationClassName(String collectionImplementationClassName) {
        this.collectionImplementationClassName_ = collectionImplementationClassName;
    }

    @Override
    public void setCollectionImplementationClass(Class<?> collectionImplementationClass) {
        this.setCollectionImplementationClassName(collectionImplementationClass != null ? collectionImplementationClass.getName() : null);
    }

    @Override
    public boolean isExplicit() {
        return this.explicit_;
    }

    @Override
    public void setExplicit(boolean explicit) {
        this.explicit_ = explicit;
    }

    @Override
    public String getCompleteName() {
        StringBuilder sb = new StringBuilder();
        if (this.collection_ && this.collectionClassName_ != null) {
            sb.append(this.collectionClassName_).append("<");
        }
        sb.append(this.componentTypeName_);
        if (this.collection_) {
            if (this.collectionClassName_ != null) {
                sb.append(">");
            } else {
                sb.append("[]");
            }
        }
        return sb.toString();
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        if (this.collection_ && this.collectionClassName_ != null) {
            sb.append(GenericsUtils.getNormalizedTypeName(this.collectionClassName_)).append("<");
        }
        sb.append(GenericsUtils.getNormalizedTypeName(this.componentTypeName_));
        if (this.collection_) {
            if (this.collectionClassName_ != null) {
                sb.append(">");
            } else {
                sb.append("[]");
            }
        }
        return sb.toString();
    }

    @Override
    public String getShortName() {
        StringBuilder sb = new StringBuilder();
        if (this.collection_ && this.collectionClassName_ != null) {
            this.touchedClassNameSet_.add(this.collectionClassName_);
            sb.append(ClassUtils.getShortName((String)this.collectionClassName_)).append("<");
        }
        TypeToken token = new TypeToken(this.componentTypeName_);
        token.accept(new TokenVisitor<Object>(){

            public Object visit(Token acceptor, Object ... parameters) {
                TypeDescImpl.this.touchedClassNameSet_.add(acceptor.getComponentName());
                acceptor.setBaseName(ClassUtils.getShorterName((String)acceptor.getBaseName()));
                return null;
            }
        }, new Object[0]);
        sb.append(token.getAsString());
        if (this.collection_) {
            if (this.collectionClassName_ != null) {
                sb.append(">");
            } else {
                sb.append("[]");
            }
        }
        return sb.toString();
    }

    @Override
    public String getShortClassName() {
        if (this.collection_ && this.collectionClassName_ != null) {
            this.touchedClassNameSet_.add(this.collectionClassName_);
            return ClassUtils.getShortName((String)this.collectionClassName_);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ClassUtils.getShortName((String)this.componentClassDesc_.getName()));
        if (this.collection_) {
            sb.append("[]");
        }
        return sb.toString();
    }

    String getShortTypeName(String typeName) {
        if (typeName == null) {
            return null;
        }
        return this.getTypeTokenForShorten(typeName).getAsString();
    }

    String getShortClassName(String typeName) {
        if (typeName == null) {
            return null;
        }
        return this.getTypeTokenForShorten(typeName).getBaseName();
    }

    TypeToken getTypeTokenForShorten(String typeName) {
        TypeToken typeToken = new TypeToken(typeName);
        typeToken.accept(new TokenVisitor<Object>(){

            public Object visit(Token acceptor, Object ... parameters) {
                acceptor.setBaseName(ClassUtils.getShortName((String)acceptor.getBaseName()));
                return null;
            }
        }, new Object[0]);
        return typeToken;
    }

    @Override
    public String getDefaultValue() {
        if (this.collection_) {
            return String.valueOf((Object)null);
        }
        Object value = ClassUtils.getDefaultValue((String)this.componentClassDesc_.getName());
        if (value instanceof Character) {
            value = (int)((Character)value).charValue();
        } else if (value instanceof Float) {
            value = ((Float)value).intValue();
        }
        return String.valueOf(value);
    }

    @Override
    public String getInstanceName() {
        if (this.collection_) {
            return this.componentClassDesc_.getInstanceName() + "s";
        }
        return this.componentClassDesc_.getInstanceName();
    }

    @Override
    public TypeDesc transcriptTo(TypeDesc desc) {
        DescPool pool = desc.getDescPool();
        if (this.componentClassDesc_.getDescPool() == pool) {
            desc.setComponentClassDesc(this.componentClassDesc_);
        } else {
            desc.setComponentClassDesc(this.componentClassDesc_.transcriptTo(pool.getClassDesc(this.componentClassDesc_.getName(), this.componentClassDesc_.getQualifier())));
        }
        desc.setCollection(this.collection_);
        desc.setCollectionClassName(this.collectionClassName_);
        desc.setCollectionImplementationClassName(this.collectionImplementationClassName_);
        desc.setExplicit(this.explicit_);
        return desc;
    }

    @Override
    public <D extends Desc<?>> D getParent() {
        return (D)this.parent_;
    }

    @Override
    public void setParent(Desc<?> parent) {
        this.parent_ = parent;
    }

    @Override
    public void addDependingClassNamesTo(final Set<String> set) {
        TypeToken token = new TypeToken(this.componentTypeName_);
        token.accept(new TokenVisitor<Object>(){

            public Object visit(Token acceptor, Object ... parameters) {
                String componentName = acceptor.getComponentName();
                Class<?> componentClass = TypeDescImpl.this.pool_.getSourceCreator().getClass(componentName);
                if (componentClass != null) {
                    set.add(componentClass.getName());
                } else {
                    set.add(componentName);
                }
                return null;
            }
        }, new Object[0]);
        if (this.collection_ && this.collectionClassName_ != null) {
            set.add(this.collectionClassName_);
        }
    }

    @Override
    public String[] getImportClassNames() {
        TreeSet<String> set = new TreeSet<String>();
        this.addDependingClassNamesTo(set);
        DescUtils.removeStandardClassNames(set);
        return set.toArray(new String[0]);
    }

    @Override
    public void setTouchedClassNameSet(Set<String> set) {
        if (set == this.touchedClassNameSet_) {
            return;
        }
        this.touchedClassNameSet_ = set;
        this.componentClassDesc_.setTouchedClassNameSet(set);
    }
}

