/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.impl;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.ImportDesc;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportDescImpl
implements ImportDesc {
    private static final String PREFIX_JAVA = "java.";
    private static final String PREFIX_JAVAX = "javax.";
    private static final String LS = System.getProperty("line.separator");
    private SourceCreator sourceCreator_;
    private ClassDesc classDesc_;
    private Set<String> applicationClassSet_ = new TreeSet<String>();
    private Set<String> frameworkClassSet_ = new TreeSet<String>();
    private Set<String> javaClassSet_ = new TreeSet<String>();
    private Set<String> javaxClassSet_ = new TreeSet<String>();

    public ImportDescImpl(SourceCreator sourceCreator, ClassDesc classDesc) {
        this.sourceCreator_ = sourceCreator;
        this.classDesc_ = classDesc;
    }

    public String toString() {
        return this.getAsString();
    }

    @Override
    public void add(Collection<String> collection) {
        for (String className : collection) {
            this.add0(className);
        }
    }

    @Override
    public void add(String ... classNames) {
        for (String className : classNames) {
            this.add0(className);
        }
    }

    @Override
    public void add(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            this.add0(clazz.getName());
        }
    }

    protected void add0(String className) {
        if (className == null) {
            return;
        }
        if (ClassUtils.isStandard((String)className)) {
            return;
        }
        if (className.startsWith(this.classDesc_.getPackageName() + ".")) {
            return;
        }
        if (className.startsWith(PREFIX_JAVA)) {
            this.javaClassSet_.add(className);
        } else if (className.startsWith(PREFIX_JAVAX)) {
            this.javaxClassSet_.add(className);
        } else {
            for (String rootPackageName : this.sourceCreator_.getRootPackageNames()) {
                if (!className.startsWith(rootPackageName + ".")) continue;
                this.applicationClassSet_.add(className);
                return;
            }
            this.frameworkClassSet_.add(className);
        }
    }

    @Override
    public String[] getApplicationClassNames() {
        return this.applicationClassSet_.toArray(new String[0]);
    }

    @Override
    public String[] getFrameworkClassNames() {
        return this.frameworkClassSet_.toArray(new String[0]);
    }

    @Override
    public String[] getJavaClassNames() {
        return this.javaClassSet_.toArray(new String[0]);
    }

    @Override
    public String[] getJavaxClassNames() {
        return this.javaxClassSet_.toArray(new String[0]);
    }

    @Override
    public String getAsString() {
        StringBuilder sb = new StringBuilder();
        String delim = "";
        if (!this.javaClassSet_.isEmpty()) {
            sb.append(delim);
            delim = LS;
            for (String className : this.javaClassSet_) {
                sb.append("import ").append(className).append(";").append(LS);
            }
        }
        if (!this.javaxClassSet_.isEmpty()) {
            sb.append(delim);
            delim = LS;
            for (String className : this.javaxClassSet_) {
                sb.append("import ").append(className).append(";").append(LS);
            }
        }
        if (!this.frameworkClassSet_.isEmpty()) {
            sb.append(delim);
            delim = LS;
            for (String className : this.frameworkClassSet_) {
                sb.append("import ").append(className).append(";").append(LS);
            }
        }
        if (!this.applicationClassSet_.isEmpty()) {
            sb.append(delim);
            delim = LS;
            for (String className : this.applicationClassSet_) {
                sb.append("import ").append(className).append(";").append(LS);
            }
        }
        return sb.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.applicationClassSet_.isEmpty() && this.frameworkClassSet_.isEmpty() && this.javaClassSet_.isEmpty() && this.javaxClassSet_.isEmpty();
    }

    @Override
    public void clear() {
        this.applicationClassSet_.clear();
        this.frameworkClassSet_.clear();
        this.javaClassSet_.clear();
        this.javaxClassSet_.clear();
    }

    @Override
    public boolean containsClass(String className) {
        return this.applicationClassSet_.contains(className) || this.frameworkClassSet_.contains(className) || this.javaClassSet_.contains(className) || this.javaxClassSet_.contains(className);
    }
}

