/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.cms.pluggable.Configuration;
import org.seasar.cms.pluggable.hotdeploy.LocalHotdeployS2Container;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.kvasir.util.PropertyUtils;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.IllegalClientCodeRuntimeException;
import org.seasar.ymir.PathMappingProvider;
import org.seasar.ymir.Ymir;
import org.seasar.ymir.YmirContext;
import org.seasar.ymir.impl.SingleApplication;
import org.seasar.ymir.util.ArtifactMetaData;
import org.seasar.ymir.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YmirBootstrap {
    private static final String LS = System.getProperty("line.separator");
    private static final String PATHPREFIX_POM_PROPERTIES = "/META-INF/maven/";
    private static final String PATHSUFFIX_POM_PROPERTIES = "pom.properties";
    private Ymir ymir_;
    private final Log log_ = LogFactory.getLog(YmirBootstrap.class);

    public void prepare(ServletContext servletContext) {
        this.initializeApplication(servletContext);
    }

    public Ymir init() {
        this.ymir_ = (Ymir)this.getContainer().getComponent(Ymir.class);
        YmirContext.setYmir(this.ymir_);
        this.ymir_.init();
        return this.ymir_;
    }

    void initializeApplication(ServletContext servletContext) {
        Configuration configuration = this.getConfiguration();
        ComponentDef cd = this.getContainer().getComponentDef(LocalHotdeployS2Container.class);
        SingleApplication application = new SingleApplication(servletContext, configuration, this.getLandmarks(configuration), this.getContainer(), (LocalHotdeployS2Container)cd.getComponent(), (PathMappingProvider)this.getContainer().getComponent(PathMappingProvider.class));
        ApplicationManager applicationManager = (ApplicationManager)this.getContainer().getComponent(ApplicationManager.class);
        applicationManager.setBaseApplication(application);
        String signature = null;
        ArtifactMetaData metaData = ArtifactMetaData.newInstance(this.findApplicationPomProperties(servletContext));
        if (metaData != null) {
            signature = metaData.getSignature();
        }
        if (signature == null) {
            signature = "unknown";
        }
        this.log_.info((Object)("Application '" + signature + "' has been initialized"));
    }

    private URL findApplicationPomProperties(ServletContext servletContext) {
        String groupPath = null;
        Set paths = servletContext.getResourcePaths(PATHPREFIX_POM_PROPERTIES);
        if (paths == null) {
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)"Can't find child resource of '/META-INF/maven/'");
            }
            return null;
        }
        for (String path : paths) {
            if (!path.endsWith("/")) continue;
            groupPath = path;
            break;
        }
        if (groupPath == null) {
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)"Can't find child resource of '/META-INF/maven/'");
            }
            return null;
        }
        String artifactPath = null;
        paths = servletContext.getResourcePaths(groupPath);
        if (paths == null) {
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)("Can't find child resource of '" + groupPath + "'"));
            }
            return null;
        }
        for (String path : paths) {
            if (!path.endsWith("/")) continue;
            artifactPath = path;
            break;
        }
        if (artifactPath == null) {
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)("Can't find child resource of '" + groupPath + "'"));
            }
            return null;
        }
        try {
            return servletContext.getResource(artifactPath + PATHSUFFIX_POM_PROPERTIES);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    Class<?>[] getLandmarks(Configuration configuration) {
        ArrayList landmarkList = new ArrayList();
        for (String landmarkClassName : PropertyUtils.toLines((String)configuration.getProperty("landmark", "org.seasar.ymir.landmark.Landmark"))) {
            try {
                landmarkList.add(ClassUtils.forName(landmarkClassName));
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalClientCodeRuntimeException("Landmark class (" + landmarkClassName + ") not found. Can't boot Ymir." + LS + "You MUST put the landmark class" + " in the jar" + " or in WEB-INF/classes.");
            }
        }
        return landmarkList.toArray(new Class[0]);
    }

    Configuration getConfiguration() {
        return (Configuration)this.getContainer().getComponent(Configuration.class);
    }

    public void destroy() {
        if (this.ymir_ != null) {
            this.ymir_.destroy();
        }
        YmirContext.setYmir(null);
    }

    S2Container getContainer() {
        return SingletonS2ContainerFactory.getContainer();
    }
}

