/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.util;

import org.seasar.ymir.Response;
import org.seasar.ymir.ResponseType;
import org.seasar.ymir.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseUtils {
    public static final String PATH_EXCEPTION_TEMPLATE = "/WEB-INF/template/exception/";
    public static final String SUFFIX_EXCEPTION_TEMPLATE = ".html";

    protected ResponseUtils() {
    }

    public static void setNoCache(Response response) {
        ResponseUtils.setNoCache(response, false);
    }

    public static void setNoCache(Response response, boolean force) {
        if (response == null || !force && response.containsHeader("Cache-Control")) {
            return;
        }
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache,no-store,must-revalidate");
        response.setDateHeader("Expires", 1L);
    }

    public static void setPrivateCache(Response response) {
        ResponseUtils.setPrivateCache(response, false);
    }

    public static void setPrivateCache(Response response, boolean force) {
        if (response == null || !force && response.containsHeader("Cache-Control")) {
            return;
        }
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "private");
    }

    public static String getExceptionTemplatePath(Class<?> exceptionClass) {
        return PATH_EXCEPTION_TEMPLATE + ClassUtils.getShortName(exceptionClass) + SUFFIX_EXCEPTION_TEMPLATE;
    }

    public static boolean isProceed(Response response) {
        return response != null && response.getType() == ResponseType.FORWARD && !response.isSubordinate();
    }

    public static boolean isRedirect(Response response) {
        return response != null && (response.getType() == ResponseType.REDIRECT || ResponseUtils.isProceed(response));
    }

    public static boolean isTransitionResponse(Response response) {
        return response != null && (response.getType() == ResponseType.FORWARD || response.getType() == ResponseType.REDIRECT);
    }

    public static boolean isPassthroughResponse(Response response) {
        return response != null && response.getType() == ResponseType.PASSTHROUGH;
    }
}

