/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.session.impl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.kvasir.util.collection.EnumerationIterator;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.Attribute;
import org.seasar.ymir.YmirContext;
import org.seasar.ymir.hotdeploy.HotdeployManager;
import org.seasar.ymir.session.SessionManager;
import org.seasar.ymir.session.impl.AttributeListener;
import org.seasar.ymir.session.impl.VoidAttributeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionManagerImpl
implements SessionManager {
    private ApplicationManager applicationManager_;
    private HotdeployManager hotdeployManager_;
    private String straddlingAttributeNamePatternString_;
    private Pattern straddlingAttributeNamePattern_;
    private AttributeListener attributeListener_ = new VoidAttributeListener();

    @Binding(bindingType=BindingType.MUST)
    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager_ = applicationManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setHotdeployManager(HotdeployManager hotdeployManager) {
        this.hotdeployManager_ = hotdeployManager;
    }

    @Override
    public HttpSession getSession() {
        return this.getSession(true);
    }

    @Override
    public HttpSession getSession(boolean create) {
        return this.getHttpServletRequest().getSession(create);
    }

    @Override
    public void invalidateSession() {
        HttpSession session = this.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    @Override
    public HttpSession invalidateAndCreateSession() {
        HttpSession session = this.getSession(false);
        if (session == null) {
            return this.getSession();
        }
        Attribute[] attributes = this.abandonAttributes(session);
        session.invalidate();
        session = this.getSession();
        this.populateAttributes(session, attributes);
        return session;
    }

    void populateAttributes(HttpSession session, Attribute[] attributes) {
        for (int i = 0; i < attributes.length; ++i) {
            session.setAttribute(attributes[i].getName(), attributes[i].getValue());
        }
    }

    Attribute[] abandonAttributes(HttpSession session) {
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        Enumeration enm = session.getAttributeNames();
        while (enm.hasMoreElements()) {
            String name = (String)enm.nextElement();
            if (!this.isStraddlingAttributeName(name)) continue;
            attributeList.add(new Attribute(name, session.getAttribute(name)));
        }
        return attributeList.toArray(new Attribute[0]);
    }

    boolean isStraddlingAttributeName(String name) {
        if (this.straddlingAttributeNamePattern_ == null) {
            return false;
        }
        return this.straddlingAttributeNamePattern_.matcher(name).matches();
    }

    @Override
    public void addStraddlingAttributeNamePattern(String namePattern) {
        this.straddlingAttributeNamePatternString_ = this.straddlingAttributeNamePatternString_ == null ? namePattern : this.straddlingAttributeNamePatternString_ + "|" + namePattern;
        this.straddlingAttributeNamePattern_ = Pattern.compile(this.straddlingAttributeNamePatternString_);
    }

    HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)this.applicationManager_.findContextApplication().getS2Container().getComponent(HttpServletRequest.class);
    }

    @Override
    public Object getAttribute(String name) {
        Object value = this.getRawAttribute(name);
        if (value != null && YmirContext.isUnderDevelopment()) {
            value = this.hotdeployManager_.fit(value);
        }
        return value;
    }

    @Override
    public Object getRawAttribute(String name) {
        HttpSession session = this.getSession(false);
        if (session == null) {
            return null;
        }
        this.attributeListener_.notifyGetAttribute(name);
        return session.getAttribute(name);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        HttpSession session = this.getSession(false);
        if (session == null) {
            return new ArrayList().iterator();
        }
        return new EnumerationIterator(session.getAttributeNames());
    }

    @Override
    public boolean isSessionPresent() {
        return this.getSession(false) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttribute(String name) {
        HttpSession session = this.getSession(false);
        if (session != null) {
            HttpSession httpSession = session;
            synchronized (httpSession) {
                session.removeAttribute(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(String name, Object value) {
        HttpSession session;
        HttpSession httpSession = session = this.getSession();
        synchronized (httpSession) {
            this.attributeListener_.notifySetAttribute(name);
            session.setAttribute(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshAttribute(String name) {
        HttpSession session = this.getSession(false);
        if (session != null) {
            HttpSession httpSession = session;
            synchronized (httpSession) {
                Object value = session.getAttribute(name);
                if (value != null && !this.isImmutable(value)) {
                    session.setAttribute(name, value);
                }
            }
        }
    }

    protected boolean isImmutable(Object value) {
        return value instanceof String || value instanceof Boolean || value instanceof Character || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double;
    }

    @Binding(bindingType=BindingType.NONE)
    public void setAttributeListener(AttributeListener attributeListener) {
        this.attributeListener_ = attributeListener;
    }
}

