/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.render.html;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seasar.ymir.render.html.Optgroup;
import org.seasar.ymir.render.html.Option;
import org.seasar.ymir.render.html.Tag;
import org.seasar.ymir.util.HTMLUtils;
import org.seasar.ymir.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Select
extends Tag {
    private static final long serialVersionUID = 1L;
    private static final String LS = System.getProperty("line.separator");
    private String name_;
    private Integer size_;
    private boolean multiple_;
    private boolean disabled_;
    private Optgroup[] optgroups_;
    private Option[] options_;
    private transient Map<String, Option> optionMap_ = new LinkedHashMap<String, Option>();
    private String[] values_;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.optionMap_ = new HashMap<String, Option>();
        this.initializeOptionMap();
        this.updateState();
    }

    public Select() {
    }

    public Select(List<?> optgroupsAndOptions) {
        this.setOptgroupsAndOptions(optgroupsAndOptions);
    }

    public Select(List<Optgroup> optgroups, List<Option> options) {
        this.setOptgroupsAndOptions(optgroups, options);
    }

    public Select(Optgroup[] optgroups) {
        this.setOptgroups(optgroups);
    }

    public Select(Option[] options) {
        this.setOptions(options);
    }

    public Select(Optgroup[] optgroups, Option[] options) {
        this.setOptgroupsAndOptions(optgroups, options);
    }

    @Override
    protected void writeName(StringBuilder sb) {
        sb.append("select");
    }

    @Override
    protected void writeAttributes(StringBuilder sb) {
        super.writeAttributes(sb);
        if (this.name_ != null) {
            sb.append(" name=\"").append(HTMLUtils.filter(this.name_)).append("\"");
        }
        if (this.size_ != null) {
            sb.append(" size=\"").append(this.size_).append("\"");
        }
        if (this.multiple_) {
            sb.append(" multiple=\"multiple\"");
        }
    }

    @Override
    protected void writeContent(StringBuilder sb) {
        if (this.optgroups_ != null && this.optgroups_.length > 0 || this.options_ != null && this.options_.length > 0) {
            int i;
            sb.append(">").append(LS);
            if (this.optgroups_ != null && this.optgroups_.length > 0) {
                for (i = 0; i < this.optgroups_.length; ++i) {
                    sb.append("  ").append(this.addIndent(this.optgroups_[i])).append(LS);
                }
            }
            if (this.options_ != null && this.options_.length > 0) {
                for (i = 0; i < this.options_.length; ++i) {
                    sb.append("  ").append(this.options_[i]).append(LS);
                }
            }
            sb.append("</");
            this.writeName(sb);
        } else {
            sb.append(" /");
        }
    }

    protected void updateState() {
        if (this.optgroups_ == null) {
            return;
        }
        Iterator<Option> itr = this.optionMap_.values().iterator();
        while (itr.hasNext()) {
            itr.next().setSelected(false);
        }
        if (this.values_ != null) {
            for (int i = 0; i < this.values_.length; ++i) {
                Option optionTag = this.optionMap_.get(this.values_[i]);
                if (optionTag == null) continue;
                optionTag.setSelected(true);
            }
        }
    }

    public String getName() {
        return this.name_;
    }

    public Select setName(String name) {
        this.name_ = name;
        return this;
    }

    public Integer getSize() {
        return this.size_;
    }

    public Select setSize(Integer size) {
        this.size_ = size;
        return this;
    }

    public boolean isMultiple() {
        return this.multiple_;
    }

    public Select setMultiple(boolean multiple) {
        this.multiple_ = multiple;
        return this;
    }

    public boolean isDisabled() {
        return this.disabled_;
    }

    public Select setDisabled(boolean disabled) {
        this.disabled_ = disabled;
        return this;
    }

    public String[] getValue() {
        return this.values_;
    }

    public void setValue(String[] values) {
        this.setSelectedValues(values);
    }

    public String getSelectedValue() {
        for (Option option : this.optionMap_.values()) {
            if (!option.isSelected()) continue;
            return option.getValue();
        }
        return null;
    }

    public Integer getSelectedValueAsInteger() {
        String value = this.getSelectedValue();
        if (value == null) {
            return null;
        }
        return Integer.valueOf(value);
    }

    public String[] getSelectedValues() {
        ArrayList<String> list = new ArrayList<String>();
        for (Option option : this.optionMap_.values()) {
            if (!option.isSelected()) continue;
            list.add(option.getValue());
        }
        return list.toArray(new String[0]);
    }

    public Integer[] getSelectedValuesAsInteger() {
        String[] values = this.getSelectedValues();
        Integer[] integers = new Integer[values.length];
        for (int i = 0; i < values.length; ++i) {
            integers[i] = Integer.valueOf(values[i]);
        }
        return integers;
    }

    public Select setSelectedValues(Object values) {
        if (values == null) {
            return this.setSelectedValues(new String[0]);
        }
        if (values.getClass().isArray()) {
            ArrayList<String> list = new ArrayList<String>();
            int length = Array.getLength(values);
            for (int i = 0; i < length; ++i) {
                Object value = Array.get(values, i);
                if (value == null) continue;
                list.add(value.toString());
            }
            return this.setSelectedValues(list.toArray(new String[0]));
        }
        if (values instanceof Collection) {
            ArrayList<String> list = new ArrayList<String>();
            for (Object value : (Collection)values) {
                if (value == null) continue;
                list.add(value.toString());
            }
            return this.setSelectedValues(list.toArray(new String[0]));
        }
        return this.setSelectedValues(values.toString());
    }

    public Select setSelectedValue(String value) {
        return this.setSelectedValues((Object)value);
    }

    public Select setSelectedValueObject(Object value) {
        return this.setSelectedValue(StringUtils.asString(value));
    }

    public Select setSelectedValues(String ... values) {
        this.values_ = values;
        this.updateState();
        return this;
    }

    public Select setSelectedValueObjects(Object ... values) {
        String[] valueStrings;
        if (values == null) {
            valueStrings = new String[]{};
        } else {
            valueStrings = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                valueStrings[i] = StringUtils.asString(values[i]);
            }
        }
        this.setSelectedValues(valueStrings);
        return this;
    }

    public Optgroup[] getOptgroups() {
        return this.optgroups_;
    }

    public List<Optgroup> getOptgroupList() {
        if (this.optgroups_ == null) {
            return null;
        }
        return new ArrayList<Optgroup>(Arrays.asList(this.optgroups_));
    }

    public Select setOptgroups(List<Optgroup> optgroups) {
        return this.setOptgroups(optgroups.toArray(new Optgroup[0]));
    }

    public Select setOptgroups(Optgroup ... optgroups) {
        return this.setOptgroupsAndOptions(optgroups, new Option[0]);
    }

    public Option[] getOptions() {
        return this.options_;
    }

    public List<Option> getOptionList() {
        if (this.options_ == null) {
            return null;
        }
        return new ArrayList<Option>(Arrays.asList(this.options_));
    }

    public Select setOptions(List<Option> options) {
        return this.setOptions(options.toArray(new Option[0]));
    }

    public Select setOptions(Option ... options) {
        return this.setOptgroupsAndOptions(new Optgroup[0], options);
    }

    public Select setOptgroupsAndOptions(List<?> optgroupsOrOptions) {
        ArrayList<Optgroup> optgroups = new ArrayList<Optgroup>();
        ArrayList<Option> options = new ArrayList<Option>();
        for (Object tag : optgroupsOrOptions) {
            if (tag instanceof Optgroup) {
                optgroups.add((Optgroup)tag);
                continue;
            }
            if (tag instanceof Option) {
                options.add((Option)tag);
                continue;
            }
            throw new IllegalArgumentException("Option or Optgroup must be specified: " + tag);
        }
        return this.setOptgroupsAndOptions(optgroups.toArray(new Optgroup[0]), options.toArray(new Option[0]));
    }

    public Select setOptgroupsAndOptions(List<Optgroup> optgroups, List<Option> options) {
        return this.setOptgroupsAndOptions(optgroups.toArray(new Optgroup[0]), options.toArray(new Option[0]));
    }

    public Select setOptgroupsAndOptions(Optgroup[] optgroups, Option[] options) {
        this.optgroups_ = optgroups;
        this.options_ = options;
        this.initializeOptionMap();
        this.updateState();
        return this;
    }

    private void initializeOptionMap() {
        int i;
        this.optionMap_.clear();
        ArrayList<String> valueList = new ArrayList<String>();
        for (i = 0; i < this.optgroups_.length; ++i) {
            Option[] os = this.optgroups_[i].getOptions();
            for (int j = 0; j < os.length; ++j) {
                Option old;
                if (this.values_ == null && os[j].isSelected()) {
                    valueList.add(os[j].getValue());
                }
                if ((old = this.optionMap_.put(os[j].getValue(), os[j])) == null) continue;
                throw new IllegalArgumentException("Values of options are duplicated: " + old + ", " + os[j]);
            }
        }
        for (i = 0; i < this.options_.length; ++i) {
            Option old;
            if (this.values_ == null && this.options_[i].isSelected()) {
                valueList.add(this.options_[i].getValue());
            }
            if ((old = this.optionMap_.put(this.options_[i].getValue(), this.options_[i])) == null) continue;
            throw new IllegalArgumentException("Values of options are duplicated: " + old + ", " + this.options_[i]);
        }
        if (this.values_ == null) {
            this.values_ = valueList.toArray(new String[0]);
        }
    }

    public String getSelectedContent() {
        for (Option option : this.optionMap_.values()) {
            if (!option.isSelected()) continue;
            return option.getContentAsString();
        }
        return null;
    }

    public String[] getSelectedContents() {
        ArrayList<String> list = new ArrayList<String>();
        for (Option option : this.optionMap_.values()) {
            if (!option.isSelected()) continue;
            list.add(option.getContentAsString());
        }
        return list.toArray(new String[0]);
    }

    public Option getSelectedOption() {
        for (Option option : this.optionMap_.values()) {
            if (!option.isSelected()) continue;
            return option;
        }
        return null;
    }

    public Option[] getSelectedOptions() {
        ArrayList<Option> list = new ArrayList<Option>();
        for (Option option : this.optionMap_.values()) {
            if (!option.isSelected()) continue;
            list.add(option);
        }
        return list.toArray(new Option[0]);
    }

    public List<Option> getSelectedOptionList() {
        return new ArrayList<Option>(Arrays.asList(this.getSelectedOptions()));
    }

    public Optgroup getOptgroup(String label) {
        for (int i = 0; i < this.optgroups_.length; ++i) {
            if (!label.equals(this.optgroups_[i].getLabel())) continue;
            return this.optgroups_[i];
        }
        return null;
    }

    public Option getOption(String value) {
        return this.optionMap_.get(value);
    }

    public String getOptionContent(String value) {
        Option option = this.getOption(value);
        if (option != null) {
            return option.getContentAsString();
        }
        return null;
    }
}

