/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.cms.pluggable.ThreadContext;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.ymir.Action;
import org.seasar.ymir.ActionManager;
import org.seasar.ymir.ActionNotFoundRuntimeException;
import org.seasar.ymir.AttributeContainer;
import org.seasar.ymir.ComponentMetaDataFactory;
import org.seasar.ymir.Dispatch;
import org.seasar.ymir.Dispatcher;
import org.seasar.ymir.ExceptionProcessor;
import org.seasar.ymir.FrameworkDispatch;
import org.seasar.ymir.IllegalClientCodeRuntimeException;
import org.seasar.ymir.MatchedPathMapping;
import org.seasar.ymir.PageComponent;
import org.seasar.ymir.PageComponentVisitor;
import org.seasar.ymir.PageNotFoundRuntimeException;
import org.seasar.ymir.Phase;
import org.seasar.ymir.Request;
import org.seasar.ymir.RequestProcessor;
import org.seasar.ymir.Response;
import org.seasar.ymir.ResponseType;
import org.seasar.ymir.Updater;
import org.seasar.ymir.Ymir;
import org.seasar.ymir.annotation.DefaultReturn;
import org.seasar.ymir.annotation.Include;
import org.seasar.ymir.annotation.handler.AnnotationHandler;
import org.seasar.ymir.constraint.ConstraintType;
import org.seasar.ymir.convention.YmirNamingConvention;
import org.seasar.ymir.impl.PageComponentImpl;
import org.seasar.ymir.impl.VisitorForInvoking;
import org.seasar.ymir.interceptor.YmirProcessInterceptor;
import org.seasar.ymir.response.PassthroughResponse;
import org.seasar.ymir.util.RequestUtils;
import org.seasar.ymir.util.ServletUtils;
import org.seasar.ymir.util.YmirUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestProcessorImpl
implements RequestProcessor {
    static final Set<ConstraintType> EMPTY_SUPPRESSTYPESET = EnumSet.noneOf(ConstraintType.class);
    private Ymir ymir_;
    private YmirNamingConvention ymirNamingConvention_;
    private ActionManager actionManager_;
    private AnnotationHandler annotationHandler_;
    private ComponentMetaDataFactory componentMetaDataFactory_;
    private ExceptionProcessor exceptionProcessor_;
    private Updater[] updaters_ = new Updater[0];
    private YmirProcessInterceptor[] ymirProcessInterceptors_ = new YmirProcessInterceptor[0];
    private PageComponentVisitor<Response> visitorForInvoking_;
    private final Log log_ = LogFactory.getLog(RequestProcessorImpl.class);

    @Binding(bindingType=BindingType.MUST)
    public void setYmir(Ymir ymir) {
        this.ymir_ = ymir;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setYmirNamingConvention(YmirNamingConvention ymirNamingConvention) {
        this.ymirNamingConvention_ = ymirNamingConvention;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setActionManager(ActionManager actionManager) {
        this.actionManager_ = actionManager;
        this.initPageComponentVisitor();
    }

    @Binding(bindingType=BindingType.MUST)
    public void setAnnotationHandler(AnnotationHandler annotationHandler) {
        this.annotationHandler_ = annotationHandler;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setComponentMetaDataFactory(ComponentMetaDataFactory componentMetaDataFactory) {
        this.componentMetaDataFactory_ = componentMetaDataFactory;
        this.initPageComponentVisitor();
    }

    @Binding(bindingType=BindingType.MUST)
    public void setExceptionProcessor(ExceptionProcessor exceptionProcessor) {
        this.exceptionProcessor_ = exceptionProcessor;
    }

    public void setUpdaters(Updater[] updaters) {
        this.updaters_ = updaters;
    }

    @Binding(value="@org.seasar.ymir.util.ContainerUtils@findAllComponents(container, @org.seasar.ymir.interceptor.YmirProcessInterceptor@class)", bindingType=BindingType.MUST)
    public void setYmirProcessInterceptors(YmirProcessInterceptor[] ymirProcessInterceptors) {
        this.ymirProcessInterceptors_ = ymirProcessInterceptors;
        YmirUtils.sortYmirProcessInterceptors(this.ymirProcessInterceptors_);
    }

    String strip(String path) {
        int question = path.indexOf(63);
        if (question >= 0) {
            path = path.substring(0, question);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    void initPageComponentVisitor() {
        if (this.actionManager_ == null || this.componentMetaDataFactory_ == null) {
            return;
        }
        this.visitorForInvoking_ = new VisitorForInvoking(this.actionManager_, this.componentMetaDataFactory_);
    }

    @Override
    public Object backupForInclusion(AttributeContainer attributeContainer) {
        return attributeContainer.getAttribute("self");
    }

    @Override
    public void restoreForInclusion(AttributeContainer attributeContainer, Object backupped) {
        attributeContainer.setAttribute("self", backupped);
    }

    ServletContext getServletContext() {
        return (ServletContext)this.getS2Container().getRoot().getComponent(ServletContext.class);
    }

    protected S2Container getS2Container() {
        return this.ymir_.getApplication().getS2Container();
    }

    @Override
    public Response process(Request request) {
        if (RequestUtils.isProceeded(request)) {
            return this.processRequest(request);
        }
        switch (request.getCurrentDispatch().getDispatcher()) {
            case REQUEST: {
                return this.processRequest(request);
            }
            case FORWARD: {
                return this.processForward(request);
            }
            case INCLUDE: {
                return this.processInclude(request);
            }
        }
        return new PassthroughResponse();
    }

    protected Response processRequest(Request request) {
        Dispatch dispatch = request.getCurrentDispatch();
        if (dispatch.isDenied()) {
            throw new PageNotFoundRuntimeException(dispatch.getPath());
        }
        if (this.ymir_.isUnderDevelopment() && YmirUtils.isUpdatable(request)) {
            for (int i = 0; i < this.updaters_.length; ++i) {
                Response response = this.updaters_[i].updateByRequesting(request);
                if (response == null) continue;
                return response;
            }
        }
        Response response = this.processRequestAndForward(request);
        if (this.ymir_.isUnderDevelopment() && YmirUtils.isUpdatable(request)) {
            for (int i = 0; i < this.updaters_.length; ++i) {
                Response newResponse = this.updaters_[i].update(request, response);
                if (newResponse == response) continue;
                return newResponse;
            }
        }
        return response;
    }

    protected Response processForward(Request request) {
        return this.processRequestAndForward(request);
    }

    protected Response processRequestAndForward(Request request) {
        FrameworkDispatch dispatch = YmirUtils.toFrameworkDispatch(request.getCurrentDispatch());
        Response response = new PassthroughResponse();
        Object page = null;
        if (!dispatch.isIgnored()) {
            PageComponent pageComponent = this.createPageComponent(dispatch.getPageComponentName());
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)("Page component name: " + dispatch.getPageComponentName()));
                this.log_.debug((Object)("Page component: " + pageComponent));
            }
            Action action = null;
            if (pageComponent != null) {
                try {
                    dispatch.setPageComponent(pageComponent);
                    Action originalAction = dispatch.getMatchedPathMapping().getAction(pageComponent, request);
                    dispatch.setOriginalAction(originalAction);
                    dispatch.setAction(originalAction);
                    Response r = (Response)pageComponent.accept(this.visitorForInvoking_, new Object[]{Phase.PAGECOMPONENT_CREATED, dispatch.getActionName()});
                    if (r.getType() != ResponseType.PASSTHROUGH) {
                        response = r;
                    } else {
                        String actionName;
                        int i;
                        for (i = 0; i < this.ymirProcessInterceptors_.length; ++i) {
                            pageComponent = this.ymirProcessInterceptors_[i].pageComponentCreated(request, pageComponent);
                        }
                        action = originalAction;
                        for (i = 0; i < this.ymirProcessInterceptors_.length; ++i) {
                            action = this.ymirProcessInterceptors_[i].actionInvoking(request, action);
                            dispatch.setAction(action);
                        }
                        if (action != null) {
                            page = action.getTarget();
                            actionName = action.getName();
                        } else {
                            page = null;
                            actionName = null;
                        }
                        if (action == null && dispatch.getDispatcher() == Dispatcher.REQUEST) {
                            throw new ActionNotFoundRuntimeException(dispatch.getPath(), request.getMethod());
                        }
                        r = (Response)pageComponent.accept(this.visitorForInvoking_, new Object[]{Phase.ACTION_INVOKING, actionName});
                        if (r.getType() != ResponseType.PASSTHROUGH) {
                            response = r;
                        } else {
                            response = this.actionManager_.invokeAction(action);
                            for (int i2 = 0; i2 < this.ymirProcessInterceptors_.length; ++i2) {
                                response = this.ymirProcessInterceptors_[i2].actionInvoked(request, response);
                            }
                            r = (Response)pageComponent.accept(this.visitorForInvoking_, new Object[]{Phase.ACTION_INVOKED, actionName});
                            if (r.getType() != ResponseType.PASSTHROUGH) {
                                response = r;
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    response = this.exceptionProcessor_.process(request, t, true);
                }
                if (response.getType() == ResponseType.PASSTHROUGH) {
                    pageComponent.accept(new VisitorForPrerendering(request), new Object[0]);
                }
                request.setAttribute("pageComponent", pageComponent);
                request.setAttribute("self", pageComponent.getPage());
            }
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)("Raw response: " + response));
            }
            response = this.adjustResponse(dispatch, response, page, action != null ? action.getTargetClass() : null, action != null ? action.getMethodInvoker().getMethod() : null);
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)("Adjusted response: " + response));
            }
        }
        return response;
    }

    protected Response processInclude(Request request) {
        Response response = new PassthroughResponse();
        Dispatch dispatch = request.getCurrentDispatch();
        if (!dispatch.isIgnored()) {
            String componentName = request.getCurrentDispatch().getPageComponentName();
            Object page = this.getPage(componentName);
            Class<?> pageClass = this.getComponentClass(componentName);
            if (page != null) {
                request.setAttribute("self", page);
            }
            response = this.adjustResponse(dispatch, response, page, pageClass, null);
        }
        return response;
    }

    protected PageComponent createPageComponent(Object pageComponentKey) {
        return this.createPageComponent(this.getPage(pageComponentKey), this.getComponentClass(pageComponentKey));
    }

    protected PageComponent createPageComponent(Object page, Class<?> pageClass) {
        PageComponentImpl pageComponent;
        if (page == null) {
            return null;
        }
        Include children = this.annotationHandler_.getAnnotation(pageClass, Include.class);
        if (children != null) {
            Class<?>[] childrenClasses = children.value();
            ArrayList<PageComponent> childPageList = new ArrayList<PageComponent>();
            for (int i = 0; i < childrenClasses.length; ++i) {
                PageComponent pc = this.createPageComponent(childrenClasses[i]);
                if (pc == null) continue;
                childPageList.add(pc);
            }
            pageComponent = new PageComponentImpl(page, pageClass, childPageList.toArray(new PageComponent[0]));
        } else {
            pageComponent = new PageComponentImpl(page, pageClass);
        }
        return pageComponent;
    }

    protected Object getPage(Object pageComponentKey) {
        if (pageComponentKey == null) {
            return null;
        }
        S2Container s2container = this.getS2Container();
        if (s2container.hasComponentDef(pageComponentKey)) {
            String pageClassName;
            String pageComponentName;
            if (this.ymir_.isUnderDevelopment() && pageComponentKey instanceof String && !pageComponentKey.equals(pageComponentName = this.ymirNamingConvention_.fromClassNameToComponentName(pageClassName = this.ymirNamingConvention_.fromComponentNameToClassName((String)pageComponentKey)))) {
                throw new IllegalClientCodeRuntimeException("Since page component name '" + pageComponentKey + "' is illegal, this application may not run correctly in release mode. You can use correct page component name '" + pageComponentName + "'.");
            }
            return s2container.getComponent(pageComponentKey);
        }
        return null;
    }

    protected Class<?> getComponentClass(Object componentKey) {
        if (componentKey == null) {
            return null;
        }
        S2Container s2container = this.getS2Container();
        if (s2container.hasComponentDef(componentKey)) {
            return s2container.getComponentDef(componentKey).getComponentClass();
        }
        return null;
    }

    protected boolean componentExists(Object componentKey) {
        if (componentKey == null) {
            return false;
        }
        return this.getS2Container().hasComponentDef(componentKey);
    }

    Response adjustResponse(Dispatch dispatch, Response response, Object page, Class<?> pageClass, Method actionMethod) {
        if (response.getType() == ResponseType.PASSTHROUGH) {
            Object returnValue = null;
            DefaultReturn defaultReturn = null;
            if (actionMethod != null) {
                defaultReturn = this.annotationHandler_.getAnnotation(actionMethod, DefaultReturn.class);
            }
            if (defaultReturn == null && pageClass != null) {
                defaultReturn = this.annotationHandler_.getAnnotation(pageClass, DefaultReturn.class);
            }
            if (defaultReturn != null) {
                returnValue = dispatch.getMatchedPathMapping().evaluate(defaultReturn.value());
            } else if (!this.fileResourceExists(dispatch.getPath())) {
                returnValue = dispatch.getMatchedPathMapping().getDefaultReturnValue();
            }
            if (returnValue != null && (response = this.actionManager_.constructResponse(page, Object.class, returnValue)).getType() == ResponseType.FORWARD && response.getPath().equals(ServletUtils.normalizePath(dispatch.getPath()))) {
                response = new PassthroughResponse();
            }
        }
        return response;
    }

    ThreadContext getThreadContext() {
        return (ThreadContext)this.ymir_.getApplication().getS2Container().getRoot().getComponent(ThreadContext.class);
    }

    boolean fileResourceExists(String path) {
        if (path.length() == 0 || path.endsWith("/")) {
            return false;
        }
        Set pathSet = this.getServletContext().getResourcePaths(path.substring(0, path.lastIndexOf(47) + 1));
        if (pathSet == null) {
            return false;
        }
        return pathSet.contains(path);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class VisitorForPrerendering
    extends PageComponentVisitor<Object> {
        private Request request_;
        private MatchedPathMapping matched_;

        public VisitorForPrerendering(Request request) {
            this.request_ = request;
            this.matched_ = this.request_.getCurrentDispatch().getMatchedPathMapping();
        }

        @Override
        public Object process(PageComponent pageComponent, Object ... parameters) {
            RequestProcessorImpl.this.actionManager_.invokeAction(this.matched_.getPrerenderAction(pageComponent, this.request_));
            return null;
        }
    }
}

